/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/
/* Project: GRUB 
 * <http://www.grub.org>
 * module: CREQ
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 08 Jan, 2001
 * Files: GetProtocol.cpp GetProtocol.h
 *
 * This class together with GetParser takes care of the REQEST or GET
 * part of the protocol. The protocol() method is the one which begins 
 * everything. 
 */


//***********************************************************
#ifndef _GetProtocol_H_
#define _GetProtocol_H_

#include "GetParser.h"
#include "Protocol.h"
#include <ClientDB.h>
extern "C" {
  #include <verbose.h>
}

class GetProtocol : public GetParser, public Protocol
{
  public:
  	GetProtocol(ClientDB *,Communication *);
  	void getNewURL(string URL, unsigned long size, unsigned long CRC);
	void getOldURL(string URL);  	
        int protocol() throw (ProtocolExp);
  private:
        ClientDB *cDB;

};

#endif
