/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/ 

#include "GetParser.h"
#include <iostream>

using std::cout;

GetParser::GetParser(Communication *new_comm)
{
  comm = new_comm;
  url_count = 0;
}

void GetParser::parse() throw (ParseExp)
{
  string in_str[10];  //string array in which the input is recieved
  int ret,i,j,k;  
  unsigned long size; //size of page
  unsigned long CRC;  //CRC of page
  int count;          //count of URLS
  string err;         //used for Error reporting purposes
    	
  ret = recv(in_str);
  if (ret==2) {
	ret = sscanf(in_str[1].c_str(),"COUNT=%d",&count);
	if ((ret != 1)||(count<0)) {
		err = "Expected:COUNT=<int>  Recieved:" + in_str[1];
		throw ParseExp(err.c_str(),PERFORM_GET_CAPTION);
	}

  	if (in_str[0] == "URLS-OLD")
  	{
  		for(i=count;i>0;i--) {
  			ret = recv(in_str);
  			if (ret == 1) getOldURL(in_str[0]);
 			else throw ParseExp("Expected: URL",PERFORM_GET_CAPTION);
 		}       	
  	}
  	else {
  		err = "Expected:URLS-OLD  Recieved:" + in_str[0];
  		throw ParseExp(err.c_str(),PERFORM_GET_CAPTION);
  	}
  }
  else throw ParseExp("Expected: URLS-OLD COUNT=x",PERFORM_GET_CAPTION);

  ret = recv(in_str);
  if (ret==2) {
  	
  	//First checking the count variables
	ret = sscanf(in_str[1].c_str(),"COUNT=%d",&count);
	url_count = count;

	if ((ret != 1)||(count<0)) {
		err = "Expected:COUNT=<int>  Recieved:" + in_str[1];
		throw ParseExp(err.c_str(),PERFORM_GET_CAPTION);
	}
	if(count == 0)
	{
		throw ParseExp("server database contains no URLs to crawl",NO_URLS);
	}

    	if (in_str[0] == "URLS-NEW") {	
 		for(i=count;i>0;i--) {
  			ret = recv(in_str);
  			if (ret==3) {
				ret = sscanf(in_str[1].c_str(),"%lu",&size);
				if (ret != 1) throw ParseExp("URL size is not numeric",PERFORM_GET_URL);
				ret = sscanf(in_str[2].c_str(),"%lu",&CRC);
				if (ret != 1) throw ParseExp("URL CRC is not numeric",PERFORM_GET_URL);
							  				
  				getNewURL(in_str[0],size,CRC);		 		
  			}
  			else throw ParseExp("Expected: URL SIZE CRC",PERFORM_GET_CAPTION);
  		}
  	
  	}
 	else {
  		err = "Expected:URLS-NEW  Recieved:" + in_str[0];
  		throw ParseExp(err.c_str(),PERFORM_GET_CAPTION);
  	}  	
  } 	
  else throw ParseExp("Expected: URLS-NEW COUNT=x",PERFORM_GET_CAPTION);

}

void GetParser::getNewURL(string str, unsigned long i, unsigned long j) { }

void GetParser::getOldURL(string str) { }

int GetParser::recv(string msg[])
{
  int ret;
  msg[0] = "";

  ret = comm->read_spacesplit(msg,10,MAX_LINE_LENGTH,'\n');
  if (ret<0) {
	// i commented out this error, but it needs to be fixed to work right - kord
  	// cout<<"COMERR:"<<comm->errmsg()<<endl;
  	throw ParseExp("Communication Error",COMM_ERROR);
  }

  return ret;
}

int GetParser::getURLCount()
{
	return url_count;
}

