#ifndef _Msg_H_
#define _Msg_H_

#include "XmlWrapper.h"
#include "SocketComm.h"

// This classes are NOT thread safe!

class MsgSender {
public:
	MsgSender();
	~MsgSender();

	void reset();

	void setMessageType( const char *type );
	void setMessageName( const char *name );

	void appendDataString( const char *tag_name, const char *value );
	void appendDataInteger( const char *tag_name, int value );
	void appendDataDouble( const char *tag_name, double value );

	const char *getMessage();

private:
	XmlWrapper xml_parser;
};

class MsgReceiver {
public:
	MsgReceiver();
	~MsgReceiver();

	void reset();

	// ret = 0, -1 (XML parse error)
	int setMessage( const char *msg );

	// ret = 1 (success), 0 (no type field found)
	int getMessageType( char *& type );
	int getMessageName( char *& name );

	// for all: ret = 1 (found), 0 (not found), -1 (bad format)
	int getDataString( const char *tag_name, int index, char *& value );
	int getDataInteger( const char *tag_name, int index, int& value );
	int getDataDouble( const char *tag_name, int index, double& value );

private:
	XmlWrapper xml_parser;
};

class MsgManager : public MsgSender, public MsgReceiver {
public:
	// server constructor
	MsgManager( unsigned short portnum );

	// client constructor
	MsgManager( unsigned short portnum, const char *hostname );

	~MsgManager();

	void setActive( bool active );
	bool isActive();
	bool isConnected();
	bool isServer();
	unsigned short getPort();
	const char *getHost();
	void send();
	void invokeError( const char *msg );

	// callback must NOT call none of MsgManager methods
	virtual void readCallback( const char *data );
	virtual void errorCallback( const char *msg );

private:
	void establishServer();
	void closeServer();
	void initSocketComm();
	void deleteSocketComm();

	unsigned short portnum;
	bool is_server;
	bool is_active;
	char hostname[1024];
	SocketComm *scomm;
	SOCKET srv_sock;

	friend int Msg_read_callback( void *arg, const char *buf,
		unsigned int len );
	friend void Msg_error_callback( void *arg, const char *msg );
};

#endif  /* _Msg_H_ */
