// CConsoleFace.h : Declaration of the CConsoleFace

#ifndef __CONSOLEFACE_H_
#define __CONSOLEFACE_H_

#include "resource.h"       // main symbols
#include <atlctl.h>

#include "ConsoleFace.h"
#include "GrubFaceCP.h"

#include "input_thread.h"  // for the dirty hack for COM to work well

#ifndef GRUB_UNIX
// called just after the input thread begins
void threadinit_callback( SocketComm *scomm );

// called just before the input thread exits
void threaduninit_callback( SocketComm *scomm );
#endif

/////////////////////////////////////////////////////////////////////////////
// CConsoleFace
class ATL_NO_VTABLE CConsoleFace : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IConsoleFace, &IID_IConsoleFace, &LIBID_GRUBFACELib>,
	public CComControl<CConsoleFace>,
	public IPersistStreamInitImpl<CConsoleFace>,
	public IOleControlImpl<CConsoleFace>,
	public IOleObjectImpl<CConsoleFace>,
	public IOleInPlaceActiveObjectImpl<CConsoleFace>,
	public IViewObjectExImpl<CConsoleFace>,
	public IOleInPlaceObjectWindowlessImpl<CConsoleFace>,
	public IConnectionPointContainerImpl<CConsoleFace>,
	public IPersistStorageImpl<CConsoleFace>,
	public ISpecifyPropertyPagesImpl<CConsoleFace>,
	public IQuickActivateImpl<CConsoleFace>,
	public IDataObjectImpl<CConsoleFace>,
	public IProvideClassInfo2Impl<&CLSID_ConsoleFace, &DIID__IConsoleFaceEvents, &LIBID_GRUBFACELib>,
	public IPropertyNotifySinkCP<CConsoleFace>,
	public CComCoClass<CConsoleFace, &CLSID_ConsoleFace>,
	public ConsoleFace,
	public CProxy_IConsoleFaceEvents< CConsoleFace >
{
public:
	CConsoleFace() : ConsoleFace()
	{
#ifndef GRUB_UNIX
		WSADATA info;

		/* initialize the socket library */
		WSAStartup(MAKELONG(1, 1), &info);
#endif

#ifndef GRUB_UNIX
	comdirtyhack_threadinit_callback = threadinit_callback;
	comdirtyhack_threaduninit_callback = threaduninit_callback;
#endif
	}

	~CConsoleFace()
	{
#ifndef GRUB_UNIX
		WSACleanup();
#endif
	}

DECLARE_REGISTRY_RESOURCEID(IDR_CONSOLEFACE)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CConsoleFace)
	COM_INTERFACE_ENTRY(IConsoleFace)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CConsoleFace)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CConsoleFace)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IConsoleFaceEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CConsoleFace)
	CHAIN_MSG_MAP(CComControl<CConsoleFace>)
	DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);



// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IConsoleFace
public:

	HRESULT OnDraw(ATL_DRAWINFO& di)
	{
		RECT& rc = *(RECT*)di.prcBounds;
		Rectangle(di.hdcDraw, rc.left, rc.top, rc.right, rc.bottom);

		SetTextAlign(di.hdcDraw, TA_CENTER|TA_BASELINE);
		LPCTSTR pszText = _T("ATL 3.0 : ConsoleFace");
		TextOut(di.hdcDraw, 
			(rc.left + rc.right) / 2, 
			(rc.top + rc.bottom) / 2, 
			pszText, 
			lstrlen(pszText));

		return S_OK;
	}

	STDMETHOD(get_Port)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Port)(/*[in]*/ long newVal);
	STDMETHOD(get_Host)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Host)(/*[in]*/ BSTR newVal);
	STDMETHOD(IsConnected)(/*[out, retval]*/ BOOL *IsConn);
	STDMETHOD(Refresh)();
	STDMETHOD(Disconnect)();
	STDMETHOD(Connect)();
	STDMETHOD(RingGetStatus)();
	STDMETHOD(RingGetCrawlerCount)();
	STDMETHOD(RingGetBandwidthLimit)();
	STDMETHOD(RingGetBandwidth)();
	STDMETHOD(PostSetCrawlerCount)(/*[in]*/ long Count);
	STDMETHOD(PostSetBandwidth)(/*[in]*/ long Bandwidth);

	virtual void EventGetBandwidth(int Bandwidth);
	virtual void EventGetBandwidthLimit(int Limit);
	virtual void EventGetCrawlerCount(int Count);
	virtual void EventGetStatus(int Status);

	virtual void EventGettingBegin();
	virtual void EventGettingURL(const char *URL, int Size, int CRC);
	virtual void EventGettingEnd();
	virtual void EventCrawlingBegin();
	virtual void EventCrawlingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC,
		int Bandwidth);
	virtual void EventCrawlingURLDone(const char *URL, const char *Status);
	virtual void EventCrawlingEnd();
	virtual void EventPuttingBegin();
	virtual void EventPuttingURL(
		const char *URL,
		const char *Status,
		int Size,
		int CRC);
	virtual void EventPuttingEnd();

	virtual void EventHostProtect();
	virtual void EventHostUnprotect();
	virtual void EventSleep(int Seconds);

	// alias for EventError(Message)
	virtual void errorCallback(const char *Message);
};

#endif //__CONSOLEFACE_H_
