/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/   

//#define DEBUG
#include "connector.h"

int openConnection(const char * host,int port)
{
	int connfd;
	struct sockaddr_in their_addr; /* connector's address information */
	struct hostent *he;

	if ((he=gethostbyname(host)) == NULL) {  /* get the host info */
#ifdef DEBUG		
		herror("gethostbyname");
#endif
		return -1;
	}

	if ((connfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {
#ifdef DEBUG		
		perror("socket");
#endif		
		return -1;
	}

	their_addr.sin_family = AF_INET;      /* host byte order */
	their_addr.sin_port = htons(port);  /* short, network byte order */
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	bzero(&(their_addr.sin_zero), 8);     /* zero the rest of the struct */

	if ( connect( connfd, (struct sockaddr *)&their_addr,
			sizeof(their_addr) ) < 0 )
	{
		close( connfd );
#ifdef DEBUG			
		perror("connect");
#endif	
	        return -1;
	}
	return connfd;	
}

int closeConnection(int connfd)
{
	return close(connfd);
}

