/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: util.c 1.4 Mon, 13 Sep 1999 23:28:20 -0500 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <math.h>
#include <stdio.h>

#include "gphone.h"
#include "gphone-lib.h"

int
short_sleep(double sleep_time)
{
  struct timeval tv;

  tv.tv_sec = (time_t) floor(sleep_time);
  tv.tv_usec = (time_t) ((sleep_time - floor(sleep_time)) * 1.0e6);

  return(select(0, NULL, NULL, NULL, &tv));
}

void
gphone_perror_exit(char *message, int status)
{
#ifdef HAVE_LIBSLANG
  term_cleanup();
#endif
  perror(message);
  exit(status);
}

void
gphone_print_exit(char *message, int status)
{
#ifdef HAVE_LIBSLANG
  term_cleanup();
#endif
  fprintf(stderr, message);
  exit(status);
}



/*
 * Local variables:
 *  compile-command: "make -k libgphone.a"
 * End:
 */
