// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/campaign.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A campaign.
type Campaign struct {
	// The resource name of the campaign.
	// Campaign resource names have the form:
	//
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the campaign.
	//
	// When a new campaign is added, the status defaults to ENABLED.
	Status enums.CampaignStatusEnum_CampaignStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.CampaignStatusEnum_CampaignStatus" json:"status,omitempty"`
	// The ad serving status of the campaign.
	ServingStatus enums.CampaignServingStatusEnum_CampaignServingStatus `protobuf:"varint,21,opt,name=serving_status,json=servingStatus,proto3,enum=google.ads.googleads.v0.enums.CampaignServingStatusEnum_CampaignServingStatus" json:"serving_status,omitempty"`
	// The ad serving optimization status of the campaign.
	AdServingOptimizationStatus enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus `protobuf:"varint,8,opt,name=ad_serving_optimization_status,json=adServingOptimizationStatus,proto3,enum=google.ads.googleads.v0.enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus" json:"ad_serving_optimization_status,omitempty"`
	// The primary serving target for ads within the campaign.
	// The targeting options can be refined in `network_settings`.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	AdvertisingChannelType enums.AdvertisingChannelTypeEnum_AdvertisingChannelType `protobuf:"varint,9,opt,name=advertising_channel_type,json=advertisingChannelType,proto3,enum=google.ads.googleads.v0.enums.AdvertisingChannelTypeEnum_AdvertisingChannelType" json:"advertising_channel_type,omitempty"`
	// Optional refinement to `advertising_channel_type`.
	// Must be a valid sub-type of the parent channel type.
	//
	// Can be set only when creating campaigns.
	// After campaign is created, the field can not be changed.
	AdvertisingChannelSubType enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType `protobuf:"varint,10,opt,name=advertising_channel_sub_type,json=advertisingChannelSubType,proto3,enum=google.ads.googleads.v0.enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType" json:"advertising_channel_sub_type,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,11,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,12,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Settings for Real-Time Bidding, a feature only available for campaigns
	// targeting the Ad Exchange network.
	RealTimeBiddingSetting *common.RealTimeBiddingSetting `protobuf:"bytes,39,opt,name=real_time_bidding_setting,json=realTimeBiddingSetting,proto3" json:"real_time_bidding_setting,omitempty"`
	// The network settings for the campaign.
	NetworkSettings *Campaign_NetworkSettings `protobuf:"bytes,14,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// The hotel setting for the campaign.
	HotelSetting *Campaign_HotelSettingInfo `protobuf:"bytes,32,opt,name=hotel_setting,json=hotelSetting,proto3" json:"hotel_setting,omitempty"`
	// The setting for controlling Dynamic Search Ads (DSA).
	DynamicSearchAdsSetting *Campaign_DynamicSearchAdsSetting `protobuf:"bytes,33,opt,name=dynamic_search_ads_setting,json=dynamicSearchAdsSetting,proto3" json:"dynamic_search_ads_setting,omitempty"`
	// The setting for controlling Shopping campaigns.
	ShoppingSetting *Campaign_ShoppingSetting `protobuf:"bytes,36,opt,name=shopping_setting,json=shoppingSetting,proto3" json:"shopping_setting,omitempty"`
	// The budget of the campaign.
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The type of bidding strategy.
	//
	// A bidding strategy can be created by setting either the bidding scheme to
	// create a standard bidding strategy or the `bidding_strategy` field to
	// create a portfolio bidding strategy.
	//
	// This field is read-only.
	BiddingStrategyType enums.BiddingStrategyTypeEnum_BiddingStrategyType `protobuf:"varint,22,opt,name=bidding_strategy_type,json=biddingStrategyType,proto3,enum=google.ads.googleads.v0.enums.BiddingStrategyTypeEnum_BiddingStrategyType" json:"bidding_strategy_type,omitempty"`
	// The date when campaign started.
	//
	// This field must not be used in WHERE clauses.
	StartDate *wrappers.StringValue `protobuf:"bytes,19,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The campaign group this campaign belongs to.
	CampaignGroup *wrappers.StringValue `protobuf:"bytes,35,opt,name=campaign_group,json=campaignGroup,proto3" json:"campaign_group,omitempty"`
	// The date when campaign ended.
	//
	// This field must not be used in WHERE clauses.
	EndDate *wrappers.StringValue `protobuf:"bytes,20,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Suffix used to append query parameters to landing pages that are served
	// with parallel tracking.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,38,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// A list that limits how often each user will see this campaign's ads.
	FrequencyCaps []*common.FrequencyCapEntry `protobuf:"bytes,40,rep,name=frequency_caps,json=frequencyCaps,proto3" json:"frequency_caps,omitempty"`
	// The bidding strategy for the campaign.
	//
	// Must be either portfolio (created via BiddingStrategy service) or
	// standard, that is embedded into the campaign.
	//
	// Types that are valid to be assigned to CampaignBiddingStrategy:
	//	*Campaign_BiddingStrategy
	//	*Campaign_ManualCpc
	//	*Campaign_ManualCpm
	//	*Campaign_ManualCpv
	//	*Campaign_MaximizeConversions
	//	*Campaign_MaximizeConversionValue
	//	*Campaign_TargetCpa
	//	*Campaign_TargetRoas
	//	*Campaign_TargetSpend
	//	*Campaign_PercentCpc
	CampaignBiddingStrategy isCampaign_CampaignBiddingStrategy `protobuf_oneof:"campaign_bidding_strategy"`
	XXX_NoUnkeyedLiteral    struct{}                           `json:"-"`
	XXX_unrecognized        []byte                             `json:"-"`
	XXX_sizecache           int32                              `json:"-"`
}

func (m *Campaign) Reset()         { *m = Campaign{} }
func (m *Campaign) String() string { return proto.CompactTextString(m) }
func (*Campaign) ProtoMessage()    {}
func (*Campaign) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_153eb7de4e2bcd72, []int{0}
}
func (m *Campaign) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign.Unmarshal(m, b)
}
func (m *Campaign) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign.Marshal(b, m, deterministic)
}
func (dst *Campaign) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign.Merge(dst, src)
}
func (m *Campaign) XXX_Size() int {
	return xxx_messageInfo_Campaign.Size(m)
}
func (m *Campaign) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign proto.InternalMessageInfo

func (m *Campaign) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Campaign) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Campaign) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Campaign) GetStatus() enums.CampaignStatusEnum_CampaignStatus {
	if m != nil {
		return m.Status
	}
	return enums.CampaignStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetServingStatus() enums.CampaignServingStatusEnum_CampaignServingStatus {
	if m != nil {
		return m.ServingStatus
	}
	return enums.CampaignServingStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdServingOptimizationStatus() enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus {
	if m != nil {
		return m.AdServingOptimizationStatus
	}
	return enums.AdServingOptimizationStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelType() enums.AdvertisingChannelTypeEnum_AdvertisingChannelType {
	if m != nil {
		return m.AdvertisingChannelType
	}
	return enums.AdvertisingChannelTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelSubType() enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType {
	if m != nil {
		return m.AdvertisingChannelSubType
	}
	return enums.AdvertisingChannelSubTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Campaign) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *Campaign) GetRealTimeBiddingSetting() *common.RealTimeBiddingSetting {
	if m != nil {
		return m.RealTimeBiddingSetting
	}
	return nil
}

func (m *Campaign) GetNetworkSettings() *Campaign_NetworkSettings {
	if m != nil {
		return m.NetworkSettings
	}
	return nil
}

func (m *Campaign) GetHotelSetting() *Campaign_HotelSettingInfo {
	if m != nil {
		return m.HotelSetting
	}
	return nil
}

func (m *Campaign) GetDynamicSearchAdsSetting() *Campaign_DynamicSearchAdsSetting {
	if m != nil {
		return m.DynamicSearchAdsSetting
	}
	return nil
}

func (m *Campaign) GetShoppingSetting() *Campaign_ShoppingSetting {
	if m != nil {
		return m.ShoppingSetting
	}
	return nil
}

func (m *Campaign) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Campaign) GetBiddingStrategyType() enums.BiddingStrategyTypeEnum_BiddingStrategyType {
	if m != nil {
		return m.BiddingStrategyType
	}
	return enums.BiddingStrategyTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *Campaign) GetCampaignGroup() *wrappers.StringValue {
	if m != nil {
		return m.CampaignGroup
	}
	return nil
}

func (m *Campaign) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *Campaign) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *Campaign) GetFrequencyCaps() []*common.FrequencyCapEntry {
	if m != nil {
		return m.FrequencyCaps
	}
	return nil
}

type isCampaign_CampaignBiddingStrategy interface {
	isCampaign_CampaignBiddingStrategy()
}

type Campaign_BiddingStrategy struct {
	BiddingStrategy *wrappers.StringValue `protobuf:"bytes,23,opt,name=bidding_strategy,json=biddingStrategy,proto3,oneof"`
}

type Campaign_ManualCpc struct {
	ManualCpc *common.ManualCpc `protobuf:"bytes,24,opt,name=manual_cpc,json=manualCpc,proto3,oneof"`
}

type Campaign_ManualCpm struct {
	ManualCpm *common.ManualCpm `protobuf:"bytes,25,opt,name=manual_cpm,json=manualCpm,proto3,oneof"`
}

type Campaign_ManualCpv struct {
	ManualCpv *common.ManualCpv `protobuf:"bytes,37,opt,name=manual_cpv,json=manualCpv,proto3,oneof"`
}

type Campaign_MaximizeConversions struct {
	MaximizeConversions *common.MaximizeConversions `protobuf:"bytes,30,opt,name=maximize_conversions,json=maximizeConversions,proto3,oneof"`
}

type Campaign_MaximizeConversionValue struct {
	MaximizeConversionValue *common.MaximizeConversionValue `protobuf:"bytes,31,opt,name=maximize_conversion_value,json=maximizeConversionValue,proto3,oneof"`
}

type Campaign_TargetCpa struct {
	TargetCpa *common.TargetCpa `protobuf:"bytes,26,opt,name=target_cpa,json=targetCpa,proto3,oneof"`
}

type Campaign_TargetRoas struct {
	TargetRoas *common.TargetRoas `protobuf:"bytes,29,opt,name=target_roas,json=targetRoas,proto3,oneof"`
}

type Campaign_TargetSpend struct {
	TargetSpend *common.TargetSpend `protobuf:"bytes,27,opt,name=target_spend,json=targetSpend,proto3,oneof"`
}

type Campaign_PercentCpc struct {
	PercentCpc *common.PercentCpc `protobuf:"bytes,34,opt,name=percent_cpc,json=percentCpc,proto3,oneof"`
}

func (*Campaign_BiddingStrategy) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpm) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpv) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversions) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversionValue) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpa) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetRoas) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetSpend) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_PercentCpc) isCampaign_CampaignBiddingStrategy() {}

func (m *Campaign) GetCampaignBiddingStrategy() isCampaign_CampaignBiddingStrategy {
	if m != nil {
		return m.CampaignBiddingStrategy
	}
	return nil
}

func (m *Campaign) GetBiddingStrategy() *wrappers.StringValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_BiddingStrategy); ok {
		return x.BiddingStrategy
	}
	return nil
}

func (m *Campaign) GetManualCpc() *common.ManualCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpc); ok {
		return x.ManualCpc
	}
	return nil
}

func (m *Campaign) GetManualCpm() *common.ManualCpm {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpm); ok {
		return x.ManualCpm
	}
	return nil
}

func (m *Campaign) GetManualCpv() *common.ManualCpv {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpv); ok {
		return x.ManualCpv
	}
	return nil
}

func (m *Campaign) GetMaximizeConversions() *common.MaximizeConversions {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversions); ok {
		return x.MaximizeConversions
	}
	return nil
}

func (m *Campaign) GetMaximizeConversionValue() *common.MaximizeConversionValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversionValue); ok {
		return x.MaximizeConversionValue
	}
	return nil
}

func (m *Campaign) GetTargetCpa() *common.TargetCpa {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetCpa); ok {
		return x.TargetCpa
	}
	return nil
}

func (m *Campaign) GetTargetRoas() *common.TargetRoas {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetRoas); ok {
		return x.TargetRoas
	}
	return nil
}

func (m *Campaign) GetTargetSpend() *common.TargetSpend {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetSpend); ok {
		return x.TargetSpend
	}
	return nil
}

func (m *Campaign) GetPercentCpc() *common.PercentCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_PercentCpc); ok {
		return x.PercentCpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Campaign) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Campaign_OneofMarshaler, _Campaign_OneofUnmarshaler, _Campaign_OneofSizer, []interface{}{
		(*Campaign_BiddingStrategy)(nil),
		(*Campaign_ManualCpc)(nil),
		(*Campaign_ManualCpm)(nil),
		(*Campaign_ManualCpv)(nil),
		(*Campaign_MaximizeConversions)(nil),
		(*Campaign_MaximizeConversionValue)(nil),
		(*Campaign_TargetCpa)(nil),
		(*Campaign_TargetRoas)(nil),
		(*Campaign_TargetSpend)(nil),
		(*Campaign_PercentCpc)(nil),
	}
}

func _Campaign_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Campaign)
	// campaign_bidding_strategy
	switch x := m.CampaignBiddingStrategy.(type) {
	case *Campaign_BiddingStrategy:
		b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BiddingStrategy); err != nil {
			return err
		}
	case *Campaign_ManualCpc:
		b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpc); err != nil {
			return err
		}
	case *Campaign_ManualCpm:
		b.EncodeVarint(25<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpm); err != nil {
			return err
		}
	case *Campaign_ManualCpv:
		b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpv); err != nil {
			return err
		}
	case *Campaign_MaximizeConversions:
		b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversions); err != nil {
			return err
		}
	case *Campaign_MaximizeConversionValue:
		b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversionValue); err != nil {
			return err
		}
	case *Campaign_TargetCpa:
		b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpa); err != nil {
			return err
		}
	case *Campaign_TargetRoas:
		b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetRoas); err != nil {
			return err
		}
	case *Campaign_TargetSpend:
		b.EncodeVarint(27<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetSpend); err != nil {
			return err
		}
	case *Campaign_PercentCpc:
		b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PercentCpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Campaign.CampaignBiddingStrategy has unexpected type %T", x)
	}
	return nil
}

func _Campaign_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Campaign)
	switch tag {
	case 23: // campaign_bidding_strategy.bidding_strategy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_BiddingStrategy{msg}
		return true, err
	case 24: // campaign_bidding_strategy.manual_cpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpc)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpc{msg}
		return true, err
	case 25: // campaign_bidding_strategy.manual_cpm
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpm)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpm{msg}
		return true, err
	case 37: // campaign_bidding_strategy.manual_cpv
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpv)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpv{msg}
		return true, err
	case 30: // campaign_bidding_strategy.maximize_conversions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MaximizeConversions)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_MaximizeConversions{msg}
		return true, err
	case 31: // campaign_bidding_strategy.maximize_conversion_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MaximizeConversionValue)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_MaximizeConversionValue{msg}
		return true, err
	case 26: // campaign_bidding_strategy.target_cpa
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetCpa)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetCpa{msg}
		return true, err
	case 29: // campaign_bidding_strategy.target_roas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetRoas)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetRoas{msg}
		return true, err
	case 27: // campaign_bidding_strategy.target_spend
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetSpend)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetSpend{msg}
		return true, err
	case 34: // campaign_bidding_strategy.percent_cpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.PercentCpc)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_PercentCpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Campaign_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Campaign)
	// campaign_bidding_strategy
	switch x := m.CampaignBiddingStrategy.(type) {
	case *Campaign_BiddingStrategy:
		s := proto.Size(x.BiddingStrategy)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpc:
		s := proto.Size(x.ManualCpc)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpm:
		s := proto.Size(x.ManualCpm)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpv:
		s := proto.Size(x.ManualCpv)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_MaximizeConversions:
		s := proto.Size(x.MaximizeConversions)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_MaximizeConversionValue:
		s := proto.Size(x.MaximizeConversionValue)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetCpa:
		s := proto.Size(x.TargetCpa)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetRoas:
		s := proto.Size(x.TargetRoas)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetSpend:
		s := proto.Size(x.TargetSpend)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_PercentCpc:
		s := proto.Size(x.PercentCpc)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The network settings for the campaign.
type Campaign_NetworkSettings struct {
	// Whether ads will be served with google.com search results.
	TargetGoogleSearch *wrappers.BoolValue `protobuf:"bytes,1,opt,name=target_google_search,json=targetGoogleSearch,proto3" json:"target_google_search,omitempty"`
	// Whether ads will be served on partner sites in the Google Search Network
	// (requires `target_google_search` to also be `true`).
	TargetSearchNetwork *wrappers.BoolValue `protobuf:"bytes,2,opt,name=target_search_network,json=targetSearchNetwork,proto3" json:"target_search_network,omitempty"`
	// Whether ads will be served on specified placements in the Google Display
	// Network. Placements are specified using the Placement criterion.
	TargetContentNetwork *wrappers.BoolValue `protobuf:"bytes,3,opt,name=target_content_network,json=targetContentNetwork,proto3" json:"target_content_network,omitempty"`
	// Whether ads will be served on the Google Partner Network.
	// This is available only to some select Google partner accounts.
	TargetPartnerSearchNetwork *wrappers.BoolValue `protobuf:"bytes,4,opt,name=target_partner_search_network,json=targetPartnerSearchNetwork,proto3" json:"target_partner_search_network,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}            `json:"-"`
	XXX_unrecognized           []byte              `json:"-"`
	XXX_sizecache              int32               `json:"-"`
}

func (m *Campaign_NetworkSettings) Reset()         { *m = Campaign_NetworkSettings{} }
func (m *Campaign_NetworkSettings) String() string { return proto.CompactTextString(m) }
func (*Campaign_NetworkSettings) ProtoMessage()    {}
func (*Campaign_NetworkSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_153eb7de4e2bcd72, []int{0, 0}
}
func (m *Campaign_NetworkSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_NetworkSettings.Unmarshal(m, b)
}
func (m *Campaign_NetworkSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_NetworkSettings.Marshal(b, m, deterministic)
}
func (dst *Campaign_NetworkSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_NetworkSettings.Merge(dst, src)
}
func (m *Campaign_NetworkSettings) XXX_Size() int {
	return xxx_messageInfo_Campaign_NetworkSettings.Size(m)
}
func (m *Campaign_NetworkSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_NetworkSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_NetworkSettings proto.InternalMessageInfo

func (m *Campaign_NetworkSettings) GetTargetGoogleSearch() *wrappers.BoolValue {
	if m != nil {
		return m.TargetGoogleSearch
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetSearchNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetContentNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetContentNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetPartnerSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetPartnerSearchNetwork
	}
	return nil
}

// Campaign-level settings for hotel ads.
type Campaign_HotelSettingInfo struct {
	// The linked Hotel Center account.
	HotelCenterId        *wrappers.Int64Value `protobuf:"bytes,1,opt,name=hotel_center_id,json=hotelCenterId,proto3" json:"hotel_center_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Campaign_HotelSettingInfo) Reset()         { *m = Campaign_HotelSettingInfo{} }
func (m *Campaign_HotelSettingInfo) String() string { return proto.CompactTextString(m) }
func (*Campaign_HotelSettingInfo) ProtoMessage()    {}
func (*Campaign_HotelSettingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_153eb7de4e2bcd72, []int{0, 1}
}
func (m *Campaign_HotelSettingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Unmarshal(m, b)
}
func (m *Campaign_HotelSettingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Marshal(b, m, deterministic)
}
func (dst *Campaign_HotelSettingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_HotelSettingInfo.Merge(dst, src)
}
func (m *Campaign_HotelSettingInfo) XXX_Size() int {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Size(m)
}
func (m *Campaign_HotelSettingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_HotelSettingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_HotelSettingInfo proto.InternalMessageInfo

func (m *Campaign_HotelSettingInfo) GetHotelCenterId() *wrappers.Int64Value {
	if m != nil {
		return m.HotelCenterId
	}
	return nil
}

// The setting for controlling Dynamic Search Ads (DSA).
type Campaign_DynamicSearchAdsSetting struct {
	// The Internet domain name that this setting represents, e.g., "google.com"
	// or "www.google.com".
	DomainName *wrappers.StringValue `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// The language code specifying the language of the domain, e.g., "en".
	LanguageCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the campaign uses advertiser supplied URLs exclusively.
	UseSuppliedUrlsOnly *wrappers.BoolValue `protobuf:"bytes,3,opt,name=use_supplied_urls_only,json=useSuppliedUrlsOnly,proto3" json:"use_supplied_urls_only,omitempty"`
	// The list of page feeds associated with the campaign.
	FeedIds              []*wrappers.Int64Value `protobuf:"bytes,4,rep,name=feed_ids,json=feedIds,proto3" json:"feed_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Campaign_DynamicSearchAdsSetting) Reset()         { *m = Campaign_DynamicSearchAdsSetting{} }
func (m *Campaign_DynamicSearchAdsSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_DynamicSearchAdsSetting) ProtoMessage()    {}
func (*Campaign_DynamicSearchAdsSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_153eb7de4e2bcd72, []int{0, 2}
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Unmarshal(m, b)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Marshal(b, m, deterministic)
}
func (dst *Campaign_DynamicSearchAdsSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Merge(dst, src)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Size(m)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_DynamicSearchAdsSetting proto.InternalMessageInfo

func (m *Campaign_DynamicSearchAdsSetting) GetDomainName() *wrappers.StringValue {
	if m != nil {
		return m.DomainName
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetLanguageCode() *wrappers.StringValue {
	if m != nil {
		return m.LanguageCode
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetUseSuppliedUrlsOnly() *wrappers.BoolValue {
	if m != nil {
		return m.UseSuppliedUrlsOnly
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetFeedIds() []*wrappers.Int64Value {
	if m != nil {
		return m.FeedIds
	}
	return nil
}

// The setting for Shopping campaigns. Defines the universe of products that
// can be advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type Campaign_ShoppingSetting struct {
	// ID of the Merchant Center account.
	// This field is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=merchant_id,json=merchantId,proto3" json:"merchant_id,omitempty"`
	// Sales country of products to include in the campaign.
	// This field is required for Shopping campaigns. This field is immutable.
	// This field is optional for non-Shopping campaigns, but it must be equal
	// to 'ZZ' if set.
	SalesCountry *wrappers.StringValue `protobuf:"bytes,2,opt,name=sales_country,json=salesCountry,proto3" json:"sales_country,omitempty"`
	// Priority of the campaign. Campaigns with numerically higher priorities
	// take precedence over those with lower priorities.
	// This field is required for Shopping campaigns, with values between 0 and
	// 2, inclusive.
	// This field is optional for Smart Shopping campaigns, but must be equal to
	// 3 if set.
	CampaignPriority *wrappers.Int32Value `protobuf:"bytes,3,opt,name=campaign_priority,json=campaignPriority,proto3" json:"campaign_priority,omitempty"`
	// Enable local inventory ads. This field is ignored for Smart Shopping
	// campaigns.
	EnableLocal          *wrappers.BoolValue `protobuf:"bytes,4,opt,name=enable_local,json=enableLocal,proto3" json:"enable_local,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Campaign_ShoppingSetting) Reset()         { *m = Campaign_ShoppingSetting{} }
func (m *Campaign_ShoppingSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_ShoppingSetting) ProtoMessage()    {}
func (*Campaign_ShoppingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_153eb7de4e2bcd72, []int{0, 3}
}
func (m *Campaign_ShoppingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_ShoppingSetting.Unmarshal(m, b)
}
func (m *Campaign_ShoppingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_ShoppingSetting.Marshal(b, m, deterministic)
}
func (dst *Campaign_ShoppingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_ShoppingSetting.Merge(dst, src)
}
func (m *Campaign_ShoppingSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_ShoppingSetting.Size(m)
}
func (m *Campaign_ShoppingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_ShoppingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_ShoppingSetting proto.InternalMessageInfo

func (m *Campaign_ShoppingSetting) GetMerchantId() *wrappers.Int64Value {
	if m != nil {
		return m.MerchantId
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetSalesCountry() *wrappers.StringValue {
	if m != nil {
		return m.SalesCountry
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetCampaignPriority() *wrappers.Int32Value {
	if m != nil {
		return m.CampaignPriority
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetEnableLocal() *wrappers.BoolValue {
	if m != nil {
		return m.EnableLocal
	}
	return nil
}

func init() {
	proto.RegisterType((*Campaign)(nil), "google.ads.googleads.v0.resources.Campaign")
	proto.RegisterType((*Campaign_NetworkSettings)(nil), "google.ads.googleads.v0.resources.Campaign.NetworkSettings")
	proto.RegisterType((*Campaign_HotelSettingInfo)(nil), "google.ads.googleads.v0.resources.Campaign.HotelSettingInfo")
	proto.RegisterType((*Campaign_DynamicSearchAdsSetting)(nil), "google.ads.googleads.v0.resources.Campaign.DynamicSearchAdsSetting")
	proto.RegisterType((*Campaign_ShoppingSetting)(nil), "google.ads.googleads.v0.resources.Campaign.ShoppingSetting")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/campaign.proto", fileDescriptor_campaign_153eb7de4e2bcd72)
}

var fileDescriptor_campaign_153eb7de4e2bcd72 = []byte{
	// 1511 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x98, 0x5d, 0x6f, 0xdb, 0x36,
	0x17, 0xc7, 0x63, 0x27, 0x4f, 0x9b, 0xd0, 0x79, 0x7b, 0x98, 0x26, 0x51, 0x9c, 0xbe, 0xa4, 0xed,
	0xd3, 0x67, 0xd9, 0x3a, 0xc8, 0x59, 0xb2, 0xb5, 0x18, 0xd2, 0x0e, 0x4d, 0xdc, 0x97, 0xa4, 0x68,
	0x53, 0x43, 0x4e, 0xb3, 0xa2, 0xc8, 0x20, 0xd0, 0x12, 0xed, 0x08, 0x95, 0x48, 0x95, 0xa4, 0xdc,
	0x7a, 0x17, 0xc3, 0xae, 0xf7, 0x01, 0xb6, 0x8b, 0x5d, 0x0c, 0x18, 0x76, 0xb5, 0x8f, 0xb2, 0xcb,
	0x7d, 0x82, 0x7d, 0x94, 0x41, 0x24, 0xa5, 0xd8, 0x8e, 0x6d, 0xc9, 0x77, 0x22, 0x79, 0x7e, 0xff,
	0x73, 0x78, 0xf8, 0x72, 0x68, 0x83, 0xad, 0x16, 0xa5, 0x2d, 0x1f, 0x57, 0x90, 0xcb, 0x2b, 0xea,
	0x33, 0xfe, 0x6a, 0x6f, 0x55, 0x18, 0xe6, 0x34, 0x62, 0x0e, 0xe6, 0x15, 0x07, 0x05, 0x21, 0xf2,
	0x5a, 0xc4, 0x0c, 0x19, 0x15, 0x14, 0xde, 0x54, 0x66, 0x26, 0x72, 0xb9, 0x99, 0x12, 0x66, 0x7b,
	0xcb, 0x4c, 0x89, 0xf2, 0xe7, 0xc3, 0x44, 0x1d, 0x1a, 0x04, 0x94, 0x54, 0x1a, 0x9e, 0xeb, 0x7a,
	0xa4, 0xa5, 0x04, 0xcb, 0x5f, 0x65, 0x58, 0x3b, 0x11, 0x17, 0x34, 0xb0, 0x43, 0xc4, 0x50, 0x80,
	0x05, 0x66, 0x1a, 0xdb, 0xce, 0xc0, 0x9a, 0x0c, 0xbf, 0x8f, 0x30, 0x71, 0x3a, 0xb6, 0x83, 0x42,
	0xcd, 0x7c, 0x93, 0xc1, 0x30, 0x8c, 0x7c, 0x5b, 0x78, 0x01, 0xb6, 0x75, 0x88, 0x36, 0xc7, 0x42,
	0x9c, 0x87, 0xba, 0x3f, 0x8c, 0xc7, 0x24, 0x0a, 0x78, 0x05, 0xb9, 0x36, 0xc7, 0xac, 0x1d, 0x73,
	0x34, 0x14, 0x5e, 0xe0, 0x7d, 0x8f, 0x84, 0x47, 0x89, 0xcd, 0x05, 0x12, 0x11, 0xd7, 0x1a, 0x8f,
	0xb2, 0x34, 0xda, 0x98, 0x09, 0x8f, 0xc7, 0x22, 0xce, 0x19, 0x22, 0x04, 0xfb, 0x36, 0x8f, 0x1a,
	0xb6, 0xe8, 0x84, 0x58, 0x2b, 0x3c, 0x18, 0x5f, 0xa1, 0x8b, 0xfe, 0x7a, 0x34, 0x9d, 0x4e, 0x5c,
	0x30, 0x24, 0x70, 0xab, 0xd3, 0x8d, 0xee, 0x8e, 0x46, 0x93, 0x8d, 0x92, 0x26, 0xa1, 0x67, 0xde,
	0x3b, 0x79, 0xe1, 0x6e, 0xe8, 0xba, 0x86, 0x64, 0xab, 0x11, 0x35, 0x2b, 0x1f, 0x18, 0x0a, 0x43,
	0xcc, 0xf4, 0xf8, 0xad, 0x9f, 0x6f, 0x80, 0xe9, 0xaa, 0x26, 0xe1, 0x6d, 0x30, 0x97, 0xec, 0x41,
	0x9b, 0xa0, 0x00, 0x1b, 0x85, 0x8d, 0xc2, 0xe6, 0x8c, 0x35, 0x9b, 0x74, 0x1e, 0xa1, 0x00, 0xc3,
	0xbb, 0xa0, 0xe8, 0xb9, 0xc6, 0xe4, 0x46, 0x61, 0xb3, 0xb4, 0xbd, 0xae, 0x37, 0xb0, 0x99, 0xc8,
	0x9b, 0x87, 0x44, 0xdc, 0xfb, 0xf2, 0x04, 0xf9, 0x11, 0xb6, 0x8a, 0x9e, 0x0b, 0xb7, 0xc0, 0x94,
	0x14, 0x9a, 0x92, 0xe6, 0x57, 0x2f, 0x98, 0xd7, 0x05, 0xf3, 0x48, 0x4b, 0xd9, 0x4b, 0x4b, 0xf8,
	0x06, 0x5c, 0x52, 0x13, 0x30, 0xfe, 0xb3, 0x51, 0xd8, 0x9c, 0xdf, 0x7e, 0x64, 0x0e, 0x3b, 0x2e,
	0x72, 0xda, 0x66, 0x12, 0x7c, 0x5d, 0x42, 0x4f, 0x48, 0x14, 0xf4, 0x75, 0x59, 0x5a, 0x0f, 0x46,
	0x60, 0xbe, 0x37, 0xaf, 0xc6, 0xb2, 0xf4, 0x70, 0x94, 0xd7, 0x83, 0x82, 0x07, 0x39, 0xea, 0x1e,
	0xb1, 0xe6, 0x78, 0x77, 0x13, 0xfe, 0x56, 0x00, 0xd7, 0x47, 0xef, 0x6b, 0x63, 0x5a, 0xc6, 0xf1,
	0x36, 0x23, 0x8e, 0x3d, 0x57, 0xfb, 0x79, 0xd5, 0x25, 0xd1, 0x15, 0xcd, 0x88, 0x71, 0x6b, 0x1d,
	0x0d, 0x1f, 0x84, 0x3f, 0x15, 0x80, 0x31, 0x6c, 0xcf, 0x1b, 0x33, 0x32, 0xb6, 0x5a, 0x66, 0x6c,
	0x29, 0x5e, 0x55, 0xf4, 0x71, 0x27, 0xc4, 0x3a, 0xac, 0x41, 0x43, 0xd6, 0x0a, 0x1a, 0xd8, 0x0f,
	0x7f, 0x29, 0x80, 0xab, 0xa3, 0x8e, 0xb0, 0x01, 0x64, 0x40, 0x27, 0x63, 0x07, 0x54, 0x8f, 0x1a,
	0x23, 0x62, 0xd2, 0xa3, 0xd6, 0x1a, 0x1a, 0x36, 0x04, 0x6b, 0x60, 0x59, 0x30, 0xe4, 0xbc, 0x8b,
	0xa3, 0x8a, 0x98, 0x6f, 0x0b, 0x1c, 0x84, 0x3e, 0x12, 0xd8, 0x28, 0xe5, 0xd8, 0xdc, 0x4b, 0x09,
	0xfa, 0x9a, 0xf9, 0xc7, 0x1a, 0x84, 0x0e, 0x58, 0x8e, 0x85, 0xfa, 0xef, 0x67, 0x6e, 0xcc, 0x6e,
	0x4c, 0x6e, 0x96, 0xb6, 0x2b, 0x43, 0xe7, 0xa8, 0x6e, 0x5b, 0xb3, 0x2a, 0xc1, 0x5a, 0xc2, 0x59,
	0x4b, 0x11, 0xf3, 0xfb, 0xfa, 0x38, 0x7c, 0x0f, 0xd6, 0x86, 0xde, 0xca, 0xc6, 0x27, 0x32, 0xf4,
	0x7b, 0x59, 0x8e, 0x2c, 0x8c, 0xfc, 0x63, 0x2f, 0xc0, 0xfb, 0x0a, 0xaf, 0x2b, 0xda, 0x5a, 0x61,
	0x03, 0xfb, 0x61, 0x13, 0x2c, 0x12, 0x2c, 0x3e, 0x50, 0xf6, 0x2e, 0x71, 0xc4, 0x8d, 0x79, 0xe9,
	0x69, 0xd7, 0xcc, 0x2c, 0x7e, 0xe9, 0xa9, 0x32, 0x8f, 0x94, 0x86, 0x56, 0xe5, 0xd6, 0x02, 0xe9,
	0xed, 0x80, 0x08, 0xcc, 0x9d, 0x51, 0x11, 0x6f, 0x0e, 0x3d, 0x9d, 0x0d, 0xe9, 0xe4, 0xc1, 0x38,
	0x4e, 0x0e, 0x62, 0x01, 0xad, 0x78, 0x48, 0x9a, 0xd4, 0x9a, 0x3d, 0xeb, 0xea, 0x81, 0x3f, 0x16,
	0x40, 0xd9, 0xed, 0x10, 0x14, 0x78, 0x8e, 0xcd, 0x31, 0x62, 0xce, 0x99, 0x8d, 0x5c, 0x9e, 0x3a,
	0xbc, 0x29, 0x1d, 0x56, 0xc7, 0x71, 0xf8, 0x58, 0xa9, 0xd5, 0xa5, 0xd8, 0x9e, 0xcb, 0x93, 0x64,
	0xae, 0xba, 0x83, 0x07, 0xe2, 0x6c, 0xf2, 0x33, 0x1a, 0x86, 0xdd, 0xeb, 0xf6, 0xbf, 0xf1, 0xb3,
	0x59, 0xd7, 0x1a, 0x89, 0xbf, 0x05, 0xde, 0xdb, 0x01, 0x9f, 0x80, 0x85, 0xb4, 0x86, 0x34, 0x22,
	0xb7, 0x85, 0x85, 0x71, 0x29, 0xc7, 0xce, 0x9e, 0x4f, 0xa0, 0x7d, 0xc9, 0xc0, 0x1f, 0xc0, 0xf2,
	0xc0, 0x12, 0x68, 0xac, 0xc8, 0x83, 0xfb, 0x3c, 0xe3, 0xe0, 0x26, 0x5b, 0x49, 0xa3, 0xe9, 0x91,
	0x1d, 0xd0, 0x6f, 0x2d, 0x35, 0x2e, 0x76, 0xc2, 0x5d, 0x00, 0xb8, 0x40, 0x4c, 0xd8, 0x6e, 0x7c,
	0x36, 0x97, 0x72, 0xcc, 0x60, 0x46, 0xda, 0x3f, 0x8e, 0x4f, 0x64, 0x15, 0xa4, 0xd3, 0xb1, 0x5b,
	0x8c, 0x46, 0xa1, 0x71, 0x3b, 0x87, 0xc0, 0x5c, 0xc2, 0x3c, 0x8b, 0x11, 0x78, 0x1f, 0x4c, 0x63,
	0xe2, 0x2a, 0xff, 0x57, 0x72, 0xe0, 0x97, 0x31, 0x71, 0xa5, 0xf7, 0xa7, 0x60, 0xb1, 0xe9, 0x11,
	0xe4, 0xcb, 0xeb, 0x85, 0x47, 0xcd, 0xa6, 0xf7, 0xd1, 0xf8, 0x7f, 0x9e, 0x25, 0x90, 0xd4, 0x6b,
	0xe6, 0xd7, 0x25, 0x03, 0xdf, 0x80, 0xf9, 0x9e, 0xc7, 0x1b, 0x37, 0x36, 0xe5, 0x85, 0xf2, 0x45,
	0xd6, 0x39, 0x7f, 0x9a, 0x50, 0x55, 0x14, 0x3e, 0x21, 0x82, 0x75, 0xac, 0xb9, 0x66, 0x57, 0x17,
	0x87, 0x87, 0x60, 0xb1, 0x7f, 0x71, 0x8d, 0xd5, 0xec, 0x08, 0x0f, 0x26, 0xac, 0x85, 0xbe, 0xb5,
	0x82, 0xcf, 0x01, 0x08, 0x10, 0x89, 0x90, 0x6f, 0x3b, 0xa1, 0x63, 0x18, 0x52, 0xe4, 0xd3, 0xac,
	0x00, 0x5f, 0x4a, 0xa2, 0x1a, 0x3a, 0x07, 0x13, 0xd6, 0x4c, 0x90, 0x34, 0x7a, 0xb4, 0x02, 0x63,
	0x6d, 0x3c, 0xad, 0xa0, 0x5b, 0x2b, 0xe8, 0xd1, 0x6a, 0x1b, 0x77, 0xc6, 0xd3, 0x6a, 0x77, 0x6b,
	0xb5, 0xe1, 0x19, 0xb8, 0x12, 0xa0, 0x8f, 0x71, 0xbd, 0xc5, 0xb6, 0x43, 0x49, 0x1b, 0x33, 0xee,
	0x51, 0xc2, 0x8d, 0xeb, 0x52, 0x75, 0x27, 0x5b, 0x55, 0xb1, 0xd5, 0x73, 0xf4, 0x60, 0xc2, 0x5a,
	0x0a, 0x2e, 0x76, 0xc3, 0x08, 0xac, 0x0d, 0xf0, 0x64, 0xb7, 0xe3, 0xec, 0x1b, 0x37, 0xa4, 0xbb,
	0xfb, 0xe3, 0xbb, 0x4b, 0x16, 0x6f, 0x35, 0x18, 0x3c, 0x14, 0x27, 0x4b, 0x20, 0xd6, 0xc2, 0xc2,
	0x76, 0x42, 0x64, 0x94, 0xf3, 0x25, 0xeb, 0x58, 0x12, 0xd5, 0x10, 0xc5, 0xc9, 0x12, 0x49, 0x03,
	0xbe, 0x04, 0x25, 0xad, 0xc5, 0x28, 0xe2, 0xc6, 0x35, 0x29, 0xf6, 0x59, 0x3e, 0x31, 0x8b, 0xa2,
	0x38, 0x35, 0x3a, 0x98, 0xb8, 0x05, 0x6b, 0x60, 0x56, 0xcb, 0xf1, 0x10, 0x13, 0xd7, 0x58, 0x97,
	0x7a, 0x77, 0xf3, 0xe9, 0xd5, 0x63, 0xe4, 0x60, 0xc2, 0xd2, 0x11, 0xc9, 0x66, 0x1c, 0x60, 0x88,
	0x99, 0x83, 0x89, 0x90, 0x5b, 0xf6, 0x56, 0xbe, 0x00, 0x6b, 0x0a, 0x51, 0x7b, 0x16, 0x84, 0x69,
	0xab, 0xfc, 0x4f, 0x11, 0x2c, 0xf4, 0x95, 0x38, 0xf8, 0x02, 0x5c, 0xd1, 0x41, 0x2b, 0x29, 0x5d,
	0x73, 0xe4, 0x43, 0xbc, 0xb4, 0x5d, 0xbe, 0x70, 0xc6, 0xf6, 0x29, 0xf5, 0xd5, 0x1d, 0x00, 0x15,
	0xf7, 0x4c, 0x1a, 0xa8, 0x1a, 0x02, 0x8f, 0xc0, 0x72, 0x92, 0x02, 0x55, 0xba, 0x74, 0x01, 0x35,
	0x8a, 0x99, 0x72, 0x4b, 0x7a, 0xe2, 0x92, 0xd3, 0x51, 0xc2, 0x1a, 0x58, 0x49, 0x56, 0x9b, 0x12,
	0x11, 0xe7, 0x21, 0x11, 0x9c, 0xcc, 0x14, 0xd4, 0xf3, 0xaa, 0x2a, 0x30, 0x51, 0xfc, 0x0e, 0x5c,
	0xd3, 0x8a, 0x21, 0x62, 0x82, 0x60, 0xd6, 0x1f, 0xe9, 0x54, 0xa6, 0x70, 0x59, 0x09, 0xd4, 0x14,
	0xdf, 0x13, 0x70, 0xf9, 0x5b, 0xb0, 0xd8, 0x5f, 0xdf, 0x61, 0x15, 0x2c, 0xa8, 0x47, 0x43, 0xbc,
	0x0e, 0x98, 0xd9, 0x9e, 0xab, 0xb3, 0x3b, 0xf2, 0xc7, 0x8c, 0x7a, 0x68, 0x54, 0x25, 0x72, 0xe8,
	0x96, 0xff, 0x28, 0x82, 0xd5, 0x21, 0x85, 0x1c, 0x3e, 0x04, 0x25, 0x97, 0x06, 0xc8, 0x23, 0xe7,
	0xbf, 0xa1, 0xb2, 0x2e, 0x70, 0xa0, 0x00, 0xf9, 0xfb, 0x6a, 0x0f, 0xcc, 0xf9, 0x88, 0xb4, 0x22,
	0xd4, 0x8a, 0x4f, 0xb2, 0x8b, 0xf5, 0x62, 0x8d, 0x16, 0x98, 0x4d, 0x90, 0x2a, 0x75, 0x31, 0x7c,
	0x05, 0x56, 0x22, 0x8e, 0x6d, 0x1e, 0x85, 0xa1, 0xef, 0x61, 0x37, 0x2e, 0x27, 0xdc, 0xa6, 0xc4,
	0xef, 0xe4, 0x58, 0xa7, 0xa5, 0x88, 0xe3, 0xba, 0x06, 0x5f, 0x33, 0x9f, 0xbf, 0x22, 0x7e, 0x07,
	0xde, 0x03, 0xd3, 0x4d, 0x8c, 0x5d, 0xdb, 0x73, 0xb9, 0x31, 0x25, 0x4b, 0xc9, 0xc8, 0x64, 0x5d,
	0x8e, 0x8d, 0x0f, 0x5d, 0x5e, 0xfe, 0xb5, 0x08, 0x16, 0xfa, 0xde, 0x1d, 0xf0, 0x01, 0x28, 0x05,
	0x98, 0xc5, 0xcf, 0x7a, 0x91, 0x33, 0xf7, 0x20, 0xb1, 0x3f, 0x74, 0xe3, 0xec, 0x70, 0xe4, 0x63,
	0x6e, 0x3b, 0x34, 0x8a, 0x0b, 0x54, 0xbe, 0xec, 0x48, 0xa4, 0xaa, 0x08, 0x78, 0x00, 0xfe, 0x9b,
	0xd6, 0xf8, 0x90, 0x79, 0x94, 0x79, 0xa2, 0x33, 0xea, 0xf7, 0xec, 0xce, 0xb6, 0x52, 0x59, 0x4c,
	0xa8, 0x9a, 0x86, 0xe0, 0x43, 0x30, 0x8b, 0x09, 0x6a, 0xf8, 0xd8, 0xf6, 0xa9, 0x83, 0xfc, 0x1c,
	0x9b, 0xb5, 0xa4, 0xec, 0x5f, 0xc4, 0xe6, 0xfb, 0xeb, 0x60, 0xed, 0xfc, 0xc1, 0xd5, 0x57, 0x55,
	0xf7, 0xff, 0x2e, 0x80, 0x3b, 0x0e, 0x0d, 0xb2, 0x5f, 0x78, 0xfb, 0x73, 0xd5, 0x34, 0x2e, 0x2a,
	0x68, 0xad, 0xf0, 0xf6, 0xb9, 0x66, 0x5a, 0x34, 0xde, 0x15, 0x26, 0x65, 0xad, 0x4a, 0x0b, 0x13,
	0x19, 0x4d, 0xf2, 0xc7, 0x41, 0xe8, 0xf1, 0x11, 0xff, 0x58, 0xed, 0xa6, 0x5f, 0xbf, 0x17, 0x27,
	0x9f, 0xed, 0xed, 0xfd, 0x59, 0xbc, 0xa9, 0xee, 0x15, 0x73, 0xcf, 0xe5, 0xa6, 0xfa, 0x8c, 0xbf,
	0x4e, 0xb6, 0x4c, 0x2b, 0xb1, 0xfc, 0x2b, 0xb1, 0x39, 0xdd, 0x73, 0xf9, 0x69, 0x6a, 0x73, 0x7a,
	0xb2, 0x75, 0x9a, 0xda, 0x34, 0x2e, 0xc9, 0x20, 0x76, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x40,
	0x6d, 0xdb, 0x8e, 0x35, 0x13, 0x00, 0x00,
}
