/* SqliteDatabase.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from SqliteDatabase.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabasesqliteSqliteDatabasePrivate {
	GFile* _database_file;
	gint new_version;
};


static gpointer dvb_database_sqlite_sqlite_database_parent_class = NULL;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_database_log;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_database_log = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabasePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DUMMY_PROPERTY,
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error);
GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error);
gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version);
void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self);
static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value);
static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj);
static void _vala_dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version) {
	DVBdatabasesqliteSqliteDatabase * self = NULL;
	GFile* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (dbfile != NULL, NULL);
	_tmp0_ = dbfile;
	self = (DVBdatabasesqliteSqliteDatabase*) g_object_new (object_type, "database-file", _tmp0_, NULL);
	_tmp1_ = version;
	self->priv->new_version = _tmp1_;
	return self;
}


/**
         * Open database and create or upgrade tables if neccessary
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	sqlite3* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* dbfile;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean create_tables;
	GFile* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* dbfile_dir;
	GFile* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	sqlite3* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_;
	gint _tmp19_ = 0;
	gint version;
	gboolean _tmp20_;
	gint _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->db;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_database_file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	dbfile = _tmp2_;
	_tmp3_ = dbfile;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	create_tables = !_tmp4_;
	_tmp5_ = dbfile;
	_tmp6_ = g_file_get_parent (_tmp5_);
	dbfile_dir = _tmp6_;
	_tmp7_ = dbfile_dir;
	_tmp8_ = g_file_query_exists (_tmp7_, NULL);
	if (!_tmp8_) {
		{
			GFile* _tmp9_;
			_tmp9_ = dbfile_dir;
			dvb_utils_mkdirs (_tmp9_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = dvb_database_sqlite_sqlite_database_log;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			dvb_logging_logger_error (_tmp10_, "SqliteDatabase.vala:54: Could not create directory: %s", _tmp12_);
			_g_error_free0 (e);
			_g_object_unref0 (dbfile_dir);
			_g_object_unref0 (dbfile);
			return;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp13_ = dbfile;
	_tmp14_ = g_file_get_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp17_ = sqlite3_open (_tmp15_, &_tmp16_);
	_sqlite3_close0 (self->db);
	self->db = _tmp16_;
	_tmp18_ = _tmp17_ != SQLITE_OK;
	_g_free0 (_tmp15_);
	if (_tmp18_) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp19_ = dvb_database_sqlite_sqlite_database_get_version (self);
	version = _tmp19_;
	_tmp20_ = create_tables;
	if (_tmp20_) {
		DVBLoggingLogger* _tmp21_;
		_tmp21_ = dvb_database_sqlite_sqlite_database_log;
		dvb_logging_logger_debug (_tmp21_, "SqliteDatabase.vala:66: Creating tables");
		dvb_database_sqlite_sqlite_database_create (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = self->priv->new_version;
		_tmp23_ = version;
		if (_tmp22_ > _tmp23_) {
			DVBLoggingLogger* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp24_ = dvb_database_sqlite_sqlite_database_log;
			dvb_logging_logger_debug (_tmp24_, "SqliteDatabase.vala:69: Updating tables");
			_tmp25_ = version;
			_tmp26_ = self->priv->new_version;
			dvb_database_sqlite_sqlite_database_upgrade (self, _tmp25_, _tmp26_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dbfile_dir);
					_g_object_unref0 (dbfile);
					return;
				} else {
					_g_object_unref0 (dbfile_dir);
					_g_object_unref0 (dbfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	_tmp27_ = self->priv->new_version;
	dvb_database_sqlite_sqlite_database_set_version (self, _tmp27_);
	dvb_database_sqlite_sqlite_database_set_journal_mode (self);
	dvb_database_sqlite_sqlite_database_on_open (self);
	_g_object_unref0 (dbfile_dir);
	_g_object_unref0 (dbfile);
}


/**
         * Set database version
         */
void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = version;
		_tmp1_ = g_strdup_printf ("PRAGMA user_version = %d", _tmp0_);
		_tmp2_ = _tmp1_;
		dvb_database_sqlite_sqlite_database_exec_sql (self, _tmp2_, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch1_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = dvb_database_sqlite_sqlite_database_log;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		dvb_logging_logger_error (_tmp3_, "SqliteDatabase.vala:85: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		dvb_database_sqlite_sqlite_database_exec_sql (self, "PRAGMA journal_mode = TRUNCATE", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch2_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = dvb_database_sqlite_sqlite_database_log;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		dvb_logging_logger_error (_tmp0_, "SqliteDatabase.vala:93: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * Get database version
         */
gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self) {
	gint result = 0;
	gint version;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	version = 0;
	{
		gint _tmp0_ = 0;
		gint _tmp1_;
		_tmp0_ = dvb_database_sqlite_sqlite_database_simple_query_int (self, "PRAGMA user_version", &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch3_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		version = _tmp1_;
	}
	goto __finally3;
	__catch3_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = dvb_database_sqlite_sqlite_database_log;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		dvb_logging_logger_error (_tmp2_, "SqliteDatabase.vala:105: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = version;
	return result;
}


gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error) {
	gint result = 0;
	sqlite3_stmt* st = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint ret;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = self->db;
	_tmp1_ = sql;
	sqlite3_prepare (_tmp0_, _tmp1_, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (st);
	st = _tmp2_;
	ret = 0;
	_tmp3_ = st;
	_tmp4_ = sqlite3_step (_tmp3_);
	if (_tmp4_ == SQLITE_ROW) {
		sqlite3_stmt* _tmp5_;
		gint _tmp6_ = 0;
		_tmp5_ = st;
		_tmp6_ = sqlite3_column_int (_tmp5_, 0);
		ret = _tmp6_;
	} else {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (st);
				return 0;
			} else {
				_sqlite3_finalize0 (st);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = ret;
	_sqlite3_finalize0 (st);
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error) {
	gchar* errmsg = NULL;
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint val;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = self->db;
	_tmp1_ = sql;
	_tmp3_ = _sqlite3_exec (_tmp0_, _tmp1_, NULL, NULL, &_tmp2_);
	_g_free0 (errmsg);
	errmsg = _tmp2_;
	val = _tmp3_;
	_tmp4_ = val;
	if (_tmp4_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (errmsg);
				return;
			} else {
				_g_free0 (errmsg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (errmsg);
}


void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_database_sqlite_sqlite_database_exec_sql (self, "BEGIN;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_database_sqlite_sqlite_database_exec_sql (self, "END;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error) {
	sqlite3_stmt* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmnt != NULL);
	_tmp0_ = stmnt;
	sqlite3_reset (_tmp0_);
	dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint code;
	gchar* msg = NULL;
	const gchar* _tmp2_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->db;
	_tmp1_ = sqlite3_errcode (_tmp0_);
	code = _tmp1_;
	_tmp2_ = errmsg;
	if (_tmp2_ == NULL) {
		gint _tmp3_;
		sqlite3* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = code;
		_tmp4_ = self->db;
		_tmp5_ = sqlite3_errmsg (_tmp4_);
		_tmp6_ = g_strdup_printf ("SqlError: %d: %s", _tmp3_, _tmp5_);
		_g_free0 (msg);
		msg = _tmp6_;
	} else {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = errmsg;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (msg);
		msg = _tmp8_;
	}
	_tmp9_ = code;
	switch (_tmp9_) {
		case 1:
		{
			const gchar* _tmp10_;
			GError* _tmp11_;
			_tmp10_ = msg;
			_tmp11_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ERROR, _tmp10_);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 2:
		{
			const gchar* _tmp12_;
			GError* _tmp13_;
			_tmp12_ = msg;
			_tmp13_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERNAL, _tmp12_);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 3:
		{
			const gchar* _tmp14_;
			GError* _tmp15_;
			_tmp14_ = msg;
			_tmp15_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PERM, _tmp14_);
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 4:
		{
			const gchar* _tmp16_;
			GError* _tmp17_;
			_tmp16_ = msg;
			_tmp17_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ABORT, _tmp16_);
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 5:
		{
			const gchar* _tmp18_;
			GError* _tmp19_;
			_tmp18_ = msg;
			_tmp19_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_BUSY, _tmp18_);
			_inner_error_ = _tmp19_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 6:
		{
			const gchar* _tmp20_;
			GError* _tmp21_;
			_tmp20_ = msg;
			_tmp21_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_LOCKED, _tmp20_);
			_inner_error_ = _tmp21_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 7:
		{
			const gchar* _tmp22_;
			GError* _tmp23_;
			_tmp22_ = msg;
			_tmp23_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOMEM, _tmp22_);
			_inner_error_ = _tmp23_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 8:
		{
			const gchar* _tmp24_;
			GError* _tmp25_;
			_tmp24_ = msg;
			_tmp25_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_READONLY, _tmp24_);
			_inner_error_ = _tmp25_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 9:
		{
			const gchar* _tmp26_;
			GError* _tmp27_;
			_tmp26_ = msg;
			_tmp27_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERRUPT, _tmp26_);
			_inner_error_ = _tmp27_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 10:
		{
			const gchar* _tmp28_;
			GError* _tmp29_;
			_tmp28_ = msg;
			_tmp29_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_IOERR, _tmp28_);
			_inner_error_ = _tmp29_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 11:
		{
			const gchar* _tmp30_;
			GError* _tmp31_;
			_tmp30_ = msg;
			_tmp31_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CORRUPT, _tmp30_);
			_inner_error_ = _tmp31_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 12:
		{
			const gchar* _tmp32_;
			GError* _tmp33_;
			_tmp32_ = msg;
			_tmp33_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTFOUND, _tmp32_);
			_inner_error_ = _tmp33_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 13:
		{
			const gchar* _tmp34_;
			GError* _tmp35_;
			_tmp34_ = msg;
			_tmp35_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FULL, _tmp34_);
			_inner_error_ = _tmp35_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 14:
		{
			const gchar* _tmp36_;
			GError* _tmp37_;
			_tmp36_ = msg;
			_tmp37_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CANTOPEN, _tmp36_);
			_inner_error_ = _tmp37_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 15:
		{
			const gchar* _tmp38_;
			GError* _tmp39_;
			_tmp38_ = msg;
			_tmp39_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PROTOCOL, _tmp38_);
			_inner_error_ = _tmp39_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 16:
		{
			const gchar* _tmp40_;
			GError* _tmp41_;
			_tmp40_ = msg;
			_tmp41_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_EMPTY, _tmp40_);
			_inner_error_ = _tmp41_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 17:
		{
			const gchar* _tmp42_;
			GError* _tmp43_;
			_tmp42_ = msg;
			_tmp43_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_SCHEMA, _tmp42_);
			_inner_error_ = _tmp43_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 18:
		{
			const gchar* _tmp44_;
			GError* _tmp45_;
			_tmp44_ = msg;
			_tmp45_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_TOOBIG, _tmp44_);
			_inner_error_ = _tmp45_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 19:
		{
			const gchar* _tmp46_;
			GError* _tmp47_;
			_tmp46_ = msg;
			_tmp47_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CONSTRAINT, _tmp46_);
			_inner_error_ = _tmp47_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 20:
		{
			const gchar* _tmp48_;
			GError* _tmp49_;
			_tmp48_ = msg;
			_tmp49_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISMATCH, _tmp48_);
			_inner_error_ = _tmp49_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 21:
		{
			const gchar* _tmp50_;
			GError* _tmp51_;
			_tmp50_ = msg;
			_tmp51_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISUSE, _tmp50_);
			_inner_error_ = _tmp51_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 22:
		{
			const gchar* _tmp52_;
			GError* _tmp53_;
			_tmp52_ = msg;
			_tmp53_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOLFS, _tmp52_);
			_inner_error_ = _tmp53_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 23:
		{
			const gchar* _tmp54_;
			GError* _tmp55_;
			_tmp54_ = msg;
			_tmp55_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_AUTH, _tmp54_);
			_inner_error_ = _tmp55_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 24:
		{
			const gchar* _tmp56_;
			GError* _tmp57_;
			_tmp56_ = msg;
			_tmp57_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FORMAT, _tmp56_);
			_inner_error_ = _tmp57_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 25:
		{
			const gchar* _tmp58_;
			GError* _tmp59_;
			_tmp58_ = msg;
			_tmp59_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_RANGE, _tmp58_);
			_inner_error_ = _tmp59_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 26:
		{
			const gchar* _tmp60_;
			GError* _tmp61_;
			_tmp60_ = msg;
			_tmp61_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTADB, _tmp60_);
			_inner_error_ = _tmp61_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		default:
		{
			break;
		}
	}
	_g_free0 (msg);
}


/**
         * Called when the database is created for the first time.
         * Put the commands required to create all tables here.
         */
static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_create'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	g_return_if_fail (self != NULL);
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->create (self, error);
}


/**
         * Called when the database needs to be upgraded.
         */
static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_upgrade'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	g_return_if_fail (self != NULL);
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->upgrade (self, old_version, new_version, error);
}


/**
          * Called when the database has been opened.
          */
static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_on_open'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	g_return_if_fail (self != NULL);
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->on_open (self);
}


GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_database_file;
	result = _tmp0_;
	return result;
}


static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_database_file);
	self->priv->_database_file = _tmp1_;
	g_object_notify ((GObject *) self, "database-file");
}


static void dvb_database_sqlite_sqlite_database_class_init (DVBdatabasesqliteSqliteDatabaseClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_database_sqlite_sqlite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteDatabasePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_database_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_database_real_upgrade;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_database_real_on_open;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_database_sqlite_sqlite_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_database_sqlite_sqlite_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_database_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE, g_param_spec_object ("database-file", "database-file", "database-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_database_sqlite_sqlite_database_log = _tmp1_;
}


static void dvb_database_sqlite_sqlite_database_instance_init (DVBdatabasesqliteSqliteDatabase * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (obj);
	_g_object_unref0 (self->priv->_database_file);
	_sqlite3_close0 (self->db);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_database_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_database_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_database_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteDatabase), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_database_instance_init, NULL };
		GType dvb_database_sqlite_sqlite_database_type_id;
		dvb_database_sqlite_sqlite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBdatabasesqliteSqliteDatabase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_database_sqlite_sqlite_database_type_id__volatile, dvb_database_sqlite_sqlite_database_type_id);
	}
	return dvb_database_sqlite_sqlite_database_type_id__volatile;
}


static void _vala_dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		g_value_set_object (value, dvb_database_sqlite_sqlite_database_get_database_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		dvb_database_sqlite_sqlite_database_set_database_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



