/* SqliteConfigTimersStore.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from SqliteConfigTimersStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE (dvb_database_sqlite_sqlite_config_timers_store_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStore))
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStoreClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_CONFIG_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_CONFIG_TIMERS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE))
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStoreClass))

typedef struct _DVBdatabasesqliteSqliteConfigTimersStore DVBdatabasesqliteSqliteConfigTimersStore;
typedef struct _DVBdatabasesqliteSqliteConfigTimersStoreClass DVBdatabasesqliteSqliteConfigTimersStoreClass;
typedef struct _DVBdatabasesqliteSqliteConfigTimersStorePrivate DVBdatabasesqliteSqliteConfigTimersStorePrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

struct _DVBdatabasesqliteSqliteConfigTimersStore {
	DVBdatabasesqliteSqliteDatabase parent_instance;
	DVBdatabasesqliteSqliteConfigTimersStorePrivate * priv;
};

struct _DVBdatabasesqliteSqliteConfigTimersStoreClass {
	DVBdatabasesqliteSqliteDatabaseClass parent_class;
};

struct _DVBdatabasesqliteSqliteConfigTimersStorePrivate {
	sqlite3_stmt* select_devices_statement;
	sqlite3_stmt* delete_group_statement;
	sqlite3_stmt* insert_group_statement;
	sqlite3_stmt* update_group_statement;
	sqlite3_stmt* delete_device_statement;
	sqlite3_stmt* delete_group_devices_statement;
	sqlite3_stmt* insert_device_statement;
	sqlite3_stmt* select_group_of_device_statement;
	sqlite3_stmt* select_timers_statement;
	sqlite3_stmt* delete_timer_statement;
	sqlite3_stmt* delete_group_timers_statement;
	sqlite3_stmt* insert_timer_statement;
	sqlite3_stmt* contains_group_statement;
	sqlite3_stmt* contains_timer_statement;
	sqlite3_stmt* insert_channel_group_statement;
	sqlite3_stmt* delete_channel_group_statement;
	sqlite3_stmt* remove_all_channel_group_statement;
	sqlite3_stmt* select_channel_groups_statement;
	sqlite3_stmt* add_channel_group_statement;
	sqlite3_stmt* remove_channel_group_statement;
	sqlite3_stmt* select_channels_statement;
};

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;


static gpointer dvb_database_sqlite_sqlite_config_timers_store_parent_class = NULL;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_config_timers_store_log;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_config_timers_store_log = NULL;
static DVBdatabaseConfigStoreIface* dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_parent_iface = NULL;
static DVBdatabaseTimersStoreIface* dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_parent_iface = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
GType dvb_database_sqlite_sqlite_config_timers_store_get_type (void) G_GNUC_CONST;
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE, DVBdatabasesqliteSqliteConfigTimersStorePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_VERSION 1
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICE_GROUPS "CREATE TABLE device_groups (\n" \
"        group_id INTEGER,\n" \
"        adapter_type INTEGER(1),\n" \
"        channels_file VARCHAR(255),\n" \
"        recordings_dir VARCHAR(255),\n" \
"        name VARCHAR(255),\n" \
"        PRIMARY KEY(group_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICES "CREATE TABLE devices (\n" \
"        group_id INTEGER,\n" \
"        adapter INTEGER,\n" \
"        frontend INTEGER,\n" \
"        PRIMARY KEY(adapter, frontend))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_TIMERS "CREATE TABLE timers (\n" \
"        timer_id INTEGER,\n" \
"        group_id INTEGER,\n" \
"        channel_sid INTEGER,\n" \
"        year INTEGER,\n" \
"        month INTEGER,\n" \
"        day INTEGER,\n" \
"        hour INTEGER,\n" \
"        minute INTEGER,\n" \
"        duration INTEGER,\n" \
"        event_id INTEGER,\n" \
"        PRIMARY KEY(timer_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_GROUPS "CREATE TABLE channel_groups (\n" \
"        channel_group_id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"        name VARCHAR(255))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_CHANNELS "CREATE TABLE channels (\n" \
"        sid INTEGER,\n" \
"        group_id INTEGER,\n" \
"        channel_group_id INTEGER,\n" \
"        PRIMARY KEY(sid, group_id, channel_group_id))"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_ALL_GROUPS "SELECT * FROM device_groups"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_DEVICES "SELECT * FROM devices WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP "DELETE FROM device_groups WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_GROUP "INSERT INTO device_groups VALUES (?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_GROUP "SELECT 1 FROM device_groups WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_UPDATE_GROUP "UPDATE device_groups SET adapter_type=?, channels_file=?, recordings_d" \
"ir=?, name=? WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_DEVICE "DELETE FROM devices WHERE adapter=? AND frontend=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_DEVICES "DELETE FROM devices WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_DEVICE "INSERT INTO devices VALUES (?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_GROUP_OF_DEVICE "SELECT group_id FROM devices WHERE adapter=? AND frontend=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_TIMERS "SELECT * FROM timers WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_TIMER "DELETE FROM timers WHERE timer_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_TIMERS "DELETE FROM timers WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_TIMER "INSERT INTO timers VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_TIMER "SELECT 1 FROM timers WHERE timer_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_CHANNEL_GROUP "INSERT INTO channel_groups (name) VALUES (?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_CHANNEL_GROUP "DELETE FROM channel_groups WHERE channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_ALL_CHANNEL_GROUP "DELETE FROM channels WHERE channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNEL_GROUPS "SELECT * FROM channel_groups"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_ADD_CHANNEL_GROUP "INSERT INTO channels VALUES (?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_CHANNEL_GROUP "DELETE FROM channels WHERE sid=? AND group_id=? AND channel_group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNELS "SELECT sid FROM channels WHERE group_id=? AND channel_group_id=?"
DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_new (void);
DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_construct (GType object_type);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
static void dvb_database_sqlite_sqlite_config_timers_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups (DVBdatabaseConfigStore* base, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error);
GQuark dvb_device_error_quark (void);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gboolean main_get_disable_epg_scanner (void);
DVBDeviceGroup* dvb_device_group_new (guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, DVBDevice* reference_device, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* dev_group, GError** error);
gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_group (DVBdatabasesqliteSqliteConfigTimersStore* self, guint group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
const gchar* dvb_device_group_get_Name (DVBDeviceGroup* self);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
gboolean dvb_database_config_store_add_device_to_group (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group (DVBdatabaseConfigStore* base, guint adapter, guint frontend, guint* group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group (DVBdatabaseTimersStore* base, DVBDeviceGroup* dev, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_timer_set_EventID (DVBTimer* self, guint value);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group (DVBdatabaseTimersStore* base, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_timer (DVBdatabasesqliteSqliteConfigTimersStore* self, guint timer_id, GError** error);
guint32 dvb_timer_get_Id (DVBTimer* self);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_timer_get_Duration (DVBTimer* self);
guint dvb_timer_get_EventID (DVBTimer* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group (DVBdatabaseTimersStore* base, guint timer_id, DVBDeviceGroup* dev, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group (DVBdatabaseTimersStore* base, guint group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group (DVBdatabaseConfigStore* base, const gchar* name, gint* channel_group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group (DVBdatabaseConfigStore* base, gint group_id, GError** error);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups (DVBdatabaseConfigStore* base, GError** error);
DVBChannelGroup* dvb_channel_group_new (gint id, const gchar* name);
DVBChannelGroup* dvb_channel_group_construct (GType object_type, gint id, const gchar* name);
static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group (DVBdatabaseConfigStore* base, guint dev_group_id, gint channel_group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error);
guint dvb_channel_get_GroupId (DVBChannel* self);
static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error);
static void dvb_database_sqlite_sqlite_config_timers_store_finalize (GObject* obj);


DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_construct (GType object_type) {
	DVBdatabasesqliteSqliteConfigTimersStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* config_dir;
	GFile* _tmp2_ = NULL;
	GFile* config_cache;
	GFile* _tmp3_ = NULL;
	GFile* dbfile;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = g_file_get_child (config_dir, "gnome-dvb-daemon");
	config_cache = _tmp2_;
	_tmp3_ = g_file_get_child (config_cache, "configtimers.sqlite3");
	dbfile = _tmp3_;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) dvb_database_sqlite_sqlite_database_construct (object_type, dbfile, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_VERSION);
	_g_object_unref0 (dbfile);
	_g_object_unref0 (config_cache);
	_g_object_unref0 (config_dir);
	return self;
}


DVBdatabasesqliteSqliteConfigTimersStore* dvb_database_sqlite_sqlite_config_timers_store_new (void) {
	return dvb_database_sqlite_sqlite_config_timers_store_construct (DVB_DATABASE_SQLITE_TYPE_SQLITE_CONFIG_TIMERS_STORE);
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICE_GROUPS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_DEVICES, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_TIMERS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_GROUPS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CREATE_CHANNELS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
}


static void dvb_database_sqlite_sqlite_config_timers_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	sqlite3* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	sqlite3* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	sqlite3* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	sqlite3* _tmp10_;
	sqlite3_stmt* _tmp11_ = NULL;
	sqlite3* _tmp12_;
	sqlite3_stmt* _tmp13_ = NULL;
	sqlite3* _tmp14_;
	sqlite3_stmt* _tmp15_ = NULL;
	sqlite3* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	sqlite3* _tmp18_;
	sqlite3_stmt* _tmp19_ = NULL;
	sqlite3* _tmp20_;
	sqlite3_stmt* _tmp21_ = NULL;
	sqlite3* _tmp22_;
	sqlite3_stmt* _tmp23_ = NULL;
	sqlite3* _tmp24_;
	sqlite3_stmt* _tmp25_ = NULL;
	sqlite3* _tmp26_;
	sqlite3_stmt* _tmp27_ = NULL;
	sqlite3* _tmp28_;
	sqlite3_stmt* _tmp29_ = NULL;
	sqlite3* _tmp30_;
	sqlite3_stmt* _tmp31_ = NULL;
	sqlite3* _tmp32_;
	sqlite3_stmt* _tmp33_ = NULL;
	sqlite3* _tmp34_;
	sqlite3_stmt* _tmp35_ = NULL;
	sqlite3* _tmp36_;
	sqlite3_stmt* _tmp37_ = NULL;
	sqlite3* _tmp38_;
	sqlite3_stmt* _tmp39_ = NULL;
	sqlite3* _tmp40_;
	sqlite3_stmt* _tmp41_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp0_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp0_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_DEVICES, -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (self->priv->select_devices_statement);
	self->priv->select_devices_statement = _tmp1_;
	_tmp2_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp2_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->priv->delete_group_statement);
	self->priv->delete_group_statement = _tmp3_;
	_tmp4_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp4_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_GROUP, -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (self->priv->insert_group_statement);
	self->priv->insert_group_statement = _tmp5_;
	_tmp6_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp6_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_UPDATE_GROUP, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (self->priv->update_group_statement);
	self->priv->update_group_statement = _tmp7_;
	_tmp8_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp8_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_DEVICE, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (self->priv->delete_device_statement);
	self->priv->delete_device_statement = _tmp9_;
	_tmp10_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp10_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_DEVICES, -1, &_tmp11_, NULL);
	_sqlite3_finalize0 (self->priv->delete_group_devices_statement);
	self->priv->delete_group_devices_statement = _tmp11_;
	_tmp12_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp12_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_DEVICE, -1, &_tmp13_, NULL);
	_sqlite3_finalize0 (self->priv->insert_device_statement);
	self->priv->insert_device_statement = _tmp13_;
	_tmp14_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp14_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_GROUP_OF_DEVICE, -1, &_tmp15_, NULL);
	_sqlite3_finalize0 (self->priv->select_group_of_device_statement);
	self->priv->select_group_of_device_statement = _tmp15_;
	_tmp16_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp16_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_TIMERS, -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (self->priv->select_timers_statement);
	self->priv->select_timers_statement = _tmp17_;
	_tmp18_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp18_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_TIMER, -1, &_tmp19_, NULL);
	_sqlite3_finalize0 (self->priv->delete_timer_statement);
	self->priv->delete_timer_statement = _tmp19_;
	_tmp20_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp20_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_GROUP_TIMERS, -1, &_tmp21_, NULL);
	_sqlite3_finalize0 (self->priv->delete_group_timers_statement);
	self->priv->delete_group_timers_statement = _tmp21_;
	_tmp22_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp22_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_TIMER, -1, &_tmp23_, NULL);
	_sqlite3_finalize0 (self->priv->insert_timer_statement);
	self->priv->insert_timer_statement = _tmp23_;
	_tmp24_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp24_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_GROUP, -1, &_tmp25_, NULL);
	_sqlite3_finalize0 (self->priv->contains_group_statement);
	self->priv->contains_group_statement = _tmp25_;
	_tmp26_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp26_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_CONTAINS_TIMER, -1, &_tmp27_, NULL);
	_sqlite3_finalize0 (self->priv->contains_timer_statement);
	self->priv->contains_timer_statement = _tmp27_;
	_tmp28_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp28_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_INSERT_CHANNEL_GROUP, -1, &_tmp29_, NULL);
	_sqlite3_finalize0 (self->priv->insert_channel_group_statement);
	self->priv->insert_channel_group_statement = _tmp29_;
	_tmp30_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp30_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_DELETE_CHANNEL_GROUP, -1, &_tmp31_, NULL);
	_sqlite3_finalize0 (self->priv->delete_channel_group_statement);
	self->priv->delete_channel_group_statement = _tmp31_;
	_tmp32_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp32_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_ALL_CHANNEL_GROUP, -1, &_tmp33_, NULL);
	_sqlite3_finalize0 (self->priv->remove_all_channel_group_statement);
	self->priv->remove_all_channel_group_statement = _tmp33_;
	_tmp34_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp34_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNEL_GROUPS, -1, &_tmp35_, NULL);
	_sqlite3_finalize0 (self->priv->select_channel_groups_statement);
	self->priv->select_channel_groups_statement = _tmp35_;
	_tmp36_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp36_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_ADD_CHANNEL_GROUP, -1, &_tmp37_, NULL);
	_sqlite3_finalize0 (self->priv->add_channel_group_statement);
	self->priv->add_channel_group_statement = _tmp37_;
	_tmp38_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp38_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_REMOVE_CHANNEL_GROUP, -1, &_tmp39_, NULL);
	_sqlite3_finalize0 (self->priv->remove_channel_group_statement);
	self->priv->remove_channel_group_statement = _tmp39_;
	_tmp40_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp40_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_CHANNELS, -1, &_tmp41_, NULL);
	_sqlite3_finalize0 (self->priv->select_channels_statement);
	self->priv->select_channels_statement = _tmp41_;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups (DVBdatabaseConfigStore* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* groups;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	groups = (GeeList*) _tmp0_;
	_tmp1_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	_tmp3_ = sqlite3_prepare (_tmp1_, DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_SELECT_ALL_GROUPS, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp2_;
	if (_tmp3_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				_g_object_unref0 (groups);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				_g_object_unref0 (groups);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = groups;
		_sqlite3_finalize0 (statement);
		return result;
	}
	while (TRUE) {
		sqlite3_stmt* _tmp4_;
		gint _tmp5_ = 0;
		sqlite3_stmt* _tmp6_;
		gint _tmp7_ = 0;
		gint group_id;
		sqlite3_stmt* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		sqlite3_stmt* _tmp11_;
		const gchar* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* channels_file;
		sqlite3_stmt* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		GFile* rec_dir;
		GeeArrayList* _tmp17_;
		GeeList* devs;
		DVBDevice* ref_dev;
		sqlite3_stmt* _tmp39_;
		DVBDevice* _tmp40_;
		gint _tmp43_;
		DVBDevice* _tmp44_;
		gboolean _tmp45_ = FALSE;
		DVBDeviceGroup* _tmp46_;
		DVBDeviceGroup* group;
		DVBDeviceGroup* _tmp47_;
		sqlite3_stmt* _tmp48_;
		const gchar* _tmp49_ = NULL;
		GeeList* _tmp62_;
		DVBDeviceGroup* _tmp63_;
		_tmp4_ = statement;
		_tmp5_ = sqlite3_step (_tmp4_);
		if (!(_tmp5_ == SQLITE_ROW)) {
			break;
		}
		_tmp6_ = statement;
		_tmp7_ = sqlite3_column_int (_tmp6_, 0);
		group_id = _tmp7_;
		_tmp8_ = self->priv->select_devices_statement;
		_tmp9_ = group_id;
		_tmp10_ = sqlite3_bind_int (_tmp8_, 1, _tmp9_);
		if (_tmp10_ != SQLITE_OK) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_sqlite3_finalize0 (statement);
					_g_object_unref0 (groups);
					return NULL;
				} else {
					_sqlite3_finalize0 (statement);
					_g_object_unref0 (groups);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			continue;
		}
		_tmp11_ = statement;
		_tmp12_ = sqlite3_column_text (_tmp11_, 2);
		_tmp13_ = g_file_new_for_path (_tmp12_);
		channels_file = _tmp13_;
		_tmp14_ = statement;
		_tmp15_ = sqlite3_column_text (_tmp14_, 3);
		_tmp16_ = g_file_new_for_path (_tmp15_);
		rec_dir = _tmp16_;
		_tmp17_ = gee_array_list_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		devs = (GeeList*) _tmp17_;
		ref_dev = NULL;
		while (TRUE) {
			sqlite3_stmt* _tmp18_;
			gint _tmp19_ = 0;
			sqlite3_stmt* _tmp20_;
			gint _tmp21_ = 0;
			guint adapter;
			sqlite3_stmt* _tmp22_;
			gint _tmp23_ = 0;
			guint frontend;
			DVBDevice* _tmp24_;
			_tmp18_ = self->priv->select_devices_statement;
			_tmp19_ = sqlite3_step (_tmp18_);
			if (!(_tmp19_ == SQLITE_ROW)) {
				break;
			}
			_tmp20_ = self->priv->select_devices_statement;
			_tmp21_ = sqlite3_column_int (_tmp20_, 1);
			adapter = (guint) _tmp21_;
			_tmp22_ = self->priv->select_devices_statement;
			_tmp23_ = sqlite3_column_int (_tmp22_, 2);
			frontend = (guint) _tmp23_;
			_tmp24_ = ref_dev;
			if (_tmp24_ == NULL) {
				{
					guint _tmp25_;
					guint _tmp26_;
					GFile* _tmp27_;
					GFile* _tmp28_;
					DVBDevice* _tmp29_ = NULL;
					DVBDevice* _tmp30_;
					_tmp25_ = adapter;
					_tmp26_ = frontend;
					_tmp27_ = channels_file;
					_tmp28_ = rec_dir;
					_tmp29_ = dvb_device_new_full (_tmp25_, _tmp26_, _tmp27_, _tmp28_, &_inner_error_);
					_tmp30_ = _tmp29_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DEVICE_ERROR) {
							goto __catch8_dvb_device_error;
						}
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (ref_dev);
					ref_dev = _tmp30_;
				}
				goto __finally8;
				__catch8_dvb_device_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp31_;
					GError* _tmp32_;
					const gchar* _tmp33_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp31_ = dvb_database_sqlite_sqlite_config_timers_store_log;
					_tmp32_ = e;
					_tmp33_ = _tmp32_->message;
					dvb_logging_logger_error (_tmp31_, "SqliteConfigTimersStore.vala:268: Could not create device: %s", _tmp33_);
					_g_error_free0 (e);
				}
				__finally8:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						return NULL;
					} else {
						_g_object_unref0 (ref_dev);
						_g_object_unref0 (devs);
						_g_object_unref0 (rec_dir);
						_g_object_unref0 (channels_file);
						_sqlite3_finalize0 (statement);
						_g_object_unref0 (groups);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			} else {
				GeeList* _tmp34_;
				guint _tmp35_;
				guint _tmp36_;
				DVBDevice* _tmp37_ = NULL;
				DVBDevice* _tmp38_;
				_tmp34_ = devs;
				_tmp35_ = adapter;
				_tmp36_ = frontend;
				_tmp37_ = dvb_device_new_with_type (_tmp35_, _tmp36_);
				_tmp38_ = _tmp37_;
				gee_collection_add ((GeeCollection*) _tmp34_, _tmp38_);
				_g_object_unref0 (_tmp38_);
			}
		}
		_tmp39_ = self->priv->select_devices_statement;
		sqlite3_reset (_tmp39_);
		_tmp40_ = ref_dev;
		if (_tmp40_ == NULL) {
			DVBLoggingLogger* _tmp41_;
			gint _tmp42_;
			_tmp41_ = dvb_database_sqlite_sqlite_config_timers_store_log;
			_tmp42_ = group_id;
			dvb_logging_logger_debug (_tmp41_, "SqliteConfigTimersStore.vala:278: Group %d has no devices", _tmp42_);
			_g_object_unref0 (ref_dev);
			_g_object_unref0 (devs);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (channels_file);
			continue;
		}
		_tmp43_ = group_id;
		_tmp44_ = ref_dev;
		_tmp45_ = main_get_disable_epg_scanner ();
		_tmp46_ = dvb_device_group_new ((guint) _tmp43_, _tmp44_, !_tmp45_);
		group = _tmp46_;
		_tmp47_ = group;
		_tmp48_ = statement;
		_tmp49_ = sqlite3_column_text (_tmp48_, 4);
		dvb_device_group_set_Name (_tmp47_, _tmp49_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp50_;
				_tmp50_ = TRUE;
				while (TRUE) {
					gboolean _tmp51_;
					gint _tmp53_;
					GeeList* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					DVBDeviceGroup* _tmp57_;
					GeeList* _tmp58_;
					gint _tmp59_;
					gpointer _tmp60_ = NULL;
					DVBDevice* _tmp61_;
					_tmp51_ = _tmp50_;
					if (!_tmp51_) {
						gint _tmp52_;
						_tmp52_ = i;
						i = _tmp52_ + 1;
					}
					_tmp50_ = FALSE;
					_tmp53_ = i;
					_tmp54_ = devs;
					_tmp55_ = gee_collection_get_size ((GeeCollection*) _tmp54_);
					_tmp56_ = _tmp55_;
					if (!(_tmp53_ < _tmp56_)) {
						break;
					}
					_tmp57_ = group;
					_tmp58_ = devs;
					_tmp59_ = i;
					_tmp60_ = gee_list_get (_tmp58_, _tmp59_);
					_tmp61_ = (DVBDevice*) _tmp60_;
					dvb_device_group_add (_tmp57_, _tmp61_);
					_g_object_unref0 (_tmp61_);
				}
			}
		}
		_tmp62_ = groups;
		_tmp63_ = group;
		gee_collection_add ((GeeCollection*) _tmp62_, _tmp63_);
		_g_object_unref0 (group);
		_g_object_unref0 (ref_dev);
		_g_object_unref0 (devs);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (channels_file);
	}
	result = groups;
	_sqlite3_finalize0 (statement);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* dev_group, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	DVBDeviceGroup* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	DVBDeviceGroup* _tmp5_;
	DVBChannelList* _tmp6_;
	DVBChannelList* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* channels;
	DVBDeviceGroup* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* recdir;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	sqlite3_stmt* _tmp19_;
	DVBDeviceGroup* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gint _tmp23_ = 0;
	gboolean _tmp29_;
	gboolean _tmp35_;
	gboolean _tmp41_;
	gboolean _tmp49_;
	sqlite3_stmt* _tmp50_;
	gint _tmp51_ = 0;
	sqlite3_stmt* _tmp53_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev_group != NULL, FALSE);
	_tmp0_ = dev_group;
	_tmp1_ = dvb_device_group_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_database_sqlite_sqlite_config_timers_store_contains_group (self, _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = dev_group;
	_tmp6_ = dvb_device_group_get_Channels (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = dvb_channel_list_get_channels_file (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_path (_tmp9_);
	channels = _tmp10_;
	_tmp11_ = dev_group;
	_tmp12_ = dvb_device_group_get_RecordingsDirectory (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_path (_tmp13_);
	recdir = _tmp14_;
	_tmp19_ = self->priv->insert_group_statement;
	_tmp20_ = dev_group;
	_tmp21_ = dvb_device_group_get_Id (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = sqlite3_bind_int (_tmp19_, 1, (gint) _tmp22_);
	if (_tmp23_ != SQLITE_OK) {
		_tmp18_ = TRUE;
	} else {
		sqlite3_stmt* _tmp24_;
		DVBDeviceGroup* _tmp25_;
		DVBAdapterType _tmp26_;
		DVBAdapterType _tmp27_;
		gint _tmp28_ = 0;
		_tmp24_ = self->priv->insert_group_statement;
		_tmp25_ = dev_group;
		_tmp26_ = dvb_device_group_get_Type (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = sqlite3_bind_int (_tmp24_, 2, (gint) _tmp27_);
		_tmp18_ = _tmp28_ != SQLITE_OK;
	}
	_tmp29_ = _tmp18_;
	if (_tmp29_) {
		_tmp17_ = TRUE;
	} else {
		sqlite3_stmt* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		GDestroyNotify _tmp33_;
		gint _tmp34_ = 0;
		_tmp30_ = self->priv->insert_group_statement;
		_tmp31_ = channels;
		_tmp32_ = g_strdup (_tmp31_);
		_tmp33_ = g_free;
		_tmp34_ = sqlite3_bind_text (_tmp30_, 3, _tmp32_, -1, _tmp33_);
		_tmp17_ = _tmp34_ != SQLITE_OK;
	}
	_tmp35_ = _tmp17_;
	if (_tmp35_) {
		_tmp16_ = TRUE;
	} else {
		sqlite3_stmt* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		GDestroyNotify _tmp39_;
		gint _tmp40_ = 0;
		_tmp36_ = self->priv->insert_group_statement;
		_tmp37_ = recdir;
		_tmp38_ = g_strdup (_tmp37_);
		_tmp39_ = g_free;
		_tmp40_ = sqlite3_bind_text (_tmp36_, 4, _tmp38_, -1, _tmp39_);
		_tmp16_ = _tmp40_ != SQLITE_OK;
	}
	_tmp41_ = _tmp16_;
	if (_tmp41_) {
		_tmp15_ = TRUE;
	} else {
		sqlite3_stmt* _tmp42_;
		DVBDeviceGroup* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		GDestroyNotify _tmp47_;
		gint _tmp48_ = 0;
		_tmp42_ = self->priv->insert_group_statement;
		_tmp43_ = dev_group;
		_tmp44_ = dvb_device_group_get_Name (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup (_tmp45_);
		_tmp47_ = g_free;
		_tmp48_ = sqlite3_bind_text (_tmp42_, 5, _tmp46_, -1, _tmp47_);
		_tmp15_ = _tmp48_ != SQLITE_OK;
	}
	_tmp49_ = _tmp15_;
	if (_tmp49_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (recdir);
				_g_free0 (channels);
				return FALSE;
			} else {
				_g_free0 (recdir);
				_g_free0 (channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		_g_free0 (recdir);
		_g_free0 (channels);
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (recdir);
			_g_free0 (channels);
			return FALSE;
		} else {
			_g_free0 (recdir);
			_g_free0 (channels);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp50_ = self->priv->insert_group_statement;
	_tmp51_ = sqlite3_step (_tmp50_);
	if (_tmp51_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp52_;
		_tmp52_ = self->priv->insert_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp52_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (recdir);
				_g_free0 (channels);
				return FALSE;
			} else {
				_g_free0 (recdir);
				_g_free0 (channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		_g_free0 (recdir);
		_g_free0 (channels);
		return result;
	}
	_tmp53_ = self->priv->insert_group_statement;
	sqlite3_reset (_tmp53_);
	{
		DVBDeviceGroup* _tmp54_;
		GeeIterator* _tmp55_ = NULL;
		GeeIterator* _dev_it;
		_tmp54_ = dev_group;
		_tmp55_ = gee_iterable_iterator ((GeeIterable*) _tmp54_);
		_dev_it = _tmp55_;
		while (TRUE) {
			GeeIterator* _tmp56_;
			gboolean _tmp57_ = FALSE;
			GeeIterator* _tmp58_;
			gpointer _tmp59_ = NULL;
			DVBDevice* dev;
			DVBDevice* _tmp60_;
			DVBDeviceGroup* _tmp61_;
			_tmp56_ = _dev_it;
			_tmp57_ = gee_iterator_next (_tmp56_);
			if (!_tmp57_) {
				break;
			}
			_tmp58_ = _dev_it;
			_tmp59_ = gee_iterator_get (_tmp58_);
			dev = (DVBDevice*) _tmp59_;
			_tmp60_ = dev;
			_tmp61_ = dev_group;
			dvb_database_config_store_add_device_to_group ((DVBdatabaseConfigStore*) self, _tmp60_, _tmp61_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dev);
					_g_object_unref0 (_dev_it);
					_g_free0 (recdir);
					_g_free0 (channels);
					return FALSE;
				} else {
					_g_object_unref0 (dev);
					_g_object_unref0 (_dev_it);
					_g_free0 (recdir);
					_g_free0 (channels);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (dev);
		}
		_g_object_unref0 (_dev_it);
	}
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (recdir);
			_g_free0 (channels);
			return FALSE;
		} else {
			_g_free0 (recdir);
			_g_free0 (channels);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (recdir);
	_g_free0 (channels);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp5_;
	DVBDeviceGroup* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_ = 0;
	sqlite3_stmt* _tmp17_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp0_ = self->priv->delete_group_statement;
	_tmp1_ = devgroup;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp3_);
	if (_tmp4_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->delete_group_devices_statement;
	_tmp6_ = devgroup;
	_tmp7_ = dvb_device_group_get_Id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = sqlite3_bind_int (_tmp5_, 1, (gint) _tmp8_);
	if (_tmp9_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = self->priv->delete_group_statement;
	_tmp11_ = sqlite3_step (_tmp10_);
	if (_tmp11_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp12_;
		_tmp12_ = self->priv->delete_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp12_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->delete_group_statement;
	sqlite3_reset (_tmp13_);
	_tmp14_ = self->priv->delete_group_devices_statement;
	_tmp15_ = sqlite3_step (_tmp14_);
	if (_tmp15_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp16_;
		_tmp16_ = self->priv->delete_group_devices_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp16_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->delete_group_devices_statement;
	sqlite3_reset (_tmp17_);
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group (DVBdatabaseConfigStore* base, guint adapter, guint frontend, guint* group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	guint _vala_group_id = 0U;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* _tmp1_;
	guint _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	gboolean ret;
	sqlite3_stmt* _tmp12_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_vala_group_id = (guint) 0;
	_tmp1_ = self->priv->select_group_of_device_statement;
	_tmp2_ = adapter;
	_tmp3_ = sqlite3_bind_int (_tmp1_, 1, (gint) _tmp2_);
	if (_tmp3_ != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp4_;
		guint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->select_group_of_device_statement;
		_tmp5_ = frontend;
		_tmp6_ = sqlite3_bind_int (_tmp4_, 2, (gint) _tmp5_);
		_tmp0_ = _tmp6_ != SQLITE_OK;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		if (group_id) {
			*group_id = _vala_group_id;
		}
		return result;
	}
	ret = FALSE;
	while (TRUE) {
		sqlite3_stmt* _tmp8_;
		gint _tmp9_ = 0;
		sqlite3_stmt* _tmp10_;
		gint _tmp11_ = 0;
		_tmp8_ = self->priv->select_group_of_device_statement;
		_tmp9_ = sqlite3_step (_tmp8_);
		if (!(_tmp9_ == SQLITE_ROW)) {
			break;
		}
		_tmp10_ = self->priv->select_group_of_device_statement;
		_tmp11_ = sqlite3_column_int (_tmp10_, 0);
		_vala_group_id = (guint) _tmp11_;
		ret = TRUE;
	}
	_tmp12_ = self->priv->select_group_of_device_statement;
	sqlite3_reset (_tmp12_);
	result = ret;
	if (group_id) {
		*group_id = _vala_group_id;
	}
	return result;
}


gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_group (DVBdatabasesqliteSqliteConfigTimersStore* self, guint group_id, GError** error) {
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	guint _tmp1_;
	gint _tmp2_ = 0;
	gint c;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->contains_group_statement;
	_tmp1_ = group_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		gint _tmp4_ = 0;
		sqlite3_stmt* _tmp5_;
		gint _tmp6_ = 0;
		_tmp3_ = self->priv->contains_group_statement;
		_tmp4_ = sqlite3_step (_tmp3_);
		if (!(_tmp4_ == SQLITE_ROW)) {
			break;
		}
		_tmp5_ = self->priv->contains_group_statement;
		_tmp6_ = sqlite3_column_int (_tmp5_, 0);
		c = _tmp6_;
	}
	_tmp7_ = self->priv->contains_group_statement;
	sqlite3_reset (_tmp7_);
	_tmp8_ = c;
	result = _tmp8_ > 0;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	DVBDeviceGroup* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp12_;
	gboolean _tmp18_;
	sqlite3_stmt* _tmp19_;
	gint _tmp20_ = 0;
	sqlite3_stmt* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp2_ = self->priv->insert_device_statement;
	_tmp3_ = devgroup;
	_tmp4_ = dvb_device_group_get_Id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp5_);
	if (_tmp6_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp7_;
		DVBDevice* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		gint _tmp11_ = 0;
		_tmp7_ = self->priv->insert_device_statement;
		_tmp8_ = dev;
		_tmp9_ = dvb_device_get_Adapter (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = sqlite3_bind_int (_tmp7_, 2, (gint) _tmp10_);
		_tmp1_ = _tmp11_ != SQLITE_OK;
	}
	_tmp12_ = _tmp1_;
	if (_tmp12_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp13_;
		DVBDevice* _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		gint _tmp17_ = 0;
		_tmp13_ = self->priv->insert_device_statement;
		_tmp14_ = dev;
		_tmp15_ = dvb_device_get_Frontend (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = sqlite3_bind_int (_tmp13_, 3, (gint) _tmp16_);
		_tmp0_ = _tmp17_ != SQLITE_OK;
	}
	_tmp18_ = _tmp0_;
	if (_tmp18_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp19_ = self->priv->insert_device_statement;
	_tmp20_ = sqlite3_step (_tmp19_);
	if (_tmp20_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp21_;
		_tmp21_ = self->priv->insert_device_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp21_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp22_ = self->priv->insert_device_statement;
	sqlite3_reset (_tmp22_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group (DVBdatabaseConfigStore* base, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* _tmp1_;
	DVBDevice* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp1_ = self->priv->delete_device_statement;
	_tmp2_ = dev;
	_tmp3_ = dvb_device_get_Adapter (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = sqlite3_bind_int (_tmp1_, 1, (gint) _tmp4_);
	if (_tmp5_ != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp6_;
		DVBDevice* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		gint _tmp10_ = 0;
		_tmp6_ = self->priv->delete_device_statement;
		_tmp7_ = dev;
		_tmp8_ = dvb_device_get_Frontend (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = sqlite3_bind_int (_tmp6_, 2, (gint) _tmp9_);
		_tmp0_ = _tmp10_ != SQLITE_OK;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->delete_device_statement;
	_tmp13_ = sqlite3_step (_tmp12_);
	if (_tmp13_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp14_;
		_tmp14_ = self->priv->delete_device_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp14_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp15_ = self->priv->delete_device_statement;
	sqlite3_reset (_tmp15_);
	result = TRUE;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group (DVBdatabaseTimersStore* base, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* timers;
	sqlite3_stmt* _tmp1_;
	DVBDeviceGroup* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_ = 0;
	sqlite3_stmt* _tmp44_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, NULL);
	_tmp0_ = gee_array_list_new (DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	timers = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->select_timers_statement;
	_tmp2_ = dev;
	_tmp3_ = dvb_device_group_get_Id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = sqlite3_bind_int (_tmp1_, 1, (gint) _tmp4_);
	if (_tmp5_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (timers);
				return NULL;
			} else {
				_g_object_unref0 (timers);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = timers;
		return result;
	}
	while (TRUE) {
		sqlite3_stmt* _tmp6_;
		gint _tmp7_ = 0;
		guint tid = 0U;
		guint sid = 0U;
		guint duration = 0U;
		guint event_id = 0U;
		gint year = 0;
		gint month = 0;
		gint day = 0;
		gint hour = 0;
		gint minute = 0;
		sqlite3_stmt* _tmp8_;
		gint _tmp9_ = 0;
		sqlite3_stmt* _tmp10_;
		gint _tmp11_ = 0;
		sqlite3_stmt* _tmp12_;
		gint _tmp13_ = 0;
		sqlite3_stmt* _tmp14_;
		gint _tmp15_ = 0;
		sqlite3_stmt* _tmp16_;
		gint _tmp17_ = 0;
		sqlite3_stmt* _tmp18_;
		gint _tmp19_ = 0;
		sqlite3_stmt* _tmp20_;
		gint _tmp21_ = 0;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		sqlite3_stmt* _tmp24_;
		gint _tmp25_ = 0;
		DVBDeviceGroup* _tmp26_;
		DVBChannelList* _tmp27_;
		DVBChannelList* _tmp28_;
		guint _tmp29_;
		DVBChannel* _tmp30_ = NULL;
		DVBChannel* channel;
		guint _tmp31_;
		DVBChannel* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		guint _tmp38_;
		DVBTimer* _tmp39_;
		DVBTimer* timer;
		DVBTimer* _tmp40_;
		guint _tmp41_;
		GeeList* _tmp42_;
		DVBTimer* _tmp43_;
		_tmp6_ = self->priv->select_timers_statement;
		_tmp7_ = sqlite3_step (_tmp6_);
		if (!(_tmp7_ == SQLITE_ROW)) {
			break;
		}
		_tmp8_ = self->priv->select_timers_statement;
		_tmp9_ = sqlite3_column_int (_tmp8_, 0);
		tid = (guint) _tmp9_;
		_tmp10_ = self->priv->select_timers_statement;
		_tmp11_ = sqlite3_column_int (_tmp10_, 2);
		sid = (guint) _tmp11_;
		_tmp12_ = self->priv->select_timers_statement;
		_tmp13_ = sqlite3_column_int (_tmp12_, 3);
		year = _tmp13_;
		_tmp14_ = self->priv->select_timers_statement;
		_tmp15_ = sqlite3_column_int (_tmp14_, 4);
		month = _tmp15_;
		_tmp16_ = self->priv->select_timers_statement;
		_tmp17_ = sqlite3_column_int (_tmp16_, 5);
		day = _tmp17_;
		_tmp18_ = self->priv->select_timers_statement;
		_tmp19_ = sqlite3_column_int (_tmp18_, 6);
		hour = _tmp19_;
		_tmp20_ = self->priv->select_timers_statement;
		_tmp21_ = sqlite3_column_int (_tmp20_, 7);
		minute = _tmp21_;
		_tmp22_ = self->priv->select_timers_statement;
		_tmp23_ = sqlite3_column_int (_tmp22_, 8);
		duration = (guint) _tmp23_;
		_tmp24_ = self->priv->select_timers_statement;
		_tmp25_ = sqlite3_column_int (_tmp24_, 9);
		event_id = (guint) _tmp25_;
		_tmp26_ = dev;
		_tmp27_ = dvb_device_group_get_Channels (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = sid;
		_tmp30_ = dvb_channel_list_get_channel (_tmp28_, _tmp29_);
		channel = _tmp30_;
		_tmp31_ = tid;
		_tmp32_ = channel;
		_tmp33_ = year;
		_tmp34_ = month;
		_tmp35_ = day;
		_tmp36_ = hour;
		_tmp37_ = minute;
		_tmp38_ = duration;
		_tmp39_ = dvb_timer_new ((guint32) _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
		timer = _tmp39_;
		_tmp40_ = timer;
		_tmp41_ = event_id;
		dvb_timer_set_EventID (_tmp40_, _tmp41_);
		_tmp42_ = timers;
		_tmp43_ = timer;
		gee_collection_add ((GeeCollection*) _tmp42_, _tmp43_);
		_g_object_unref0 (timer);
		_g_object_unref0 (channel);
	}
	_tmp44_ = self->priv->select_timers_statement;
	sqlite3_reset (_tmp44_);
	result = timers;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group (DVBdatabaseTimersStore* base, DVBTimer* timer, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	DVBTimer* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	DVBTimer* _tmp5_;
	gint _tmp6_ = 0;
	guint* _tmp7_ = NULL;
	guint* start;
	gint start_length1;
	gint _start_size_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	sqlite3_stmt* _tmp17_;
	DVBTimer* _tmp18_;
	guint32 _tmp19_;
	guint32 _tmp20_;
	gint _tmp21_ = 0;
	gboolean _tmp27_;
	gboolean _tmp35_;
	gboolean _tmp40_;
	gboolean _tmp45_;
	gboolean _tmp50_;
	gboolean _tmp55_;
	gboolean _tmp60_;
	gboolean _tmp66_;
	gboolean _tmp72_;
	sqlite3_stmt* _tmp73_;
	gint _tmp74_ = 0;
	sqlite3_stmt* _tmp76_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (timer != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	_tmp0_ = timer;
	_tmp1_ = dvb_timer_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_database_sqlite_sqlite_config_timers_store_contains_timer (self, (guint) _tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = timer;
	_tmp7_ = dvb_timer_get_start_time (_tmp5_, &_tmp6_);
	start = _tmp7_;
	start_length1 = _tmp6_;
	_start_size_ = start_length1;
	_tmp17_ = self->priv->insert_timer_statement;
	_tmp18_ = timer;
	_tmp19_ = dvb_timer_get_Id (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sqlite3_bind_int (_tmp17_, 1, (gint) _tmp20_);
	if (_tmp21_ != SQLITE_OK) {
		_tmp16_ = TRUE;
	} else {
		sqlite3_stmt* _tmp22_;
		DVBDeviceGroup* _tmp23_;
		guint _tmp24_;
		guint _tmp25_;
		gint _tmp26_ = 0;
		_tmp22_ = self->priv->insert_timer_statement;
		_tmp23_ = dev;
		_tmp24_ = dvb_device_group_get_Id (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = sqlite3_bind_int (_tmp22_, 2, (gint) _tmp25_);
		_tmp16_ = _tmp26_ != SQLITE_OK;
	}
	_tmp27_ = _tmp16_;
	if (_tmp27_) {
		_tmp15_ = TRUE;
	} else {
		sqlite3_stmt* _tmp28_;
		DVBTimer* _tmp29_;
		DVBChannel* _tmp30_;
		DVBChannel* _tmp31_;
		guint _tmp32_;
		guint _tmp33_;
		gint _tmp34_ = 0;
		_tmp28_ = self->priv->insert_timer_statement;
		_tmp29_ = timer;
		_tmp30_ = dvb_timer_get_Channel (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = dvb_channel_get_Sid (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = sqlite3_bind_int (_tmp28_, 3, (gint) _tmp33_);
		_tmp15_ = _tmp34_ != SQLITE_OK;
	}
	_tmp35_ = _tmp15_;
	if (_tmp35_) {
		_tmp14_ = TRUE;
	} else {
		sqlite3_stmt* _tmp36_;
		guint* _tmp37_;
		gint _tmp37__length1;
		guint _tmp38_;
		gint _tmp39_ = 0;
		_tmp36_ = self->priv->insert_timer_statement;
		_tmp37_ = start;
		_tmp37__length1 = start_length1;
		_tmp38_ = _tmp37_[0];
		_tmp39_ = sqlite3_bind_int (_tmp36_, 4, (gint) _tmp38_);
		_tmp14_ = _tmp39_ != SQLITE_OK;
	}
	_tmp40_ = _tmp14_;
	if (_tmp40_) {
		_tmp13_ = TRUE;
	} else {
		sqlite3_stmt* _tmp41_;
		guint* _tmp42_;
		gint _tmp42__length1;
		guint _tmp43_;
		gint _tmp44_ = 0;
		_tmp41_ = self->priv->insert_timer_statement;
		_tmp42_ = start;
		_tmp42__length1 = start_length1;
		_tmp43_ = _tmp42_[1];
		_tmp44_ = sqlite3_bind_int (_tmp41_, 5, (gint) _tmp43_);
		_tmp13_ = _tmp44_ != SQLITE_OK;
	}
	_tmp45_ = _tmp13_;
	if (_tmp45_) {
		_tmp12_ = TRUE;
	} else {
		sqlite3_stmt* _tmp46_;
		guint* _tmp47_;
		gint _tmp47__length1;
		guint _tmp48_;
		gint _tmp49_ = 0;
		_tmp46_ = self->priv->insert_timer_statement;
		_tmp47_ = start;
		_tmp47__length1 = start_length1;
		_tmp48_ = _tmp47_[2];
		_tmp49_ = sqlite3_bind_int (_tmp46_, 6, (gint) _tmp48_);
		_tmp12_ = _tmp49_ != SQLITE_OK;
	}
	_tmp50_ = _tmp12_;
	if (_tmp50_) {
		_tmp11_ = TRUE;
	} else {
		sqlite3_stmt* _tmp51_;
		guint* _tmp52_;
		gint _tmp52__length1;
		guint _tmp53_;
		gint _tmp54_ = 0;
		_tmp51_ = self->priv->insert_timer_statement;
		_tmp52_ = start;
		_tmp52__length1 = start_length1;
		_tmp53_ = _tmp52_[3];
		_tmp54_ = sqlite3_bind_int (_tmp51_, 7, (gint) _tmp53_);
		_tmp11_ = _tmp54_ != SQLITE_OK;
	}
	_tmp55_ = _tmp11_;
	if (_tmp55_) {
		_tmp10_ = TRUE;
	} else {
		sqlite3_stmt* _tmp56_;
		guint* _tmp57_;
		gint _tmp57__length1;
		guint _tmp58_;
		gint _tmp59_ = 0;
		_tmp56_ = self->priv->insert_timer_statement;
		_tmp57_ = start;
		_tmp57__length1 = start_length1;
		_tmp58_ = _tmp57_[4];
		_tmp59_ = sqlite3_bind_int (_tmp56_, 8, (gint) _tmp58_);
		_tmp10_ = _tmp59_ != SQLITE_OK;
	}
	_tmp60_ = _tmp10_;
	if (_tmp60_) {
		_tmp9_ = TRUE;
	} else {
		sqlite3_stmt* _tmp61_;
		DVBTimer* _tmp62_;
		guint _tmp63_;
		guint _tmp64_;
		gint _tmp65_ = 0;
		_tmp61_ = self->priv->insert_timer_statement;
		_tmp62_ = timer;
		_tmp63_ = dvb_timer_get_Duration (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = sqlite3_bind_int (_tmp61_, 9, (gint) _tmp64_);
		_tmp9_ = _tmp65_ != SQLITE_OK;
	}
	_tmp66_ = _tmp9_;
	if (_tmp66_) {
		_tmp8_ = TRUE;
	} else {
		sqlite3_stmt* _tmp67_;
		DVBTimer* _tmp68_;
		guint _tmp69_;
		guint _tmp70_;
		gint _tmp71_ = 0;
		_tmp67_ = self->priv->insert_timer_statement;
		_tmp68_ = timer;
		_tmp69_ = dvb_timer_get_EventID (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = sqlite3_bind_int (_tmp67_, 10, (gint) _tmp70_);
		_tmp8_ = _tmp71_ != SQLITE_OK;
	}
	_tmp72_ = _tmp8_;
	if (_tmp72_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				start = (g_free (start), NULL);
				return FALSE;
			} else {
				start = (g_free (start), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		start = (g_free (start), NULL);
		return result;
	}
	_tmp73_ = self->priv->insert_timer_statement;
	_tmp74_ = sqlite3_step (_tmp73_);
	if (_tmp74_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp75_;
		_tmp75_ = self->priv->insert_timer_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp75_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				start = (g_free (start), NULL);
				return FALSE;
			} else {
				start = (g_free (start), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		start = (g_free (start), NULL);
		return result;
	}
	_tmp76_ = self->priv->insert_timer_statement;
	sqlite3_reset (_tmp76_);
	result = TRUE;
	start = (g_free (start), NULL);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group (DVBdatabaseTimersStore* base, guint timer_id, DVBDeviceGroup* dev, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	guint _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (dev != NULL, FALSE);
	_tmp0_ = self->priv->delete_timer_statement;
	_tmp1_ = timer_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->delete_timer_statement;
	_tmp4_ = sqlite3_step (_tmp3_);
	if (_tmp4_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp5_;
		_tmp5_ = self->priv->delete_timer_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->delete_timer_statement;
	sqlite3_reset (_tmp6_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group (DVBdatabaseTimersStore* base, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	guint _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp0_ = self->priv->delete_group_timers_statement;
	_tmp1_ = group_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->delete_group_timers_statement;
	_tmp4_ = sqlite3_step (_tmp3_);
	if (_tmp4_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp5_;
		_tmp5_ = self->priv->delete_group_timers_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->delete_group_timers_statement;
	sqlite3_reset (_tmp6_);
	result = TRUE;
	return result;
}


gboolean dvb_database_sqlite_sqlite_config_timers_store_contains_timer (DVBdatabasesqliteSqliteConfigTimersStore* self, guint timer_id, GError** error) {
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	guint _tmp1_;
	gint _tmp2_ = 0;
	gint c;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->contains_timer_statement;
	_tmp1_ = timer_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp3_;
		gint _tmp4_ = 0;
		sqlite3_stmt* _tmp5_;
		gint _tmp6_ = 0;
		_tmp3_ = self->priv->contains_timer_statement;
		_tmp4_ = sqlite3_step (_tmp3_);
		if (!(_tmp4_ == SQLITE_ROW)) {
			break;
		}
		_tmp5_ = self->priv->contains_timer_statement;
		_tmp6_ = sqlite3_column_int (_tmp5_, 0);
		c = _tmp6_;
	}
	_tmp7_ = self->priv->contains_timer_statement;
	sqlite3_reset (_tmp7_);
	_tmp8_ = c;
	result = _tmp8_ > 0;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group (DVBdatabaseConfigStore* base, DVBDeviceGroup* devgroup, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	sqlite3_stmt* _tmp4_;
	DVBDeviceGroup* _tmp5_;
	DVBAdapterType _tmp6_;
	DVBAdapterType _tmp7_;
	gint _tmp8_ = 0;
	gboolean _tmp18_;
	gboolean _tmp26_;
	gboolean _tmp34_;
	gboolean _tmp40_;
	sqlite3_stmt* _tmp41_;
	gint _tmp42_ = 0;
	sqlite3_stmt* _tmp44_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp4_ = self->priv->update_group_statement;
	_tmp5_ = devgroup;
	_tmp6_ = dvb_device_group_get_Type (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = sqlite3_bind_int (_tmp4_, 1, (gint) _tmp7_);
	if (_tmp8_ != SQLITE_OK) {
		_tmp3_ = TRUE;
	} else {
		sqlite3_stmt* _tmp9_;
		DVBDeviceGroup* _tmp10_;
		DVBChannelList* _tmp11_;
		DVBChannelList* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		GDestroyNotify _tmp16_;
		gint _tmp17_ = 0;
		_tmp9_ = self->priv->update_group_statement;
		_tmp10_ = devgroup;
		_tmp11_ = dvb_device_group_get_Channels (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = dvb_channel_list_get_channels_file (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_get_path (_tmp14_);
		_tmp16_ = g_free;
		_tmp17_ = sqlite3_bind_text (_tmp9_, 2, _tmp15_, -1, _tmp16_);
		_tmp3_ = _tmp17_ != SQLITE_OK;
	}
	_tmp18_ = _tmp3_;
	if (_tmp18_) {
		_tmp2_ = TRUE;
	} else {
		sqlite3_stmt* _tmp19_;
		DVBDeviceGroup* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		gchar* _tmp23_ = NULL;
		GDestroyNotify _tmp24_;
		gint _tmp25_ = 0;
		_tmp19_ = self->priv->update_group_statement;
		_tmp20_ = devgroup;
		_tmp21_ = dvb_device_group_get_RecordingsDirectory (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_get_path (_tmp22_);
		_tmp24_ = g_free;
		_tmp25_ = sqlite3_bind_text (_tmp19_, 3, _tmp23_, -1, _tmp24_);
		_tmp2_ = _tmp25_ != SQLITE_OK;
	}
	_tmp26_ = _tmp2_;
	if (_tmp26_) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp27_;
		DVBDeviceGroup* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		GDestroyNotify _tmp32_;
		gint _tmp33_ = 0;
		_tmp27_ = self->priv->update_group_statement;
		_tmp28_ = devgroup;
		_tmp29_ = dvb_device_group_get_Name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup (_tmp30_);
		_tmp32_ = g_free;
		_tmp33_ = sqlite3_bind_text (_tmp27_, 4, _tmp31_, -1, _tmp32_);
		_tmp1_ = _tmp33_ != SQLITE_OK;
	}
	_tmp34_ = _tmp1_;
	if (_tmp34_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp35_;
		DVBDeviceGroup* _tmp36_;
		guint _tmp37_;
		guint _tmp38_;
		gint _tmp39_ = 0;
		_tmp35_ = self->priv->update_group_statement;
		_tmp36_ = devgroup;
		_tmp37_ = dvb_device_group_get_Id (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = sqlite3_bind_int (_tmp35_, 5, (gint) _tmp38_);
		_tmp0_ = _tmp39_ != SQLITE_OK;
	}
	_tmp40_ = _tmp0_;
	if (_tmp40_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp41_ = self->priv->update_group_statement;
	_tmp42_ = sqlite3_step (_tmp41_);
	if (_tmp42_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp43_;
		_tmp43_ = self->priv->update_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp43_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp44_ = self->priv->update_group_statement;
	sqlite3_reset (_tmp44_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group (DVBdatabaseConfigStore* base, const gchar* name, gint* channel_group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gint _vala_channel_group_id = 0;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GDestroyNotify _tmp3_;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp5_;
	gint _tmp6_ = 0;
	sqlite3* _tmp8_;
	gint64 _tmp9_ = 0LL;
	sqlite3_stmt* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_vala_channel_group_id = -1;
	_tmp0_ = self->priv->insert_channel_group_statement;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = g_free;
	_tmp4_ = sqlite3_bind_text (_tmp0_, 1, _tmp2_, -1, _tmp3_);
	if (_tmp4_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		if (channel_group_id) {
			*channel_group_id = _vala_channel_group_id;
		}
		return result;
	}
	_tmp5_ = self->priv->insert_channel_group_statement;
	_tmp6_ = sqlite3_step (_tmp5_);
	if (_tmp6_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp7_;
		_tmp7_ = self->priv->insert_channel_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		if (channel_group_id) {
			*channel_group_id = _vala_channel_group_id;
		}
		return result;
	}
	_tmp8_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	_tmp9_ = sqlite3_last_insert_rowid (_tmp8_);
	_vala_channel_group_id = (gint) _tmp9_;
	_tmp10_ = self->priv->insert_channel_group_statement;
	sqlite3_reset (_tmp10_);
	result = TRUE;
	if (channel_group_id) {
		*channel_group_id = _vala_channel_group_id;
	}
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group (DVBdatabaseConfigStore* base, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp13_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp0_ = self->priv->delete_channel_group_statement;
	_tmp1_ = group_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->remove_all_channel_group_statement;
	_tmp4_ = group_id;
	_tmp5_ = sqlite3_bind_int (_tmp3_, 1, _tmp4_);
	if (_tmp5_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	dvb_database_sqlite_sqlite_database_begin_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp6_ = self->priv->delete_channel_group_statement;
	_tmp7_ = sqlite3_step (_tmp6_);
	if (_tmp7_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp8_;
		_tmp8_ = self->priv->delete_channel_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->delete_channel_group_statement;
	sqlite3_reset (_tmp9_);
	_tmp10_ = self->priv->remove_all_channel_group_statement;
	_tmp11_ = sqlite3_step (_tmp10_);
	if (_tmp11_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp12_;
		_tmp12_ = self->priv->remove_all_channel_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp12_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->remove_all_channel_group_statement;
	sqlite3_reset (_tmp13_);
	dvb_database_sqlite_sqlite_database_end_transaction ((DVBdatabasesqliteSqliteDatabase*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups (DVBdatabaseConfigStore* base, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* groups;
	sqlite3_stmt* _tmp13_;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_CHANNEL_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	groups = _tmp0_;
	while (TRUE) {
		sqlite3_stmt* _tmp1_;
		gint _tmp2_ = 0;
		sqlite3_stmt* _tmp3_;
		gint _tmp4_ = 0;
		gint group_id;
		sqlite3_stmt* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* group_name;
		gint _tmp8_;
		const gchar* _tmp9_;
		DVBChannelGroup* _tmp10_;
		DVBChannelGroup* group;
		GeeArrayList* _tmp11_;
		DVBChannelGroup* _tmp12_;
		_tmp1_ = self->priv->select_channel_groups_statement;
		_tmp2_ = sqlite3_step (_tmp1_);
		if (!(_tmp2_ == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = self->priv->select_channel_groups_statement;
		_tmp4_ = sqlite3_column_int (_tmp3_, 0);
		group_id = _tmp4_;
		_tmp5_ = self->priv->select_channel_groups_statement;
		_tmp6_ = sqlite3_column_text (_tmp5_, 1);
		_tmp7_ = g_strdup (_tmp6_);
		group_name = _tmp7_;
		_tmp8_ = group_id;
		_tmp9_ = group_name;
		_tmp10_ = dvb_channel_group_new (_tmp8_, _tmp9_);
		group = _tmp10_;
		_tmp11_ = groups;
		_tmp12_ = group;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
		_g_object_unref0 (group);
		_g_free0 (group_name);
	}
	_tmp13_ = self->priv->select_channel_groups_statement;
	sqlite3_reset (_tmp13_);
	result = (GeeList*) groups;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group (DVBdatabaseConfigStore* base, guint dev_group_id, gint channel_group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	GeeList* result = NULL;
	gboolean _tmp0_ = FALSE;
	sqlite3_stmt* _tmp1_;
	guint _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* channels;
	sqlite3_stmt* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	_tmp1_ = self->priv->select_channels_statement;
	_tmp2_ = dev_group_id;
	_tmp3_ = sqlite3_bind_int (_tmp1_, 1, (gint) _tmp2_);
	if (_tmp3_ != SQLITE_OK) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->select_channels_statement;
		_tmp5_ = channel_group_id;
		_tmp6_ = sqlite3_bind_int (_tmp4_, 2, _tmp5_);
		_tmp0_ = _tmp6_ != SQLITE_OK;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp8_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	channels = _tmp8_;
	while (TRUE) {
		sqlite3_stmt* _tmp9_;
		gint _tmp10_ = 0;
		GeeArrayList* _tmp11_;
		sqlite3_stmt* _tmp12_;
		gint _tmp13_ = 0;
		_tmp9_ = self->priv->select_channels_statement;
		_tmp10_ = sqlite3_step (_tmp9_);
		if (!(_tmp10_ == SQLITE_ROW)) {
			break;
		}
		_tmp11_ = channels;
		_tmp12_ = self->priv->select_channels_statement;
		_tmp13_ = sqlite3_column_int (_tmp12_, 0);
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, GUINT_TO_POINTER ((guint) _tmp13_));
	}
	_tmp14_ = self->priv->select_channels_statement;
	sqlite3_reset (_tmp14_);
	result = (GeeList*) channels;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	DVBChannel* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp12_;
	gboolean _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp20_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp2_ = self->priv->add_channel_group_statement;
	_tmp3_ = channel;
	_tmp4_ = dvb_channel_get_Sid (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp5_);
	if (_tmp6_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp7_;
		DVBChannel* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		gint _tmp11_ = 0;
		_tmp7_ = self->priv->add_channel_group_statement;
		_tmp8_ = channel;
		_tmp9_ = dvb_channel_get_GroupId (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = sqlite3_bind_int (_tmp7_, 2, (gint) _tmp10_);
		_tmp1_ = _tmp11_ != SQLITE_OK;
	}
	_tmp12_ = _tmp1_;
	if (_tmp12_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp13_;
		gint _tmp14_;
		gint _tmp15_ = 0;
		_tmp13_ = self->priv->add_channel_group_statement;
		_tmp14_ = group_id;
		_tmp15_ = sqlite3_bind_int (_tmp13_, 3, _tmp14_);
		_tmp0_ = _tmp15_ != SQLITE_OK;
	}
	_tmp16_ = _tmp0_;
	if (_tmp16_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->add_channel_group_statement;
	_tmp18_ = sqlite3_step (_tmp17_);
	if (_tmp18_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp19_;
		_tmp19_ = self->priv->add_channel_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->add_channel_group_statement;
	sqlite3_reset (_tmp20_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group (DVBdatabaseConfigStore* base, DVBChannel* channel, gint group_id, GError** error) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	DVBChannel* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp12_;
	gboolean _tmp16_;
	sqlite3_stmt* _tmp17_;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp20_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteConfigTimersStore*) base;
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp2_ = self->priv->remove_channel_group_statement;
	_tmp3_ = channel;
	_tmp4_ = dvb_channel_get_Sid (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp5_);
	if (_tmp6_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp7_;
		DVBChannel* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		gint _tmp11_ = 0;
		_tmp7_ = self->priv->remove_channel_group_statement;
		_tmp8_ = channel;
		_tmp9_ = dvb_channel_get_GroupId (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = sqlite3_bind_int (_tmp7_, 2, (gint) _tmp10_);
		_tmp1_ = _tmp11_ != SQLITE_OK;
	}
	_tmp12_ = _tmp1_;
	if (_tmp12_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp13_;
		gint _tmp14_;
		gint _tmp15_ = 0;
		_tmp13_ = self->priv->remove_channel_group_statement;
		_tmp14_ = group_id;
		_tmp15_ = sqlite3_bind_int (_tmp13_, 3, _tmp14_);
		_tmp0_ = _tmp15_ != SQLITE_OK;
	}
	_tmp16_ = _tmp0_;
	if (_tmp16_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->remove_channel_group_statement;
	_tmp18_ = sqlite3_step (_tmp17_);
	if (_tmp18_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp19_;
		_tmp19_ = self->priv->remove_channel_group_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->remove_channel_group_statement;
	sqlite3_reset (_tmp20_);
	result = TRUE;
	return result;
}


static void dvb_database_sqlite_sqlite_config_timers_store_class_init (DVBdatabasesqliteSqliteConfigTimersStoreClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_database_sqlite_sqlite_config_timers_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteConfigTimersStorePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_config_timers_store_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_config_timers_store_real_upgrade;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_config_timers_store_real_on_open;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_config_timers_store_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_database_sqlite_sqlite_config_timers_store_log = _tmp1_;
}


static void dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_interface_init (DVBdatabaseConfigStoreIface * iface) {
	dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_all_device_groups = (GeeList* (*)(DVBdatabaseConfigStore*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_get_all_device_groups;
	iface->add_device_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_add_device_group;
	iface->remove_device_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_group;
	iface->get_parent_group = (gboolean (*)(DVBdatabaseConfigStore*, guint, guint, guint*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_get_parent_group;
	iface->add_device_to_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBDevice*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_add_device_to_group;
	iface->remove_device_from_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBDevice*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_device_from_group;
	iface->update_from_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_update_from_group;
	iface->add_channel_group = (gboolean (*)(DVBdatabaseConfigStore*, const gchar*, gint*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_group;
	iface->remove_channel_group = (gboolean (*)(DVBdatabaseConfigStore*, gint, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_group;
	iface->get_channel_groups = (GeeList* (*)(DVBdatabaseConfigStore*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_get_channel_groups;
	iface->get_channels_of_group = (GeeList* (*)(DVBdatabaseConfigStore*, guint, gint, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_get_channels_of_group;
	iface->add_channel_to_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBChannel*, gint, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_add_channel_to_group;
	iface->remove_channel_from_group = (gboolean (*)(DVBdatabaseConfigStore*, DVBChannel*, gint, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_channel_from_group;
}


static void dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_interface_init (DVBdatabaseTimersStoreIface * iface) {
	dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_all_timers_of_device_group = (GeeList* (*)(DVBdatabaseTimersStore*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_get_all_timers_of_device_group;
	iface->add_timer_to_device_group = (gboolean (*)(DVBdatabaseTimersStore*, DVBTimer*, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_add_timer_to_device_group;
	iface->remove_timer_from_device_group = (gboolean (*)(DVBdatabaseTimersStore*, guint, DVBDeviceGroup*, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_timer_from_device_group;
	iface->remove_all_timers_from_device_group = (gboolean (*)(DVBdatabaseTimersStore*, guint, GError**)) dvb_database_sqlite_sqlite_config_timers_store_real_remove_all_timers_from_device_group;
}


static void dvb_database_sqlite_sqlite_config_timers_store_instance_init (DVBdatabasesqliteSqliteConfigTimersStore * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_config_timers_store_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteConfigTimersStore * self;
	self = DVB_DATABASE_SQLITE_SQLITE_CONFIG_TIMERS_STORE (obj);
	_sqlite3_finalize0 (self->priv->select_devices_statement);
	_sqlite3_finalize0 (self->priv->delete_group_statement);
	_sqlite3_finalize0 (self->priv->insert_group_statement);
	_sqlite3_finalize0 (self->priv->update_group_statement);
	_sqlite3_finalize0 (self->priv->delete_device_statement);
	_sqlite3_finalize0 (self->priv->delete_group_devices_statement);
	_sqlite3_finalize0 (self->priv->insert_device_statement);
	_sqlite3_finalize0 (self->priv->select_group_of_device_statement);
	_sqlite3_finalize0 (self->priv->select_timers_statement);
	_sqlite3_finalize0 (self->priv->delete_timer_statement);
	_sqlite3_finalize0 (self->priv->delete_group_timers_statement);
	_sqlite3_finalize0 (self->priv->insert_timer_statement);
	_sqlite3_finalize0 (self->priv->contains_group_statement);
	_sqlite3_finalize0 (self->priv->contains_timer_statement);
	_sqlite3_finalize0 (self->priv->insert_channel_group_statement);
	_sqlite3_finalize0 (self->priv->delete_channel_group_statement);
	_sqlite3_finalize0 (self->priv->remove_all_channel_group_statement);
	_sqlite3_finalize0 (self->priv->select_channel_groups_statement);
	_sqlite3_finalize0 (self->priv->add_channel_group_statement);
	_sqlite3_finalize0 (self->priv->remove_channel_group_statement);
	_sqlite3_finalize0 (self->priv->select_channels_statement);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_config_timers_store_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_config_timers_store_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteConfigTimersStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_config_timers_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteConfigTimersStore), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_instance_init, NULL };
		static const GInterfaceInfo dvb_database_config_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_dvb_database_config_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_database_timers_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_config_timers_store_dvb_database_timers_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_database_sqlite_sqlite_config_timers_store_type_id;
		dvb_database_sqlite_sqlite_config_timers_store_type_id = g_type_register_static (DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, "DVBdatabasesqliteSqliteConfigTimersStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_config_timers_store_type_id, DVB_DATABASE_TYPE_CONFIG_STORE, &dvb_database_config_store_info);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_config_timers_store_type_id, DVB_DATABASE_TYPE_TIMERS_STORE, &dvb_database_timers_store_info);
		g_once_init_leave (&dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile, dvb_database_sqlite_sqlite_config_timers_store_type_id);
	}
	return dvb_database_sqlite_sqlite_config_timers_store_type_id__volatile;
}



