#include <string.h>

#include "mfsk.h"

#define TypeAheadBufLen	1024

static unsigned char typeaheadbuf[TypeAheadBufLen];
static int typeaheadptr = 0;
static int typeaheaddel = 0;

void typeahead_put_char(unsigned char c)
{
	if (typeaheadptr > TypeAheadBufLen - 1) {
		g_print("typeahead buffer overflow\n");
		return;
	}

	/* do a LF -> CR conversion */
	typeaheadbuf[typeaheadptr++] = (c == '\n') ? '\r' : c;
}

void typeahead_put_string(unsigned char *s)
{
	while (*s)
		typeahead_put_char(*s++);
}

void typeahead_del_char(void)
{
	if (typeaheadptr > 0) {
		typeaheadptr--;
		return;
	}

	/* do not accumulate DELs if transmitter is not on */
	if (TXon == TRUE)
		typeaheaddel++;
}

int typeahead_get_char(void)
{
	int c;

	if (typeaheaddel > 0) {
		typeaheaddel--;
		return 8;	/* send backspace */
	}

	if (typeaheadptr == 0)
		return -1;	/* send idle */

	c = typeaheadbuf[0];

	memmove(typeaheadbuf, typeaheadbuf + 1, typeaheadptr - 1);
	typeaheadptr--;

	return c;
}

void typeahead_clear(void)
{
	typeaheadptr = 0;
	typeaheaddel = 0;
}
