#ifndef _FFT_H
#define _FFT_H

#include "complex.h"

struct fft {
	int fftlen;
	int fftlenlog;
	complex *twiddles;
	unsigned int *bitrev;
	float *window;
};

extern struct fft *init_fft(int len);
extern void fft(struct fft *f, complex *in, complex *out);
extern void fft2(struct fft *f, float *in, complex *out);


struct slfft {
	int fftlen;
	int first;
	int last;
	int ptr;
	complex *twiddles;
	complex *bins;
	float *history;
};

extern struct slfft *init_slfft(int len, int first, int last);
extern complex *slfft(struct slfft *f, float in);

#endif
