/**********************
 * Born to disappear. *
 **********************/

#include "gliv.h"

#include <unistd.h>             /* access() */

/*** GRand ***/

GRand *g_rand_new_with_seed(guint32 seed)
{
    srandom(seed);
    return NULL;
}

/*** g_build_filename() ***/

gchar *g_build_filename(const gchar * str1, const gchar * str2, gchar * unused)
{
    return g_strconcat(str1, "/", str2, NULL);
}

/*** g_file_test() ***/

gboolean g_file_test(const gchar * filename, gint test)
{
    return !access(filename, test);
}

/*** Pango ***/

void gtk_widget_modify_font(GtkWidget * widget,
                            PangoFontDescription * font_desc)
{
    GtkStyle *style;

    style = gtk_widget_get_style(widget);
    style = gtk_style_copy(style);
    style->font = gdk_font_load(FONT);
    gtk_widget_set_style(widget, style);
}

/*** GtkWindow ***/

void gtk_window_resize(GtkWindow * window, gint width, gint height)
{
    gtk_window_set_default_size(window, width, height);
    gdk_window_resize(GTK_WIDGET(window)->window, width, height);
}

/*** GtkColorSelection ***/

void gtk_color_selection_get_current_color(GtkColorSelection * colorsel,
                                           GdkColor * color)
{
    gdouble col[4];

    gtk_color_selection_get_color(colorsel, col);

    color->red = (gushort) (col[0] * 65535.0);
    color->green = (gushort) (col[1] * 65535.0);
    color->blue = (gushort) (col[2] * 65535.0);
}

void gtk_color_selection_set_current_color(GtkColorSelection * colorsel,
                                           GdkColor * color)
{
    gdouble col[4];

    col[0] = color->red / 65535.0;
    col[1] = color->green / 65535.0;
    col[2] = color->blue / 65535.0;

    gtk_color_selection_set_color(colorsel, col);
}

/*** GtkFileSelection ***/

void gtk_file_selection_set_select_multiple(GtkFileSelection * filesel,
                                            gboolean select_multiple)
{
    GtkSelectionMode mode;

    mode = (select_multiple) ? GTK_SELECTION_EXTENDED : GTK_SELECTION_SINGLE;
    gtk_clist_set_selection_mode(GTK_CLIST(filesel->file_list), mode);
}

gchar **gtk_file_selection_get_selections(GtkFileSelection * filesel)
{
    guint count = 0;
    GList *node;
    gchar **array, **ptr;
    gchar *dirname, *buf;

    node = GTK_CLIST(filesel->file_list)->selection;
    while (node != NULL) {
        count++;
        node = node->next;
    }

    dirname = g_path_get_dirname(gtk_file_selection_get_filename(filesel));

    array = ptr = g_new(gchar *, count + 1);
    node = GTK_CLIST(filesel->file_list)->selection;

    while (node != NULL) {
        gtk_clist_get_text(GTK_CLIST(filesel->file_list),
                           GPOINTER_TO_INT(node->data), 0, &buf);

        *ptr = g_strconcat(dirname, "/", buf, NULL);
        ptr++;
        node = node->next;
    }

    g_free(dirname);

    array[count] = NULL;
    return array;
}

/*** GtkAdjustment ***/

gdouble gtk_adjustment_get_value(GtkAdjustment * adjustment)
{
    return adjustment->value;
}

/*** GdkWindow ***/

void gdk_window_process_all_updates(void)
{
    while (gtk_events_pending() != 0)
        gtk_main_iteration_do(FALSE);
}
