#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"
#include "gtk_gui.h"
#include "files.h"
#include "debconf.h"
#include "config.h"
#include "cbs.h"

GtkWidget*
create_main_window ()
{
  GtkWidget *win;

  GtkWidget *vbox;

  GtkWidget *menubar;

  GtkWidget *hbox;

  GtkWidget *pix_win;
  GtkWidget *frame_pix;

  GtkWidget *frame;
  GtkWidget *table;
  GtkWidget *toplabel;
  GtkWidget *felabel;

  /* package to configure */
  GtkWidget *cfcombo;
  /* what frontend to use */
  GtkWidget *fecombo;

  GtkWidget *hsep;

  GtkWidget *ok_btn,
    *cancel_btn;

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(win), "Gk Debconf");
  gtk_signal_connect_object (GTK_OBJECT(win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_main_quit),
			     NULL);


  vbox = gtk_vbox_new (0, 2);
  gtk_widget_show (vbox);

  gtk_container_add (GTK_CONTAINER(win), vbox);

  menubar = create_menubar (win);
  gtk_widget_show (menubar);

  gtk_box_pack_start (GTK_BOX(vbox), menubar, TRUE, TRUE, 2);

  hbox = gtk_hbox_new (0, 1);
  gtk_widget_show (hbox);

  gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 2);

  /* image */
  frame_pix = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(frame_pix), 2);
  gtk_widget_show (frame_pix);

  pix_win = create_gkdebconf_image(win, "gkdebconf-main.xpm");
  gtk_widget_show (pix_win);
  gtk_container_add (GTK_CONTAINER(frame_pix), pix_win);
  gtk_box_pack_start (GTK_BOX(hbox), frame_pix, TRUE, TRUE, 2);

  /* useful stuff */
  frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(frame), 4);
  gtk_widget_show (frame);

  table = gtk_table_new (6, 2, FALSE);
  gtk_container_add (GTK_CONTAINER(frame), table);
  gtk_widget_show (table);

  toplabel = gtk_label_new (_("Select the name of the package wich\n"
			      "you want to configure with Debconf\n"
			      "and click \"Configure\""));
  gtk_label_set_justify (GTK_LABEL(toplabel), GTK_JUSTIFY_LEFT);
  gtk_widget_show (toplabel);

  cfcombo = gtk_combo_new ();
  get_options (cfcombo);
  gtk_widget_show (cfcombo);

  felabel = gtk_label_new (_("Select the Debconf frontend you want\n"
			     "to use."));
  gtk_label_set_justify (GTK_LABEL(felabel), GTK_JUSTIFY_LEFT);
  gtk_widget_show (felabel);

  /* chooses front end */
  fecombo = gtk_combo_new();
  get_frontends(fecombo);
  gtk_signal_connect (GTK_OBJECT(GTK_COMBO(fecombo)->entry), "changed",
		      GTK_SIGNAL_FUNC(fe_select), NULL);
  gtk_widget_show (fecombo);

  hsep = gtk_hseparator_new ();
  gtk_widget_show (hsep);

  ok_btn = gtk_button_new_with_label (_("Configure"));
  gtk_signal_connect (GTK_OBJECT(ok_btn), "clicked",
		      GTK_SIGNAL_FUNC(configure_cb),
		      GTK_COMBO(cfcombo)->entry);
  gtk_widget_show (ok_btn);

  cancel_btn = gtk_button_new_with_label (_("Exit"));
  gtk_signal_connect_object (GTK_OBJECT(cancel_btn), "clicked",
			     GTK_SIGNAL_FUNC(gtk_main_quit),
			     NULL);
  gtk_widget_show (cancel_btn);

  gtk_table_attach (GTK_TABLE(table), toplabel, 0, 2, 0, 1,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 6, 3);

  gtk_table_attach (GTK_TABLE(table), cfcombo, 0, 2, 1, 2,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 6, 3);

  gtk_table_attach (GTK_TABLE(table), felabel, 0, 2, 2, 3,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 6, 3);

  gtk_table_attach (GTK_TABLE(table), fecombo, 0, 2, 3, 4,
		    GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 6, 3);

  gtk_table_attach (GTK_TABLE(table), hsep, 0, 2, 4, 5,
		    GTK_FILL|GTK_EXPAND, 0, 1, 1);

  gtk_table_attach (GTK_TABLE(table), ok_btn, 0, 1, 5, 6,
		    GTK_FILL|GTK_EXPAND, GTK_FILL, 12, 12);

  gtk_table_attach (GTK_TABLE(table), cancel_btn, 1, 2, 5, 6,
		    GTK_FILL|GTK_EXPAND, GTK_FILL, 12, 12);

  gtk_box_pack_start (GTK_BOX(hbox), frame, TRUE, TRUE, 2);
	    
  return win;
}

/*
  creates the main menu bar
*/
GtkWidget*
create_menubar (GtkWidget *win)
{
  GtkWidget *menubar;
  GtkWidget *fe_toggle;
  GtkAccelGroup *accel_group;
  GtkItemFactory *item_factory;
  GtkItemFactoryEntry menu_items[] = \
    {
      { _("/_File"), NULL, NULL, 0, "<Branch>" },
      { _("/File/_Quit"), NULL, gtk_main_quit, 0, "<Item>" },
      { _("/_Options"), NULL, NULL, 0, "<Branch>" },
      { _("/Options/_Remember last Frontend"), NULL, remember_fe_cb, 
	0, "<ToggleItem>"},
      { _("/_Help"), NULL, NULL, 0, "<LastBranch>" },
      { _("/Help/_About"), NULL, about_cb, 0, "<Item>" }
    };
  gint num_items = sizeof (menu_items) / sizeof (menu_items[0]);

  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				       accel_group);
  gtk_item_factory_create_items (item_factory, num_items, menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW(win), accel_group);
  menubar = gtk_item_factory_get_widget (item_factory, "<main>");

  fe_toggle = gtk_item_factory_get_widget (GTK_ITEM_FACTORY(item_factory),
					   _("<main>/Options/Remember last Frontend"));

  if (!strcmp (read_config ("remember_frontend"), "yes") && fe_toggle)
      GTK_CHECK_MENU_ITEM(fe_toggle)->active = TRUE;

  return menubar;
}

GtkWidget*
create_gkdebconf_image (GtkWidget *win, gchar *iname)
{
  GtkWidget *pix_win;
  GdkPixmap *pix;
  GdkColormap *colormap;
  GdkBitmap *mask;
  GtkStyle *style;
  gchar pixmap_file[FILENAME_MAX];

#ifndef PREFIX
#define PREFIX "/usr"
#endif

  sprintf (pixmap_file, "%s/share/gkdebconf/%s", PREFIX, iname);

  /* pixmap */
  style = gtk_widget_get_style (win);
  colormap = gtk_widget_get_colormap(win);
  pix = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
					     NULL, pixmap_file);
  pix_win = gtk_pixmap_new (pix, mask);

  return pix_win;
}

/* 
   about dialog, something like a gk_diag plus the splash
*/
void
show_about_window (gchar *msg, gchar *iname)
{
  GtkWidget *about_win;
  GtkWidget *about_frame;
  GtkWidget *about_table;
  GtkWidget *pix_win;
  GtkWidget *about_label;
  GtkWidget *button_ok;

  about_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(about_win), "GkDebconf");
  gtk_signal_connect_object (GTK_OBJECT(about_win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(about_win));
  gtk_container_set_border_width (GTK_CONTAINER(about_win), 3);

  about_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(about_frame), 3);
  gtk_container_add (GTK_CONTAINER(about_win), about_frame);
  gtk_widget_show (about_frame);

  /* image */
  pix_win = create_gkdebconf_image(about_win, iname);
  gtk_widget_show (pix_win);

  about_label = gtk_label_new (msg);
  gtk_label_set_justify (GTK_LABEL(about_label), GTK_JUSTIFY_LEFT);

  button_ok = gtk_button_new_with_label (_("OK"));
  gtk_signal_connect_object (GTK_OBJECT(button_ok), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(about_win));

  about_table = gtk_table_new (2, 2, FALSE);
  gtk_container_add (GTK_CONTAINER(about_frame), about_table);

  gtk_table_attach (GTK_TABLE(about_table), pix_win, 0, 1, 0, 2, 
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(about_table), about_label, 1, 2, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(about_table), button_ok, 1, 2, 1, 2,
		    GTK_FILL, GTK_EXPAND, 4, 4);

  gtk_widget_show (button_ok);
  gtk_widget_show (about_label);
  gtk_widget_show (about_table);
  gtk_widget_show (about_win);
}

/* 
   Shows 'msg' in a dialog box with an OK button 
   This function is to be a helper for functions needing to
   display some information to the user
*/
void 
gk_diag (gchar *msg)
{
  GtkWidget *diag_win;
  GtkWidget *diag_frame;
  GtkWidget *diag_table;
  GtkWidget *diag_label;
  GtkWidget *button_ok;

  diag_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(diag_win), "GkDebconf");
  gtk_signal_connect_object (GTK_OBJECT(diag_win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(diag_win));
  gtk_container_set_border_width (GTK_CONTAINER(diag_win), 3);

  diag_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(diag_frame), 3);
  gtk_container_add (GTK_CONTAINER(diag_win), diag_frame);
  gtk_widget_show (diag_frame);

  button_ok = gtk_button_new_with_label (_("OK"));
  gtk_signal_connect_object (GTK_OBJECT(button_ok), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(diag_win));

  diag_label = gtk_label_new (msg);
  gtk_label_set_justify (GTK_LABEL(diag_label), GTK_JUSTIFY_LEFT);

  diag_table = gtk_table_new (2, 1, FALSE);
  gtk_container_add (GTK_CONTAINER(diag_frame), diag_table);

  gtk_table_attach (GTK_TABLE(diag_table), diag_label, 0, 1, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(diag_table), button_ok, 0, 1, 1, 2,
		    GTK_FILL, GTK_EXPAND, 4, 4);

  gtk_widget_show (button_ok);
  gtk_widget_show (diag_label);
  gtk_widget_show (diag_table);
  gtk_widget_show (diag_win);
}
