#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"
#include "debconf.h"
#include "gtk_gui.h"
#include "files.h"
#include "config.h"

#define TERMCMD "/usr/bin/x-terminal-emulator"
#define GKTERM "/bin/gkdebconf-term"
#define DEBCONFCMD "/usr/sbin/dpkg-reconfigure"

extern GtkWidget *main_window;
extern GtkWidget *splash_label;
extern gint errno;

/* stores information about available front ends */
dfrontend dfes[] = {{"Gnome", FALSE, "libgnome-perl"},
		    {"Dialog", TRUE, "dialog"},
		    {"Readline", TRUE, "libterm-readline-gnu-perl"},
		    {"Editor", TRUE, NULL},
		    {NULL, FALSE}};

gchar frontend[FILENAME_MAX];

int
check_missing (gchar *fe)
{
  gchar *command;
  gchar *msg;
  gint i;
  gint ret;

  for (i = 0 ; strcmp (dfes[i].name, fe) ; i++);

  if (dfes[i].dep == NULL)
    return 0;

  msg = g_strdup_printf (_("Checking whether %s is installed..."),
			 dfes[i].dep);
  gtk_label_set_text (GTK_LABEL(splash_label), msg);
  while (gtk_events_pending())
    gtk_main_iteration(); 
  g_free (msg);

  command = g_strdup_printf ("/usr/bin/dpkg -s %s > /dev/null 2>&1", 
			     dfes[i].dep);
  ret = system(command);
  g_free (command);

  return ret;
}

/*
  fills the combo box with the available frontends
*/
void
get_frontends (GtkWidget *combo)
{
  gchar *fe;
  GList *felist = NULL;
  gint i;

  for (i = 0 ; dfes[i].name != NULL ; i++)
    {
      if (check_missing(dfes[i].name) == 0)
	{
	  felist = g_list_append (felist, 
				  g_strdup (dfes[i].name));
	}
    }

  gtk_combo_set_popdown_strings (GTK_COMBO(combo),
				 felist);

  if (!strcmp (read_config ("remember_frontend"), "yes"))
    {
      fe = read_config ("last_frontend");
      if (strcmp (fe, "none"))
	strcpy (frontend, fe);
    }

  if (!strlen(frontend))
    strcpy (frontend, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)));
  else
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(combo)->entry), frontend);
}

/*
  mostly a callback to the frontend selection combo box
*/
void
fe_select (GtkWidget *entry, gpointer data)
{
  gchar *fename;

  fename = gtk_entry_get_text (GTK_ENTRY(entry));

  strncpy (frontend, fename, FILENAME_MAX);

  write_config ("last_frontend", frontend);
}

int
run_config (gchar *cf)
{
  gushort need_term = FALSE;
  gushort gk_ask_for_root = FALSE;
  gchar *call_command = NULL;
  gint i, cmdret;
  
  /*
    hides the main window immediately
  */
  gtk_widget_hide (main_window);

  while (gtk_events_pending())
    gtk_main_iteration();

  for (i = 0 ; strcmp(frontend, dfes[i].name) ; i++);
  need_term = dfes[i].need_term;
  
  if (getuid() != 0)
    gk_ask_for_root = TRUE;
  
  if (need_term == TRUE || gk_ask_for_root == TRUE)
    {
      gchar gkterm[256];
      
      strcpy (gkterm, PREFIX);
      strcat (gkterm, GKTERM);
      
      call_command = g_strdup_printf ("%s -e %s %s %s",
				      TERMCMD, gkterm,
				      frontend, cf);
    }
  else
    {
      call_command = g_strdup_printf ("%s -f%s %s",
				      DEBCONFCMD, frontend,
				      cf);
    }

  cmdret = system (call_command);

  gtk_widget_show (main_window);

  if (cmdret != 0)
    {
      gk_diag (_("The configuration script returned an\n"
		 "error status."));
    }

  if (call_command)
    g_free (call_command);

  return 0;
}
