#ifndef SYMMETRICCOMPLEX_H_INCLUDED
#define SYMMETRICCOMPLEX_H_INCLUDED

#include <set>
#include <string>
#include <map>

using namespace std;

#include "symmetry.h"
#include "matrix.h"

class SymmetricComplex{
  int n;
  IntegerMatrix vertices;
  map<IntegerVector,int> indexMap;
  SymmetryGroup sym;
 public:
  class Cone : public set<int>
  {
  public:
    int dimension;
    int multiplicity;
    bool isSubsetOf(Cone const &c)const;
    SymmetricComplex::Cone permuted(IntegerVector const &permutation, SymmetricComplex const &complex)const;
  };
  list<Cone> cones;
  SymmetricComplex(int n_, IntegerVectorList const &v, SymmetryGroup const &sym_);
  bool contains(Cone const &c)const;
  void insert(Cone const &c);
  int getMaxDim()const;
  int getMinDim()const;
  bool isMaximal(Cone const &c)const;
  bool isPure()const;
  IntegerVector fvector()const;
  string toString(int dimLow, int dimHigh, bool onlyMaximal, bool group, ostream *multiplicities=0)const;
};

#endif
