#include "gfanapplication.h"
#include "field.h"
#include "field_rationals.h"
#include "field_zmodpz.h"
#include "division.h"
#include "printer.h"
#include "symmetry.h"
#include "log.h"

GFanApplication::FieldOption::FieldOption():
  IntegerOption("--mod","Set the field to Z / pZ. The value must be a prime number p between 2 and 32749.\n")
{
}


void GFanApplication::FieldOption::onOptionsParsed()
{
  if(getValue())
    {
      fprintf(Stderr,"CANNOT CHANGE FIELD\n");
      assert(0);
      //      Field::setField(new FieldZModPZ(getValue()));
      //      Field::setField(Field::find("Zmod2Z"));
    }
}


GFanApplication::LogLevelOption::LogLevelOption():
  IntegerOption("--log","Set the logging level.\n")
{
  hide();
}


void GFanApplication::LogLevelOption::onOptionsParsed()
{
  if(getValue())
    {
      setLogLevel(getValue());
    }
}


void GFanApplication::assertSymmetriesMatch(IntegerVectorList const &g, PolynomialSet &markedGroebnerBasis)
{
  int n=markedGroebnerBasis.numberOfVariablesInRing();
  for(IntegerVectorList::const_iterator i=g.begin();i!=g.end();i++)
    {
      if(i->size()!=n)
	{
	  fprintf(Stderr,"PERMUTATION ");
	  AsciiPrinter(Stderr).printVector(*i);
	  fprintf(Stderr," HAS WRONG LENGTH.\n");
	  assert(0);
	}
      if(!areIdealsEqual(markedGroebnerBasis,SymmetryGroup::permutePolynomialSet(markedGroebnerBasis,*i)))
	{
	  fprintf(Stderr,"PERMUTATION ");
	  AsciiPrinter(Stderr).printVector(*i);
	  fprintf(Stderr," DOES NOT KEEP THE IDEAL FIXED.\n");
	  assert(0);
	}
    }  
}

void GFanApplication::onExit()
{
  log1
    {
      fprintf(Stderr,"Number of living FieldImplementation objects:%i\n",FieldImplementation::getNumberOfLivingFieldImplementations());
      fprintf(Stderr,"Number of living FieldElementImplementation objects:%i\n",FieldElementImplementation::getNumberOfLivingFieldElementImplementations());
    }
}
