#include "parser.h"
#include "printer.h"
#include "saturation.h"
#include "gfanapplication.h"

class SaturationApplication : public GFanApplication
{
public:
  const char *helpText()
  {
    return "This program computes the saturation of the input ideal with the product of the variables x_1,...,x_n. The ideal does not have to be homogeneous.\n";
  }
  SaturationApplication()
  {
    registerOptions();
  }
  
  char *name()
  {
    return "_saturation";
  }

  int main()
  {
    FileParser P(Stdin);

    PolynomialSet a=P.parsePolynomialSetWithRing();

    AsciiPrinter(Stdout).printPolynomialRing(a.getRing());
    AsciiPrinter(Stdout).printNewLine();
    AsciiPrinter(Stdout).printPolynomialSet(nonHomogeneousSaturation(a));
    
    return 0;
  }
};

static SaturationApplication theApplication;
