/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.viewer.xml;

import java.awt.Color;
import javax.swing.UIManager;

public class StyledString {
    public static final String CONTROL_COLOR_ID = "org.bounce.viewer.xml.control-color";
    public static final String COMMENT_COLOR_ID = "org.bounce.viewer.xml.comment-color";
    public static final String ELEMENT_NAME_COLOR_ID = "org.bounce.viewer.xml.element-name-color";
    public static final String NAMESPACE_PREFIX_COLOR_ID = "org.bounce.viewer.xml.namespace-prefix-color";
    public static final String NAMESPACE_NAME_COLOR_ID = "org.bounce.viewer.xml.namespace-name-color";
    public static final String NAMESPACE_URI_COLOR_ID = "org.bounce.viewer.xml.namespace-uri-color";
    public static final String ATTRIBUTE_NAME_COLOR_ID = "org.bounce.viewer.xml.attribute-name-color";
    public static final String ATTRIBUTE_VALUE_COLOR_ID = "org.bounce.viewer.xml.attribute-value-color";
    public static final String ELEMENT_VALUE_COLOR_ID = "org.bounce.viewer.xml.element-value-color";
    private static final Color BRACKET_COLOR = new Color(102, 102, 102);
    private static final Color COMMENT_COLOR = new Color(153, 153, 153);
    private static final Color ELEMENT_PREFIX_COLOR = new Color(0, 102, 102);
    private static final Color ELEMENT_NAME_COLOR = new Color(0, 51, 102);
    private static final Color NAMESPACE_PREFIX_COLOR = ELEMENT_PREFIX_COLOR;
    private static final Color NAMESPACE_NAME_COLOR = new Color(102, 102, 102);
    private static final Color NAMESPACE_URI_COLOR = new Color(0, 51, 51);
    private static final Color ATTRIBUTE_PREFIX_COLOR = ELEMENT_PREFIX_COLOR;
    private static final Color ATTRIBUTE_NAME_COLOR = new Color(153, 51, 51);
    private static final Color ATTRIBUTE_VALUE_COLOR = new Color(102, 0, 0);
    private static final Color ELEMENT_VALUE_COLOR = Color.black;
    static final StyledString COMMENT_START = new StyledString("<!--");
    static final StyledString COMMENT_END = new StyledString("-->");
    static final StyledString SPACE = new StyledString(" ");
    static final StyledString TAB = new StyledString("  ");
    static final StyledString SLASH = new StyledString("/");
    static final StyledString ATTRIBUTE_ASIGN = new StyledString("=");
    static final StyledString ATTRIBUTE_COLON = new StyledString(":");
    static final StyledString NAMESPACE_ASIGN = new StyledString("=");
    protected static final StyledString NAMESPACE_COLON = new StyledString(":");
    static final StyledString NAMESPACE_NAME = new StyledString("xmlns", "org.bounce.viewer.xml.namespace-name-color", NAMESPACE_NAME_COLOR);
    static final StyledString ELEMENT_COLON = new StyledString(":");
    static final StyledString OPEN_BRACKET = new StyledString("<");
    static final StyledString CLOSE_BRACKET = new StyledString(">");
    private String text = null;
    private String colorID = null;

    StyledString(String text) {
        this(text, CONTROL_COLOR_ID, BRACKET_COLOR);
    }

    StyledString(String text, String colorID, Color color) {
        this.text = text;
        this.colorID = colorID;
        UIManager.put(colorID, color);
    }

    String getText() {
        return this.text;
    }

    Color getColor() {
        return UIManager.getColor(this.colorID);
    }

    static class ElementPrefix
    extends StyledString {
        public ElementPrefix(String text) {
            super(text, StyledString.NAMESPACE_PREFIX_COLOR_ID, ELEMENT_PREFIX_COLOR);
        }
    }

    static class ElementName
    extends StyledString {
        public ElementName(String text) {
            super(text, StyledString.ELEMENT_NAME_COLOR_ID, ELEMENT_NAME_COLOR);
        }
    }

    static class NamespacePrefix
    extends StyledString {
        public NamespacePrefix(String text) {
            super(text, StyledString.NAMESPACE_PREFIX_COLOR_ID, NAMESPACE_PREFIX_COLOR);
        }
    }

    static class NamespaceURI
    extends StyledString {
        public NamespaceURI(String text) {
            super("\"" + text + "\"", StyledString.NAMESPACE_URI_COLOR_ID, NAMESPACE_URI_COLOR);
        }
    }

    static class AttributeName
    extends StyledString {
        public AttributeName(String text) {
            super(text, StyledString.ATTRIBUTE_NAME_COLOR_ID, ATTRIBUTE_NAME_COLOR);
        }
    }

    static class AttributePrefix
    extends StyledString {
        public AttributePrefix(String text) {
            super(text, StyledString.NAMESPACE_PREFIX_COLOR_ID, ATTRIBUTE_PREFIX_COLOR);
        }
    }

    static class AttributeValue
    extends StyledString {
        public AttributeValue(String text) {
            super("\"" + text + "\"", StyledString.ATTRIBUTE_VALUE_COLOR_ID, ATTRIBUTE_VALUE_COLOR);
        }
    }

    static class ElementValue
    extends StyledString {
        public ElementValue(String text) {
            super(text, StyledString.ELEMENT_VALUE_COLOR_ID, ELEMENT_VALUE_COLOR);
        }
    }

    static class CommentText
    extends StyledString {
        public CommentText(String text) {
            super(text, StyledString.COMMENT_COLOR_ID, COMMENT_COLOR);
        }
    }
}

