/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

final class FieldInfos {
    private Vector byNumber = new Vector();
    private Hashtable byName = new Hashtable();

    FieldInfos() {
        this.add("", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldInfos(Directory d, String name) throws IOException {
        InputStream input = d.openFile(name);
        try {
            this.read(input);
        }
        finally {
            input.close();
        }
    }

    public void add(Document doc) {
        Enumeration fields = doc.fields();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            this.add(field.name(), field.isIndexed(), field.isTermVectorStored());
        }
    }

    public void addIndexed(Collection names, boolean storeTermVectors) {
        Iterator i = names.iterator();
        boolean j = false;
        while (i.hasNext()) {
            this.add((String)i.next(), true, storeTermVectors);
        }
    }

    public void add(Collection names, boolean isIndexed) {
        Iterator i = names.iterator();
        boolean j = false;
        while (i.hasNext()) {
            this.add((String)i.next(), isIndexed);
        }
    }

    public void add(String name, boolean isIndexed) {
        this.add(name, isIndexed, false);
    }

    public void add(String name, boolean isIndexed, boolean storeTermVector) {
        FieldInfo fi = this.fieldInfo(name);
        if (fi == null) {
            this.addInternal(name, isIndexed, storeTermVector);
        } else {
            if (fi.isIndexed != isIndexed) {
                fi.isIndexed = true;
            }
            if (fi.storeTermVector != storeTermVector) {
                fi.storeTermVector = true;
            }
        }
    }

    private void addInternal(String name, boolean isIndexed, boolean storeTermVector) {
        FieldInfo fi = new FieldInfo(name, isIndexed, this.byNumber.size(), storeTermVector);
        this.byNumber.addElement(fi);
        this.byName.put(name, fi);
    }

    public int fieldNumber(String fieldName) {
        FieldInfo fi = this.fieldInfo(fieldName);
        if (fi != null) {
            return fi.number;
        }
        return -1;
    }

    public FieldInfo fieldInfo(String fieldName) {
        return (FieldInfo)this.byName.get(fieldName);
    }

    public String fieldName(int fieldNumber) {
        return this.fieldInfo((int)fieldNumber).name;
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        return (FieldInfo)this.byNumber.elementAt(fieldNumber);
    }

    public int size() {
        return this.byNumber.size();
    }

    public boolean hasVectors() {
        boolean hasVectors = false;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.fieldInfo((int)i).storeTermVector) continue;
            hasVectors = true;
        }
        return hasVectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory d, String name) throws IOException {
        OutputStream output = d.createFile(name);
        try {
            this.write(output);
        }
        finally {
            output.close();
        }
    }

    public void write(OutputStream output) throws IOException {
        output.writeVInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            FieldInfo fi = this.fieldInfo(i);
            byte bits = 0;
            if (fi.isIndexed) {
                bits = (byte)(bits | 1);
            }
            if (fi.storeTermVector) {
                bits = (byte)(bits | 2);
            }
            output.writeString(fi.name);
            output.writeByte(bits);
        }
    }

    private void read(InputStream input) throws IOException {
        int size = input.readVInt();
        for (int i = 0; i < size; ++i) {
            String name = input.readString().intern();
            byte bits = input.readByte();
            boolean isIndexed = (bits & 1) != 0;
            boolean storeTermVector = (bits & 2) != 0;
            this.addInternal(name, isIndexed, storeTermVector);
        }
    }
}

