/*
  Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(channel_set_gui)(void *_cpssp, int val);
/*forward*/ static void
NAME_(volt_div_set)(void *_cpssp, int val, int channel);
/*forward*/ static void
NAME_(volt_div_set_sim)(void *_cpssp, int val, int channel);
/*forward*/ static void
NAME_(volt_div_set_gui)(void *_cpssp, int val);
/*forward*/ static void
NAME_(amp_div_set)(void *_cpssp, int val, int channel);
/*forward*/ static void
NAME_(amp_div_set_sim)(void *_cpssp, int val, int channel);
/*forward*/ static void
NAME_(amp_div_set_gui)(void *_cpssp, int val);
/*forward*/ static void
NAME_(sample_rate_set)(void *_cpssp, unsigned int sample_rate);
/*forward*/ static void
NAME_(sample_rate_set_sim)(void *_cpssp, int val);
/*forward*/ static void
NAME_(sample_rate_set_gui)(void *_cpssp, int val);
/*forward*/ static void
NAME_(sec_div_set)(void *_cpssp, unsigned int val);
/*forward*/ static void
NAME_(sec_div_set_sim)(void *_cpssp, int val);
/*forward*/ static void
NAME_(sec_div_set_gui)(void *_cpssp, int val);
/*forward*/ static void
NAME_(offset_set_gui)(void *_cpssp, int value);
/*forward*/ static void
NAME_(offset_set_sim)(void *_cpssp, int channel, double value);
/*forward*/ static void
NAME_(trigger_channel_set_sim)(void *_cpssp, int channel);
/*forward*/ static void
NAME_(trigger_edge_set_sim)(void *_cpssp, int edge);
/*forward*/ static void
NAME_(trigger_level_set_sim)(void *_cpssp, int level);
/*forward*/ static void
NAME_(trigger_channel_set_gui)(void *_cpssp, int channel);
/*forward*/ static void
NAME_(trigger_edge_set_gui)(void *_cpssp, int edge);
/*forward*/ static void
NAME_(trigger_level_set_gui)(void *_cpssp, int level);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(channel_set_gui)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;
	char channel_type;

	if (val < 1
	 || NUMBER_ANALOG_CHANNELS + NUMBER_DIGITAL_CHANNELS < val) {
		return;
	}

	cpssp->selected_channel = val - 1;
	channel_type = get_channel_type(cpssp, val - 1);
	sig_integer_set(cpssp->port_vert_offset_sim_gui, cpssp, cpssp->vertical_offset[val -1]);
	if (cpssp->selected_channel < NUMBER_ANALOG_CHANNELS && cpssp->selected_channel == val - 1) {
		if (channel_type == 'v') {
			sig_integer_set(cpssp->port_volt_div_sim_gui, cpssp,
					(int) cpssp->scale_factor[cpssp->selected_channel]
							* GRID_STEP);
		} else if (channel_type == 'c') {
			sig_integer_set(cpssp->port_amp_div_sim_gui, cpssp,
					(int) cpssp->scale_factor[cpssp->selected_channel]
							* GRID_STEP);
		}
	}
}


static void
NAME_(volt_div_set)(void *_cpssp, int val, int channel)
{
	struct cpssp *cpssp = _cpssp;
	char channel_type;

	channel_type = get_channel_type(cpssp, channel);
	if (channel < NUMBER_ANALOG_CHANNELS && channel_type == 'v') {
		if (val != 0) {
			cpssp->scale_factor[channel] = val / GRID_STEP;
		} else {
			cpssp->scale_factor[channel] = 1;
		}
	}
}

static void
NAME_(volt_div_set_sim)(void *_cpssp, int val, int channel)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}
	NAME_(volt_div_set)(cpssp, val, channel - 1);
	if (cpssp->selected_channel == channel - 1) {
		sig_integer_set(cpssp->port_volt_div_sim_gui, cpssp,
				round(cpssp->scale_factor[cpssp->selected_channel] * (double) GRID_STEP));
	}
}

static void
NAME_(volt_div_set_gui)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}
	NAME_(volt_div_set)(cpssp, val, cpssp->selected_channel);
	if (! cpssp->running) {
		wipe_screen(cpssp);
		update_pixel_buffer(cpssp);
	}
}

static void
NAME_(amp_div_set)(void *_cpssp, int val, int channel)
{
	struct cpssp *cpssp = _cpssp;
	char channel_type;

	channel_type = get_channel_type(cpssp, channel);
	if (channel < NUMBER_ANALOG_CHANNELS && channel_type == 'c') {
		if (val != 0) {
			cpssp->scale_factor[channel] = val / GRID_STEP;
		} else {
			cpssp->scale_factor[channel] = 1;
		}
	}
}

static void
NAME_(amp_div_set_sim)(void *_cpssp, int val, int channel)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}
	NAME_(amp_div_set)(cpssp, val, channel - 1);
	if (cpssp->selected_channel == channel - 1) {
		sig_integer_set(cpssp->port_amp_div_sim_gui, cpssp,
				round(cpssp->scale_factor[cpssp->selected_channel] * (double) GRID_STEP));
	}
}

static void
NAME_(amp_div_set_gui)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}
	NAME_(amp_div_set)(_cpssp, val, cpssp->selected_channel);
	if (! cpssp->running) {
		wipe_screen(cpssp);
		update_pixel_buffer(cpssp);
	}
}

static void
NAME_(sample_rate_set)(void *_cpssp, unsigned int sample_rate)
{
	struct cpssp *cpssp = _cpssp;
	double time_hz_d;
	double sample_rate_d;
	double call_after_d;

	cpssp->sample_rate = sample_rate;
	sample_rate_d = (double) sample_rate;
	time_hz_d = (double) TIME_HZ;
	cpssp->ticks_per_sample = time_hz_d / sample_rate_d;
	call_after_d = (1.0 / sample_rate_d) * time_hz_d;
	cpssp->call_after_ticks = round(call_after_d);
}

static void
NAME_(sample_rate_set_sim)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	NAME_(sample_rate_set)(cpssp, (unsigned int) val);
	sig_integer_set(cpssp->port_sample_rate_sim_gui, cpssp, val);
}

static void
NAME_(sample_rate_set_gui)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}
	NAME_(sample_rate_set)(cpssp, (unsigned int) val);
}

static void
NAME_(sec_div_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;
	double val_d;
	double sample_rate_d;
	double grid_step_d;
	double pixel_step_d;
	double time_hz_d;
	double seconds_d;

	if (val != 0) {
		val_d = (double) val;
		sample_rate_d = (double)cpssp->sample_rate;
		grid_step_d = (double)GRID_STEP;
		time_hz_d = (double) TIME_HZ;
		cpssp->sec_div = val_d / (double)1e9;
		seconds_d = (double)1e9 / val_d;
		/* samples per pixel */
		pixel_step_d = (sample_rate_d/seconds_d)/grid_step_d;
		cpssp->pixel_step_d = pixel_step_d;
		cpssp->pixel_step = (int) pixel_step_d;
		cpssp->ticks_per_sample = time_hz_d / sample_rate_d;
		int channel;
		for (channel = 0; channel < NUMBER_ANALOG_CHANNELS; channel++) {
			cpssp->pixel_step_overflow[channel] = 0.0;
		}
	}
}

static void
NAME_(sec_div_set_sim)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	NAME_(sec_div_set)(_cpssp, val);
	sig_integer_set(cpssp->port_sec_div_sim_gui, cpssp, val);
}

static void
NAME_(sec_div_set_gui)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;

	if (val == 0) {
		return;
	}

	NAME_(sec_div_set)(_cpssp, (unsigned int) val);
	if (cpssp->running == false) {
		wipe_screen(cpssp);
		update_pixel_buffer(cpssp);
	}
}

static void
NAME_(offset_set_gui)(void *_cpssp, int value)
{
	struct cpssp *cpssp = _cpssp;
	int channel;

	channel = cpssp->selected_channel;
	cpssp->vertical_offset[channel] = value;
	if (cpssp->running == false) {
		wipe_screen(cpssp);
		update_pixel_buffer(cpssp);
	}

}

static void
NAME_(offset_set_sim)(void *_cpssp, int channel, double value)
{
	struct cpssp *cpssp = _cpssp;
	double val;

	if (channel <= NUMBER_ANALOG_CHANNELS + NUMBER_DIGITAL_CHANNELS) {
		/*channel_step = SCREEN_HEIGHT
			/ (NUMBER_ANALOG_CHANNELS + NUMBER_DIGITAL_CHANNELS);
		val = value * 10.0 * channel_step;*/
		val = value * SCREEN_HEIGHT;
		cpssp->vertical_offset[channel-1] = (int) val;
		if (channel-1 == cpssp->selected_channel) {
			sig_integer_set(cpssp->port_vert_offset_sim_gui, cpssp,
					(int) val);
		}
	}
}

static void
NAME_(trigger_channel_set_sim)(void *_cpssp, int channel)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->trigger_channel = channel - 1;
	sig_integer_set(cpssp->port_trigger_channel_sim_gui, cpssp, channel);
}

static void
NAME_(trigger_edge_set_sim)(void *_cpssp, int edge)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->trigger_edge = edge;
	sig_integer_set(cpssp->port_trigger_edge_sim_gui, cpssp, edge);
}

static void
NAME_(trigger_level_set_sim)(void *_cpssp, int level)
{
	/*TODO*/
	struct cpssp *cpssp = _cpssp;

	cpssp->trigger_level = level;
	sig_integer_set(cpssp->port_trigger_level_sim_gui, cpssp, level);
}

static void
NAME_(trigger_channel_set_gui)(void *_cpssp, int channel)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->trigger_channel = channel;
}

static void
NAME_(trigger_edge_set_gui)(void *_cpssp, int edge)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->trigger_edge = edge;
}

static void
NAME_(trigger_level_set_gui)(void *_cpssp, int level)
{
#if 0
	struct cpssp *cpssp = _cpssp;

	/*TODO control needs to be debugged and added to GUI*/
	cpssp->trigger_level = level;
#endif
}

#endif /* BEHAVIOUR */
