/*
 *  i386 micro operations (templates for various register related
 *  operations)
 * 
 *  Copyright (c) 2003 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
void glue(NAME_(op_movl_A0),REGNAME)(void)
{
    A0(env) = (uint32_t)env->regs[REG];
}

void glue(NAME_(op_addl_A0),REGNAME)(void)
{
    A0(env) = (uint32_t)(A0(env) + env->regs[REG]);
}

void glue(glue(NAME_(op_addl_A0),REGNAME),_s1)(void)
{
    A0(env) = (uint32_t)(A0(env) + (env->regs[REG] << 1));
}

void glue(glue(NAME_(op_addl_A0),REGNAME),_s2)(void)
{
    A0(env) = (uint32_t)(A0(env) + (env->regs[REG] << 2));
}

void glue(glue(NAME_(op_addl_A0),REGNAME),_s3)(void)
{
    A0(env) = (uint32_t)(A0(env) + (env->regs[REG] << 3));
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
void glue(NAME_(op_movq_A0),REGNAME)(void)
{
    A0(env) = env->regs[REG];
}

void glue(NAME_(op_addq_A0),REGNAME)(void)
{
    A0(env) = (A0(env) + env->regs[REG]);
}

void glue(glue(NAME_(op_addq_A0),REGNAME),_s1)(void)
{
    A0(env) = (A0(env) + (env->regs[REG] << 1));
}

void glue(glue(NAME_(op_addq_A0),REGNAME),_s2)(void)
{
    A0(env) = (A0(env) + (env->regs[REG] << 2));
}

void glue(glue(NAME_(op_addq_A0),REGNAME),_s3)(void)
{
    A0(env) = (A0(env) + (env->regs[REG] << 3));
}
#endif

void glue(NAME_(op_movl_T0),REGNAME)(void)
{
    T0(env) = env->regs[REG];
}

void glue(NAME_(op_movl_T1),REGNAME)(void)
{
    T1(env) = env->regs[REG];
}

void glue(NAME_(op_movh_T0),REGNAME)(void)
{
    T0(env) = env->regs[REG] >> 8;
}

void glue(NAME_(op_movh_T1),REGNAME)(void)
{
    T1(env) = env->regs[REG] >> 8;
}

void glue(glue(NAME_(op_movl),REGNAME),_T0)(void)
{
    env->regs[REG] = (uint32_t)T0(env);
}

void glue(glue(NAME_(op_movl),REGNAME),_T1)(void)
{
    env->regs[REG] = (uint32_t)T1(env);
}

void glue(glue(NAME_(op_movl),REGNAME),_A0)(void)
{
    env->regs[REG] = (uint32_t)A0(env);
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
void glue(glue(NAME_(op_movq),REGNAME),_T0)(void)
{
    env->regs[REG] = T0(env);
}

void glue(glue(NAME_(op_movq),REGNAME),_T1)(void)
{
    env->regs[REG] = T1(env);
}

void glue(glue(NAME_(op_movq),REGNAME),_A0)(void)
{
    env->regs[REG] = A0(env);
}
#endif

/* mov T1 to REG if T0 is true */
void glue(glue(NAME_(op_cmovw),REGNAME),_T1_T0)(void)
{
    env->regs[REG] &= 0xffffffff;
    if (T0(env))
        env->regs[REG] = (env->regs[REG] & ~0xffff) | (T1(env) & 0xffff);
    FORCE_RET();
}

void glue(glue(NAME_(op_cmovl),REGNAME),_T1_T0)(void)
{
    env->regs[REG] &= 0xffffffff;
    if (T0(env))
        env->regs[REG] = (uint32_t)T1(env);
    FORCE_RET();
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
void glue(glue(NAME_(op_cmovq),REGNAME),_T1_T0)(void)
{
    if (T0(env))
        env->regs[REG] = T1(env);
    FORCE_RET();
}
#endif

/* NOTE: T0 high order bits are ignored */
void glue(glue(NAME_(op_movw),REGNAME),_T0)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xffff) | (T0(env) & 0xffff);
}

/* NOTE: T0 high order bits are ignored */
void glue(glue(NAME_(op_movw),REGNAME),_T1)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xffff) | (T1(env) & 0xffff);
}

/* NOTE: A0 high order bits are ignored */
void glue(glue(NAME_(op_movw),REGNAME),_A0)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xffff) | (A0(env) & 0xffff);
}

/* NOTE: T0 high order bits are ignored */
void glue(glue(NAME_(op_movb),REGNAME),_T0)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xff) | (T0(env) & 0xff);
}

/* NOTE: T0 high order bits are ignored */
void glue(glue(NAME_(op_movh),REGNAME),_T0)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xff00) | ((T0(env) & 0xff) << 8);
}

/* NOTE: T1 high order bits are ignored */
void glue(glue(NAME_(op_movb),REGNAME),_T1)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xff) | (T1(env) & 0xff);
}

/* NOTE: T1 high order bits are ignored */
void glue(glue(NAME_(op_movh),REGNAME),_T1)(void)
{
    env->regs[REG] = (env->regs[REG] & ~0xff00) | ((T1(env) & 0xff) << 8);
}
