/*
 * Copyright (C) 2016-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define CHIP_(x)	chip_intel_80586_int_ ## x

/* Configuration */
#define CONFIG_HZ			(66*1000*1000)
#define CONFIG_CPU			80586
#define CONFIG_FPU			1

#define CONFIG_CPU_VIRT_BITS		32
#define CONFIG_CPU_PHYS_BITS		32

#define CONFIG_CPU_SOCKET_HOST

/* Caches */
#define CONFIG_CPU_CACHE_LINE_SIZE	64

#define CONFIG_CPU_L1I_SIZE		(8*1024)
#define CONFIG_CPU_L1I_ASSOC		2
#define CONFIG_CPU_L1D_SIZE		(8*1024)
#define CONFIG_CPU_L1D_ASSOC		2

#define CONFIG_CPU_L2_SIZE              (8*1024)
#define CONFIG_CPU_L2_ASSOC             2

/* TLB */
#define CONFIG_CPU_TLB_SIZE		32	/* FIXME */
#define CONFIG_CPU_TLB_ASSOC		4	/* FIXME */

/*
 * 0x00000001: EDX Register
 * Features
 */
#define CONFIG_CPU_FPU_SUPPORT		1
#define CONFIG_CPU_VME_SUPPORT		0
#define CONFIG_CPU_DE_SUPPORT		0
#define CONFIG_CPU_PSE_SUPPORT		0
#define CONFIG_CPU_TSC_SUPPORT		1
#define CONFIG_CPU_MSR_SUPPORT		1
#define CONFIG_CPU_PAE_SUPPORT		0
#define CONFIG_CPU_MCE_SUPPORT		0

#define CONFIG_CPU_CX8_SUPPORT		0
#define CONFIG_CPU_APIC_SUPPORT		1
/* Bit 10: reserved */
#define CONFIG_CPU_SEP_SUPPORT		0
#define CONFIG_CPU_MTRR_SUPPORT		1

/* Ports */
#include "chip_intel_80586_int.h"

#include "conf_intel_x86_int.c"
