/* 
    tuxzap for linux_dvb

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gtk/gtk.h>
#include <unistd.h>
#include <stream.h>
#include <stdlib.h>

#include "interface.hh"
gint LISTX = 200;
gint LISTY = 600;

int ipaq = 0;
int master = 0;
char filen[80];

int main(int argc, char *argv[])
{
	int c,channel = 0, dev = 0;

	gtk_set_locale();
#ifdef ENABLE_NLS	
	bindtextdomain(PACKAGE, LOCALE_DIR);
	textdomain(PACKAGE);
#endif
	filen[0]='\0';

	for (;;) {
		if (-1 == (c = getopt(argc, argv, "id:c:mf:")))
			break;
		switch (c) {
		case 'i':
			ipaq = 1;
			break;
		case 'm':
			master = 1;
			break;
		case 'c':
			channel = atoi(optarg);
			break;
		case 'd':
			dev = atoi(optarg);
			break;

		case 'f':
			strcpy(filen,optarg);
			break;

		case 'h':
		default:
			cerr << _("usage: ") << argv[0] << _("  [ options ] ") 
			     <<	endl << endl << _("options:") << endl
			     << _("    -i        use ipaq dimensions") << endl 
			     << _("    -m        use master volume") << endl 
			     << endl << _("    -c <n>    set channel") << endl
			     << endl << _("    -f <f>    use <f> as dvbrc") << endl
			     << endl << _("    -d <n>    set devices (0 =/dev/ost/xxx0)") << endl;
			exit(1);
		}
	}

	if (ipaq) {
		LISTX = 200;
		LISTY = 310;
	}

	gtk_init(&argc, &argv);


	//ListHandler listh;
	cerr << _("WELCOME TO TUXZAP") << endl;
	create_window (dev);
	gtk_main();
	
	return 0;
}
