/* 
    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "common.hh"


gint contextid;
GtkWidget *statusbar;

void status_message(char *buf)
{
        gint messid;
        
        
        if (statusbar && GTK_WIDGET_VISIBLE(statusbar)) {
                gtk_statusbar_pop(GTK_STATUSBAR(statusbar), contextid);
                messid = gtk_statusbar_push(GTK_STATUSBAR(statusbar), 
                                            contextid, buf);
        }
}

GtkWidget *CreateWidgetFromXpm(GtkWidget * window, gchar ** xpm_data)
{
        GdkBitmap *mask;
        GdkPixmap *pixmap_data;
        GtkWidget *pixmap_widget;

        pixmap_data = gdk_pixmap_create_from_xpm_d(window->window,
                                                   &mask,
                                                   (GdkColor *) NULL,
                                                   (gchar **) xpm_data);

        pixmap_widget = gtk_pixmap_new(pixmap_data, mask);
        gtk_widget_show(pixmap_widget);

        return (pixmap_widget);
}



GtkWidget *CreateMenuItem(GtkWidget * menu, char *szName, char *szAccel,
                          char *szTip, GtkSignalFunc func, gpointer data,
			  GtkAccelGroup *accel_group)
{
        GtkWidget *menuitem;
        static GtkTooltips *tooltips = (GtkTooltips *) (NULL);


        if (szName && strlen(szName)) {
                menuitem = gtk_menu_item_new_with_label(szName);
                gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                                   GTK_SIGNAL_FUNC(func), data);
        } else {
                menuitem = gtk_menu_item_new();
        }

        gtk_menu_append(GTK_MENU(menu), menuitem);
        gtk_widget_show(menuitem);

        if (szAccel) {
                if (szAccel[0] == '^') {
                        gtk_widget_add_accelerator(menuitem,
                                                   "activate",
                                                   accel_group,
                                                   szAccel[1],
                                                   GDK_CONTROL_MASK,
                                                   GTK_ACCEL_VISIBLE);
                } else {
                        gtk_widget_add_accelerator(menuitem,
                                                   "activate",
                                                   accel_group,
                                                   szAccel[0],
                                                   0, GTK_ACCEL_VISIBLE);
                }
        }

        if (szTip && strlen(szTip)) {
                if (tooltips == NULL) {
                        tooltips = gtk_tooltips_new();
                }
                gtk_tooltips_set_tip(tooltips, menuitem, szTip,
				     (gchar *) NULL);

        }
        return (menuitem);
}


GtkWidget *CreateBarSubMenu(GtkWidget * menu, char *szName)
{
        GtkWidget *menuitem;
        GtkWidget *submenu;

        menuitem = gtk_menu_item_new_with_label(szName);

        gtk_menu_bar_append(GTK_MENU_BAR(menu), menuitem);
        gtk_widget_show(menuitem);

        submenu = gtk_menu_new();
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);

        return (submenu);
}


