// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __FORMS_H
#define __FORMS_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class forms_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  forms_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.169533172561123, 0.0841793787126844, -0.116642368703961, 0.0, -0.146820034222104, 0.0729014804399756, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.321678327423669, -0.134687005940295, 0.0972019739199675, 0.260579710864614, -0.12987926104263, 0.0976879837895674, -0.0631345340345133};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0782460796435952, -0.168358757425369, 0.349927106111882, 0.0, 0.0677630927178939, -0.145802960879951, 0.303045763365662};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.165186168136479, 0.235702260395516, -0.272165526975909, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0391230398217977, -0.084179378712684, -0.349927106111882, 0.0, -0.0338815463589471, -0.0729014804399753, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0608580619450188, 0.0, 0.213844342623929, 0.0601337794302957, 0.0395284707521045, 0.112268279877563, -0.138895974875929};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126838, 0.116642368703961, 0.0, 0.146820034222104, 0.0729014804399753, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.0169407731794733, -0.0247865033495919, 0.0378807204207081};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0782460796435954, -0.168358757425368, -0.349927106111882, 0.0, -0.0677630927178941, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.243432247780074, -0.404061017820884, -0.622092633087791, 0.120267558860591, 0.0790569415042094, 0.0787335988751739, -0.126269068069027};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0391230398217975, -0.0841793787126842, 0.349927106111882, 0.0, 0.0338815463589469, -0.0729014804399755, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0999811017668155, -0.0841793787126838, 0.563771448735811, -0.0601337794302958, 0.073410017111052, -0.185169760317538, 0.164149788489735};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, 0.303045763365664, 0.311046316543896, 0.0, -0.0903507902905253, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.0677630927178938, 0.0320766513935896, -0.0757614408414161};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.765072778737375, 0.0, -0.155523158271948, 0.0, 0.18070158058105, 0.0, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.382536389368687, 0.0673435029701476, -0.0777615791359742, -0.320713490294909, 0.0903507902905251, -0.0641533027871788, 0.0505076272276108};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368688, -0.303045763365664, 0.311046316543896, 0.0, -0.0903507902905251, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.213003216807565, -0.218866384652979, 0.194403947839935, 0.160356745147455, -0.158113883008419, 0.177879612273541, -0.126269068069027};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {3.99999999999986, 0.0, 0.0, -0.368855556781646, -0.47619047619046, -1.64957219768459, 0.0, -0.319438282499959, -0.412393049421146, 0.571428571428549};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.614759261302741, 0.47619047619046, -0.549857399228195, 0.56694670951382, 0.159719141249981, -0.453632354363262, 0.357142857142845};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 3.99999999999986, 0.0, -0.677630927178917, 1.80795671491133, 0.0, 0.0, -0.586845597326945, -1.26269068069022, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 1.05409255338942, 1.16642368703957, -0.336717514850723, 1.04154761224408, 0.684653196881436, -0.5808377131175, 0.218704441319918};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 3.99999999999986, 0.13041013273932, -0.841793787126812, 0.933138949631658, 0.0, 0.112938487863152, -0.729014804399729, -2.02030508910435};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.34776035397152, 0.336717514850724, 1.3608276348795, -0.200445931434309, 0.621161683247338, 0.597792139607781, -0.883883476483156};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 0.952380952380919, 0.0, 0.0, 0.0, 0.824786098842294, 0.0};
      
      static const double coefficients1[10] = \
      {3.99999999999986, 0.0, 0.0, -1.59837407938713, 0.476190476190459, -0.549857399228198, 0.0, -0.638876564999919, 0.412393049421147, -0.142857142857138};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 1.35526185435783, 0.0, 0.0, 0.0, 1.17369119465389, 0.0, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 3.99999999999986, 0.0, 0.677630927178916, -0.524890659167805, 0.0, -2.08309522448817, 0.586845597326942, -0.101015254455218, 0.0};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 1.68358757425363, 0.0, 0.0, 0.0, 1.45802960879946, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 3.99999999999986, 0.825930840682367, 0.841793787126812, -1.78851632012734, 0.0, -1.12938487863153, 0.72901480439973, -0.252538136138044};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using covariant Piola transform to map values back to the physical element.
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (K_00*tmp_ref0 + K_10*tmp_ref1);
      values[1] = (K_01*tmp_ref0 + K_11*tmp_ref1);
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.169533172561123, 0.0841793787126844, -0.116642368703961, 0.0, -0.146820034222104, 0.0729014804399756, -0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.321678327423669, -0.134687005940295, 0.0972019739199675, 0.260579710864614, -0.12987926104263, 0.0976879837895674, -0.0631345340345133};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0782460796435952, -0.168358757425369, 0.349927106111882, 0.0, 0.0677630927178939, -0.145802960879951, 0.303045763365662};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.165186168136479, 0.235702260395516, -0.272165526975909, -0.120267558860592, 0.146820034222104, -0.224536559755125, 0.176776695296637};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0391230398217977, -0.084179378712684, -0.349927106111882, 0.0, -0.0338815463589471, -0.0729014804399753, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0608580619450188, 0.0, 0.213844342623929, 0.0601337794302957, 0.0395284707521045, 0.112268279877563, -0.138895974875929};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.0841793787126838, 0.116642368703961, 0.0, 0.146820034222104, 0.0729014804399753, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.491211499984792, 0.218866384652979, 0.213844342623928, -0.260579710864614, 0.0169407731794733, -0.0247865033495919, 0.0378807204207081};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.0782460796435954, -0.168358757425368, -0.349927106111882, 0.0, -0.0677630927178941, -0.145802960879951, -0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.243432247780074, -0.404061017820884, -0.622092633087791, 0.120267558860591, 0.0790569415042094, 0.0787335988751739, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0391230398217975, -0.0841793787126842, 0.349927106111882, 0.0, 0.0338815463589469, -0.0729014804399755, 0.303045763365663};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.0999811017668155, -0.0841793787126838, 0.563771448735811, -0.0601337794302958, 0.073410017111052, -0.185169760317538, 0.164149788489735};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368687, 0.303045763365664, 0.311046316543896, 0.0, -0.0903507902905253, -0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.169533172561123, 0.084179378712684, 0.116642368703961, 0.160356745147455, 0.0677630927178938, 0.0320766513935896, -0.0757614408414161};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, -0.765072778737375, 0.0, -0.155523158271948, 0.0, 0.18070158058105, 0.0, 0.101015254455221};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.382536389368687, 0.0673435029701476, -0.0777615791359742, -0.320713490294909, 0.0903507902905251, -0.0641533027871788, 0.0505076272276108};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.382536389368688, -0.303045763365664, 0.311046316543896, 0.0, -0.0903507902905251, 0.145802960879951, -0.202030508910442};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.213003216807565, -0.218866384652979, 0.194403947839935, 0.160356745147455, -0.158113883008419, 0.177879612273541, -0.126269068069027};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {3.99999999999986, 0.0, 0.0, -0.368855556781646, -0.47619047619046, -1.64957219768459, 0.0, -0.319438282499959, -0.412393049421146, 0.571428571428549};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 0.614759261302741, 0.47619047619046, -0.549857399228195, 0.56694670951382, 0.159719141249981, -0.453632354363262, 0.357142857142845};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 3.99999999999986, 0.0, -0.677630927178917, 1.80795671491133, 0.0, 0.0, -0.586845597326945, -1.26269068069022, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, 1.05409255338942, 1.16642368703957, -0.336717514850723, 1.04154761224408, 0.684653196881436, -0.5808377131175, 0.218704441319918};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 3.99999999999986, 0.13041013273932, -0.841793787126812, 0.933138949631658, 0.0, 0.112938487863152, -0.729014804399729, -2.02030508910435};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 0.0, -0.34776035397152, 0.336717514850724, 1.3608276348795, -0.200445931434309, 0.621161683247338, 0.597792139607781, -0.883883476483156};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 0.952380952380919, 0.0, 0.0, 0.0, 0.824786098842294, 0.0};
      
      static const double coefficients1[10] = \
      {3.99999999999986, 0.0, 0.0, -1.59837407938713, 0.476190476190459, -0.549857399228198, 0.0, -0.638876564999919, 0.412393049421147, -0.142857142857138};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 1.35526185435783, 0.0, 0.0, 0.0, 1.17369119465389, 0.0, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 3.99999999999986, 0.0, 0.677630927178916, -0.524890659167805, 0.0, -2.08309522448817, 0.586845597326942, -0.101015254455218, 0.0};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0, 0.0, 0.0, 0.0, 1.68358757425363, 0.0, 0.0, 0.0, 1.45802960879946, 0.0};
      
      static const double coefficients1[10] = \
      {0.0, 0.0, 3.99999999999986, 0.825930840682367, 0.841793787126812, -1.78851632012734, 0.0, -1.12938487863153, 0.72901480439973, -0.252538136138044};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513775, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175277, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063973, -1.05830052442584, 0.30550504633039, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002066, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845308, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives];
      for (unsigned int r = 0; r < 2*num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using covariant Piola transform to map values back to the physical element
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives + r];
        derivatives[r] = (K_00*tmp_ref0 + K_10*tmp_ref1);
        derivatives[num_derivatives + r] = (K_01*tmp_ref0 + K_11*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
          values[num_derivatives + r] += transform[r][s]*derivatives[num_derivatives + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];switch (i)
    {
    case 0:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      result = (J_01*vals[0] + J_11*vals[1]);
      return result;
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      result = (J_00*vals[0] + J_10*vals[1]);
      return result;
        break;
      }
    case 9:
      {
        result = 0.0;
      double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_9[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
        const double w1 = X_9[r][0];
        const double w2 = X_9[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_9[0] = J_00*vals[0] + J_10*vals[1];
        copy_9[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_9[D_9[r][s]]*W_9[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 10:
      {
        result = 0.0;
      double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_10[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
        const double w1 = X_10[r][0];
        const double w2 = X_10[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_10[0] = J_00*vals[0] + J_10*vals[1];
        copy_10[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_10[D_10[r][s]]*W_10[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 11:
      {
        result = 0.0;
      double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
      double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_11[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
        const double w1 = X_11[r][0];
        const double w2 = X_11[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_11[0] = J_00*vals[0] + J_10*vals[1];
        copy_11[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_11[D_11[r][s]]*W_11[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 12:
      {
        result = 0.0;
      double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
      double copy_12[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
        const double w1 = X_12[r][0];
        const double w2 = X_12[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_12[0] = J_00*vals[0] + J_10*vals[1];
        copy_12[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_12[D_12[r][s]]*W_12[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 13:
      {
        result = 0.0;
      double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
      double copy_13[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
        const double w1 = X_13[r][0];
        const double w2 = X_13[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_13[0] = J_00*vals[0] + J_10*vals[1];
        copy_13[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_13[D_13[r][s]]*W_13[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    case 14:
      {
        result = 0.0;
      double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
      int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
      double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
      double copy_14[2];
      // Loop over points.
      for (unsigned int r = 0; r < 36; r++)
      {
        // Evaluate basis functions for affine mapping
        const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
        const double w1 = X_14[r][0];
        const double w2 = X_14[r][1];
        
        // Compute affine mapping y = F(X)
        y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
        y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
        // Evaluate function at physical point.
        f.evaluate(vals, y, c);
        // Map function to reference element.
        copy_14[0] = J_00*vals[0] + J_10*vals[1];
        copy_14[1] = J_01*vals[0] + J_11*vals[1];
        // Loop over directions.
        for (unsigned int s = 0; s < 1; s++)
        {
          result += copy_14[D_14[r][s]]*W_14[r][s];
        }// end loop over 's'
      }// end loop over 'r'
      return result;
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    double result;
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[0] = result;
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[1] = result;
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    result = (-1.0)*(J_00*vals[0] + J_10*vals[1]) + (J_01*vals[0] + J_11*vals[1]);
    values[2] = result;
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[3] = result;
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[4] = result;
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    result = (J_01*vals[0] + J_11*vals[1]);
    values[5] = result;
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[6] = result;
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[7] = result;
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    result = (J_00*vals[0] + J_10*vals[1]);
    values[8] = result;
    result = 0.0;
    double X_9[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_9[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_9[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_9[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_9[r][0] - X_9[r][1];
      const double w1 = X_9[r][0];
      const double w2 = X_9[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_9[0] = J_00*vals[0] + J_10*vals[1];
      copy_9[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_9[D_9[r][s]]*W_9[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[9] = result;
    result = 0.0;
    double X_10[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_10[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_10[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_10[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_10[r][0] - X_10[r][1];
      const double w1 = X_10[r][0];
      const double w2 = X_10[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_10[0] = J_00*vals[0] + J_10*vals[1];
      copy_10[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_10[D_10[r][s]]*W_10[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[10] = result;
    result = 0.0;
    double X_11[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_11[36][1] = {{0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}, {0}};
    double W_11[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_11[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_11[r][0] - X_11[r][1];
      const double w1 = X_11[r][0];
      const double w2 = X_11[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_11[0] = J_00*vals[0] + J_10*vals[1];
      copy_11[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_11[D_11[r][s]]*W_11[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[11] = result;
    result = 0.0;
    double X_12[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_12[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_12[36][1] = {{0.00821012828325}, {0.00821012828325}, {0.0119624829871}, {0.0056064144375}, {0.00144559962225}, {0.0125840795694}, {0.0179578758575}, {0.0172882391377}, {0.000529299521057}, {0.00111455709092}, {0.0172882391377}, {0.00266246789938}, {0.00852813657368}, {0.00922307258049}, {0.0163217665744}, {0.00727161547759}, {0.00266246789938}, {0.000529299521057}, {0.00111455709092}, {0.0056064144375}, {0.00438000703533}, {0.00727161547759}, {0.0179578758575}, {0.00597613827346}, {0.0163217665744}, {0.023291672331}, {0.0119624829871}, {0.0224231420448}, {0.023291672331}, {0.00922307258049}, {0.0125840795694}, {0.00438000703533}, {0.0224231420448}, {0.00597613827346}, {0.00144559962225}, {0.00852813657368}};
    double copy_12[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_12[r][0] - X_12[r][1];
      const double w1 = X_12[r][0];
      const double w2 = X_12[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_12[0] = J_00*vals[0] + J_10*vals[1];
      copy_12[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_12[D_12[r][s]]*W_12[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[12] = result;
    result = 0.0;
    double X_13[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_13[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_13[36][1] = {{0.0159756941744}, {-0.0159756941744}, {-0.00678703358623}, {-0.00209542400951}, {-6.17269708946e-05}, {0.0089949353583}, {0.0192838239128}, {-0.0238542037517}, {-8.83197279225e-05}, {0.000131875132445}, {0.0238542037517}, {-0.00140335236045}, {0.0129148084988}, {0.014499997977}, {0.00421027151037}, {-0.000980807938907}, {0.00140335236045}, {8.83197279225e-05}, {-0.000131875132445}, {0.00209542400951}, {-0.00971097319454}, {0.000980807938907}, {-0.0192838239128}, {-0.00602410954055}, {-0.00421027151037}, {-0.00902620543637}, {0.00678703358623}, {0.0111654692844}, {0.00902620543637}, {-0.014499997977}, {-0.0089949353583}, {0.00971097319454}, {-0.0111654692844}, {0.00602410954055}, {6.17269708946e-05}, {-0.0129148084988}};
    double copy_13[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_13[r][0] - X_13[r][1];
      const double w1 = X_13[r][0];
      const double w2 = X_13[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_13[0] = J_00*vals[0] + J_10*vals[1];
      copy_13[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_13[D_13[r][s]]*W_13[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[13] = result;
    result = 0.0;
    double X_14[36][2] = {{0.823156067319, 0.148078599668}, {0.0287653330126, 0.148078599668}, {0.369529924372, 0.0293164271598}, {0.0390907007328, 0.76923386203}, {0.0278110821154, 0.92694567132}, {0.366569507766, 0.558671518772}, {0.550703627938, 0.336984690281}, {0.14431148695, 0.148078599668}, {0.00246669715267, 0.92694567132}, {0.0606792682628, 0.92694567132}, {0.707609913381, 0.148078599668}, {0.00779187470129, 0.76923386203}, {0.640628436741, 0.336984690281}, {0.806254331245, 0.0293164271598}, {0.273318962107, 0.558671518772}, {0.087850454976, 0.76923386203}, {0.222974263269, 0.76923386203}, {0.0705876315276, 0.92694567132}, {0.0123750604174, 0.92694567132}, {0.191675437237, 0.76923386203}, {0.0327753666145, 0.0293164271598}, {0.142915682994, 0.76923386203}, {0.112311681781, 0.336984690281}, {0.0149015633667, 0.558671518772}, {0.168009519121, 0.558671518772}, {0.252403568077, 0.336984690281}, {0.601153648468, 0.0293164271598}, {0.527603095743, 0.148078599668}, {0.410611741642, 0.336984690281}, {0.164429241595, 0.0293164271598}, {0.0747589734626, 0.558671518772}, {0.937908206226, 0.0293164271598}, {0.324318304589, 0.148078599668}, {0.426426917862, 0.558671518772}, {0.0452432465649, 0.92694567132}, {0.022386872978, 0.336984690281}};
    int D_14[36][1] = {{1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}, {1}};
    double W_14[36][1] = {{-0.00645290853773}, {-0.00645290853773}, {-0.015429623211}, {0.010368330848}, {0.00364071931307}, {0.0120307444266}, {0.000278192558146}, {-0.0135880247038}, {0.00133303229957}, {0.00280699404177}, {-0.0135880247038}, {0.00492388644484}, {0.000132112736967}, {-0.0118962371707}, {0.0156040814239}, {0.0134479025608}, {0.00492388644484}, {0.00133303229957}, {0.00280699404177}, {0.010368330848}, {-0.0056494841656}, {0.0134479025608}, {0.000278192558146}, {0.00571336122195}, {0.0156040814239}, {0.0003608205091}, {-0.015429623211}, {-0.0176239005959}, {0.0003608205091}, {-0.0118962371707}, {0.0120307444266}, {-0.0056494841656}, {-0.0176239005959}, {0.00571336122195}, {0.00364071931307}, {0.000132112736967}};
    double copy_14[2];
    // Loop over points.
    for (unsigned int r = 0; r < 36; r++)
    {
      // Evaluate basis functions for affine mapping
      const double w0 = 1.0 - X_14[r][0] - X_14[r][1];
      const double w1 = X_14[r][0];
      const double w2 = X_14[r][1];
      
      // Compute affine mapping y = F(X)
      y[0] = w0*x[0][0] + w1*x[1][0] + w2*x[2][0];
      y[1] = w0*x[0][1] + w1*x[1][1] + w2*x[2][1];
      // Evaluate function at physical point.
      f.evaluate(vals, y, c);
      // Map function to reference element.
      copy_14[0] = J_00*vals[0] + J_10*vals[1];
      copy_14[1] = J_01*vals[0] + J_11*vals[1];
      // Loop over directions.
      for (unsigned int s = 0; s < 1; s++)
      {
        result += copy_14[D_14[r][s]]*W_14[r][s];
      }// end loop over 's'
    }// end loop over 'r'
    values[14] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    // Evaluate function and change variables
    vertex_values[0] = dof_values[3]*K_10*3.0 + dof_values[4]*(K_10*(-3.0)) + dof_values[5]*K_10 + dof_values[6]*K_00*3.0 + dof_values[7]*(K_00*(-3.0)) + dof_values[8]*K_00;
    vertex_values[2] = dof_values[0]*K_10*3.0 + dof_values[1]*(K_10*(-3.0)) + dof_values[2]*K_10 + dof_values[6]*(K_00 + K_10) + dof_values[7]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[8]*(K_00*3.0 + K_10*3.0) + dof_values[9]*(K_10*(-1.78745906965e-14)) + dof_values[10]*(K_10*(-1.58761892521e-14)) + dof_values[11]*(K_10*(3.13082892944e-14)) + dof_values[12]*(K_10*(1.3433698598e-14)) + dof_values[14]*(K_10*(1.86517468137e-14));
    vertex_values[4] = dof_values[0]*(K_00*(-1.0)) + dof_values[1]*K_00*3.0 + dof_values[2]*(K_00*(-3.0)) + dof_values[3]*(K_00 + K_10) + dof_values[4]*(K_00*(-3.0) + K_10*(-3.0)) + dof_values[5]*(K_00*3.0 + K_10*3.0) + dof_values[9]*(K_00*(-1.50990331349e-14)) + dof_values[10]*(K_00*(-1.4638040558e-14)) + dof_values[11]*(K_00*(2.48689957516e-14)) + dof_values[14]*(K_00*(1.03995536426e-14));
    vertex_values[1] = dof_values[3]*K_11*3.0 + dof_values[4]*(K_11*(-3.0)) + dof_values[5]*K_11 + dof_values[6]*K_01*3.0 + dof_values[7]*(K_01*(-3.0)) + dof_values[8]*K_01;
    vertex_values[3] = dof_values[0]*K_11*3.0 + dof_values[1]*(K_11*(-3.0)) + dof_values[2]*K_11 + dof_values[6]*(K_01 + K_11) + dof_values[7]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[8]*(K_01*3.0 + K_11*3.0) + dof_values[9]*(K_11*(-1.78745906965e-14)) + dof_values[10]*(K_11*(-1.58761892521e-14)) + dof_values[11]*(K_11*(3.13082892944e-14)) + dof_values[12]*(K_11*(1.3433698598e-14)) + dof_values[14]*(K_11*(1.86517468137e-14));
    vertex_values[5] = dof_values[0]*(K_01*(-1.0)) + dof_values[1]*K_01*3.0 + dof_values[2]*(K_01*(-3.0)) + dof_values[3]*(K_01 + K_11) + dof_values[4]*(K_01*(-3.0) + K_11*(-3.0)) + dof_values[5]*(K_01*3.0 + K_11*3.0) + dof_values[9]*(K_01*(-1.50990331349e-14)) + dof_values[10]*(K_01*(-1.4638040558e-14)) + dof_values[11]*(K_01*(2.48689957516e-14)) + dof_values[14]*(K_01*(1.03995536426e-14));
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new forms_finite_element_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class forms_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  forms_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~forms_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3*m.num_entities[1] + 6*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 15;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 15;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 3;
        break;
      }
    case 2:
      {
        return 6;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + 3*c.entity_indices[1][0];
    dofs[1] = offset + 3*c.entity_indices[1][0] + 1;
    dofs[2] = offset + 3*c.entity_indices[1][0] + 2;
    dofs[3] = offset + 3*c.entity_indices[1][1];
    dofs[4] = offset + 3*c.entity_indices[1][1] + 1;
    dofs[5] = offset + 3*c.entity_indices[1][1] + 2;
    dofs[6] = offset + 3*c.entity_indices[1][2];
    dofs[7] = offset + 3*c.entity_indices[1][2] + 1;
    dofs[8] = offset + 3*c.entity_indices[1][2] + 2;
    offset += 3*m.num_entities[1];
    dofs[9] = offset + 6*c.entity_indices[2][0];
    dofs[10] = offset + 6*c.entity_indices[2][0] + 1;
    dofs[11] = offset + 6*c.entity_indices[2][0] + 2;
    dofs[12] = offset + 6*c.entity_indices[2][0] + 3;
    dofs[13] = offset + 6*c.entity_indices[2][0] + 4;
    dofs[14] = offset + 6*c.entity_indices[2][0] + 5;
    offset += 6*m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 3;
      dofs[1] = 4;
      dofs[2] = 5;
        break;
      }
    case 2:
      {
        dofs[0] = 6;
      dofs[1] = 7;
      dofs[2] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 1;
        dofs[2] = 2;
          break;
        }
      case 1:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 5;
          break;
        }
      case 2:
        {
          dofs[0] = 6;
        dofs[1] = 7;
        dofs[2] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
      dofs[1] = 10;
      dofs[2] = 11;
      dofs[3] = 12;
      dofs[4] = 13;
      dofs[5] = 14;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    throw std::runtime_error("tabulate_coordinates is not defined for this element");
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new forms_dofmap_0();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius, assuming triangle is embedded in 2D.
    
    
    // Facet Area.
    
    // Array of quadrature weights.
    static const double W6[6] = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    // Quadrature points on the UFC reference element: (0.816847572980459, 0.091576213509771), (0.091576213509771, 0.816847572980459), (0.091576213509771, 0.091576213509771), (0.10810301816807, 0.445948490915965), (0.445948490915965, 0.10810301816807), (0.445948490915965, 0.445948490915965)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0_D01[6][15] = \
    {{-2.84278477949182, 2.60133169408132, -0.632753871377706, 1.85982644165772, -0.63541501841312, 1.6157122092118, 2.32942687730164, -3.32302980327736, -5.80496552817116, 16.7566247559306, 28.2503375501112, -10.3125950058212, -5.5604520504506, 17.1175226659555, -9.82958337834064},
    {-1.79074768975489, 5.75744296329206, -10.10108767901, 4.75292843843425, -11.6818044606508, 7.13890693033063, -0.0216896923939891, 0.10407417947384, -0.26580392483987, -16.8318933605096, 0.917612187043456, -25.9334825297501, 16.7566247559308, 3.45115998442155, 29.6218074867926},
    {-0.730727158911739, 0.369744598943469, -1.15078897513993, 1.38159747240879, -1.67148522593757, 0.499918661642881, -11.562274986093, 6.6872894314358, -1.9235828994897, 14.953319808833, -30.970567403202, -19.4780023354878, 3.68187849877411, 6.76404271269083, 6.50870313497029},
    {0.565452740291991, -0.671420571424328, 2.08901867938574, -1.60411004260619, 2.74873517605272, -1.05036137707154, 1.90640810299341, -0.306199418639674, 0.74806331668432, -1.03300141506715, 15.1714233065578, 29.9298875179392, -5.87553297436215, -4.86317762376486, -10.3865730231416},
    {0.793731867204491, 0.0134168093131581, 0.0345065371732645, -0.97634244359682, 0.351804343471501, 0.148104039219066, -2.56551891256161, -1.543441746175, -2.01177024702697, 19.6926017532207, 9.2405576147594, -13.0772891857657, -1.03300141506717, -7.82861046966409, -1.82610576392324},
    {-0.957138495883963, -2.14608846111386, -0.00427037407146003, 2.74910419187173, -1.43784293086167, -1.78769532191631, 3.34906346933698, -2.09584669297285, 1.09505522467392, -15.4312459652903, 2.32121430766123, 18.0366977074505, 10.1368887622926, 18.6226537852274, 17.9196569598771}};
    
    static const double FE0_C1_D10[6][15] = \
    {{10.10108767901, -5.75744296329211, 1.7907476897549, -0.021689692393994, 0.104074179473847, -0.265803924839894, 4.75292843843425, -11.6818044606508, 7.13890693033066, 16.7566247559307, 27.3788177817851, -11.8221115243628, -16.8318933605095, -22.0002485858418, 13.761416729677},
    {0.632753871377709, -2.60133169408132, 2.84278477949182, 2.32942687730164, -3.32302980327736, -5.80496552817115, 1.85982644165772, -0.635415018413122, 1.61571220921181, -5.5604520504506, 0.0460924187174623, 19.7390011677437, 16.7566247559306, 5.1941995210739, 29.6218074867924},
    {1.15078897513993, -0.369744598943472, 0.730727158911738, -11.562274986093, 6.68728943143579, -1.9235828994897, 1.38159747240879, -1.67148522593757, 0.49991866164288, 3.6818784987741, 9.01872361692109, 2.60348125398813, 14.9533198088331, -32.353728539106, -17.0822969730473},
    {-0.0345065371732635, -0.0134168093131608, -0.793731867204489, -2.5655189125616, -1.54344174617501, -2.01177024702696, -0.97634244359682, 0.351804343471501, 0.148104039219067, -1.03300141506717, -5.49575921638676, -5.86672266110031, 19.6926017532208, -6.7049858401289, 14.5412022323982},
    {-2.08901867938574, 0.671420571424338, -0.565452740291994, 1.90640810299341, -0.306199418639675, 0.748063316684322, -1.60411004260619, 2.74873517605272, -1.05036137707155, -5.87553297436213, -11.4266249081852, 0.98165114627436, -1.03300141506717, 33.505754576225, -1.82610576392324},
    {0.00427037407145568, 2.14608846111387, 0.957138495883959, 3.34906346933698, -2.09584669297285, 1.09505522467392, 2.74910419187173, -1.43784293086167, -1.78769532191632, 10.1368887622926, 24.8302050469698, 7.16786278395081, -15.4312459652903, 16.7808455688633, -7.00811829566276}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 225; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 22.
    double G[2];
    G[0] = det*(K_00*K_00*K_11*K_11 + K_01*K_10*(K_01*K_10-2.0*K_00*K_11));
    G[1] = det*(K_01*K_10*(2.0*K_00*K_11 - K_01*K_10) - K_00*K_00*K_11*K_11);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 16212
    for (unsigned int ip = 0; ip < 6; ip++)
    {
      
      // Number of operations to compute ip constants: 2
      double I[2];
      // Number of operations: 1
      I[0] = G[0]*W6[ip];
      
      // Number of operations: 1
      I[1] = G[1]*W6[ip];
      
      
      // Number of operations for primary indices: 2700
      for (unsigned int j = 0; j < 15; j++)
      {
        for (unsigned int k = 0; k < 15; k++)
        {
          // Number of operations to compute entry: 12
          A[j*15 + k] += (FE0_C0_D01[ip][j]*FE0_C0_D01[ip][k]*I[0] + FE0_C0_D01[ip][j]*FE0_C1_D10[ip][k]*I[1] + FE0_C0_D01[ip][k]*FE0_C1_D10[ip][j]*I[1] + FE0_C1_D10[ip][j]*FE0_C1_D10[ip][k]*I[0]);
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0).");
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class forms_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  forms_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 777
    // Total number of operations (multiply-add pairs):                  796
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.0216269841269843*G0_0_0 - 0.0111607142857144*G0_0_1 - 0.0111607142857143*G0_1_0 + 0.0573412698412703*G0_1_1;
    A[1] = -0.0298611111111112*G0_0_0 + 0.0059523809523809*G0_0_1 + 0.009920634920635*G0_1_0 - 0.0487103174603178*G0_1_1;
    A[2] = 0.0176587301587301*G0_0_0 - 0.00471230158730155*G0_0_1 - 0.00471230158730161*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[3] = -0.0154265873015874*G0_0_0 - 0.0244791666666668*G0_0_1 + 0.00905257936507941*G0_1_0 + 0.0186011904761906*G0_1_1;
    A[4] = 0.0174603174603174*G0_0_0 + 0.0216765873015871*G0_0_1 - 0.0057043650793651*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[5] = -0.023859126984127*G0_0_0 - 0.0326636904761905*G0_0_1 + 0.00682043650793656*G0_1_0 + 0.0111607142857142*G0_1_1;
    A[6] = -0.0131448412698413*G0_0_0 - 0.00880456349206354*G0_0_1 + 0.0306795634920637*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[7] = 0.027777777777778*G0_0_0 + 0.0141369047619049*G0_0_1 - 0.0727678571428577*G0_1_0 - 0.0611111111111116*G0_1_1;
    A[8] = -0.0205853174603176*G0_0_0 - 0.00706845238095236*G0_0_1 + 0.0582093253968257*G0_1_0 + 0.0511408730158734*G0_1_1;
    A[9] = 0.0434926790015494*G0_0_0 - 0.0231493291459878*G0_0_1 - 0.0624330392119042*G0_1_0 + 0.0350747411302843*G0_1_1;
    A[10] = 0.06529556615835*G0_0_0 - 0.051549131177644*G0_0_1 - 0.127154523571519*G0_1_0 + 0.0652955661583487*G0_1_1;
    A[11] = -0.0168650793650808*G0_0_0 - 0.00744047619047553*G0_0_1 + 0.0719246031746002*G0_1_0 - 0.0109126984126988*G0_1_1;
    A[12] = 0.0350747411302844*G0_0_0 + 0.128373552536838*G0_0_1 - 0.0119254119842966*G0_1_0 - 0.124866078423811*G0_1_1;
    A[13] = -0.100520805796406*G0_0_0 - 0.0631476856926133*G0_0_1 + 0.0708800553692599*G0_1_0 - 0.0850560664431109*G0_1_1;
    A[14] = 0.062003968253967*G0_0_0 + 0.0959821428571384*G0_0_1 - 0.0210813492063487*G0_1_0 + 0.0530753968253966*G0_1_1;
    A[15] = -0.0298611111111112*G0_0_0 + 0.009920634920635*G0_0_1 + 0.0059523809523809*G0_1_0 - 0.0487103174603178*G0_1_1;
    A[16] = 0.0686507936507939*G0_0_0 - 0.0128968253968255*G0_0_1 - 0.0128968253968255*G0_1_0 + 0.0686507936507944*G0_1_1;
    A[17] = -0.0487103174603175*G0_0_0 + 0.00595238095238089*G0_0_1 + 0.00992063492063499*G0_1_0 - 0.0298611111111114*G0_1_1;
    A[18] = 0.0174603174603174*G0_0_0 + 0.0231646825396825*G0_0_1 - 0.00421626984126978*G0_1_0 - 0.0104166666666666*G0_1_1;
    A[19] = -0.0438492063492063*G0_0_0 - 0.0532738095238096*G0_0_1 + 0.00942460317460321*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[20] = 0.0611111111111113*G0_0_0 + 0.0752480158730162*G0_0_1 - 0.0116567460317461*G0_1_0 - 0.0252976190476191*G0_1_1;
    A[21] = 0.0104166666666666*G0_0_0 + 0.00421626984126976*G0_0_1 - 0.0231646825396826*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[22] = -0.0178571428571429*G0_0_0 - 0.00942460317460321*G0_0_1 + 0.0532738095238098*G0_1_0 + 0.0438492063492066*G0_1_1;
    A[23] = 0.0252976190476193*G0_0_0 + 0.0116567460317461*G0_0_1 - 0.0752480158730165*G0_1_0 - 0.0611111111111117*G0_1_1;
    A[24] = -0.0785674201318344*G0_0_0 - 0.00982092751647962*G0_0_1 + 0.136089995585501*G0_1_0 + 0.0701494822605691*G0_1_1;
    A[25] = -0.0532674355502332*G0_0_0 - 0.0085915218629412*G0_0_1 + 0.183858567866929*G0_1_0 + 0.0841969142568196*G0_1_1;
    A[26] = -0.0049603174603141*G0_0_0 + 0.0198412698412685*G0_0_1 - 0.162698412698407*G0_1_0 - 0.102182539682538*G0_1_1;
    A[27] = -0.0701494822605688*G0_0_0 - 0.136089995585501*G0_0_1 + 0.00982092751647956*G0_1_0 + 0.0785674201318344*G0_1_1;
    A[28] = 0.0463942180598788*G0_0_0 + 0.0489716746187602*G0_0_1 - 0.01288728279441*G0_1_0 + 0.030929478706585*G0_1_1;
    A[29] = -0.124007936507934*G0_0_0 - 0.240575396825388*G0_0_1 + 0.0173611111111107*G0_1_0 + 0.0436507936507938*G0_1_1;
    A[30] = 0.0176587301587301*G0_0_0 - 0.00471230158730161*G0_0_1 - 0.00471230158730155*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[31] = -0.0487103174603175*G0_0_0 + 0.00992063492063499*G0_0_1 + 0.00595238095238089*G0_1_0 - 0.0298611111111114*G0_1_1;
    A[32] = 0.0573412698412701*G0_0_0 - 0.0111607142857143*G0_0_1 - 0.0111607142857143*G0_1_0 + 0.0216269841269844*G0_1_1;
    A[33] = -0.023859126984127*G0_0_0 - 0.0306795634920636*G0_0_1 + 0.00880456349206354*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[34] = 0.0611111111111114*G0_0_0 + 0.0727678571428576*G0_0_1 - 0.0141369047619049*G0_1_0 - 0.027777777777778*G0_1_1;
    A[35] = -0.0511408730158731*G0_0_0 - 0.0582093253968256*G0_0_1 + 0.00706845238095235*G0_1_0 + 0.0205853174603175*G0_1_1;
    A[36] = -0.0186011904761907*G0_0_0 - 0.0090525793650794*G0_0_1 + 0.0244791666666669*G0_1_0 + 0.0154265873015875*G0_1_1;
    A[37] = 0.011904761904762*G0_0_0 + 0.0057043650793651*G0_0_1 - 0.0216765873015873*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[38] = -0.0111607142857144*G0_0_0 - 0.00682043650793657*G0_0_1 + 0.0326636904761907*G0_1_0 + 0.0238591269841272*G0_1_1;
    A[39] = 0.124866078423811*G0_0_0 + 0.0119254119842966*G0_0_1 - 0.128373552536838*G0_1_0 - 0.0350747411302845*G0_1_1;
    A[40] = -0.00343660874517742*G0_0_0 - 0.0171830437258811*G0_0_1 - 0.0515491311776427*G0_1_0 - 0.00343660874517651*G0_1_1;
    A[41] = 0.100198412698408*G0_0_0 - 0.0719246031746011*G0_0_1 + 0.102678571428568*G0_1_0 + 0.118055555555554*G0_1_1;
    A[42] = -0.0350747411302847*G0_0_0 + 0.0624330392119044*G0_0_1 + 0.0231493291459879*G0_1_0 - 0.0434926790015496*G0_1_1;
    A[43] = -0.0231971090299389*G0_0_0 + 0.00128872827944093*G0_0_1 + 0.0322182069860271*G0_1_0 - 0.0180421959121745*G0_1_1;
    A[44] = -0.0620039682539674*G0_0_0 + 0.146081349206342*G0_0_1 + 0.0409226190476185*G0_1_0 - 0.0649801587301584*G0_1_1;
    A[45] = -0.0154265873015874*G0_0_0 + 0.00905257936507941*G0_0_1 - 0.0244791666666668*G0_1_0 + 0.0186011904761906*G0_1_1;
    A[46] = 0.0174603174603174*G0_0_0 - 0.00421626984126978*G0_0_1 + 0.0231646825396825*G0_1_0 - 0.0104166666666666*G0_1_1;
    A[47] = -0.023859126984127*G0_0_0 + 0.00880456349206354*G0_0_1 - 0.0306795634920636*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[48] = 0.0216269841269843*G0_0_0 + 0.0327876984126987*G0_0_1 + 0.0327876984126987*G0_1_0 + 0.101289682539683*G0_1_1;
    A[49] = -0.0298611111111113*G0_0_0 - 0.0358134920634922*G0_0_1 - 0.0397817460317463*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[50] = 0.0176587301587301*G0_0_0 + 0.0223710317460317*G0_0_1 + 0.0223710317460317*G0_1_0 + 0.0447420634920634*G0_1_1;
    A[51] = 0.0205853174603176*G0_0_0 + 0.0135168650793652*G0_0_1 + 0.0787946428571432*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[52] = -0.027777777777778*G0_0_0 - 0.0136408730158731*G0_0_1 - 0.100545634920636*G0_1_0 - 0.0252976190476193*G0_1_1;
    A[53] = 0.0131448412698413*G0_0_0 + 0.00434027777777773*G0_0_1 + 0.0438244047619049*G0_1_0 + 0.0111607142857143*G0_1_1;
    A[54] = -0.0785674201318341*G0_0_0 + 0.0266568032590162*G0_0_1 - 0.152925871328036*G0_1_0 + 0.0420896893563414*G0_1_1;
    A[55] = -0.0352252396380563*G0_0_0 + 0.0794715772322013*G0_0_1 + 0.021049228564203*G0_1_0 + 0.115985545149699*G0_1_1;
    A[56] = -0.0451388888888866*G0_0_0 + 0.0434027777777766*G0_0_1 + 0.00570436507936432*G0_1_0 + 0.0520833333333311*G0_1_1;
    A[57] = 0.0350747411302846*G0_0_0 - 0.0932988114065537*G0_0_1 + 0.0470001531145814*G0_1_0 - 0.206239477846068*G0_1_1;
    A[58] = 0.100520805796406*G0_0_0 + 0.0373731201037924*G0_0_1 + 0.171400861165666*G0_1_0 + 0.193309241916163*G0_1_1;
    A[59] = 0.0620039682539672*G0_0_0 - 0.0339781746031716*G0_0_1 + 0.0830853174603164*G0_1_0 + 0.0401785714285732*G0_1_1;
    A[60] = 0.0174603174603174*G0_0_0 - 0.0057043650793651*G0_0_1 + 0.0216765873015871*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[61] = -0.0438492063492063*G0_0_0 + 0.00942460317460321*G0_0_1 - 0.0532738095238096*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[62] = 0.0611111111111114*G0_0_0 - 0.0141369047619049*G0_0_1 + 0.0727678571428576*G0_1_0 - 0.027777777777778*G0_1_1;
    A[63] = -0.0298611111111113*G0_0_0 - 0.0397817460317463*G0_0_1 - 0.0358134920634922*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[64] = 0.0686507936507941*G0_0_0 + 0.0815476190476197*G0_0_1 + 0.0815476190476197*G0_1_0 + 0.163095238095239*G0_1_1;
    A[65] = -0.0487103174603175*G0_0_0 - 0.0546626984126985*G0_0_1 - 0.0586309523809526*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[66] = -0.0252976190476193*G0_0_0 - 0.0136408730158731*G0_0_1 - 0.100545634920636*G0_1_0 - 0.027777777777778*G0_1_1;
    A[67] = 0.017857142857143*G0_0_0 + 0.00843253968253973*G0_0_1 + 0.0711309523809527*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[68] = -0.0104166666666667*G0_0_0 - 0.00620039682539685*G0_0_1 - 0.0335813492063491*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[69] = 0.148716902392404*G0_0_0 + 0.00280597929042267*G0_0_1 + 0.294627825494385*G0_1_0;
    A[70] = -0.00687321749035419*G0_0_0 - 0.0472533702461735*G0_0_1 - 0.177844502562873*G0_1_0 - 0.103098262355288*G0_1_1;
    A[71] = 0.128968253968249*G0_0_0 - 0.0917658730158706*G0_0_1 - 0.0163690476190462*G0_1_0 - 0.178571428571424*G0_1_1;
    A[72] = -0.0701494822605692*G0_0_0 + 0.0659405133249322*G0_0_1 - 0.0799704097770489*G0_1_0 + 0.134687005940288*G0_1_1;
    A[73] = -0.0463942180598789*G0_0_0 + 0.00257745655888144*G0_0_1 - 0.0592815008542887*G0_1_0 - 0.0412393049421136*G0_1_1;
    A[74] = -0.124007936507935*G0_0_0 + 0.116567460317454*G0_0_1 - 0.141369047619045*G0_1_0 + 0.142857142857138*G0_1_1;
    A[75] = -0.023859126984127*G0_0_0 + 0.00682043650793656*G0_0_1 - 0.0326636904761905*G0_1_0 + 0.0111607142857142*G0_1_1;
    A[76] = 0.0611111111111113*G0_0_0 - 0.0116567460317461*G0_0_1 + 0.0752480158730162*G0_1_0 - 0.0252976190476191*G0_1_1;
    A[77] = -0.0511408730158731*G0_0_0 + 0.00706845238095236*G0_0_1 - 0.0582093253968256*G0_1_0 + 0.0205853174603175*G0_1_1;
    A[78] = 0.0176587301587301*G0_0_0 + 0.0223710317460317*G0_0_1 + 0.0223710317460317*G0_1_0 + 0.0447420634920634*G0_1_1;
    A[79] = -0.0487103174603176*G0_0_0 - 0.0586309523809526*G0_0_1 - 0.0546626984126986*G0_1_0 - 0.0944444444444449*G0_1_1;
    A[80] = 0.05734126984127*G0_0_0 + 0.0685019841269845*G0_0_1 + 0.0685019841269845*G0_1_0 + 0.101289682539683*G0_1_1;
    A[81] = 0.0111607142857143*G0_0_0 + 0.00434027777777772*G0_0_1 + 0.0438244047619049*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[82] = -0.0119047619047619*G0_0_0 - 0.00620039682539684*G0_0_1 - 0.033581349206349*G0_1_0 - 0.0104166666666665*G0_1_1;
    A[83] = 0.0186011904761906*G0_0_0 + 0.00954861111111121*G0_0_1 + 0.0430803571428573*G0_1_0 + 0.0186011904761905*G0_1_1;
    A[84] = -0.089791337293526*G0_0_0 - 0.0154328860973251*G0_0_1 - 0.195015560684377*G0_1_0 - 0.0420896893563413*G0_1_1;
    A[85] = -0.0266337177751163*G0_0_0 - 0.0107394023286763*G0_0_1 - 0.00730279358350019*G0_1_0 - 0.0128872827944116*G0_1_1;
    A[86] = -0.0381944444444409*G0_0_0 + 0.0359623015873001*G0_0_1 + 0.105406746031745*G0_1_0 + 0.126488095238092*G0_1_1;
    A[87] = -0.0350747411302843*G0_0_0 - 0.0975077803421883*G0_0_1 - 0.058224070276272*G0_1_0 - 0.164149788489726*G0_1_1;
    A[88] = 0.0231971090299389*G0_0_0 + 0.0244858373093798*G0_0_1 + 0.0554153160159659*G0_1_0 + 0.0747462402075815*G0_1_1;
    A[89] = -0.0620039682539668*G0_0_0 - 0.208085317460309*G0_0_1 - 0.102926587301585*G0_1_0 - 0.313988095238087*G0_1_1;
    A[90] = -0.0131448412698413*G0_0_0 + 0.0306795634920637*G0_0_1 - 0.00880456349206354*G0_1_0 + 0.0238591269841271*G0_1_1;
    A[91] = 0.0104166666666666*G0_0_0 - 0.0231646825396826*G0_0_1 + 0.00421626984126976*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[92] = -0.0186011904761907*G0_0_0 + 0.0244791666666668*G0_0_1 - 0.0090525793650794*G0_1_0 + 0.0154265873015875*G0_1_1;
    A[93] = 0.0205853174603176*G0_0_0 + 0.0787946428571432*G0_0_1 + 0.0135168650793652*G0_1_0 + 0.0205853174603176*G0_1_1;
    A[94] = -0.0252976190476193*G0_0_0 - 0.100545634920636*G0_0_1 - 0.0136408730158731*G0_1_0 - 0.027777777777778*G0_1_1;
    A[95] = 0.0111607142857143*G0_0_0 + 0.0438244047619049*G0_0_1 + 0.00434027777777772*G0_1_0 + 0.0131448412698413*G0_1_1;
    A[96] = 0.101289682539683*G0_0_0 + 0.0327876984126987*G0_0_1 + 0.0327876984126987*G0_1_0 + 0.0216269841269844*G0_1_1;
    A[97] = -0.0944444444444449*G0_0_0 - 0.0397817460317463*G0_0_1 - 0.0358134920634922*G0_1_0 - 0.0298611111111113*G0_1_1;
    A[98] = 0.0447420634920635*G0_0_0 + 0.0223710317460318*G0_0_1 + 0.0223710317460318*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[99] = -0.206239477846068*G0_0_0 + 0.0470001531145811*G0_0_1 - 0.0932988114065537*G0_1_0 + 0.0350747411302843*G0_1_1;
    A[100] = 0.131450284502993*G0_0_0 + 0.157654426184961*G0_0_1 - 0.0107394023286737*G0_1_0 + 0.103957414541582*G0_1_1;
    A[101] = 0.147321428571422*G0_0_0 + 0.106894841269839*G0_0_1 + 0.0493551587301573*G0_1_0 + 0.0560515873015863*G0_1_1;
    A[102] = 0.0420896893563416*G0_0_0 - 0.152925871328036*G0_0_1 + 0.0266568032590163*G0_1_0 - 0.078567420131834*G0_1_1;
    A[103] = 0.103098262355287*G0_0_0 + 0.0154647393532918*G0_0_1 + 0.0773236967664658*G0_1_0 - 0.056704044295407*G0_1_1;
    A[104] = 0.074404761904761*G0_0_0 + 0.0153769841269827*G0_0_1 + 0.0471230158730152*G0_1_0 - 0.00793650793650759*G0_1_1;
    A[105] = 0.027777777777778*G0_0_0 - 0.0727678571428578*G0_0_1 + 0.0141369047619049*G0_1_0 - 0.0611111111111116*G0_1_1;
    A[106] = -0.0178571428571429*G0_0_0 + 0.0532738095238099*G0_0_1 - 0.00942460317460322*G0_1_0 + 0.0438492063492066*G0_1_1;
    A[107] = 0.011904761904762*G0_0_0 - 0.0216765873015873*G0_0_1 + 0.0057043650793651*G0_1_0 - 0.0174603174603175*G0_1_1;
    A[108] = -0.027777777777778*G0_0_0 - 0.100545634920636*G0_0_1 - 0.0136408730158731*G0_1_0 - 0.0252976190476193*G0_1_1;
    A[109] = 0.017857142857143*G0_0_0 + 0.0711309523809527*G0_0_1 + 0.00843253968253973*G0_1_0 + 0.0178571428571429*G0_1_1;
    A[110] = -0.0119047619047619*G0_0_0 - 0.033581349206349*G0_0_1 - 0.00620039682539684*G0_1_0 - 0.0104166666666665*G0_1_1;
    A[111] = -0.0944444444444449*G0_0_0 - 0.0358134920634922*G0_0_1 - 0.0397817460317463*G0_1_0 - 0.0298611111111113*G0_1_1;
    A[112] = 0.163095238095239*G0_0_0 + 0.0815476190476197*G0_0_1 + 0.0815476190476196*G0_1_0 + 0.0686507936507941*G0_1_1;
    A[113] = -0.0944444444444449*G0_0_0 - 0.0586309523809528*G0_0_1 - 0.0546626984126986*G0_1_0 - 0.0487103174603177*G0_1_1;
    A[114] = 0.134687005940288*G0_0_0 - 0.0799704097770482*G0_0_1 + 0.0659405133249322*G0_1_0 - 0.0701494822605686*G0_1_1;
    A[115] = 0.103098262355288*G0_0_0 - 0.152069936974049*G0_0_1 + 0.102239110168991*G0_1_0 - 0.130591132316698*G0_1_1;
    A[116] = -0.107142857142852*G0_0_0 + 0.019345238095239*G0_0_1 - 0.056051587301585*G0_1_0 + 0.0218253968253969*G0_1_1;
    A[117] = 0.294627825494385*G0_0_1 + 0.00280597929042265*G0_1_0 + 0.148716902392403*G0_1_1;
    A[118] = -0.206196524710575*G0_0_0 - 0.103098262355287*G0_0_1 - 0.103098262355287*G0_1_0 + 0.10825317547305*G0_1_1;
    A[119] = -0.145833333333332*G0_0_1 + 0.00496031746031724*G0_1_0 - 0.0704365079365076*G0_1_1;
    A[120] = -0.0205853174603176*G0_0_0 + 0.0582093253968257*G0_0_1 - 0.00706845238095236*G0_1_0 + 0.0511408730158734*G0_1_1;
    A[121] = 0.0252976190476193*G0_0_0 - 0.0752480158730165*G0_0_1 + 0.0116567460317461*G0_1_0 - 0.0611111111111117*G0_1_1;
    A[122] = -0.0111607142857144*G0_0_0 + 0.0326636904761907*G0_0_1 - 0.00682043650793657*G0_1_0 + 0.0238591269841272*G0_1_1;
    A[123] = 0.0131448412698413*G0_0_0 + 0.0438244047619049*G0_0_1 + 0.00434027777777773*G0_1_0 + 0.0111607142857143*G0_1_1;
    A[124] = -0.0104166666666667*G0_0_0 - 0.0335813492063491*G0_0_1 - 0.00620039682539685*G0_1_0 - 0.0119047619047619*G0_1_1;
    A[125] = 0.0186011904761907*G0_0_0 + 0.0430803571428573*G0_0_1 + 0.00954861111111121*G0_1_0 + 0.0186011904761905*G0_1_1;
    A[126] = 0.0447420634920635*G0_0_0 + 0.0223710317460318*G0_0_1 + 0.0223710317460318*G0_1_0 + 0.0176587301587302*G0_1_1;
    A[127] = -0.0944444444444449*G0_0_0 - 0.0546626984126986*G0_0_1 - 0.0586309523809528*G0_1_0 - 0.0487103174603177*G0_1_1;
    A[128] = 0.101289682539683*G0_0_0 + 0.0685019841269847*G0_0_1 + 0.0685019841269847*G0_1_0 + 0.0573412698412704*G0_1_1;
    A[129] = -0.164149788489726*G0_0_0 - 0.0582240702762726*G0_0_1 - 0.0975077803421887*G0_1_0 - 0.0350747411302848*G0_1_1;
    A[130] = -0.234548546858281*G0_0_0 - 0.0614293813200272*G0_0_1 - 0.167964252420489*G0_1_0 - 0.0420984571284103*G0_1_1;
    A[131] = 0.221726190476183*G0_0_0 + 0.0994543650793628*G0_0_1 + 0.125248015873011*G0_1_0 + 0.0510912698412686*G0_1_1;
    A[132] = -0.0420896893563413*G0_0_0 - 0.195015560684376*G0_0_1 - 0.0154328860973251*G0_1_0 - 0.0897913372935261*G0_1_1;
    A[133] = 0.103098262355287*G0_0_0 + 0.087633523001995*G0_0_1 + 0.0257745655888211*G0_1_0 - 0.0463942180598782*G0_1_1;
    A[134] = -0.0744047619047605*G0_0_0 - 0.0590277777777774*G0_0_1 - 0.0272817460317455*G0_1_0 - 0.00396825396825449*G0_1_1;
    A[135] = 0.0434926790015494*G0_0_0 - 0.0624330392119042*G0_0_1 - 0.0231493291459878*G0_1_0 + 0.0350747411302843*G0_1_1;
    A[136] = -0.0785674201318344*G0_0_0 + 0.136089995585501*G0_0_1 - 0.00982092751647962*G0_1_0 + 0.0701494822605691*G0_1_1;
    A[137] = 0.124866078423811*G0_0_0 - 0.128373552536838*G0_0_1 + 0.0119254119842966*G0_1_0 - 0.0350747411302845*G0_1_1;
    A[138] = -0.0785674201318341*G0_0_0 - 0.152925871328036*G0_0_1 + 0.0266568032590162*G0_1_0 + 0.0420896893563413*G0_1_1;
    A[139] = 0.148716902392404*G0_0_0 + 0.294627825494385*G0_0_1 + 0.00280597929042268*G0_1_0;
    A[140] = -0.089791337293526*G0_0_0 - 0.195015560684377*G0_0_1 - 0.0154328860973251*G0_1_0 - 0.0420896893563413*G0_1_1;
    A[141] = -0.206239477846068*G0_0_0 - 0.0932988114065537*G0_0_1 + 0.0470001531145811*G0_1_0 + 0.0350747411302843*G0_1_1;
    A[142] = 0.134687005940288*G0_0_0 + 0.0659405133249322*G0_0_1 - 0.0799704097770482*G0_1_0 - 0.0701494822605686*G0_1_1;
    A[143] = -0.164149788489726*G0_0_0 - 0.0975077803421887*G0_0_1 - 0.0582240702762726*G0_1_0 - 0.0350747411302848*G0_1_1;
    A[144] = 4.92063492063456*G0_0_0 + 0.198412698412687*G0_0_1 + 0.198412698412687*G0_1_0 + 0.396825396825375*G0_1_1;
    A[145] = 0.0243004934799669*G0_0_0 - 0.0607512336999676*G0_0_1 + 0.230854688059914*G0_1_0 + 0.607512336999764*G0_1_1;
    A[146] = -0.519106168728166*G0_0_0 - 0.806719045996497*G0_0_1 - 0.30164277372043*G0_1_0 - 0.350747411302833*G0_1_1;
    A[147] = -0.19841269841269*G0_0_0 + 4.30555555555523*G0_0_1 + 0.0198412698412689*G0_1_0 - 0.198412698412688*G0_1_1;
    A[148] = -0.218704441319893*G0_0_0 - 0.0364507402199852*G0_0_1 + 0.255155181539901*G0_1_0 - 0.218704441319912*G0_1_1;
    A[149] = -0.350747411302834*G0_0_0 + 0.54015101340635*G0_0_1 + 0.0350747411302835*G0_1_0 + 0.322687618398612*G0_1_1;
    A[150] = 0.06529556615835*G0_0_0 - 0.127154523571519*G0_0_1 - 0.051549131177644*G0_1_0 + 0.0652955661583487*G0_1_1;
    A[151] = -0.0532674355502332*G0_0_0 + 0.183858567866929*G0_0_1 - 0.00859152186294119*G0_1_0 + 0.0841969142568196*G0_1_1;
    A[152] = -0.00343660874517742*G0_0_0 - 0.0515491311776427*G0_0_1 - 0.0171830437258811*G0_1_0 - 0.00343660874517652*G0_1_1;
    A[153] = -0.0352252396380563*G0_0_0 + 0.021049228564203*G0_0_1 + 0.0794715772322013*G0_1_0 + 0.115985545149699*G0_1_1;
    A[154] = -0.00687321749035419*G0_0_0 - 0.177844502562873*G0_0_1 - 0.0472533702461735*G0_1_0 - 0.103098262355288*G0_1_1;
    A[155] = -0.0266337177751163*G0_0_0 - 0.00730279358350021*G0_0_1 - 0.0107394023286763*G0_1_0 - 0.0128872827944116*G0_1_1;
    A[156] = 0.131450284502993*G0_0_0 - 0.0107394023286737*G0_0_1 + 0.157654426184961*G0_1_0 + 0.103957414541582*G0_1_1;
    A[157] = 0.103098262355288*G0_0_0 + 0.102239110168991*G0_0_1 - 0.152069936974049*G0_1_0 - 0.130591132316698*G0_1_1;
    A[158] = -0.234548546858281*G0_0_0 - 0.167964252420489*G0_0_1 - 0.0614293813200273*G0_1_0 - 0.0420984571284103*G0_1_1;
    A[159] = 0.0243004934799669*G0_0_0 + 0.230854688059914*G0_0_1 - 0.0607512336999674*G0_1_0 + 0.607512336999764*G0_1_1;
    A[160] = 5.41666666666634*G0_0_0 + 0.431547619047605*G0_0_1 + 0.431547619047605*G0_1_0 + 1.13095238095232*G0_1_1;
    A[161] = -0.189013480984696*G0_0_0 - 0.0687321749035201*G0_0_1 - 0.274928699614086*G0_1_0 - 0.189013480984689*G0_1_1;
    A[162] = 0.170103454359941*G0_0_0 + 0.449559129379812*G0_0_1 + 0.157953207619939*G0_1_0 - 0.413108389159829*G0_1_1;
    A[163] = -0.401785714285694*G0_0_0 + 3.59374999999975*G0_0_1 + 0.558035714285684*G0_1_0 - 0.401785714285687*G0_1_1;
    A[164] = 0.300703265202927*G0_0_0 + 0.176126198190278*G0_0_1 + 0.279224460545564*G0_1_0 + 0.300703265202922*G0_1_1;
    A[165] = -0.0168650793650808*G0_0_0 + 0.0719246031746003*G0_0_1 - 0.00744047619047554*G0_1_0 - 0.0109126984126988*G0_1_1;
    A[166] = -0.00496031746031409*G0_0_0 - 0.162698412698407*G0_0_1 + 0.0198412698412685*G0_1_0 - 0.102182539682537*G0_1_1;
    A[167] = 0.100198412698408*G0_0_0 + 0.102678571428568*G0_0_1 - 0.0719246031746011*G0_1_0 + 0.118055555555554*G0_1_1;
    A[168] = -0.0451388888888866*G0_0_0 + 0.00570436507936436*G0_0_1 + 0.0434027777777766*G0_1_0 + 0.0520833333333311*G0_1_1;
    A[169] = 0.128968253968249*G0_0_0 - 0.0163690476190462*G0_0_1 - 0.0917658730158706*G0_1_0 - 0.178571428571424*G0_1_1;
    A[170] = -0.0381944444444409*G0_0_0 + 0.105406746031745*G0_0_1 + 0.0359623015873001*G0_1_0 + 0.126488095238092*G0_1_1;
    A[171] = 0.147321428571422*G0_0_0 + 0.0493551587301573*G0_0_1 + 0.106894841269839*G0_1_0 + 0.0560515873015863*G0_1_1;
    A[172] = -0.107142857142852*G0_0_0 - 0.056051587301585*G0_0_1 + 0.019345238095239*G0_1_0 + 0.0218253968253969*G0_1_1;
    A[173] = 0.221726190476183*G0_0_0 + 0.125248015873011*G0_0_1 + 0.0994543650793628*G0_1_0 + 0.0510912698412686*G0_1_1;
    A[174] = -0.519106168728166*G0_0_0 - 0.30164277372043*G0_0_1 - 0.806719045996497*G0_1_0 - 0.350747411302833*G0_1_1;
    A[175] = -0.189013480984696*G0_0_0 - 0.274928699614086*G0_0_1 - 0.0687321749035201*G0_1_0 - 0.189013480984689*G0_1_1;
    A[176] = 5.55555555555519*G0_0_0 + 0.59027777777774*G0_0_1 + 0.59027777777774*G0_1_0 + 0.912698412698367*G0_1_1;
    A[177] = -0.350747411302834*G0_0_0 - 0.301642773720423*G0_0_1 + 0.203433498555644*G0_1_0 - 0.0140298964520948*G0_1_1;
    A[178] = 0.0773236967664696*G0_0_0 + 0.167534676327336*G0_0_1 + 0.0644364139720513*G0_1_0 + 0.0773236967664651*G0_1_1;
    A[179] = -0.620039682539652*G0_0_0 + 3.39533730158706*G0_0_1 + 0.359623015872998*G0_1_0 - 0.620039682539659*G0_1_1;
    A[180] = 0.0350747411302844*G0_0_0 - 0.0119254119842966*G0_0_1 + 0.128373552536838*G0_1_0 - 0.124866078423811*G0_1_1;
    A[181] = -0.0701494822605688*G0_0_0 + 0.00982092751647956*G0_0_1 - 0.136089995585501*G0_1_0 + 0.0785674201318344*G0_1_1;
    A[182] = -0.0350747411302847*G0_0_0 + 0.0231493291459879*G0_0_1 + 0.0624330392119044*G0_1_0 - 0.0434926790015496*G0_1_1;
    A[183] = 0.0350747411302846*G0_0_0 + 0.0470001531145814*G0_0_1 - 0.0932988114065537*G0_1_0 - 0.206239477846068*G0_1_1;
    A[184] = -0.0701494822605692*G0_0_0 - 0.0799704097770489*G0_0_1 + 0.0659405133249321*G0_1_0 + 0.134687005940288*G0_1_1;
    A[185] = -0.0350747411302843*G0_0_0 - 0.058224070276272*G0_0_1 - 0.0975077803421883*G0_1_0 - 0.164149788489726*G0_1_1;
    A[186] = 0.0420896893563416*G0_0_0 + 0.0266568032590163*G0_0_1 - 0.152925871328036*G0_1_0 - 0.078567420131834*G0_1_1;
    A[187] = 0.00280597929042265*G0_0_1 + 0.294627825494385*G0_1_0 + 0.148716902392403*G0_1_1;
    A[188] = -0.0420896893563413*G0_0_0 - 0.0154328860973251*G0_0_1 - 0.195015560684376*G0_1_0 - 0.0897913372935261*G0_1_1;
    A[189] = -0.19841269841269*G0_0_0 + 0.0198412698412689*G0_0_1 + 4.30555555555523*G0_1_0 - 0.198412698412688*G0_1_1;
    A[190] = 0.170103454359941*G0_0_0 + 0.157953207619939*G0_0_1 + 0.449559129379812*G0_1_0 - 0.413108389159829*G0_1_1;
    A[191] = -0.350747411302834*G0_0_0 + 0.203433498555644*G0_0_1 - 0.301642773720423*G0_1_0 - 0.0140298964520949*G0_1_1;
    A[192] = 0.396825396825377*G0_0_0 + 0.198412698412686*G0_0_1 + 0.198412698412686*G0_1_0 + 4.92063492063457*G0_1_1;
    A[193] = -0.145802960879936*G0_0_1 - 0.729014804399696*G0_1_0 - 0.437408882639821*G0_1_1;
    A[194] = 0.701494822605666*G0_0_0 + 0.350747411302831*G0_0_1 + 0.350747411302831*G0_1_0 + 0.280597929042239*G0_1_1;
    A[195] = -0.100520805796406*G0_0_0 + 0.0708800553692599*G0_0_1 - 0.0631476856926133*G0_1_0 - 0.0850560664431108*G0_1_1;
    A[196] = 0.0463942180598788*G0_0_0 - 0.01288728279441*G0_0_1 + 0.0489716746187602*G0_1_0 + 0.030929478706585*G0_1_1;
    A[197] = -0.0231971090299389*G0_0_0 + 0.0322182069860271*G0_0_1 + 0.00128872827944092*G0_1_0 - 0.0180421959121745*G0_1_1;
    A[198] = 0.100520805796406*G0_0_0 + 0.171400861165666*G0_0_1 + 0.0373731201037924*G0_1_0 + 0.193309241916163*G0_1_1;
    A[199] = -0.0463942180598789*G0_0_0 - 0.0592815008542887*G0_0_1 + 0.00257745655888145*G0_1_0 - 0.0412393049421135*G0_1_1;
    A[200] = 0.0231971090299389*G0_0_0 + 0.0554153160159659*G0_0_1 + 0.0244858373093799*G0_1_0 + 0.0747462402075815*G0_1_1;
    A[201] = 0.103098262355287*G0_0_0 + 0.0773236967664658*G0_0_1 + 0.0154647393532918*G0_1_0 - 0.056704044295407*G0_1_1;
    A[202] = -0.206196524710575*G0_0_0 - 0.103098262355287*G0_0_1 - 0.103098262355287*G0_1_0 + 0.10825317547305*G0_1_1;
    A[203] = 0.103098262355287*G0_0_0 + 0.0257745655888211*G0_0_1 + 0.087633523001995*G0_1_0 - 0.0463942180598782*G0_1_1;
    A[204] = -0.218704441319893*G0_0_0 + 0.255155181539901*G0_0_1 - 0.0364507402199852*G0_1_0 - 0.218704441319912*G0_1_1;
    A[205] = -0.401785714285694*G0_0_0 + 0.558035714285684*G0_0_1 + 3.59374999999975*G0_1_0 - 0.401785714285687*G0_1_1;
    A[206] = 0.0773236967664696*G0_0_0 + 0.0644364139720513*G0_0_1 + 0.167534676327336*G0_1_0 + 0.0773236967664651*G0_1_1;
    A[207] = -0.729014804399696*G0_0_1 - 0.145802960879936*G0_1_0 - 0.437408882639821*G0_1_1;
    A[208] = 0.803571428571386*G0_0_0 + 0.401785714285693*G0_0_1 + 0.401785714285692*G0_1_0 + 5.3571428571425*G0_1_1;
    A[209] = -0.0515491311776324*G0_0_1 - 0.257745655888199*G0_1_0 - 0.154647393532917*G0_1_1;
    A[210] = 0.062003968253967*G0_0_0 - 0.0210813492063487*G0_0_1 + 0.0959821428571385*G0_1_0 + 0.0530753968253966*G0_1_1;
    A[211] = -0.124007936507934*G0_0_0 + 0.0173611111111107*G0_0_1 - 0.240575396825388*G0_1_0 + 0.0436507936507939*G0_1_1;
    A[212] = -0.0620039682539674*G0_0_0 + 0.0409226190476185*G0_0_1 + 0.146081349206343*G0_1_0 - 0.0649801587301585*G0_1_1;
    A[213] = 0.0620039682539672*G0_0_0 + 0.0830853174603164*G0_0_1 - 0.0339781746031716*G0_1_0 + 0.0401785714285732*G0_1_1;
    A[214] = -0.124007936507935*G0_0_0 - 0.141369047619046*G0_0_1 + 0.116567460317454*G0_1_0 + 0.142857142857138*G0_1_1;
    A[215] = -0.0620039682539668*G0_0_0 - 0.102926587301585*G0_0_1 - 0.208085317460309*G0_1_0 - 0.313988095238087*G0_1_1;
    A[216] = 0.074404761904761*G0_0_0 + 0.0471230158730152*G0_0_1 + 0.0153769841269827*G0_1_0 - 0.00793650793650757*G0_1_1;
    A[217] = 0.00496031746031724*G0_0_1 - 0.145833333333332*G0_1_0 - 0.0704365079365076*G0_1_1;
    A[218] = -0.0744047619047605*G0_0_0 - 0.0272817460317455*G0_0_1 - 0.0590277777777774*G0_1_0 - 0.00396825396825449*G0_1_1;
    A[219] = -0.350747411302834*G0_0_0 + 0.0350747411302835*G0_0_1 + 0.54015101340635*G0_1_0 + 0.322687618398612*G0_1_1;
    A[220] = 0.300703265202927*G0_0_0 + 0.279224460545564*G0_0_1 + 0.176126198190278*G0_1_0 + 0.300703265202922*G0_1_1;
    A[221] = -0.620039682539652*G0_0_0 + 0.359623015872998*G0_0_1 + 3.39533730158706*G0_1_0 - 0.620039682539659*G0_1_1;
    A[222] = 0.701494822605666*G0_0_0 + 0.350747411302831*G0_0_1 + 0.350747411302831*G0_1_0 + 0.280597929042239*G0_1_1;
    A[223] = -0.257745655888199*G0_0_1 - 0.0515491311776324*G0_1_0 - 0.154647393532917*G0_1_1;
    A[224] = 1.2400793650793*G0_0_0 + 0.620039682539648*G0_0_1 + 0.620039682539648*G0_1_0 + 5.61507936507903*G0_1_1;
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_0: public ufc::form
{
public:

  /// Constructor
  forms_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((FixedIndex(0),), {})), MultiIndex((FixedIndex(1),), {})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((FixedIndex(1),), {})), MultiIndex((FixedIndex(0),), {})))), Sum(Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((FixedIndex(0),), {})), MultiIndex((FixedIndex(1),), {})), Product(IntValue(-1, (), (), {}), Indexed(SpatialDerivative(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((FixedIndex(1),), {})), MultiIndex((FixedIndex(0),), {}))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_0();
        break;
      }
    case 1:
      {
        return new forms_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class forms_form_1: public ufc::form
{
public:

  /// Constructor
  forms_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~forms_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 0), MultiIndex((Index(0),), {Index(0): 2})), Indexed(Argument(FiniteElement('Nedelec 1st kind H(curl)', Cell('triangle', Space(2)), 3, None), 1), MultiIndex((Index(0),), {Index(0): 2}))), MultiIndex((Index(0),), {Index(0): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_finite_element_0();
        break;
      }
    case 1:
      {
        return new forms_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_dofmap_0();
        break;
      }
    case 1:
      {
        return new forms_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new forms_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Forms
{

class Form_0_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_0()
  {
  }

};

class Form_0_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_0_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_0_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_0_FunctionSpace_1()
  {
  }

};

class Form_0: public dolfin::Form
{
public:

  // Constructor
  Form_0(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Constructor
  Form_0(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_0());
  }

  // Destructor
  ~Form_0()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_0_FunctionSpace_0 TestSpace;
  typedef Form_0_FunctionSpace_1 TrialSpace;

  // Coefficients
};

class Form_1_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_0()
  {
  }

};

class Form_1_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  Form_1_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  Form_1_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new forms_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new forms_dofmap_0()), *mesh)))
  {
      // Do nothing
  }

  ~Form_1_FunctionSpace_1()
  {
  }

};

class Form_1: public dolfin::Form
{
public:

  // Constructor
  Form_1(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Constructor
  Form_1(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new forms_form_1());
  }

  // Destructor
  ~Form_1()
  {}

  /// Return the number of the coefficient with this name
  virtual dolfin::uint coefficient_number(const std::string& name) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(dolfin::uint i) const
  {

    dolfin::dolfin_error("generated code for class Form",
                         "access coeficient data",
                         "There are no coefficients");
    return "unnamed";
  }

  // Typedefs
  typedef Form_1_FunctionSpace_0 TestSpace;
  typedef Form_1_FunctionSpace_1 TrialSpace;

  // Coefficients
};

// Class typedefs
typedef Form_0::TestSpace FunctionSpace;

}

#endif
