/* debug.h				-*- C++ -*-
   $Id: debug.h,v 1.12 2001/03/25 23:50:59 elf Exp $
   
   written by Marc Singer
   21 Oct 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   in a file called COPYING along with this program; if not, write to
   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
   02139, USA.

*/

#if !defined (__DEBUG_H__)
#    define   __DEBUG_H__

/* ----- Includes */

/* ----- Globals */

/* ----- Typedefs */

typedef enum {
  debugEnable		= 0x0001, 	// Must be set for ANY tracing to occur
  debugSeverityInfo	= 0x0002, 	// General information
  debugSeverityTrace	= 0x0004, 	// Debug trace information 
  debugSeverityWarning	= 0x0008,	// Potentially erroneous situation
  debugSeverityError	= 0x0010,	// Error condition detected
  debugSeverityFatal	= 0x0020,	// Fatal situation, probably bailing
  debugSeverityMask	= 0x003f, 	// Mask to illicit severity bits
} eDebugSeverity;

typedef enum {
  debugClassNone	= 0x0000, 	// Always trace
  debugClassPrefs	= 0x0100,	// Preference parsing
  debugClassUI		= 0x0200,	// User interface and windowing
  debugClassFile	= 0x0400,	// Filesystem activity
  debugClassCvs		= 0x0800,	// Version control interface
  debugClassSignal	= 0x1000,	// Processing of signals
  debugClassMouse	= 0x2000, 	// Mouse events
  debugClassTermcap     = 0x4000,	// Low level display access
  debugClassMask	= 0x7f00, 	// Mask to illicit class bits
} eDebugClass;

#define T_INFO		(debugSeverityInfo)
#define T_TRACE		(debugSeverityTrace)
#define T_WARN		(debugSeverityWarning)
#define T_ERR		(debugSeverityError)
#define T_FATAL		(debugSeverityFatal)

#define T_PREFS_INFO	(debugClassPrefs | debugSeverityInfo)
#define T_PREFS_TRACE	(debugClassPrefs | debugSeverityTrace)
#define T_PREFS_WARN	(debugClassPrefs | debugSeverityWarning)
#define T_PREFS_ERR	(debugClassPrefs | debugSeverityError)
#define T_PREFS_FATAL	(debugClassPrefs | debugSeverityFatal)

#define T_UI_INFO	(debugClassUI | debugSeverityInfo)
#define T_UI_TRACE	(debugClassUI | debugSeverityTrace)
#define T_UI_WARN	(debugClassUI | debugSeverityWarning)
#define T_UI_ERR	(debugClassUI | debugSeverityError)
#define T_UI_FATAL	(debugClassUI | debugSeverityFatal)

#define T_CVS_INFO	(debugClassCvs | debugSeverityInfo)
#define T_CVS_TRACE	(debugClassCvs | debugSeverityTrace)
#define T_CVS_WARN	(debugClassCvs | debugSeverityWarning)
#define T_CVS_ERR	(debugClassCvs | debugSeverityError)
#define T_CVS_FATAL	(debugClassCvs | debugSeverityFatal)

#define T_MOUSE_INFO	(debugClassMouse | debugSeverityInfo)
#define T_MOUSE_TRACE	(debugClassMouse | debugSeverityTrace)
#define T_MOUSE_WARN	(debugClassMouse | debugSeverityWarning)
#define T_MOUSE_ERR	(debugClassMouse | debugSeverityError)
#define T_MOUSE_FATAL	(debugClassMouse | debugSeverityFatal)

#define T_FILE_INFO	(debugClassFile | debugSeverityInfo)
#define T_FILE_TRACE	(debugClassFile | debugSeverityTrace)
#define T_FILE_WARN	(debugClassFile | debugSeverityWarning)
#define T_FILE_ERR	(debugClassFile | debugSeverityError)
#define T_FILE_FATAL	(debugClassFile | debugSeverityFatal)

#define T_TC_INFO	(debugClassTermcap | debugSeverityInfo)
#define T_TC_TRACE	(debugClassTermcap | debugSeverityTrace)
#define T_TC_WARN	(debugClassTermcap | debugSeverityWarning)
#define T_TC_ERR	(debugClassTermcap | debugSeverityError)
#define T_TC_FATAL	(debugClassTermcap | debugSeverityFatal)


/* ----- Prototypes */

void _x_assert (const char*, const char*, int);

	// __attribute__ ((__noreturn__)); // say function doesn't return
void __trace (int code, const char*, ...);


/* ----- Macros */

#define __STR(e)	#e


#if defined (DEBUG)

# define TRACE(a)	__trace a
# define assert_(expr) ((void) ((expr)\
			     || (_x_assert (__STR (expr),__FILE__,__LINE__),0)))

#else

# define TRACE(a)
# defined assert_(expr)

#endif

#endif  /* __DEBUG_H__ */
