/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <iostream>
#include <fstream>

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/snglinst.h>
#include "Cryptonit.hh"
#include "Common.hh"
#include "../Utils.hh"
#include "NewUserWizard.hh"
#include "i18n.h"
#include "../../config.h"

#ifndef __WXMSW__
#include "pics/splash.xpm"
#endif

IMPLEMENT_APP(CryptonitGui)
  BEGIN_EVENT_TABLE(CryptonitGui::SplashScreen, wxDialog)
  EVT_TIMER(SS_TIMER_ID, CryptonitGui::SplashScreen::OnTimer)
  EVT_PAINT  (CryptonitGui::SplashScreen::OnPaint)
//EVT_EXIT  (wxID_EXIT, CryptonitGui::OnExit)
END_EVENT_TABLE()

/* Initialize the language list */
const wxString CryptonitGui::langs[] = {
    _("(System default)"),
#ifdef I18N_fr
    _T("fran\u00e7ais"),
#endif
#ifdef I18N_pt_BR
    _T("Portugues do Brasil"),
#endif
#ifdef I18N_de
    _T("Deutsch"),
#endif
#ifdef I18N_nl
    _T("Nederlands"),
#endif
#ifdef I18N_ar
	  _T("Arabic"),
//        _T("\u0639\u0631\u0628\u064a"),
#endif
#ifdef I18N_sv
    _T("svenska"),
#endif
    _T("English")
};

#ifdef __WXMSW__
static char separator = '\\';
static wxChar wxseparator = '\\';
#else
static char separator = '/';
static wxChar wxseparator = '/';
#endif

const int CryptonitGui::nbLangs = WXSIZEOF( CryptonitGui::langs );

/** Check if the I18N path exists.
 *  @return true if the I18N path already exists
 */
static bool i18nPathExist()
{
    wxString dirHome = std2wx(getCryptonitHome());
    wxFileName i18nPath( dirHome, _T("i18n"));
    return wxDir::Exists(i18nPath.GetFullPath());
}


/** Create the base i18n path if it doesn't exist.
 *  If the path already exist, no error are returned.
 *  @return the path to the i18n base directory
 */
static std::string createI18NPath() 
{
  std::string i18npath = appendDir(getCryptonitHome(), "i18n");
#ifdef DEBUG
  std::cerr << "create path = " <<i18npath  << std::endl;
#endif
  MKDIR(i18npath.c_str());

  return i18npath;
}

void createLanguage( std::string i18nPath, std::string lang, const unsigned char* data, unsigned int size )
{
  std::string languagePath = appendDir(i18nPath, lang);
  MKDIR(languagePath.c_str());
  std::ofstream os(appendDir(languagePath, "cryptonit.mo").c_str(), std::ios::out | std::ios::binary);
  os.write((const char *)data, size);
  os.close();
}

bool CryptonitGui::OnInit()
{
    std::cout << "Cryptonit " << VERSION << " Copyright (c) 2003-2006 IDEALX" << std::endl;
    std::cout << "This software is ditributed under the GNU General Public License version 2" << std::endl;
    std::cout << std::endl;
    std::cout << "The Cryptonit security software suite is developped by IDEALX" << std::endl;
    std::cout << "Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org)." << std::endl;
    std::cout << std::endl;

#if 0
    const wxString name = wxString::Format(_T("Cryptonit-%s"), wxGetUserId());
    instanceChecker = new wxSingleInstanceChecker(name);
    if ( instanceChecker->IsAnotherRunning() ) {
				wxLogError(_("Another program instance is already running, aborting."));
				return false;
    }
#endif

   
    if(! i18nPathExist()) {
      NewUserWizard::createUserFiles(std2wx(USER_NAME), std2wx(USER_PASSWD), std2wx("fr"));
    }

    std::string i18nPath = createI18NPath();

    /* Create .mo files for all supported languages */
#ifdef I18N_fr
    createLanguage( i18nPath, "fr", fr, WXSIZEOF(fr)  );
#endif
#ifdef I18N_pt_BR
    createLanguage( i18nPath, "pt_BR", pt_BR, WXSIZEOF(pt_BR) );
#endif
#ifdef I18N_de
    createLanguage( i18nPath, "de", de, WXSIZEOF(de) );
#endif
#ifdef I18N_nl
    createLanguage( i18nPath, "nl", nl, WXSIZEOF(nl) );
#endif
#ifdef I18N_ar
        createLanguage( i18nPath, "ar", ar, WXSIZEOF(ar) );
#endif
#ifdef I18N_sv
        createLanguage( i18nPath, "sv", sv, WXSIZEOF(sv) );
#endif


    locale.AddCatalogLookupPathPrefix( std2wx(i18nPath) );

    SetExitOnFrameDelete(FALSE);
    
    // wxString lang = wxGetSingleChoice( _("Please choose language:"), 
    // 				       _("Language"),
    //     			       WXSIZEOF(langs), langs);
    // SetExitOnFrameDelete(TRUE);

    locale.Init(wxLANGUAGE_DEFAULT);
    currentLocale = _("(System default)");
    
    // currentLocale = lang;

    // Initialize the catalogs we'll be using
    /* not needed any more, done in wxLocale ctor
    locale.AddCatalog("wxstd");      // 1) for library messages
    */
    locale.AddCatalog(wxT("cryptonit"));      // 2) our private one
    /* this catalog is installed in standard location on Linux systems,
       it might not be installed on yours - just ignore the errrors
     or comment out this line then */

// #ifdef __LINUX__
//     {
// 	wxLogNull noLog;
// 	locale.AddCatalog(_T("fileutils"));  // 3) and another just for testing
//     }
// #endif

    SplashScreen *splashScreen = new SplashScreen( NULL, wxBITMAP(splash), 2000, login );
    splashScreen->Show(TRUE);
    //SetTopWindow(splashScreen);

    return TRUE;	

}

int CryptonitGui::OnExit()
{
  delete instanceChecker;
  return 0;
}


wxString CryptonitGui::getCurrentLocale()
{
    return currentLocale;
}


void CryptonitGui::setCurrentLocale( wxString language )
{
   	
if( language == _T("(System default)") ) {
      locale.Init(wxLANGUAGE_DEFAULT);
    }
#ifdef I18N_fr
    if( language == _T("fran\u00e7ais") ) {
      locale.Init(wxLANGUAGE_FRENCH);
    }
#endif
#ifdef I18N_pt_BR
    if( language == _T("Portugues do Brasil") ) {
      locale.Init(wxLANGUAGE_PORTUGUESE_BRAZILIAN);
    }
#endif
#ifdef I18N_de
    if( language == _T("Deutsch") ) {
      locale.Init(wxLANGUAGE_GERMAN);
    }
#endif
#ifdef I18N_nl
    if( language == _T("Nederlands") ) {
      locale.Init(wxLANGUAGE_DUTCH);
    }
#endif
#ifdef I18N_ar
   if( language == _T("Arabic")) { //\u0639\u0631\u0628\u064a") ) {
      locale.Init(wxLANGUAGE_ARABIC);
   }
#endif
#ifdef I18N_sv
   if( language == _T("svenska")) { 
      locale.Init(wxLANGUAGE_SWEDISH);
   }
#endif
			  

    if( language == _T("English") ) {
      // locale.Init(wxLANGUAGE_ENGLISH);
      locale.Init(wxLANGUAGE_DEFAULT);
    }

    locale.AddCatalog(wxT("cryptonit"));      // 2) our private one
    currentLocale = language;
}


wxArrayString CryptonitGui::getFiles()
{
    wxArrayString files;
    for( int i = 1; i < argc; i++ ) {
	if( argv[i] != NULL && wxFileExists(argv[i]) ) {
	    files.Add( wxString(argv[i]) );
	}
    }
    return files;
}

CryptonitGui::SplashScreen::SplashScreen( wxWindow* parent, const wxBitmap& bitmap, 
					  int timeout, LoginFrame *login )
    :  wxDialog( parent, -1, wxEmptyString, wxDefaultPosition, wxSize(400,300), wxSTAY_ON_TOP | wxFRAME_TOOL_WINDOW )
{
  loginFrame = login;
  /* wxPanel *panel = new wxPanel(this);
     wxBoxSizer *sizer = new wxBoxSizer( wxVERTICAL );
     sizer->Add( new wxStaticBitmap( panel, -1, wxBITMAP(splash)), 1, 
     wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 0 );
     panel->SetSizer( sizer );
     sizer->Fit( panel );*/
  Center();

  timer.SetOwner( this, SS_TIMER_ID );
  timer.Start(timeout, TRUE);
}


void CryptonitGui::SplashScreen::OnTimer(wxTimerEvent& event)
{
    wxString title = _T("IDEALX Cryptonit: ");

    loginFrame = new LoginFrame
      (NULL, -1, title.append(_("Login")), wxDefaultPosition,
       wxSize(400, 300),  wxFRAME_TOOL_WINDOW );
#ifdef USER_AUTHENTICATION
    loginFrame->Show(TRUE);
#endif
    Show(FALSE);

    // Destroy() method only destroy the SplashScreen window under Linux
    // and kill the app under Windows...
#ifndef __WXMSW__
    Destroy();
#endif
}

void CryptonitGui::SplashScreen::OnPaint(wxPaintEvent &event)
{
  wxPaintDC dc( this );
  dc.DrawBitmap( wxBITMAP(splash), 0, 0, TRUE );  
}
