/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <iostream>
#include "Common.hh"
#include <wx/filename.h>

/* Functions to hack arround wxWidget and unicode flaws. 
 * -- pmachard */

wxString std2wx(std::string s){
 wxString wx; 
 const char* my_string=s.c_str();
 wxMBConvUTF8 *wxconv= new wxMBConvUTF8();
 wx=wxString(wxconv->cMB2WC(my_string),wxConvUTF8);
 delete wxconv;
 // test if conversion works of not. In case it fails convert from Ascii
 if(wx.length()==0)
 wx=wxString(wxString::FromAscii(s.c_str()));
 return wx;
}

std::string wx2std(wxString s){
  std::string s2;
  if(s.wxString::IsAscii()) {
    s2=s.wxString::ToAscii();
  } else {
    const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(s);
    const char *tmp_str = (const char*) tmp_buf;
    s2=std::string(tmp_str, strlen(tmp_str));
  }
  return s2;
}

wxString rstd2wx(std::string s, char* file, int line) {
#ifdef __WXMSW__
 wxString wx(wxString::FromAscii(s.c_str()));
#endif
#ifndef __WXMSW__
 const char* my_string=s.c_str();
 wxString wx(wxConvUTF8.cMB2WC(my_string), *wxConvCurrent); // wxConvUTF8);
#endif
#ifdef DEBUG
  std::cerr << "std2wx: <= " << s <<  " (" << strlen(s.c_str()) << ")" << std::endl;
  std::string tmp ((const char*)wx.mb_str(wxConvUTF8), wx.length());
  std::cerr << "std2wx: => " << tmp <<  " (" << wx.length() << ")" << std::endl;    std::cerr << "In " << file << ":" << line << std::endl;
#endif
  return wx;
}

std::string rwx2std(wxString s, char* file, int line) {       
  std::string s2;
  if(s.wxString::IsAscii()) {
    s2=s.wxString::ToAscii();
  } else {
    const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(s);
    const char *tmp_str = (const char*) tmp_buf;
    s2=std::string(tmp_str, strlen(tmp_str));
  }
#ifdef DEBUG
  std::cerr << "wx2std: <= " << (const char*)s.ToAscii() << " (" << strlen((const char*)s.ToAscii()) << ")" << std::endl;
  std::cerr << "wx2std: => " << s2 << " (" << s2.length() << ")"  << std::endl;
  std::cerr << "In " << file << ":" << line << std::endl;
#endif
  return s2;
}

wxFileName wxMyPrepend(wxFileName filename,const wxString stringToPrepend) {
  wxString thestream;
  thestream+=stringToPrepend;

#ifdef __WXMSW__
  thestream+=wxString::FromAscii("\\");
#endif
#ifndef __WXMSW__
  thestream+= wxString::FromAscii("/");
#endif
  thestream+=filename.GetFullPath();

#ifdef DEBUG
  std::cerr << "The Full File Name " << wx2std(thestream) << std::endl;
#endif
  return wxFileName(thestream);

}

wxFileName wxMyAppend(wxFileName filename,const wxString stringToAppend) {
  wxString thestream;
  thestream+=filename.GetFullPath();
    
#ifdef __WXMSW__
  thestream+=wxString::FromAscii("\\");
#endif
#ifndef __WXMSW__
  thestream+=wxString::FromAscii("/");
#endif
  thestream+=stringToAppend;

#ifdef DEBUG
  std::cerr << "The Full File Name " << wx2std(thestream) << std::endl;
#endif
  return wxFileName(thestream);

}
