;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: response.lisp,v 1.14 2001/11/12 20:07:08 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.
;;;
;;; Stuff concerned with variables that are mamipulated during
;;; response construction.
;;;
;;; For instance, the response's MIME type is determined to some exten
;;; by what happens during response processing, as is the page title,
;;; and other contents of 'HEAD' element.

(in-package :imho)

;; Assert that a response is going to be binary.
;;
;; FIX: handle this better.

(defun set-http-header (key value)
  (if (string= key "Content-Type")
      (progn
        (when (string= value "application/binary")
          (setf (request-binary *active-request*) t))
        (setf (request-response-type *active-request*) value))
      (push (cons key value)
            (request-headers-out *active-request*))))

(defun set-cookie (key value)
  (push (cons "Set-Cookie" (format nil "~a=~a; path=/" key value))
        (request-headers-out *active-request*)))

(defun get-http-header (key)
  (cdr (assoc key (request-headers-out *active-request*) :test #'string=)))

(defun ensure-divstream ()
  (when (null (request-div-elements *active-request*))
    (setf (request-div-elements *active-request*)
          (make-string-output-stream)))
  (request-div-elements *active-request*))

(defmacro with-div ((divstream name) &body rest)
  `(let ((,divstream (ensure-divstream)))
    (html-stream
     ,divstream
     ((:div :id ,name)
      ,@rest))))
    
(defun set-page-title (string)
  (setf (request-doc-title *active-request*) string))

(defun get-page-title ()
  (request-doc-title *active-request*))
  