/* $Id: server.c,v 1.2 2000/05/03 23:11:32 jesse Exp $ */

/*
 * Run server: listen on a message queue, dispatch to image functions.
 */

#include "server.h"

static int in_server = 0;

int is_server()
{
  return in_server;
}

int server_run()
{
  int id;
  int cmd_rtn;
  int ipc_key = ftok(LISP_PATH, LISP_PROJ);
  lctl_msg *msg, *out;
  int done = 0;

  msg = (lctl_msg *) malloc(sizeof(lctl_msg));
  out = (lctl_msg *) malloc(sizeof(lctl_msg));
  id = msgget(ipc_key, IPC_CREAT | IPC_EXCL | 0666);

  if (id == -1)
    {
      perror("Can't create server message queue");
      return id;
    }
  else
    {
      printf("Server MQID: %u\n", id);

      in_server = 1;
      if ((cmd_rtn = issue_ticket()) == -1)
        done = 1;
      
      while (!done)
        {
          if ((cmd_rtn = msgrcv(id, msg, LCTL_MSGLEN, 2, 0)) == -1)
            {
              switch (errno)
                {
                case EIDRM:
                  printf("Server Message Queue destroyed, exiting.\n");
                  break;
                default:
                  perror("Server Message Queue error");
                  break;
                }
              cmd_rtn = -1;
              done = 1;
            }
          else
            {
              printf("Ticket #%lu returned\n", msg->ticket);
              switch (msg->code)
                {
                case SRV_STOP:
                  printf("Message SRV_STOP rcvd: no handler\n");
                  break;
                case IMG_CREATE:
                  {
                    int success;
                    printf("Message IMG_CREATE rcvd: %s\n", msg->text);
                    success = (image_create(msg->text) != (lisp_image *) 0);
                    out->channel = msg->ticket;
                    out->code = (success ? SUCCESS : FAILURE);
                    if (send_message(out) == -1
                        || (cmd_rtn = issue_ticket()) == -1)
                      done = 1;
                    break;
                  }
                case IMG_DESTROY:
                  printf("Message IMG_DESTROY rcvd: %s\n", msg->text);
                  image_destroy(msg->text);
                  break;
                case IMG_SEND:
                  printf("Message IMG_SEND rcvd.\n");
                  break;
                default:
                  printf("Unknown message rcvd.\n");
                  break;
                }
            }
        }
    }
  printf("Server Finished.\n");
}

int server_start()
{
  pid_t pid;
  lisp_image *server;
  int id;
  int cmd_rtn = -1;

  pid = fork();
  if (pid == -1)
    perror("forking lisp server"); 
  else if (pid != 0)            /* in parent (control process) */
    {
      printf("Server started... waiting for confirmation\n"); 
      sleep(1); 
      if (!server_running_p())
        { 
          perror("Server failed to start up correctly"); 
          cmd_rtn = -1;
        } 
      else
        {
          cmd_rtn = 0;
        }
    }
  else                          /* in child (server process) */
    { 
      printf("Server process alive.\n");
/*        if ((pid = daemon(0,0)) == -1) */
/*          { */
/*            perror("daemonizing"); */
/*            exit(1); */
/*          } */
      cmd_rtn = server_run();
    } 
  
  return cmd_rtn;
}

int server_stop()
{
  int cmd_rtn = -1;
  int id;

  id = ipc_mqueue();
  if (id == -1)
    {
      perror("Couldn't obtain server message queue");
      cmd_rtn = -1;
    }

  /* stop the server... */
  
  cmd_rtn = msgctl(id, IPC_RMID, 0);
  if (cmd_rtn == -1)
    {
      perror("Couldn't close server message queue");
    }

  return cmd_rtn;
}

int server_create(char *image)
{
  int cmd_rtn = -1;
  lctl_msg *msg;
  long ticket;

  msg = (lctl_msg *) malloc(sizeof(lctl_msg));

  ticket = seize_ticket();

  if (ticket == -1) 
    {
      printf("Got no ticket from server.\n");
      return -1;
    }

  printf("Got ticket #%lu\n", ticket);
  msg->channel = 2;
  msg->ticket = ticket;
  msg->code = IMG_CREATE;
  strcpy(msg->text, image);

  printf("Sending create request\n");
  
  if ((cmd_rtn = send_message(msg)) == -1)
    {
      return cmd_rtn;
    }

  printf("Awaiting response\n");

  if ((msg = recv_message(ticket)) == (lctl_msg *) -1)
    {
      return -1;
    }

  printf("Response: %li\n", msg->code);

  free(msg);

  return cmd_rtn;
}

int server_connect(char *image)
{
  int cmd_rtn = -1;

  return cmd_rtn;
}

int server_running_p()
{
  return (ipc_mqueue() != -1);
}

