;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: wco -*-
;; $Id: burp.lisp,v 1.3 2000/02/15 06:01:41 jesse Exp $

(in-package :burp)

(locally-enable-sql-reader-syntax)

(defvar *burp-base-category* nil)

(defvar *burp-view-classes*
  '(burp-bug burp-user bug-category))

(defvar *burp-sequences*
  '(bug-sequence bug-category-sequence))

(defclass burp-session (http-session)
  ((user
    :initform nil))
  )

(defapplication burp-app
    :base-url "burp"
    :main-class burp-categories
    :session-class burp-session
    :template-root "systems:burp;templates;"
    :script-root "systems:burp;javascript;")

(defun start ()
  (format t ";; Starting BURP~%")
  (if (not *burp-base-category*)
      (initialize))
  (if (run-application 'burp-app)
      (format t ";; started~%")
      (format t ";; not started~%")))

(defun stop ()
  (format t ";; Stopping BURP~%")
  (if (stop-application 'burp-app)
      (format t ";; stopped~%")
      (format t ";; not stopped~%")))

(defun reinitialize (&key (force nil))
  (if (or force
          (y-or-n-p ";; This will wipe the DB *but good*. Really do it? "))
      (progn
        (dolist (class *burp-view-classes*)
          (ignore-errors (drop-view-from-class class))
          (create-view-from-class class))
        (dolist (sequence *burp-sequences*)
          (ignore-errors (drop-sequence sequence))
          (create-sequence sequence))
        (setf *burp-base-category*
              (make-instance 'bug-category
                             :id 0
                             :name "base category"))
        (update-records-from-instance *burp-base-category*))
      (format t ";; Chicken!~%")))

(defun initialize ()
  (sql:connect '(nil "burp" "jesse" nil) :database-type :postgresql)
  (setf *burp-base-category*
        (car (select 'bug-category :where [= [category_id] 0]))))
