(in-package :burp)

(locally-enable-sql-reader-syntax)

(def-view-class burp-bug ()
  ((bug-id
    :db-kind :key
    :type (integer 6))
   (bug-creator-id
    :initarg :creator
    :db-kind :base
    :type (string 30))
   (bug-creator
    :reader bug-creator
    :db-kind :join
    :db-info (:join-class burp-user
                          :home-key bug-creator-id
                          :foreign-key user-id
                          :set nil))
   (bug-category
    :db-kind :join
    :db-info (:join-class bug-category
                          :home-key bug-category-id
                          :foreign-key category-id
                          :set nil))
   (bug-category-id
    :initarg :category
    :db-kind :base
    :type (integer 6))
   (bug-title
    :reader title
    :initarg :title
    :initform ""
    :db-kind :base
    :type (string 60))
   (bug-description
    :reader description
    :initarg :description
    :db-kind :base
    :type (string 200)))
  )

(defmethod shared-initialize ((bug burp-bug) slot &rest)
  (call-next-method)
  (if (not (slot-boundp bug 'bug-id))
      (setf (slot-value bug 'bug-id) (sequence-next 'bug-sequence))))

(defmethod extern-ref ((bug burp-bug))
  (format nil "~d" (slot-value bug 'bug-id)))

(defmethod intern-ref ((bug (eql 'burp-bug)) arg)
  (select 'burp-bug :where [= [bug_id] (parse-integer arg)]))

;; move this crud over to MaiSQL

(defmethod create-sequence (name)
  (sql:execute-command
   (concatenate 'string "CREATE SEQUENCE " (maisql-sys::sql-escape name))))

(defmethod drop-sequence (name)
  (sql:execute-command
   (concatenate 'string "DROP SEQUENCE " (maisql-sys::sql-escape name))))

(defun sequence-next (name)
  (parse-integer (caar (sql:query (concatenate 'string
                                               "SELECT NEXTVAL ('"
                                               (maisql-sys::sql-escape name) "')")))))
  

;; (create-sequence 'bug-sequence)
;; (create-sequence 'bug-category-sequence)
