(in-package :bz)

(def-view-class bug ()
  ((bug-id
    :db-kind :key
    :db-type (int 8))                   ; bug-id mediumint not null auto-increment primary key,
   (assigned-to
    :db-type bug-person)                ; mediumint not null
   (bug-file-loc)                       ; text,
   (bug-severity)                       ; enum($severities) not null,
   (bug-status
    :db-type bug-status)                ; "NEW", "ASSIGNED", "REOPENED", "RESOLVED", "VERIFIED", "CLOSED") not null,
   (creation-ts)                        ; datetime not null,
   (delta-ts)                           ; timestamp,
   (short-desc)                         ; mediumtext,
   (long-desc)                          ; mediumtext,
   (op-sys)                             ; enum($opsys) not null,
   (priority)                           ; enum($priorities) not null,
   (product)                            ; varchar(64) not null,
   (rep-platform)                       ; enum($platforms),
   (reporter)                           ; mediumint not null,
   (version)                            ; varchar(16) not null,
   (component)                          ; varchar(50) not null,    
   (resolution
    :db-type bug-resolution)            ; enum("", "FIXED", "INVALID", "WONTFIX", "LATER", "REMIND", "DUPLICATE", "WORKSFORME") not null, 
   (target-milestone)                   ; varchar(20) not null,
   (qa-contact)                         ; mediumint not null,     
   (status-whiteboard)                  ; mediumtext not null,
   (votes)                              ; mediumint not null,
   ))

(def-view-class bug-group ()
  ((group-id)
   (bug-id)))
    
(def-view-class bug-status ()
  ((bug-status-id
    :db-kind :key
    :db-type (int 8))
   (bug-status-name)))

(def-view-class bug-resolution ()
  ((bug-resolution-id
    :type :key)
   (bug-resolution-name
    :type :base)))

