# CiviCRM 5.17.0

Released September 4, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add unique names and unique title for recurrings.
  ([14820](https://github.com/civicrm/civicrm-core/pull/14820))**

  Adds the key `unique_title` to the entity definition schema for situations where
  multiple entities may be involved (e.g advanced search) and disambiguation is
  needed

- **Add query dispatcher to allow query modification
  ([CRM-20445](https://issues.civicrm.org/jira/browse/CRM-20445):
  [259](https://github.com/civicrm/civicrm-packages/pull/259) and
  [180](https://github.com/civicrm/civicrm-packages/pull/180))**

  Allows a query to be modified from an extension, for example by prepending
  data like '/* Query run by user 45*/'.

- **Add support for bulkcreates
  ([dev/core#1093](https://lab.civicrm.org/dev/core/issues/1093):
  [14829](https://github.com/civicrm/civicrm-core/pull/14829) and
  [14694](https://github.com/civicrm/civicrm-core/pull/14694))**

  Adds a bulkCreate function for CustomField so that one can create multiple
  custom fields at the same time. This sets the stage for a new protocol
  for how bulk create actions could look from a code point of view.

- **Make admin panels hookable
  ([dev/core#1104](https://lab.civicrm.org/dev/core/issues/1104):
  [14734](https://github.com/civicrm/civicrm-core/pull/14734))**

  Adds the hook `alterAdminPanel` to allow extension developers to hide and show
  elements on the admin screen.

- **[EXPORT] add getPreview function
  ([14782](https://github.com/civicrm/civicrm-core/pull/14782))**

  Adds a function to allow preview of export results.

- **Export help info does not match code
  ([dev/core#1120](https://lab.civicrm.org/dev/core/issues/1120):
  [14830](https://github.com/civicrm/civicrm-core/pull/14830))**

  Improves the export UI when one selects "Merge All Contacts with the Same
  Address" so that the field "Postal Greeting (merging > 2 contacts)" reads
  "Postal Greeting (when merging contacts)" and the field "Addressee (merging >
  2 contacts)" reads "Addressee (when merging contacts)" and the code behind
  these fields so that merging greater than 2 contacts or less than 2 contacts
  functions the same.

- **Can't show contact subtype in search views
  ([core#1130](https://lab.civicrm.org/dev/core/issues/1130):
  [14840](https://github.com/civicrm/civicrm-core/pull/14840))**

  This change ensures that one can use Contact Subtype as a result column in
  Search Views.

- **[REPORT] Allow extensions to join address, email and phone tables without
  limiting to primary fields
  ([14941](https://github.com/civicrm/civicrm-core/pull/14941))**

  Allows reports to join the address email and phone tables without limiting to
  just primary fields and add a test to ensure this functionality stays in
  place.

- **Use metadata for getOptions abbreviation & include currency symbol
  ([14969](https://github.com/civicrm/civicrm-core/pull/14969))**

  Refactors the "abbreviation" mode in getOptions to be more consistently
  metadata-driven, and adds the currency symbol as an abbreviation to fetch.

- **Error log improvements: Provide severity level and use Civi::log()
  ([14222](https://github.com/civicrm/civicrm-core/pull/14222))**

  Improves the Error Logging functionality ` CRM_Core_Error::debug_var` by
  adding an optional severity level parameter and using `Civi::log()`.

- **Move the code to add employer from relationship backoffice form to BAO
  ([14950](https://github.com/civicrm/civicrm-core/pull/14950))**

  Makes it so one can add the employer contact after a current 'Employee of'
  relationship is created and adds an optional relationship.create API parameter
  `is_current_employer`.

- **[METADATA] Add titles to Mapping xml & DAOs
  ([14867](https://github.com/civicrm/civicrm-core/pull/14867) and
  [14975](https://github.com/civicrm/civicrm-core/pull/14975))**

  Adds some missing metadata to the Mapping & MappingField entities.

- **Fix support for relative dates in urls
  ([14893](https://github.com/civicrm/civicrm-core/pull/14893))**

  Improves url support for relative dates for fields that have been converted to
  use datepicker.

- **Add default location for API v3 creates of Address, IM, OpenID and Phone
  ([14885](https://github.com/civicrm/civicrm-core/pull/14885))**

- **EntityPageTrait: Set logged in contact ID as default if one is not
  specified, this allows permission checks etc. to work properly.
  ([14620](https://github.com/civicrm/civicrm-core/pull/14620))**

  Currently the `entitypagetrait` is only in use by
  CRM_Contact_Page_View_Relationship. However the plan is to extend it to other
  pages too, this PR updates it to get the logged in contact ID if none is
  passed in - so it can be used on non-contact forms (eg. event lists).

- **Move log and compilation dirs from "Runtime" to "Paths"
  ([14718](https://github.com/civicrm/civicrm-core/pull/14718))**

  This is an update to the path-handling convention for data folders that allows
  more intuitive management of file-paths.

- **Use select2 to display field mappings
  ([14794](https://github.com/civicrm/civicrm-core/pull/14794))**

  On the "Export Options" Screen for the "Use Saved Field Mapping" select field
  adds the Description for the option (if one exists).

- **expose smarty's compile_check to be overridden in civicrm.settings.php
  ([14706](https://github.com/civicrm/civicrm-core/pull/14706))**

  Exposes the Smarty variable `compile_force` so that it can be overridden from
  civicrm.settings.php because having `compile_force` set to FALSE in some
  environments has a positive impact on page rendering performance.

- **[dev/core#538](https://lab.civicrm.org/dev/core/issues/538) Activity search
  (advanced search) by subject - is exact match only
  ([14703](https://github.com/civicrm/civicrm-core/pull/14703))**

  Makes searching on some fields (including but not limited to invoice_number,
  activity details, activity subject and activity location) do a "Like" search
  as opposed to a strict match search consistently whether using the advanced
  search or a component specific search.

- **Unable to use url search arguments in 'Advanced Search' using force=1
  ([Core/dev#692](https://lab.civicrm.org/dev/core/issues/692):
  [14921](https://github.com/civicrm/civicrm-core/pull/14921))**

  Adds support for the url search arguments 'contact_tags' and 'email' for the
  'Advanced Search' form.

### CiviContribute

- **Extend contribute search url parsing to advanced search
  ([14939](https://github.com/civicrm/civicrm-core/pull/14939))**

  This change extends the url parameters accepted by the Advanced Search form to
  include the search url parameters accepted by the Contribution Search form.

- **Improve performance on getSoftContribution details - only run one query
  instead of one per contribution
  ([14747](https://github.com/civicrm/civicrm-core/pull/14747))**

  Improves performance when retrieving bulk contributions.

- **Switch priceset selector to addField method
  ([14843](https://github.com/civicrm/civicrm-core/pull/14843))**

  Switches to adding price set fields using schema metadata instead of hard
  coded metadata.

- **Set title using standard form method and use for success message on
  contributionpage
  ([14615](https://github.com/civicrm/civicrm-core/pull/14615))**

  Switches to using a standard form method for assigning title on the Manage
  Contribution page screen so the title can be accessed during postprocess.

### CiviEvent

- **Improve handling of 'Manage Event' title
  ([14614](https://github.com/civicrm/civicrm-core/pull/14614))**

  Switches to using a standard form method for assigning title on the Manage
  Event screen so the title can be accessed during postprocess.

### CiviMail

- **Changed the title and description of profile_add_to_group_double_optin
  ([14852](https://github.com/civicrm/civicrm-core/pull/14852))**

  Improves help text by updating the profile_add_to_group_double_optin and
  profile_double_optin to have different titles and descriptions.

### CiviMembership

- **Add serialization metadata for MembershipType api
  ([14954](https://github.com/civicrm/civicrm-core/pull/14954))**

  Adds metadata for serializing the membership_type fields
  'relationship_type_id' and 'relationship_direction'.

- **Switch create MembershipPayment to use API
  ([14886](https://github.com/civicrm/civicrm-core/pull/14886))**

  Simplifies and standardizes the creation of a MembershipPayment when using a
  "live" payment method.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Does CiviCRM make it possible to specify which directories are private and
  which are public-accessible?
  ([dev/cloud-native#3](https://lab.civicrm.org/dev/cloud-native/issues/3):
  [14778](https://github.com/civicrm/civicrm-core/pull/14778))**

  This deprecates a function which was enabling/complicit in problematic
  file-construction logic.

- **Postal Code Suffix returns Postal Code value
  ([dev/report#17](https://lab.civicrm.org/dev/report/issues/17):
  [14744](https://github.com/civicrm/civicrm-core/pull/14744))**

  Ensures when the postal code suffix column is displayed it returns the suffix,
  before this change the postal code value was displayed.

- **Contact Reference Field Cutoff on Export
  ([dev/core#439](https://lab.civicrm.org/dev/core/issues/439):
  [14937](https://github.com/civicrm/civicrm-core/pull/14937))**

  Fixes the handling of custom country fields longer than 16 characters when
  exporting and improves test coverage.

- **Issue with alterReportVars hook invoke
  ([dev/core#987](https://lab.civicrm.org/dev/core/issues/987):
  [14320](https://github.com/civicrm/civicrm-core/pull/14320))**

  Switches to invoking alterReportVars hook before grand total and section total
  calculations instead of after so that when alterReportVars hook is used to
  alter values in report rows those changes are taken into account when
  totaling.

- **Delete repeating activities not working as intended
  ([dev/core#1050](https://lab.civicrm.org/dev/core/issues/1050):
  [14784](https://github.com/civicrm/civicrm-core/pull/14784))**

  Ensures that when the user opts to delete multiple repeat activities, the
  specified activities are actually deleted.

- **Bad popup on update recurring screen
  ([dev/core#1061](https://lab.civicrm.org/dev/core/issues/1061):
  [14964](https://github.com/civicrm/civicrm-core/pull/14964))**

  Ensures that custom data is not loaded on the update subscription form when it
  is in self service mode.

- **Count on Groups tab changes when tab is loaded
  ([dev/core#1097](https://lab.civicrm.org/dev/core/issues/1097):
  [14721](https://github.com/civicrm/civicrm-core/pull/14721))**

  Fixes a bug where if a contact had been explicitly added to any Smart Groups,
  then the number on their Groups tab would not include these Smart Groups until
  the tab was loaded.

- **Contact Reference fields are not updated when merging contacts
  ([dev/core#1109](https://lab.civicrm.org/dev/core/issues/1109):
  [14983](https://github.com/civicrm/civicrm-core/pull/14983))**

  Ensures when duplicates are merged, custom fields and other records pointing
  to the duplicate contact are updated to point to the surviving contact.

- **Regression: Custom searches no longer work
  (dev/[core#1175](https://lab.civicrm.org/dev/core/issues/1175):
  [15007](https://github.com/civicrm/civicrm-core/pull/15007))**

  Fixes a regression that broke custom searches in 5.16.

- **Datatables error when viewing contact multiple record custom field tab
  containing a file field
  ([dev/core#1186](https://lab.civicrm.org/dev/core/issues/1186):
  [15058](https://github.com/civicrm/civicrm-core/pull/15058) and
  [15055](https://github.com/civicrm/civicrm-core/pull/15055))**

  Fixes a Datatables error when viewing a contact's multiple record custom field
  tab containing a file field because of an uncaught exception and adds a unit
  test.

- **Add pptx to safe file types
  ([dev/core#1190](https://lab.civicrm.org/dev/core/issues/1190):
  [15047](https://github.com/civicrm/civicrm-core/pull/15047))**

  Ensures the file type 'pptx' is included as an uploadable file type.

- **[Report] Fix handling of location type in Reports
  ([14942](https://github.com/civicrm/civicrm-core/pull/14942))**

  Fixes a bug in the processing of the `location_type_id` field for addresses in
  reports. Before this change the array key's name was "is_primary" which led to
  showing the location type as either blank or Home which is generally the label
  for location type id 1.

- **[Export] Convert testGender Export to new test format.
  ([14914](https://github.com/civicrm/civicrm-core/pull/14914))**

  This change ensures that gender labels longer than 16 characters are supported
  when exporting.

- **[EXPORT] Minor fixes to the export form
  ([14785](https://github.com/civicrm/civicrm-core/pull/14785))**

  This improves the export form by only showing enabled contact types and
  only showing relevant relationship types for a given contact type.

- **[IMPORT] [code-quality] Remove instances of CRM_Core_Error::fatal from first
  import form ([14870](https://github.com/civicrm/civicrm-core/pull/14870))**

  Code cleanup towards removing `CRM_Core_Error::fatal` and using
  `CRM_Core_Exception` instead.

- **Translation 'ts' usage fixes.
  ([14971](https://github.com/civicrm/civicrm-core/pull/14971))**

  Fixes how the gettext 'ts' translation function is called reducing the
  number of warnings from the string extraction script.

- **Fix removeNullContactTokens compatibility with custom tokens
  ([14943](https://github.com/civicrm/civicrm-core/pull/14943))**

   Fixes notices and warnings with custom tokens when updating a contact record.

- **Do not launch raw js alert jqueryValidation fails
  ([14854](https://github.com/civicrm/civicrm-core/pull/14854))**

  For sites with Jquery validation turned on disables js alerts.

- **Invalidate smart group cache for group following deletion of group_contact
  row ([14672](https://github.com/civicrm/civicrm-core/pull/14672))**

  Ensures that when a contact is removed from a smart group they are removed
  from the cache instantly.

- **Ensure that if present the HTTP_X_FORWARDED_FOR IP address is used instead
  of the SERVER_ADDR when logging items from the IDS
  ([14833](https://github.com/civicrm/civicrm-core/pull/14833))**

  Ensures the `SERVER_ADDR` is only used if `HTTP_X_FORWARDED_FOR` cannot be.

- **Set profile greeting fields based on actual contact type
  ([14845](https://github.com/civicrm/civicrm-core/pull/14845))**

   Sets greeting options in a profile based on the actual contact type being
   edited instead of based off the profile type.

- **Menubar - Improve flexibility & remove hardcoded values
  ([14839](https://github.com/civicrm/civicrm-core/pull/14839))**

  Minor tweak to crm.menubar.js to make it less reliant on the presence of a
  `<div id="crm-container">` which may not be present on non-civicrm pages. Also
  tweaks the js to remove hardcoded pixel values to work better with theme
  overrides.

- **Use singleton to get session instead of relying on ->_session being set
  elsewhere ([14832](https://github.com/civicrm/civicrm-core/pull/14832))**

  Calls CRM_Core_Session::singleton() on the `CRM_Profile_Form` instead of
  relying on $this->_session being set.

- **Remove the only two defined fonts from selectors
  ([14815](https://github.com/civicrm/civicrm-core/pull/14815))**

  Before this change CiviCRM was setting h3 tags on front end forms to have the
  font arial. After this change h3 tags on front end forms inherit their fonts
  from the theme (like the rest of the h tags).

- **GenCode, Cache::cleanKey() - Fix deploop during clean initialization
  ([14777](https://github.com/civicrm/civicrm-core/pull/14777))**

  Fixes a bug when running `xml/GenCode.php` with a clean codebase with no DAO
  files.

- **e-notice fix & unit test
  ([14729](https://github.com/civicrm/civicrm-core/pull/14729))**

  Fixes an e-notice when a table has been excluded from triggers by a hook.

- **Fatal db error in Activity Summary report when Sorting uses Section Header
  (without ONLY_FULL_GROUP_BY)
  ([dev/core/issues/577](https://lab.civicrm.org/dev/core/issues/577):
  [13540](https://github.com/civicrm/civicrm-core/pull/13540) and
  [dev/core#578](https://lab.civicrm.org/dev/core/issues/578):
  [14745](https://github.com/civicrm/civicrm-core/pull/14745))**

- **With logging turned on editing an activity displays as a deletion
  ([dev/core#1149](https://lab.civicrm.org/dev/core/issues/1149):
  [14889](https://github.com/civicrm/civicrm-core/pull/14889))**

- **Regression: Can't use CiviCRM menu on 5.16.0
  ([dev/core#1182](https://lab.civicrm.org/dev/core/issues/1182):
  [15021](https://github.com/civicrm/civicrm-core/pull/15021))**

- **Add missing is_public flags to public paths
 ([14945](https://github.com/civicrm/civicrm-core/pull/14945))**

- **Fix php7.x warning on count
  ([14896](https://github.com/civicrm/civicrm-core/pull/14896))**

- **Don't let optiongroup check crash
  ([14895](https://github.com/civicrm/civicrm-core/pull/14895))**

- **Fix enotice on formatting credit card details
  ([14750](https://github.com/civicrm/civicrm-core/pull/14750))**

- **Fix obscure bug on updating custom fields (not necessarily hittable via UI)
  ([14754](https://github.com/civicrm/civicrm-core/pull/14754))**

- **MagicMerge - Fix ephemeral overrides for aliased properties
  ([14818](https://github.com/civicrm/civicrm-core/pull/14818))**

- **Current employer disappears when disabling expired relationships
  ([dev/core#470](https://lab.civicrm.org/dev/core/issues/470):
  [14951](https://github.com/civicrm/civicrm-core/pull/14951))**

### CiviCase

- **Case summary report filters incorrectly for case type
  ([dev/core#1118](https://lab.civicrm.org/dev/core/issues/1118):
  [14827](https://github.com/civicrm/civicrm-core/pull/14827))**

  Fixes a bug where applying the case type filter in the case summary report
  resulted in two case types being reported where only one is selected in the
  case type filter.

- **CiviCase singleton activity warning has wrong url
  ([dev/core#1115](https://lab.civicrm.org/dev/core/issues/1115):
  [14824](https://github.com/civicrm/civicrm-core/pull/14824))**

  Fixes a bug where if a case type has an activity type (other than open case)
  with max_instances set to 1 and a user attempted to create a second activity
  of that type for that case type the warning presented to the user would
  contain a broken link to edit the existing activity of that type so that the
  link works as expected.

### CiviContribute

- **[dev/core#1133](https://lab.civicrm.org/dev/core/issues/1133) Payment method
  name is displayed instead of label in payment block for Manual payment
  ([14841](https://github.com/civicrm/civicrm-core/pull/14841))**

  Ensures the Payment method name is displayed instead of label in payment block
  for Manual payment.

- **Bug, cannot import Contributions because the import requires the payment
  method, payment instrument ID, not the payment instrument label
  ([dev/financial#36](https://lab.civicrm.org/dev/financial/issues/36):
  [14881](https://github.com/civicrm/civicrm-core/pull/14881))**

- **Editing a financial account pops up a blank new form
  ([dev/financial#65](https://lab.civicrm.org/dev/financial/issues/65):
  [15037](https://github.com/civicrm/civicrm-core/pull/15037))**

- **Contribution page including 2 email fields does not respect dedupe rule.
  ([dev/core#961](https://lab.civicrm.org/dev/core/issues/961):
  [14252](https://github.com/civicrm/civicrm-core/pull/14252))**

- **Catch Payment Processor Exception if thrown when registering via back office
  participant registration
  ([14930](https://github.com/civicrm/civicrm-core/pull/14930))**

- **Fix creation of additional zero value line item when changing fee selection
  in edge case ([14589](https://github.com/civicrm/civicrm-core/pull/14589))**

### CiviEvent

- **Fixed event type id fetch
  ([14534](https://github.com/civicrm/civicrm-core/pull/14534))**

  Fixes a bug where when using the query search the event type id was being
  returned as the option_value.id instead option_value.value.

- **Participants having multiple roles affects maximum event registration count
  ([dev/core#1135](https://lab.civicrm.org/dev/core/issues/1135):
  [14844](https://github.com/civicrm/civicrm-core/pull/14844))**

  Ensures that Participants having multiple roles does not affect the maximum
  event registration count.

- **Allow duplicate backend registration when event has "allow same participant
  emails" ([dev/event#6](https://lab.civicrm.org/dev/event/issues/6):
  [14884](https://github.com/civicrm/civicrm-core/pull/14884))**

- **Event Cart: does not save participant custom fields on checkout
  ([dev/event#8](https://lab.civicrm.org/dev/event/issues/8):
  [14816](https://github.com/civicrm/civicrm-core/pull/14816))**

- **Event Templates: do not auto-populate the Start Date / End Date
  ([dev/event#9](https://lab.civicrm.org/dev/event/issues/9):
  [14862](https://github.com/civicrm/civicrm-core/pull/14862))**

### CiviMail

- **Unsubscribe broken if mailing sent to previous mailing recipients with an
  excluded group (Work towards
  [dev/core#1108](https://lab.civicrm.org/dev/core/issues/1108):
  [14760](https://github.com/civicrm/civicrm-core/pull/14760) and
  [14761](https://github.com/civicrm/civicrm-core/pull/14761))**

  These changes clean up code to set the stage to fix a bug where the
  unsubscribe link does not work if a mailing is sent to a list of previous
  mailing recipients and excludes a group.

- **Contribution tokens with option values display values, not label
  ([dev/mail#46](https://lab.civicrm.org/dev/mail/issues/46):
  [14658](https://github.com/civicrm/civicrm-core/pull/14658))**

### CiviMembership

- **Scheduled Reminders for Membership not being sent
  ([dev/core#285](https://lab.civicrm.org/dev/core/issues/285):
  [13487](https://github.com/civicrm/civicrm-core/pull/13487) and
  [14810](https://github.com/civicrm/civicrm-core/pull/14810))**

  Fixes a bug where If you setup a scheduled reminder for memberships based on
  the end date, the first reminder would send as expected but if the user
  renewed their membership it wouldn't send out another reminder when the
  condition became true for the new end date.

- **Fix mishandling of renamed membership status labels on membership import
  ([14940](https://github.com/civicrm/civicrm-core/pull/14940))**

  Fixes a bug that especially affects multilingual sites where the 'Membership
  Status' is compared against the 'name' field but not the 'label'.

- **Fix membership end date on confirming a pending contribution
 ([14902](https://github.com/civicrm/civicrm-core/pull/14902))**

  Fixes a bug where if a user created a Membership with a contribution status of
  pending for 2 or more terms, recording a payment for that Contribution would
  lead to the membership end_date being set incorrectly.

### Backdrop Integration

- **Fix getLoginURL() for Backdrop
  ([dev/core#1170](https://lab.civicrm.org/dev/core/issues/1170):
  [14985](https://github.com/civicrm/civicrm-core/pull/14985))**

  Fixes the redirect when an anonymous user goes to `/user` to point to
  `/user/login` instead of `/user?destination...`.

### Drupal Integration

- **confirmation screen shows internal profile name not public title (reg screen
  shows public title)
  ([dev/drupal#72](https://lab.civicrm.org/dev/drupal/issues/72):
  [14960](https://github.com/civicrm/civicrm-core/pull/14960))**

  Fixes a bug whereby the front end profile title was not being used in event
  confirm & thank you screens & confirmation emails.

- **[regression] `cv` fails on CiviCRM 5.15.0
  ([dev/drupal#75](https://lab.civicrm.org/dev/drupal/issues/75):
  [14772](https://github.com/civicrm/civicrm-core/pull/14772))**

  Fixes a call to `languageNegotiationURL` that was causing cv to fail on Drupal
  8 sites.

- **Fail more gracefully when attempting to install on PHP 5.x
  ([dev/drupal#79](https://lab.civicrm.org/dev/drupal/issues/79):
  [15082](https://github.com/civicrm/civicrm-core/pull/15082) and
  [15089](https://github.com/civicrm/civicrm-core/pull/15089))**

  Raises the `MINIMUM_PHP_VERSION` from 5.6 to 7.0 in the metadata because when
  upgrading via drush or Drupal web UI to Civi 5.16+ on PHP 5.6, the Civi
  class-loader fails to initialize.  The installer is also updated to check the
  PHP version before proceeding with the class loader.

- **Migrate CivicrmHelper::parseUrl() to CRM_Utils_System_Drupal8::parseUrl().
  ([14696](https://github.com/civicrm/civicrm-core/pull/14696))**

  Fixes a bug when installing Drupal8 thru the command line.

- **Fix path for civicrm.settings.php when installed in profiles/
  ([552](https://github.com/civicrm/civicrm-drupal/pull/552))**

  Ensures that when CiviCRM is installed in a Drupal distribution profile under
  `profiles/<profile_name>/modules/[contrib]`, the function `civicrm_conf_init()`
  returns the proper path for file civicrm.settings.php before this change
  calling an API using REST would result in a "Could not load the settings
  file..." error.

## <a name="misc"></a>Miscellany

- **Changing a civicase activity's label breaks the max_instances check (Begins
  work towards [dev/core#1116](https://lab.civicrm.org/dev/core/issues/1116):
  [14952](https://github.com/civicrm/civicrm-core/pull/14952) and
  [14970](https://github.com/civicrm/civicrm-core/pull/14970))**

- **Update civicrmtheme module to use new isFrontEndPage function on user System
  ([581](https://github.com/civicrm/civicrm-drupal/pull/581))**

- **Removed hardcoded activity status and used Activity create
  ([14720](https://github.com/civicrm/civicrm-core/pull/14720))**

- **Extract field wrangling to determineReturnProperties
  ([14756](https://github.com/civicrm/civicrm-core/pull/14756))**

- **Finish removing references to Config.IDS.ini
  ([14770](https://github.com/civicrm/civicrm-core/pull/14770))**

- **Convert Navigation cache group to current cache definition system
  ([14581](https://github.com/civicrm/civicrm-core/pull/14581))**

- **Convert the contact fields cache group to standard cache backend
  ([14583](https://github.com/civicrm/civicrm-core/pull/14583) and
  [14582](https://github.com/civicrm/civicrm-core/pull/14582))**

- **Remove additional custom fields deletegroup functions
  ([14823](https://github.com/civicrm/civicrm-core/pull/14823))**

- **Add in Deprecation warnings on Cache functons
  ([14828](https://github.com/civicrm/civicrm-core/pull/14828))**

- **Autoformat /tests directory with php short array syntax
  ([14857](https://github.com/civicrm/civicrm-core/pull/14857))**

- **Remove use of deprecated path in function
  `CRM_Event_BAO_Event::checkPermission()`
  ([14735](https://github.com/civicrm/civicrm-core/pull/14735))**

- **Add in Atomfeeds deprecation now that the extension has a new release with
  converted cache mechanism
  ([14856](https://github.com/civicrm/civicrm-core/pull/14856))**

- **Further deprecate use of $ids array in membership functions
  ([14887](https://github.com/civicrm/civicrm-core/pull/14887))**

- **[IMPORT] reduce php4 support, don't pass by ref when not required
  ([14872](https://github.com/civicrm/civicrm-core/pull/14872))**

- **[IMPORT] [code-quality] Remove usage of nullArray
  ([14869](https://github.com/civicrm/civicrm-core/pull/14869))**

- **[IMPORT] [code quality] [REF] Improve readability of variable assignment
  ([14871](https://github.com/civicrm/civicrm-core/pull/14871))**

- **Remove "Copy Case custom data" code (circa 2013)
  ([15051](https://github.com/civicrm/civicrm-core/pull/15051))**

- **People tagged with “No Bulk Email (User Opt Out)” seem to be receiving bulk
  email (Adds test for
  [dev/core#1162](https://lab.civicrm.org/dev/core/issues/1162):
  [14947](https://github.com/civicrm/civicrm-core/pull/14947))**

- **Remove deprecated SQL_CALC_FOUND_ROWS
  ([dev/core#1141](https://lab.civicrm.org/dev/core/issues/1141):
  [14877](https://github.com/civicrm/civicrm-core/pull/14877))**

- **Remove unused xml/schema/Event/EventPage.xml
  ([dev/core#1056](https://lab.civicrm.org/dev/core/issues/1056):
  [14834](https://github.com/civicrm/civicrm-core/pull/14834))**

- **Errors exporting contributions on 5.13.2 (unit test for
  [dev/core#1015](https://lab.civicrm.org/dev/core/issues/1015):
  [14514](https://github.com/civicrm/civicrm-core/pull/14514))**

- **Minor cleanup around invoicing on event code
  ([14959](https://github.com/civicrm/civicrm-core/pull/14959))**

- **Multilingual test fix and cleanup
  ([14639](https://github.com/civicrm/civicrm-core/pull/14639))**

- **Updated Circle-Interactive developers info
  ([14736](https://github.com/civicrm/civicrm-core/pull/14736))**

- **Remove unused standalone-mode code
  ([14910](https://github.com/civicrm/civicrm-core/pull/14910))**

- **[TEST] [REF] [Export] Convert a couple more tests
  ([14953](https://github.com/civicrm/civicrm-core/pull/14953))**

- **[REF] [Test] [Export] Convert some more tests to use the newer function
  ([14933](https://github.com/civicrm/civicrm-core/pull/14933))**

- **[REF] [Export] [Test] Update 2 more tests to use new helper
  ([14915](https://github.com/civicrm/civicrm-core/pull/14915))**

- **[REF][TEST][EXPORT] minor test cleanup & minor cleanup of code it tests
  ([14848](https://github.com/civicrm/civicrm-core/pull/14848))**

- **[REF] [TEST] [Export] Update export tests to reflect new format
  ([14813](https://github.com/civicrm/civicrm-core/pull/14813))**

- **[REF] [EXPORT] [TLA] Update handling of input fields so that the mapping
  format is accepted.
  ([14792](https://github.com/civicrm/civicrm-core/pull/14792))**

- **[NFC] [REF] [TEST] [EXPORT] Update various export tests to test csv output
  with new functions
  ([14780](https://github.com/civicrm/civicrm-core/pull/14780))**

- **[REf] [Export] Remove deprecated componentPaymentFields function
  ([14874](https://github.com/civicrm/civicrm-core/pull/14874))**

- **[Ref] [Export] Remove exportComponent function - it's not adding much here
  ([14875](https://github.com/civicrm/civicrm-core/pull/14875))**

- **[REF] [Export] Move writeToTable fn to exportProcessor
  ([14932](https://github.com/civicrm/civicrm-core/pull/14932))**

- **[REF] [Export] Stop passing header rows around
  ([14913](https://github.com/civicrm/civicrm-core/pull/14913))**

- **[REF] [Export] Remove now redundant param
  ([14912](https://github.com/civicrm/civicrm-core/pull/14912))**

- **[REF] [EXPORT] Use columns from processor instead of passing them
  ([14860](https://github.com/civicrm/civicrm-core/pull/14860))**

- **[REF] [Export] Move temp table creation function to the processor
  ([14851](https://github.com/civicrm/civicrm-core/pull/14851))**

- **[REF] [Export] Stop passing exportParams & sqlColumns around
  ([14838](https://github.com/civicrm/civicrm-core/pull/14838))**

- **[REF] [Export] remove another confusing parameter
  ([14822](https://github.com/civicrm/civicrm-core/pull/14822))**

- **[REF] [Export] Stop passing export params to the merge function
  ([14819](https://github.com/civicrm/civicrm-core/pull/14819))**

- **[REF] [Export] Simplify setting of address strings
  ([14835](https://github.com/civicrm/civicrm-core/pull/14835))**

- **[REF] [Export] clean up incorporation of order by & group by into
  ExportProcessor
  ([14811](https://github.com/civicrm/civicrm-core/pull/14811))**

- **[REF] [Export] More export Structure arrays to processor
  ([14812](https://github.com/civicrm/civicrm-core/pull/14812))**

- **[REF] [Export] Further  cleanup - construct  sql more concisely
  ([14808](https://github.com/civicrm/civicrm-core/pull/14808))**

- **[REF] [Export] move mergeSameAddress to processor class
  ([14809](https://github.com/civicrm/civicrm-core/pull/14809))**

- **[REF] [Export] further code cleanup
  ([14806](https://github.com/civicrm/civicrm-core/pull/14806))**

- **[REF] [EXPORT] Alter CRM_Export_BAO_Export::exportComponents
  ([14800](https://github.com/civicrm/civicrm-core/pull/14800))**

- **[REF] [Export] move build master copy array to ExportProcessor
  ([14803](https://github.com/civicrm/civicrm-core/pull/14803))**

- **[REF] [Export] Remove code that seems unused
  ([14804](https://github.com/civicrm/civicrm-core/pull/14804))**

- **[REF] [Export] Move setting of household properties to processor
  ([14802](https://github.com/civicrm/civicrm-core/pull/14802))**

- **[REF] [Export] Minor code relocation
  ([14801](https://github.com/civicrm/civicrm-core/pull/14801))**

- **[REF] [Export] Move replace merge tokens to processor class
  ([14799](https://github.com/civicrm/civicrm-core/pull/14799))**

- **[REF] [EXPORT] Stop passing return Properties
  ([14795](https://github.com/civicrm/civicrm-core/pull/14795))**

- **[REF] [Export] Move function that parses tokens to address processor
  ([14797](https://github.com/civicrm/civicrm-core/pull/14797))**

- **[REF] [EXPORT] Minor consolidation of weird mergeSameAddreess nightmare code
  ([14796](https://github.com/civicrm/civicrm-core/pull/14796))**

- **[REF] [EXPORT] cleanup setting of additional postal fields
  ([14790](https://github.com/civicrm/civicrm-core/pull/14790))**

- **[REF][Export] Minor cleanup on household merge properties
  ([14787](https://github.com/civicrm/civicrm-core/pull/14787))**

- **[REF] [EXPORT] partial cleanup on adding fields to returnProperties based on
  usage ([14788](https://github.com/civicrm/civicrm-core/pull/14788))**

- **[REF] [export] remove chunk of non-functional code
  ([14773](https://github.com/civicrm/civicrm-core/pull/14773))**

- **[REF] [export] Cleaner handling of additional return properties
  ([14774](https://github.com/civicrm/civicrm-core/pull/14774))**

- **[ref] [export] [test] Improve csv test to test final output rather than the
  csv ([14779](https://github.com/civicrm/civicrm-core/pull/14779))**

- **[REF] [export] . Move greeting params retrieval to the place in the code
  where it is used
  ([14768](https://github.com/civicrm/civicrm-core/pull/14768))**

- **[REF] [Export] Move fetch Relationship details to processor
  ([14898](https://github.com/civicrm/civicrm-core/pull/14898))**

- **[REF] [Import] extract function that sets field metadata
  ([14979](https://github.com/civicrm/civicrm-core/pull/14979))**

- **[REF][Import]   very minor cleanup - 3 lines of code to one
  ([14976](https://github.com/civicrm/civicrm-core/pull/14976))**

- **[REF][Event]  Extract calculation of 'zero-ness' in form rule
  ([14917](https://github.com/civicrm/civicrm-core/pull/14917))**

- **[REF] extract loadSavedMapping
  ([14873](https://github.com/civicrm/civicrm-core/pull/14873))**

- **[REF] Add in cleanup function to prevnext service and utilise in clea…
  ([14911](https://github.com/civicrm/civicrm-core/pull/14911))**

- **[REF] Update selfService in updateBilling to use shared function
  ([14965](https://github.com/civicrm/civicrm-core/pull/14965))**

- **[REF] remove never-set, mispelt parameter
  ([14907](https://github.com/civicrm/civicrm-core/pull/14907))**

- **[REF] minor code cleanup on import mapping
  ([14962](https://github.com/civicrm/civicrm-core/pull/14962))**

- **[REF] Move Self service handlng to shared function to allow for use i…
  ([14963](https://github.com/civicrm/civicrm-core/pull/14963))**

- **[REF] simple extraction of function to check required fields are present
  ([14961](https://github.com/civicrm/civicrm-core/pull/14961))**

- **[REF] Down with php4 compatibility
  ([14847](https://github.com/civicrm/civicrm-core/pull/14847))**

- **[REF] Convert contribution_recur dates to datepicker from jcalendar
  ([14737](https://github.com/civicrm/civicrm-core/pull/14737))**

- **[REF] initial extraction of loading saved mapping to qf format
  ([14767](https://github.com/civicrm/civicrm-core/pull/14767))**

- **[REF] simplify & add tests on getMappingParams
  ([14769](https://github.com/civicrm/civicrm-core/pull/14769))**

- **[REF] Update export test to new function
  ([14765](https://github.com/civicrm/civicrm-core/pull/14765))**

- **[REF] Extract mapping converter function, kinda brutally
  ([14762](https://github.com/civicrm/civicrm-core/pull/14762))**

- **[REF] export code simplification
  ([14758](https://github.com/civicrm/civicrm-core/pull/14758))**

- **[REF] Extract saveMapping Field
  ([14757](https://github.com/civicrm/civicrm-core/pull/14757))**

- **[REF] Remove call to getMappingFields in favour of api call.
  ([14755](https://github.com/civicrm/civicrm-core/pull/14755))**

- **[REF] un-extract createProportionalFinancialEntities
  ([14742](https://github.com/civicrm/civicrm-core/pull/14742))**

- **[REF] Move function onto the processor class
  ([14752](https://github.com/civicrm/civicrm-core/pull/14752))**

- **[REF] Further cleanup & extraction in getMappingFieds
  ([14743](https://github.com/civicrm/civicrm-core/pull/14743))**

- **[REF] Simple function extraction for buildMappingForm
  ([14741](https://github.com/civicrm/civicrm-core/pull/14741))**

- **[REF] simple extraction of getFieldAlterSQL
  ([14727](https://github.com/civicrm/civicrm-core/pull/14727))**

- **[REF] extract portion that creates the custom field record
  ([14725](https://github.com/civicrm/civicrm-core/pull/14725))**

- **[REF] simple extraction of prepareCreateParams
  ([14726](https://github.com/civicrm/civicrm-core/pull/14726))**

- **[REF] Cleanup fixSchemaDifferencesFor()
  ([14697](https://github.com/civicrm/civicrm-core/pull/14697))**

- **[REF] clarify  variable (very minor change with good test cover)
  ([14724](https://github.com/civicrm/civicrm-core/pull/14724))**

- **[REF] Extract CRM_Core_BAO_Mapping::addComponentFields
  ([14751](https://github.com/civicrm/civicrm-core/pull/14751))**

- **REF Simple cleanup of tabset code for contributionpages
  ([14616](https://github.com/civicrm/civicrm-core/pull/14616))**

- **[REF] final cleanup - call bulkCreate from migrate_utils
  ([14728](https://github.com/civicrm/civicrm-core/pull/14728))**

- **[REF] Cleanup up handling of dates for Recurring & Contribution date fields
  in query class ([14825](https://github.com/civicrm/civicrm-core/pull/14825))**

- **[REF] Cleanup usage of CRM_Core_BAO_PrevNextCache::setItem and deprec…
  ([14675](https://github.com/civicrm/civicrm-core/pull/14675))**

- **[REF] [Test] Add test to cover handling of 'gender_id' on import, remove
  unused code. ([14879](https://github.com/civicrm/civicrm-core/pull/14879))**

- **[REF] [TEST] cleanup on export activity test
  ([14850](https://github.com/civicrm/civicrm-core/pull/14850))**

- **[test] Catch A.net exception & ignore
  ([14861](https://github.com/civicrm/civicrm-core/pull/14861))**

- **[Test] [Import] Add test to demonstrate bug that turns out not to exist
  ([14880](https://github.com/civicrm/civicrm-core/pull/14880))**

- **Add test for failed payment
  ([14946](https://github.com/civicrm/civicrm-core/pull/14946))**

- **Add unit test demonstrating attaching a listener to queries
  ([14716](https://github.com/civicrm/civicrm-core/pull/14716))**

- **[Test] Add test cover for Member_BAO_Query auto_renew field
  ([14956](https://github.com/civicrm/civicrm-core/pull/14956))**

- **Add unit test for net_amount when fee_amount is set
  ([14909](https://github.com/civicrm/civicrm-core/pull/14909))**

- **Fix some test leakage
  ([14731](https://github.com/civicrm/civicrm-core/pull/14731))**

- **[TEST] export - add unit test covering merge to same address addressee
  handling ([14817](https://github.com/civicrm/civicrm-core/pull/14817))**

- **[TEST][EXPORT] Improve unit test on export.
  ([14793](https://github.com/civicrm/civicrm-core/pull/14793))**

- **[NFC] [TEST] Reformat arrays in test classes
  ([14831](https://github.com/civicrm/civicrm-core/pull/14831))**

- **[NFC] [TEST] code formatting in test class
  ([14849](https://github.com/civicrm/civicrm-core/pull/14849))**

- **[NFC] reformat class
  ([14899](https://github.com/civicrm/civicrm-core/pull/14899))**

- **[NFC] Formatting in BAO_Relationship class
  ([14949](https://github.com/civicrm/civicrm-core/pull/14949))**

- **[NFC] code formatting only
  ([14977](https://github.com/civicrm/civicrm-core/pull/14977))**

- **[NFC] minor cleanup
  ([14957](https://github.com/civicrm/civicrm-core/pull/14957))**

- **NFC Update node module versions based on npm audit fix
  ([14859](https://github.com/civicrm/civicrm-core/pull/14859))**

- **(NFC) Fixing documentation links in readme.
  ([14855](https://github.com/civicrm/civicrm-core/pull/14855))**

- **[NFC] code reformatting
  ([14853](https://github.com/civicrm/civicrm-core/pull/14853))**

- **(NFC) VERSIONS.php - Add discussion about how to migrate to composer
  ([261](https://github.com/civicrm/civicrm-packages/pull/261))**

- **[NFC] comment fixes, function mis-casing fix
  ([14906](https://github.com/civicrm/civicrm-core/pull/14906))**

- **[NFC] comment
  fixes([15197](https://github.com/civicrm/civicrm-core/pull/15197))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt, Eli Lisseck; Agileware - Alok Patel, Justin
Freeman; Australian Greens - Seamus Lee; Circle Interactive - Dave Jenkins, Kirk
Jackson, Pradeep Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; Coop SymbioTIC - Mathieu Lutfy; Dave D; Deepak Srivastava; Electronic
Frontier Foundation - Mark Burdett; Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit; Giant Rabbit - Peter Haight; Greenpeace CEE - Patrick
Figel; iXiam - Luciano Spiegel; JMA Consulting - Monish Deb; John Kingsnorth;
Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; MillerTech - Chamil Wijesooriya; MJCO - Mikey
O'Toole; MJW Consulting - Matthew Wire; Nicol Wistreich; OSSeed Technologies
LLP - Sushant Paste; Squiffle Consulting - Aidan Saunders; Wikimedia Foundation -
Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; CiviCoop - Jaap
Jansma; CiviDesk - Nicolas Ganivet; CompuCorp - Alessandro Verdura; Fuzion -
Luke Stewart; Joseph Lacey; Richard van Oosterhout; Ryan L. Robinson; Skvare -
Mark Hanna; Tadpole Collective - Kevin Cristiano;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
