/**
 * @file run.c
 * Program execution primitives
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  1994-1996 Marko Mkel and Olaf Seibert
 * Copyright  2001 Marko Mkel
 * Original Linux and Commodore 64/128/Vic-20 version by Marko Mkel
 * Ported to the PET and the Amiga series by Olaf Seibert
 * Restructured by Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "comm.h"
#include "info.h"

/** execute a BASIC program
 * @param comm		the communication primitives
 * @return		zero on success, nonzero on error
 */
int
run (const struct comm* comm)
{
  char req = REQ_RUN;
  return (*comm->comm_write) (&req, 1);
}

/** execute a machine language program
 * @param comm		the communication primitives
 * @param bank		memory bank (0=normal)
 * @param addr		execution address
 * @return		zero on success, nonzero on error
 */
int
jump (const struct comm* comm,
      unsigned bank, unsigned addr)
{
  char req[4];
  req[0] = REQ_JUMP;
  req[1] = bank;
  req[2] = addr;
  req[3] = addr >> 8;
  return (*comm->comm_write) (req, sizeof req);
}
