;;; $1000/$1003 interrupt based music player for the Commodore 64.
;;; Copyright  1996,2001,2002 Marko Mkel (msmakela@nic.funet.fi)
;;; /* Last essential modification: 16th March, 1996. */
;;; Converted from DASM to XA syntax in 2002.

;;; /* Usage: cbmlink ... -l playtune.prg -l musicfile.prg -j,0xc800 */
;;; When loading another tune, the -l playtune.prg can be omitted.
;;; Please note that the start address of the server ($cc00 or 52224)
;;; is hardcoded at the start of this program.

;;; Video chip parameters for setting the interrupt rate
CYCLES = 63
	;; 6567R56A	64 (a very old NTSC-M chip)
	;; 6567R8	65 (newer NTSC-M chips)
	;; 6569		63 (all PAL-B chips)
LINES = 312
	;; 6567R56A	262 (a very old NTSC-M chip)
	;; 6567R8	263 (newer NTSC-M chips)
	;; 6569		312 (all PAL-B chips)

	.text
	.word $c800
	*=$c800

	jsr $cc00		; reinstall the cbmlink server
	sei
	lda $314		; save the old IRQ vector (cbmlink server)
	ldx $315
	sta oldirq
	stx oldirq+1

	lda #<irq		; install the IRQ routine
	ldx #>irq
	sta $314
	stx $315

	lda #<(CYCLES*LINES-1)	; adjust the timers to sync with the screen
	ldx #>(CYCLES*LINES-1)
	sta $dc04
	stx $dc05
	lda #0
	jsr $1000		; initialize the music
	jmp $ea81		; return to the system

irq:	inc $d020		; alter the border color to measure time
	jsr $1003		; play the music in the IRQ routine
	dec $d020		; restore the border color
oldirq = * + 1
	jmp *			; self-modified return address to original IRQ
