;;; @file x1541.s
;;; Transfer routines for the Commodore serial bus
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#define initcable
	;; deinitialize the cable
#define deinitcable
	;; determine whether a request is pending
	;; by raising CLK and DATA and testing if both are low
#define isrequest \
	lda iecport1:and #255-clko-dato:sta iecport1:\
	lda iecport2:and #clki|dati:bne return

	; .A = data, .Y = 00, .X preserved
receive_switch:
rereceive:
	lda #clki|dati	; wait for CLK==DATA==low
	.(:wait bit iecport2:bne wait:.)
	.(
wait	lda #clko
	ora iecport1
	sta iecport1	; drop CLK
	and #255 - clko
	sta iecport1	; raise CLK
	lda iecport2
	and #clki | dati
	eor #dati
	bne wait	; repeat until CLK==low && DATA==high
	.)

	lda #dato
	ora iecport1
	sta iecport1	; drop DATA
	lda #clki	; wait for CLK==high
	.(:wait bit iecport2:beq wait:.)

	lda #255 - dato
	and iecport1
	sta iecport1	; raise DATA

receive:
	ldy #8	; get 8 bits
	.(
loop	lda iecport2
	and #dati | clki
	eor #dati | clki
	beq loop	; wait for CLK==low || DATA==low
#if dati = 128
	asl		; Carry = DATA==low
#else
#if dati < clki
	and #dati
#endif
	cmp #dati
#endif

	lda iecport1
	and #255 - dato - clko
	eor #clko
	bcs skip
	eor #dato | clko
skip	sta iecport1	; acknowledge the bit
	ror stemp	; store the data

	lda #dati | clki
getack	bit iecport2
	beq getack	; wait for CLK==high || DATA==high

	lda iecport1
	and #255 - clko - dato
	sta iecport1	; raise CLK and DATA
	dey
	bne loop	; loop until all bits are sent
	.)
	lda stemp
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
	tay
	.(
waitclk	lda iecport1
	ora #clko | dato
	sta iecport1	; drop CLK and DATA
	and #255 - clko - dato
	sta iecport1	; raise CLK and DATA
	lda iecport2
	and #clki	; repeat until CLK==low
	bne waitclk
	.)

	lda iecport1
	ora #clko
	sta iecport1	; drop CLK
	lda #dati	; wait for DATA==low
	.(:wait bit iecport2:bne wait:.)
	lda iecport1
	and #255 - clko
	sta iecport1	; raise CLK
	lda #dati	; wait for DATA==high
	.(:wait bit iecport2:beq wait:.)
	tya

send:
	sta stemp
	ldy #8	; send 8 bits
	.(
loop	lsr stemp	; read a bit
	lda iecport1
	and #255 - dato - clko
	eor #clko
	bcc skip
	eor #dato | clko
skip	sta iecport1	; send the data

	lda #dati | clki
getack	bit iecport2
	bne getack	; wait for CLK==DATA==low

	lda #255 - clko - dato
	and iecport1
	sta iecport1	; set DATA=CLK=high
putack	lda iecport2
	and #dati | clki
	eor #dati | clki
	bne putack	; wait for CLK==DATA==high
	dey
	bne loop	; loop until all bits are sent
	.)
	rts
