;;; @file c2n.s
;;; Commodore C2N tape header for the file server
;;; @author Marko Mkel (msmakela@nic.funet.fi)

#include "cable_.s"
	;; clear the Y register if needed
#if y_unmod_r			; does the receive routine leave .Y alone?
#define LDY0R ldy #0
#else
#define LDY0R
#endif

#include "host.s"
#include "mem.s"

	.text
	*=0
#if host = 201 || host = 202 || host = 203
	.byte 1
#else
	.byte 3
#endif
	.word serverstart
	.word serverend
	.byte "CBMLINK SYS"
#if serverstart / 10000
	.byte $30 + (serverstart / 10000)
#endif
#if serverstart / 1000
	.byte $30 + ((serverstart - (serverstart / 10000 * 10000)) / 1000)
#endif
#if serverstart / 100
	.byte $30 + ((serverstart - (serverstart / 1000 * 1000)) / 100)
#endif
#if serverstart / 10
	.byte $30 + ((serverstart - (serverstart / 100 * 100)) / 10)
#endif
	.byte $30 + (serverstart - (serverstart / 10 * 10))

	.dsb 192-*, $20

	*=serverstart

#include "main.s"
serverend
