#!/bin/sh

## Compile the cbmlink server programs

## Output directory for the programs
: ${PRGDIR="../cbmprg"}
## Output directory for the Commodore tape files
: ${C2NDIR="../cbmc2n"}

set -eu
<&-

## Function to execute critical commands
perform() { eval "$@" || exit $?; }
#perform() { echo "$@" >&2; eval "$@" || exit $?; }

## Function to build binaries for the specified cable and target
build() {
    host="$1"
    mem="$2"
    shift 2
    while { cable="${1:-}"; shift; }
    do
	[ -d "$PRGDIR/$cable" ] || perform mkdir "$PRGDIR/$cable"
	[ -d "$PRGDIR/$cable/$host" ] || perform mkdir "$PRGDIR/$cable/$host"
	perform xa server.s \
-Ihost/"$host" -Ihost -Imem/"$mem" -Imem -Icable/"$cable" -Icable
	cmp -s a.o65 "$PRGDIR/$cable/$host/$mem".prg || \
	    mv a.o65 "$PRGDIR/$cable/$host/$mem".prg
    done
}

## Function to build binaries for the C2N232 device and the specified target
buildc2n() {
    mem="$1"
    shift
    while { host="${1:-}"; shift; }
    do
	[ -d "$C2NDIR/$host" ] || perform mkdir "$C2NDIR/$host"
	perform xa c2n.s \
-Ihost/"$host" -Ihost -Imem/"$mem" -Imem -Icable/c2n232 -Icable
	cmp -s a.o65 "$C2NDIR/$host/$mem".c2n || \
	    mv a.o65 "$C2NDIR/$host/$mem".c2n
    done
}

[ -d "$PRGDIR" ] || perform mkdir "$PRGDIR"
[ -d "$C2NDIR" ] || perform mkdir "$C2NDIR"

# Build the PET and VIC-20 binaries
for h in pet3001 pet4001 vic20
do
    build $h plain c2n232 pc64 kontros prlink88 prlink48 transnib c64net
done
build vic20 plain x1541
# Build the PET binaries for cassette port #2
build pet3001 port2 c2n232
build pet4001 port2 c2n232
# Build the VIC-20 binaries for the auto-start cartridge area ($a000)
build vic20 cart c2n232 pc64 kontros prlink88 prlink48 transnib c64net x1541

# Build the C64 and C128 binaries
for h in c64 c128
do
    for m in plain pia reu piareu
    do
	build $h $m c2n232 serial pc64 kontros prlink88 prlink48 transnib \
		c64net x1541
    done
done

# Build the 264 series binaries (c16, c116, plus/4)
build c264 plain c2n232 serial x1541
# Build the PET II series binaries (510/P500, 610/710/B-128, 620/720/B-256)
build p500 plain c2n232 serial
build b128 plain c2n232 serial
build b256 plain c2n232 serial

# Build the C2N232 binaries
buildc2n plain pet3001 pet4001 vic20 c64 c128 c264 #p500 b128 b256
buildc2n port2 pet3001 pet4001
buildc2n cart vic20
buildc2n pia c64 c128
buildc2n reu c64 c128
buildc2n piareu c64 c128
[ -f a.o65 ] || rm -f a.o65
