/* uuid.c generated by valac 0.32.1, the Vala compiler
 * generated from uuid.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <uuid.h>


#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())

typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;



GType uuid_uuid_flags_get_type (void) G_GNUC_CONST;
gchar* uuid_new (LibUUIDUUIDFlags flags);


GType uuid_uuid_flags_get_type (void) {
	static volatile gsize uuid_uuid_flags_type_id__volatile = 0;
	if (g_once_init_enter (&uuid_uuid_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{UUID_UUID_FLAGS_LOWER_CASE, "UUID_UUID_FLAGS_LOWER_CASE", "lower-case"}, {UUID_UUID_FLAGS_UPPER_CASE, "UUID_UUID_FLAGS_UPPER_CASE", "upper-case"}, {UUID_UUID_FLAGS_DEFAULT_CASE, "UUID_UUID_FLAGS_DEFAULT_CASE", "default-case"}, {UUID_UUID_FLAGS_RANDOM_TYPE, "UUID_UUID_FLAGS_RANDOM_TYPE", "random-type"}, {UUID_UUID_FLAGS_DEFAULT_TYPE, "UUID_UUID_FLAGS_DEFAULT_TYPE", "default-type"}, {UUID_UUID_FLAGS_TIME_TYPE, "UUID_UUID_FLAGS_TIME_TYPE", "time-type"}, {UUID_UUID_FLAGS_TIME_SAFE_TYPE, "UUID_UUID_FLAGS_TIME_SAFE_TYPE", "time-safe-type"}, {0, NULL, NULL}};
		GType uuid_uuid_flags_type_id;
		uuid_uuid_flags_type_id = g_enum_register_static ("LibUUIDUUIDFlags", values);
		g_once_init_leave (&uuid_uuid_flags_type_id__volatile, uuid_uuid_flags_type_id);
	}
	return uuid_uuid_flags_type_id__volatile;
}


gchar* uuid_new (LibUUIDUUIDFlags flags) {
	gchar* result = NULL;
	guint8 time[16] = {0};
	gchar uuid[37] = {0};
	LibUUIDUUIDFlags _tmp0_ = 0;
	LibUUIDUUIDFlags _tmp3_ = 0;
	gchar* _tmp5_ = NULL;
	_tmp0_ = flags;
	if ((_tmp0_ & UUID_UUID_FLAGS_RANDOM_TYPE) != 0) {
		uuid_generate_random (time);
	} else {
		LibUUIDUUIDFlags _tmp1_ = 0;
		_tmp1_ = flags;
		if ((_tmp1_ & UUID_UUID_FLAGS_TIME_TYPE) != 0) {
			uuid_generate_time (time);
		} else {
			LibUUIDUUIDFlags _tmp2_ = 0;
			_tmp2_ = flags;
			if ((_tmp2_ & UUID_UUID_FLAGS_TIME_SAFE_TYPE) != 0) {
				uuid_generate_time_safe (time);
			} else {
				uuid_generate (time);
			}
		}
	}
	_tmp3_ = flags;
	if ((_tmp3_ & UUID_UUID_FLAGS_UPPER_CASE) != 0) {
		uuid_unparse_upper (time, uuid);
	} else {
		LibUUIDUUIDFlags _tmp4_ = 0;
		_tmp4_ = flags;
		if ((_tmp4_ & UUID_UUID_FLAGS_LOWER_CASE) != 0) {
			uuid_unparse_lower (time, uuid);
		} else {
			uuid_unparse (time, uuid);
		}
	}
	_tmp5_ = g_strdup ((const gchar*) uuid);
	result = _tmp5_;
	return result;
}



