/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.Access;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.Annotatable;
import org.codehaus.janino.util.ClassFile;

public class UnitCompiler {
    private static final Logger LOGGER = Logger.getLogger(UnitCompiler.class.getName());
    private static final int STRING_CONCAT_LIMIT = 3;
    public static final boolean JUMP_IF_TRUE = true;
    public static final boolean JUMP_IF_FALSE = false;
    private static final Pattern LOOKS_LIKE_TYPE_PARAMETER = Pattern.compile("\\p{javaUpperCase}+");
    public static final Object NOT_CONSTANT = IClass.NOT_CONSTANT;
    private static final Pattern TWO_E_31_INTEGER = Pattern.compile("2147483648|0+20000000000|0b0*10{31}", 2);
    private static final Pattern TWO_E_63_LONG = Pattern.compile("9223372036854775808L|0+10{21}L|0b0*10{63}L", 2);
    @Nullable
    private Map<String, String[]> singleTypeImports;
    @Nullable
    private Collection<String[]> typeImportsOnDemand;
    private final Map<String, IClass> onDemandImportableTypes = new HashMap<String, IClass>();
    private static final Map<String, byte[]> PRIMITIVE_WIDENING_CONVERSIONS = new HashMap<String, byte[]>();
    private static final Map<String, byte[]> PRIMITIVE_NARROWING_CONVERSIONS;
    @Nullable
    private CodeContext codeContext;
    @Nullable
    private ErrorHandler optionalCompileErrorHandler;
    private int compileErrorCount;
    @Nullable
    private WarningHandler optionalWarningHandler;
    private final Java.CompilationUnit compilationUnit;
    private final IClassLoader iClassLoader;
    @Nullable
    private List<ClassFile> generatedClassFiles;
    private boolean debugSource;
    private boolean debugLines;
    private boolean debugVars;
    private final Map<String, List<Object>> singleStaticImports = new HashMap<String, List<Object>>();
    private final Collection<IClass> staticImportsOnDemand = new ArrayList<IClass>();

    public UnitCompiler(Java.CompilationUnit compilationUnit, IClassLoader iClassLoader) {
        this.compilationUnit = compilationUnit;
        this.iClassLoader = iClassLoader;
    }

    public Java.CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    private void import2(Java.CompilationUnit.SingleStaticImportDeclaration ssid) throws CompileException {
        IClass iClass;
        String name = UnitCompiler.last(ssid.identifiers);
        List<Object> importedObjects = this.singleStaticImports.get(name);
        if (importedObjects == null) {
            importedObjects = new ArrayList<Object>();
            this.singleStaticImports.put(name, importedObjects);
        }
        if ((iClass = this.findTypeByFullyQualifiedName(ssid.getLocation(), ssid.identifiers)) != null) {
            importedObjects.add(iClass);
            return;
        }
        Object[] typeName = UnitCompiler.allButLast(ssid.identifiers);
        IClass iClass2 = this.findTypeByFullyQualifiedName(ssid.getLocation(), (String[])typeName);
        if (iClass2 == null) {
            this.compileError("Could not load \"" + Java.join(typeName, ".") + "\"", ssid.getLocation());
            return;
        }
        IClass.IField iField = iClass2.getDeclaredIField(name);
        if (iField != null) {
            if (!iField.isStatic()) {
                this.compileError("Field \"" + name + "\" of \"" + Java.join(typeName, ".") + "\" must be static", ssid.getLocation());
            }
            importedObjects.add(iField);
            return;
        }
        IClass.IMethod[] ms = iClass2.getDeclaredIMethods(name);
        if (ms.length > 0) {
            importedObjects.addAll(Arrays.asList(ms));
            return;
        }
        this.compileError("\"" + Java.join(typeName, ".") + "\" has no static member \"" + name + "\"", ssid.getLocation());
    }

    private void import2(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) throws CompileException {
        IClass iClass = this.findTypeByFullyQualifiedName(siodd.getLocation(), siodd.identifiers);
        if (iClass == null) {
            this.compileError("Could not load \"" + Java.join(siodd.identifiers, ".") + "\"", siodd.getLocation());
            return;
        }
        this.staticImportsOnDemand.add(iClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile[] compileUnit(boolean debugSource, boolean debugLines, boolean debugVars) throws CompileException {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
        for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
            id.accept(new Visitor.ImportVisitor<Void, CompileException>(){

                @Override
                @Nullable
                public Void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                    return null;
                }

                @Override
                @Nullable
                public Void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                    return null;
                }

                @Override
                @Nullable
                public Void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) throws CompileException {
                    UnitCompiler.this.import2(ssid);
                    return null;
                }

                @Override
                @Nullable
                public Void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) throws CompileException {
                    UnitCompiler.this.import2(siodd);
                    return null;
                }
            });
        }
        if (this.generatedClassFiles != null) {
            throw new IllegalStateException("\"UnitCompiler.compileUnit()\" is not reentrant");
        }
        this.generatedClassFiles = new ArrayList<ClassFile>();
        ArrayList<ClassFile> gcfs = this.generatedClassFiles;
        try {
            for (Java.PackageMemberTypeDeclaration pmtd : this.compilationUnit.packageMemberTypeDeclarations) {
                try {
                    this.compile(pmtd);
                }
                catch (ClassFile.ClassFileException cfe) {
                    throw new CompileException(cfe.getMessage(), pmtd.getLocation(), (Throwable)cfe);
                }
                catch (RuntimeException re) {
                    throw new RuntimeException("Compiling \"" + pmtd + "\": " + re.getMessage(), re);
                }
            }
            if (this.compileErrorCount > 0) {
                throw new CompileException(this.compileErrorCount + " error(s) while compiling unit \"" + this.compilationUnit.optionalFileName + "\"", null);
            }
            ClassFile[] classFileArray = gcfs.toArray(new ClassFile[gcfs.size()]);
            return classFileArray;
        }
        finally {
            this.generatedClassFiles = null;
        }
    }

    private void compile(Java.TypeDeclaration td) throws CompileException {
        td.accept(new Visitor.TypeDeclarationVisitor<Void, CompileException>(){

            @Override
            @Nullable
            public Void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration acd) throws CompileException {
                UnitCompiler.this.compile2(acd);
                return null;
            }

            @Override
            @Nullable
            public Void visitLocalClassDeclaration(Java.LocalClassDeclaration lcd) throws CompileException {
                UnitCompiler.this.compile2(lcd);
                return null;
            }

            @Override
            @Nullable
            public Void visitPackageMemberClassDeclaration(Java.AbstractPackageMemberClassDeclaration apmcd) throws CompileException {
                UnitCompiler.this.compile2(apmcd);
                return null;
            }

            @Override
            @Nullable
            public Void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration mid) throws CompileException {
                UnitCompiler.this.compile2(mid);
                return null;
            }

            @Override
            @Nullable
            public Void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration pmid) throws CompileException {
                UnitCompiler.this.compile2(pmid);
                return null;
            }

            @Override
            @Nullable
            public Void visitMemberClassDeclaration(Java.MemberClassDeclaration mcd) throws CompileException {
                UnitCompiler.this.compile2(mcd);
                return null;
            }

            @Override
            @Nullable
            public Void visitEnumConstant(Java.EnumConstant ec) throws CompileException {
                UnitCompiler.this.compileError("Compilation of enum constant NYI", ec.getLocation());
                return null;
            }

            @Override
            @Nullable
            public Void visitMemberEnumDeclaration(Java.MemberEnumDeclaration med) throws CompileException {
                UnitCompiler.this.compile2(med);
                return null;
            }

            @Override
            @Nullable
            public Void visitPackageMemberEnumDeclaration(Java.PackageMemberEnumDeclaration pmed) throws CompileException {
                UnitCompiler.this.compile2(pmed);
                return null;
            }

            @Override
            @Nullable
            public Void visitMemberAnnotationTypeDeclaration(Java.MemberAnnotationTypeDeclaration matd) throws CompileException {
                UnitCompiler.this.compileError("Compilation of member annotation type declaration NYI", matd.getLocation());
                return null;
            }

            @Override
            @Nullable
            public Void visitPackageMemberAnnotationTypeDeclaration(Java.PackageMemberAnnotationTypeDeclaration pmatd) throws CompileException {
                UnitCompiler.this.compile2(pmatd);
                return null;
            }
        });
    }

    private void compile2(Java.PackageMemberTypeDeclaration pmtd) throws CompileException {
        Java.PackageMemberTypeDeclaration otherPmtd;
        Java.CompilationUnit declaringCompilationUnit = pmtd.getDeclaringCompilationUnit();
        Object[] ss = this.getSingleTypeImport(pmtd.getName(), pmtd.getLocation());
        if (ss != null) {
            this.compileError("Package member type declaration \"" + pmtd.getName() + "\" conflicts with single-type-import \"" + Java.join(ss, ".") + "\"", pmtd.getLocation());
        }
        if ((otherPmtd = declaringCompilationUnit.getPackageMemberTypeDeclaration(pmtd.getName())) != null && otherPmtd != pmtd) {
            this.compileError("Redeclaration of type \"" + pmtd.getName() + "\", previously declared in " + otherPmtd.getLocation(), pmtd.getLocation());
        }
        if (pmtd instanceof Java.PackageMemberClassDeclaration) {
            this.compile2((Java.NamedClassDeclaration)((Object)pmtd));
        } else if (pmtd instanceof Java.EnumDeclaration) {
            this.compile2((Java.NamedClassDeclaration)((Object)pmtd));
        } else if (pmtd instanceof Java.InterfaceDeclaration) {
            this.compile2((Java.InterfaceDeclaration)((Object)pmtd));
        } else {
            throw new JaninoRuntimeException("PMTD of unexpected type " + pmtd.getClass().getName());
        }
    }

    private void compile2(Java.AbstractClassDeclaration cd) throws CompileException {
        Java.ConstructorDeclarator[] ctords;
        Object ed2;
        IClass iClass = this.resolve(cd);
        if (!Mod.isAbstract(cd.getModifierFlags())) {
            IClass.IMethod[] ms;
            for (IClass.IMethod base : ms = iClass.getIMethods()) {
                IClass.IMethod override;
                if (!base.isAbstract() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) != null && !override.isAbstract() && base.getReturnType().isAssignableFrom(override.getReturnType())) continue;
                this.compileError("Non-abstract class \"" + iClass + "\" must implement method \"" + base + "\"", cd.getLocation());
            }
        }
        IClass superclass = iClass.getSuperclass();
        ClassFile cf = new ClassFile((short)(cd.getModifierFlags() | 0x20), iClass.getDescriptor(), superclass != null ? superclass.getDescriptor() : null, IClass.getDescriptors(iClass.getInterfaces()));
        this.compileAnnotations(cd.getAnnotations(), cf, cf);
        if (!(cd.getEnclosingScope() instanceof Java.CompilationUnit)) {
            if (cd.getEnclosingScope() instanceof Java.Block) {
                short innerNameIndex;
                short innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short s = innerNameIndex = this instanceof Java.NamedTypeDeclaration ? cf.addConstantUtf8Info(((Java.NamedTypeDeclaration)((Object)this)).getName()) : (short)0;
                assert (cd.getAnnotations().length == 0) : "NYI";
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, 0, innerNameIndex, cd.getModifierFlags()));
            } else if (cd.getEnclosingScope() instanceof Java.TypeDeclaration) {
                short innerClassInfoIndex = cf.addConstantClassInfo(iClass.getDescriptor());
                short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve((Java.TypeDeclaration)cd.getEnclosingScope()).getDescriptor());
                short innerNameIndex = cf.addConstantUtf8Info(((Java.MemberTypeDeclaration)((Object)cd)).getName());
                assert (cd.getAnnotations().length == 0) : "NYI";
                cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, cd.getModifierFlags()));
            }
        }
        if (this.debugSource) {
            String s = cd.getLocation().getFileName();
            String sourceFileName = s != null ? new File(s).getName() : (cd instanceof Java.NamedTypeDeclaration ? ((Java.NamedTypeDeclaration)((Object)cd)).getName() + ".java" : "ANONYMOUS.java");
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (cd instanceof Java.DocCommentable && ((Java.DocCommentable)((Object)cd)).hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        ArrayList<Java.BlockStatement> classInitializationStatements = new ArrayList<Java.BlockStatement>();
        if (cd instanceof Java.EnumDeclaration) {
            Java.EnumDeclaration ed2 = (Java.EnumDeclaration)((Object)cd);
            for (Java.EnumConstant ec : ed2.getConstants()) {
                Java.VariableDeclarator variableDeclarator = new Java.VariableDeclarator(ec.getLocation(), ec.name, 0, new Java.NewClassInstance(ec.getLocation(), null, iClass, ec.optionalArguments != null ? ec.optionalArguments : new Java.Rvalue[]{}));
                Java.FieldDeclaration fd = new Java.FieldDeclaration(ec.getLocation(), ec.getDocComment(), new Java.Modifiers(25), new Java.SimpleType(ec.getLocation(), iClass), new Java.VariableDeclarator[]{variableDeclarator});
                fd.setDeclaringType(ed2);
                classInitializationStatements.add(fd);
                this.addFields(fd, cf);
            }
            Location loc = ed2.getLocation();
            IClass enumIClass = this.resolve(ed2);
            Java.FieldDeclaration fd = new Java.FieldDeclaration(loc, null, new Java.Modifiers(26), new Java.SimpleType(loc, enumIClass), new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, "ENUM$VALUES", 1, new Java.NewArray(loc, new Java.SimpleType(loc, enumIClass), new Java.Rvalue[]{new Java.IntegerLiteral(loc, String.valueOf(ed2.getConstants().size()))}, 0))});
            ((Java.AbstractClassDeclaration)((Object)ed2)).addFieldDeclaration(fd);
        }
        for (Java.BlockStatement vdoi : cd.variableDeclaratorsAndInitializers) {
            if (!((Java.TypeBodyDeclaration)((Object)vdoi)).isStatic()) continue;
            classInitializationStatements.add(vdoi);
        }
        if (cd instanceof Java.EnumDeclaration) {
            ed2 = (Java.EnumDeclaration)((Object)cd);
            IClass enumIClass = this.resolve((Java.TypeDeclaration)ed2);
            int index = 0;
            for (Java.EnumConstant ec : ed2.getConstants()) {
                classInitializationStatements.add(new Java.ExpressionStatement(new Java.Assignment(ec.getLocation(), new Java.ArrayAccessExpression(ec.getLocation(), new Java.FieldAccessExpression(ec.getLocation(), new Java.SimpleType(ec.getLocation(), enumIClass), "ENUM$VALUES"), new Java.IntegerLiteral(ec.getLocation(), String.valueOf(index++))), "=", new Java.FieldAccessExpression(ec.getLocation(), new Java.SimpleType(ec.getLocation(), enumIClass), ec.name))));
            }
        }
        this.maybeCreateInitMethod(cd, cf, classInitializationStatements);
        if (cd instanceof Java.EnumDeclaration) {
            ed2 = (Java.EnumDeclaration)((Object)cd);
            Location loc = ed2.getLocation();
            int numberOfEnumConstants = ed2.getConstants().size();
            IClass enumIClass = this.resolve((Java.TypeDeclaration)ed2);
            Java.VariableDeclarator vd = new Java.VariableDeclarator(loc, "tmp", 0, new Java.NewArray(loc, new Java.SimpleType(loc, enumIClass), new Java.Rvalue[]{new Java.IntegerLiteral(loc, String.valueOf(numberOfEnumConstants))}, 0));
            Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(loc, new Java.Modifiers(), new Java.SimpleType(loc, enumIClass.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object)), new Java.VariableDeclarator[]{vd});
            Java.MethodDeclarator md = new Java.MethodDeclarator(loc, null, new Java.Modifiers(9), null, new Java.ArrayType(new Java.SimpleType(loc, enumIClass)), "values", new Java.FunctionDeclarator.FormalParameters(loc), new Java.Type[0], Arrays.asList(lvds, new Java.ExpressionStatement(new Java.MethodInvocation(loc, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_System), "arraycopy", new Java.Rvalue[]{new Java.FieldAccessExpression(loc, new Java.SimpleType(loc, enumIClass), "ENUM$VALUES"), new Java.IntegerLiteral(loc, "0"), new Java.LocalVariableAccess(loc, this.getLocalVariable(lvds, vd)), new Java.IntegerLiteral(loc, "0"), new Java.IntegerLiteral(loc, String.valueOf(numberOfEnumConstants))})), new Java.ReturnStatement(loc, new Java.LocalVariableAccess(loc, this.getLocalVariable(lvds, vd)))));
            md.setDeclaringType((Java.TypeDeclaration)ed2);
            this.compile(md, cf);
            Java.FunctionDeclarator.FormalParameter fp = new Java.FunctionDeclarator.FormalParameter(loc, false, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_String), "s");
            Java.MethodDeclarator md2 = new Java.MethodDeclarator(loc, null, new Java.Modifiers(9), null, new Java.SimpleType(loc, enumIClass), "valueOf", new Java.FunctionDeclarator.FormalParameters(loc, new Java.FunctionDeclarator.FormalParameter[]{fp}, false), new Java.Type[0], Arrays.asList(new Java.ReturnStatement(loc, new Java.Cast(loc, new Java.SimpleType(loc, enumIClass), new Java.MethodInvocation(loc, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_Enum), "valueOf", new Java.Rvalue[]{new Java.ClassLiteral(loc, new Java.SimpleType(loc, enumIClass)), new Java.ParameterAccess(loc, fp)})))));
            md2.setEnclosingScope((Java.Scope)ed2);
            this.compile(md2, cf);
        }
        this.compileDeclaredMethods(cd, cf);
        int declaredMethodCount = cd.getMethodDeclarations().size();
        int syntheticFieldCount = cd.syntheticFields.size();
        for (Java.ConstructorDeclarator ctord : ctords = cd.getConstructors()) {
            this.compile(ctord, cf);
            if (syntheticFieldCount == cd.syntheticFields.size()) continue;
            throw new JaninoRuntimeException("SNO: Compilation of constructor \"" + ctord + "\" (" + ctord.getLocation() + ") added synthetic fields!?");
        }
        this.compileDeclaredMemberTypes(cd, cf);
        this.compileDeclaredMethods(cd, cf, declaredMethodCount);
        for (IClass.IMethod base : iClass.getIMethods()) {
            IClass.IMethod override;
            if (base.isStatic() || (override = iClass.findIMethod(base.getName(), base.getParameterTypes())) == null || base.getReturnType() == override.getReturnType()) continue;
            this.generateBridgeMethod(cf, base, override);
        }
        for (Java.BlockStatement vdoi : cd.getVariableDeclaratorsAndInitializers()) {
            if (!(vdoi instanceof Java.FieldDeclaration)) continue;
            this.addFields((Java.FieldDeclaration)vdoi, cf);
        }
        for (IClass.IField f : cd.getSyntheticFields().values()) {
            cf.addFieldInfo((short)0, f.getName(), f.getType().getDescriptor(), null);
        }
        this.addClassFile(cf);
    }

    private void addClassFile(ClassFile cf) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            UnitCompiler.disassembleToStdout(cf.toByteArray());
        }
        assert (this.generatedClassFiles != null);
        this.generatedClassFiles.add(cf);
    }

    private void addFields(Java.FieldDeclaration fd, ClassFile cf) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            Java.Type type = fd.type;
            for (int i = 0; i < vd.brackets; ++i) {
                type = new Java.ArrayType(type);
            }
            Object ocv = NOT_CONSTANT;
            if (Mod.isFinal(fd.modifiers.accessFlags) && vd.optionalInitializer instanceof Java.Rvalue) {
                ocv = this.getConstantValue((Java.Rvalue)vd.optionalInitializer);
            }
            ClassFile.FieldInfo fi = Mod.isPrivateAccess(fd.modifiers.accessFlags) ? cf.addFieldInfo(Mod.changeAccess(fd.modifiers.accessFlags, (short)0), vd.name, this.getType(type).getDescriptor(), ocv == NOT_CONSTANT ? null : ocv) : cf.addFieldInfo(fd.modifiers.accessFlags, vd.name, this.getType(type).getDescriptor(), ocv == NOT_CONSTANT ? null : ocv);
            this.compileAnnotations(fd.getAnnotations(), fi, cf);
            if (!fd.hasDeprecatedDocTag()) continue;
            fi.addAttribute(new ClassFile.DeprecatedAttribute(cf.addConstantUtf8Info("Deprecated")));
        }
    }

    private void compile2(Java.AnonymousClassDeclaration acd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)acd);
    }

    private void compile2(Java.LocalClassDeclaration lcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)lcd);
    }

    private void compile2(Java.InnerClassDeclaration icd) throws CompileException {
        List<Java.TypeDeclaration> ocs = UnitCompiler.getOuterClasses(icd);
        int nesting = ocs.size();
        if (nesting >= 2) {
            icd.defineSyntheticField(new SimpleIField(this.resolve(icd), "this$" + (nesting - 2), this.resolve(ocs.get(1))));
        }
        if (icd instanceof Java.AnonymousClassDeclaration || icd instanceof Java.LocalClassDeclaration) {
            Java.AbstractClassDeclaration cd = (Java.AbstractClassDeclaration)((Object)icd);
            List<Java.BlockStatement> vdais = cd.variableDeclaratorsAndInitializers;
            for (int i = 0; i < vdais.size(); ++i) {
                Java.BlockStatement vdoi = vdais.get(i);
                this.fakeCompile(vdoi);
            }
        }
        this.compile2((Java.AbstractClassDeclaration)((Object)icd));
    }

    private void compile2(Java.MemberClassDeclaration mcd) throws CompileException {
        this.compile2((Java.InnerClassDeclaration)mcd);
    }

    private void compile2(Java.InterfaceDeclaration id) throws CompileException {
        IClass iClass = this.resolve(id);
        id.interfaces = new IClass[id.extendedTypes.length];
        IClass[] is = id.interfaces;
        String[] interfaceDescriptors = new String[is.length];
        for (int i = 0; i < id.extendedTypes.length; ++i) {
            is[i] = this.getType(id.extendedTypes[i]);
            interfaceDescriptors[i] = is[i].getDescriptor();
        }
        ClassFile cf = new ClassFile((short)(id.getModifierFlags() | 0x200 | 0x400), iClass.getDescriptor(), "Ljava/lang/Object;", interfaceDescriptors);
        this.compileAnnotations(id.getAnnotations(), cf, cf);
        if (this.debugSource) {
            String s = id.getLocation().getFileName();
            String sourceFileName = s != null ? new File(s).getName() : id.getName() + ".java";
            cf.addSourceFileAttribute(sourceFileName);
        }
        if (id.hasDeprecatedDocTag()) {
            cf.addDeprecatedAttribute();
        }
        if (!id.constantDeclarations.isEmpty()) {
            ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
            statements.addAll(id.constantDeclarations);
            this.maybeCreateInitMethod(id, cf, statements);
        }
        this.compileDeclaredMethods(id, cf);
        for (Java.FieldDeclaration constantDeclaration : id.constantDeclarations) {
            this.addFields(constantDeclaration, cf);
        }
        this.compileDeclaredMemberTypes(id, cf);
        this.addClassFile(cf);
    }

    private void compileAnnotations(Java.Annotation[] annotations, Annotatable target, final ClassFile cf) throws CompileException {
        block0: for (Java.Annotation a : annotations) {
            Java.Type annotationType = a.getType();
            IClass annotationIClass = this.getType(annotationType);
            IClass.IAnnotation[] annotationAnnotations = annotationIClass.getIAnnotations();
            boolean runtimeVisible = false;
            for (IClass.IAnnotation aa : annotationAnnotations) {
                if (aa.getAnnotationType() != this.iClassLoader.TYPE_java_lang_annotation_Retention) continue;
                Object rev = aa.getElementValue("value");
                String retention = ((IClass.IField)rev).getName();
                if ("SOURCE".equals(retention)) continue block0;
                if ("CLASS".equals(retention)) {
                    runtimeVisible = false;
                    break;
                }
                if ("RUNTIME".equals(retention)) {
                    runtimeVisible = true;
                    break;
                }
                throw new AssertionError((Object)retention);
            }
            final HashMap<Short, ClassFile.AnnotationsAttribute.ElementValue> evps = new HashMap<Short, ClassFile.AnnotationsAttribute.ElementValue>();
            a.accept(new Visitor.AnnotationVisitor<Void, CompileException>(){

                @Override
                @Nullable
                public Void visitSingleElementAnnotation(Java.SingleElementAnnotation sea) throws CompileException {
                    evps.put(cf.addConstantUtf8Info("value"), UnitCompiler.this.compileElementValue(sea.elementValue, cf));
                    return null;
                }

                @Override
                @Nullable
                public Void visitNormalAnnotation(Java.NormalAnnotation na) throws CompileException {
                    for (Java.ElementValuePair evp : na.elementValuePairs) {
                        evps.put(cf.addConstantUtf8Info(evp.identifier), UnitCompiler.this.compileElementValue(evp.elementValue, cf));
                    }
                    return null;
                }

                @Override
                @Nullable
                public Void visitMarkerAnnotation(Java.MarkerAnnotation ma) {
                    return null;
                }
            });
            target.addAnnotationsAttributeEntry(runtimeVisible, annotationIClass.getDescriptor(), evps);
        }
    }

    private ClassFile.AnnotationsAttribute.ElementValue compileElementValue(Java.ElementValue elementValue, final ClassFile cf) throws CompileException {
        ClassFile.AnnotationsAttribute.ElementValue result = elementValue.accept(new Visitor.ElementValueVisitor<ClassFile.AnnotationsAttribute.ElementValue, CompileException>(){

            @Override
            public ClassFile.AnnotationsAttribute.ElementValue visitRvalue(Java.Rvalue rv) throws CompileException {
                Java.Rvalue enumConstant;
                if (rv instanceof Java.AmbiguousName && (enumConstant = UnitCompiler.this.reclassify((Java.AmbiguousName)rv).toRvalue()) instanceof Java.FieldAccess) {
                    Java.FieldAccess enumConstantFieldAccess = (Java.FieldAccess)enumConstant;
                    Java.Type enumType = enumConstantFieldAccess.lhs.toType();
                    if (enumType != null) {
                        IClass enumIClass = UnitCompiler.this.findTypeByName(rv.getLocation(), enumType.toString());
                        if (enumIClass == null) {
                            UnitCompiler.this.compileError("Cannot find enum \"" + enumType + "\"", enumType.getLocation());
                        } else if (enumIClass.getSuperclass() != ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Enum) {
                            UnitCompiler.this.compileError("\"" + enumType + "\" is not an enum", enumType.getLocation());
                        } else {
                            return new ClassFile.AnnotationsAttribute.EnumConstValue(cf.addConstantUtf8Info(enumIClass.getDescriptor()), cf.addConstantUtf8Info(enumConstantFieldAccess.field.getName()));
                        }
                    }
                }
                if (rv instanceof Java.ClassLiteral) {
                    return new ClassFile.AnnotationsAttribute.ClassElementValue(cf.addConstantUtf8Info(UnitCompiler.this.getType(((Java.ClassLiteral)rv).type).getDescriptor()));
                }
                Object cv = UnitCompiler.this.getConstantValue(rv);
                if (cv == NOT_CONSTANT) {
                    throw new CompileException("\"" + rv + "\" is not a constant expression", rv.getLocation());
                }
                if (cv == null) {
                    throw new CompileException("Null literal not allowed as element value", rv.getLocation());
                }
                if (cv instanceof Boolean) {
                    return new ClassFile.AnnotationsAttribute.BooleanElementValue(cf.addConstantIntegerInfo((Boolean)cv != false ? 1 : 0));
                }
                if (cv instanceof Byte) {
                    return new ClassFile.AnnotationsAttribute.ByteElementValue(cf.addConstantIntegerInfo(((Byte)cv).byteValue()));
                }
                if (cv instanceof Short) {
                    return new ClassFile.AnnotationsAttribute.ShortElementValue(cf.addConstantIntegerInfo(((Short)cv).shortValue()));
                }
                if (cv instanceof Integer) {
                    return new ClassFile.AnnotationsAttribute.IntElementValue(cf.addConstantIntegerInfo((Integer)cv));
                }
                if (cv instanceof Long) {
                    return new ClassFile.AnnotationsAttribute.LongElementValue(cf.addConstantLongInfo((Long)cv));
                }
                if (cv instanceof Float) {
                    return new ClassFile.AnnotationsAttribute.FloatElementValue(cf.addConstantFloatInfo(((Float)cv).floatValue()));
                }
                if (cv instanceof Double) {
                    return new ClassFile.AnnotationsAttribute.DoubleElementValue(cf.addConstantDoubleInfo((Double)cv));
                }
                if (cv instanceof Character) {
                    return new ClassFile.AnnotationsAttribute.CharElementValue(cf.addConstantIntegerInfo(((Character)cv).charValue()));
                }
                if (cv instanceof String) {
                    return new ClassFile.AnnotationsAttribute.StringElementValue(cf.addConstantUtf8Info((String)cv));
                }
                throw new AssertionError(cv);
            }

            @Override
            public ClassFile.AnnotationsAttribute.ElementValue visitAnnotation(Java.Annotation a) throws CompileException {
                short annotationTypeIndex = cf.addConstantClassInfo(UnitCompiler.this.getType(a.getType()).getDescriptor());
                final HashMap<Short, ClassFile.AnnotationsAttribute.ElementValue> evps = new HashMap<Short, ClassFile.AnnotationsAttribute.ElementValue>();
                a.accept(new Visitor.AnnotationVisitor<Void, CompileException>(){

                    @Override
                    @Nullable
                    public Void visitMarkerAnnotation(Java.MarkerAnnotation ma) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSingleElementAnnotation(Java.SingleElementAnnotation sea) throws CompileException {
                        evps.put(cf.addConstantUtf8Info("value"), UnitCompiler.this.compileElementValue(sea.elementValue, cf));
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitNormalAnnotation(Java.NormalAnnotation na) throws CompileException {
                        for (Java.ElementValuePair evp : na.elementValuePairs) {
                            evps.put(cf.addConstantUtf8Info(evp.identifier), UnitCompiler.this.compileElementValue(evp.elementValue, cf));
                        }
                        return null;
                    }
                });
                return new ClassFile.AnnotationsAttribute.Annotation(annotationTypeIndex, evps);
            }

            @Override
            public ClassFile.AnnotationsAttribute.ElementValue visitElementValueArrayInitializer(Java.ElementValueArrayInitializer evai) throws CompileException {
                ClassFile.AnnotationsAttribute.ElementValue[] evs = new ClassFile.AnnotationsAttribute.ElementValue[evai.elementValues.length];
                for (int i = 0; i < evai.elementValues.length; ++i) {
                    evs[i] = UnitCompiler.this.compileElementValue(evai.elementValues[i], cf);
                }
                return new ClassFile.AnnotationsAttribute.ArrayElementValue(evs);
            }
        });
        assert (result != null);
        return result;
    }

    private void maybeCreateInitMethod(Java.TypeDeclaration td, ClassFile cf, List<Java.BlockStatement> statements) throws CompileException {
        if (this.generatesCode2(statements)) {
            Java.MethodDeclarator md = new Java.MethodDeclarator(td.getLocation(), null, new Java.Modifiers(9), null, new Java.PrimitiveType(td.getLocation(), Java.Primitive.VOID), "<clinit>", new Java.FunctionDeclarator.FormalParameters(td.getLocation()), new Java.ReferenceType[0], statements);
            md.setDeclaringType(td);
            this.compile(md, cf);
        }
    }

    private void compileDeclaredMemberTypes(Java.TypeDeclaration decl, ClassFile cf) throws CompileException {
        for (Java.MemberTypeDeclaration mtd : decl.getMemberTypeDeclarations()) {
            this.compile(mtd);
            short innerClassInfoIndex = cf.addConstantClassInfo(this.resolve(mtd).getDescriptor());
            short outerClassInfoIndex = cf.addConstantClassInfo(this.resolve(decl).getDescriptor());
            short innerNameIndex = cf.addConstantUtf8Info(mtd.getName());
            assert (mtd.getAnnotations().length == 0);
            cf.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(innerClassInfoIndex, outerClassInfoIndex, innerNameIndex, mtd.getModifierFlags()));
        }
    }

    private void compileDeclaredMethods(Java.TypeDeclaration typeDeclaration, ClassFile cf) throws CompileException {
        this.compileDeclaredMethods(typeDeclaration, cf, 0);
    }

    private void compileDeclaredMethods(Java.TypeDeclaration typeDeclaration, ClassFile cf, int startPos) throws CompileException {
        for (int i = startPos; i < typeDeclaration.getMethodDeclarations().size(); ++i) {
            Java.MethodDeclarator md = typeDeclaration.getMethodDeclarations().get(i);
            IClass.IMethod m = this.toIMethod(md);
            boolean overrides = this.overridesMethodFromSupertype(m, this.resolve(md.getDeclaringType()));
            boolean hasOverrideAnnotation = this.hasAnnotation(md, this.iClassLoader.TYPE_java_lang_Override);
            if (overrides && !hasOverrideAnnotation && !(typeDeclaration instanceof Java.InterfaceDeclaration)) {
                this.warning("MO", "Missing @Override", md.getLocation());
            } else if (!overrides && hasOverrideAnnotation) {
                this.compileError("Method does not override a method declared in a supertype", md.getLocation());
            }
            this.compile(md, cf);
        }
    }

    private boolean hasAnnotation(Java.FunctionDeclarator fd, IClass methodAnnotation) throws CompileException {
        Java.Annotation[] methodAnnotations;
        for (Java.Annotation ma : methodAnnotations = fd.modifiers.annotations) {
            if (this.getType(ma.getType()) != methodAnnotation) continue;
            return true;
        }
        return false;
    }

    private boolean overridesMethodFromSupertype(IClass.IMethod m, IClass type) throws CompileException {
        IClass[] ifs;
        IClass superclass = type.getSuperclass();
        if (superclass != null && this.overridesMethod(m, superclass)) {
            return true;
        }
        for (IClass i : ifs = type.getInterfaces()) {
            if (!this.overridesMethod(m, i)) continue;
            return true;
        }
        if (ifs.length == 0 && type.isInterface()) {
            return this.overridesMethod(m, this.iClassLoader.TYPE_java_lang_Object);
        }
        return false;
    }

    private boolean overridesMethod(IClass.IMethod method, IClass type) throws CompileException {
        IClass.IMethod[] ms;
        for (IClass.IMethod m : ms = type.getDeclaredIMethods(method.getName())) {
            if (!Arrays.equals(method.getParameterTypes(), m.getParameterTypes())) continue;
            return true;
        }
        return this.overridesMethodFromSupertype(method, type);
    }

    private void generateBridgeMethod(ClassFile cf, IClass.IMethod base, IClass.IMethod override) throws CompileException {
        if (!base.getReturnType().isAssignableFrom(override.getReturnType()) || override.getReturnType() == IClass.VOID) {
            this.compileError("The return type of \"" + override + "\" is incompatible with that of \"" + base + "\"");
            return;
        }
        ClassFile.MethodInfo mi = cf.addMethodInfo((short)4097, base.getName(), base.getDescriptor());
        IClass[] thrownExceptions = base.getThrownExceptions();
        if (thrownExceptions.length > 0) {
            short eani = cf.addConstantUtf8Info("Exceptions");
            short[] tecciis = new short[thrownExceptions.length];
            for (int i = 0; i < thrownExceptions.length; ++i) {
                tecciis[i] = cf.addConstantClassInfo(thrownExceptions[i].getDescriptor());
            }
            mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
        }
        final CodeContext codeContext = new CodeContext(mi.getClassFile(), base.toString());
        CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
        codeContext.saveLocalVariables();
        codeContext.allocateLocalVariable((short)1, "this", override.getDeclaringIClass());
        IClass[] paramTypes = override.getParameterTypes();
        Java.LocalVariableSlot[] locals = new Java.LocalVariableSlot[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            locals[i] = codeContext.allocateLocalVariable(Descriptor.size(paramTypes[i].getDescriptor()), "param" + i, paramTypes[i]);
        }
        this.writeOpcode(Java.Located.NOWHERE, 42);
        for (Java.LocalVariableSlot l : locals) {
            this.load(Java.Located.NOWHERE, l.getType(), l.getSlotIndex());
        }
        this.invoke((Java.Locatable)Java.Located.NOWHERE, override);
        this.writeOpcode(Java.Located.NOWHERE, -80);
        this.replaceCodeContext(savedCodeContext);
        codeContext.flowAnalysis(override.getName());
        mi.addAttribute(new ClassFile.AttributeInfo(cf.addConstantUtf8Info("Code")){

            @Override
            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, (short)0, (short)0);
            }
        });
    }

    private boolean compile(Java.BlockStatement bs) throws CompileException {
        Boolean result = bs.accept(new Visitor.BlockStatementVisitor<Boolean, CompileException>(){

            @Override
            public Boolean visitInitializer(Java.Initializer i) throws CompileException {
                return UnitCompiler.this.compile2(i);
            }

            @Override
            public Boolean visitFieldDeclaration(Java.FieldDeclaration fd) throws CompileException {
                return UnitCompiler.this.compile2(fd);
            }

            @Override
            public Boolean visitLabeledStatement(Java.LabeledStatement ls) throws CompileException {
                return UnitCompiler.this.compile2(ls);
            }

            @Override
            public Boolean visitBlock(Java.Block b) throws CompileException {
                return UnitCompiler.this.compile2(b);
            }

            @Override
            public Boolean visitExpressionStatement(Java.ExpressionStatement es) throws CompileException {
                return UnitCompiler.this.compile2(es);
            }

            @Override
            public Boolean visitIfStatement(Java.IfStatement is) throws CompileException {
                return UnitCompiler.this.compile2(is);
            }

            @Override
            public Boolean visitForStatement(Java.ForStatement fs) throws CompileException {
                return UnitCompiler.this.compile2(fs);
            }

            @Override
            public Boolean visitForEachStatement(Java.ForEachStatement fes) throws CompileException {
                return UnitCompiler.this.compile2(fes);
            }

            @Override
            public Boolean visitWhileStatement(Java.WhileStatement ws) throws CompileException {
                return UnitCompiler.this.compile2(ws);
            }

            @Override
            public Boolean visitTryStatement(Java.TryStatement ts) throws CompileException {
                return UnitCompiler.this.compile2(ts);
            }

            @Override
            public Boolean visitSwitchStatement(Java.SwitchStatement ss) throws CompileException {
                return UnitCompiler.this.compile2(ss);
            }

            @Override
            public Boolean visitSynchronizedStatement(Java.SynchronizedStatement ss) throws CompileException {
                return UnitCompiler.this.compile2(ss);
            }

            @Override
            public Boolean visitDoStatement(Java.DoStatement ds) throws CompileException {
                return UnitCompiler.this.compile2(ds);
            }

            @Override
            public Boolean visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) throws CompileException {
                return UnitCompiler.this.compile2(lvds);
            }

            @Override
            public Boolean visitReturnStatement(Java.ReturnStatement rs) throws CompileException {
                return UnitCompiler.this.compile2(rs);
            }

            @Override
            public Boolean visitThrowStatement(Java.ThrowStatement ts) throws CompileException {
                return UnitCompiler.this.compile2(ts);
            }

            @Override
            public Boolean visitBreakStatement(Java.BreakStatement bs) throws CompileException {
                return UnitCompiler.this.compile2(bs);
            }

            @Override
            public Boolean visitContinueStatement(Java.ContinueStatement cs) throws CompileException {
                return UnitCompiler.this.compile2(cs);
            }

            @Override
            public Boolean visitAssertStatement(Java.AssertStatement as) throws CompileException {
                return UnitCompiler.this.compile2(as);
            }

            @Override
            public Boolean visitEmptyStatement(Java.EmptyStatement es) {
                return UnitCompiler.this.compile2(es);
            }

            @Override
            public Boolean visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) throws CompileException {
                return UnitCompiler.this.compile2(lcds);
            }

            @Override
            public Boolean visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) throws CompileException {
                return UnitCompiler.this.compile2(aci);
            }

            @Override
            public Boolean visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) throws CompileException {
                return UnitCompiler.this.compile2(sci);
            }
        });
        assert (result != null);
        return result;
    }

    private boolean fakeCompile(Java.BlockStatement bs) throws CompileException {
        CodeContext.Offset from = this.getCodeContext().newOffset();
        boolean ccn = this.compile(bs);
        CodeContext.Offset to = this.getCodeContext().newOffset();
        this.getCodeContext().removeCode(from, to);
        return ccn;
    }

    private CodeContext getCodeContext() {
        assert (this.codeContext != null);
        return this.codeContext;
    }

    private boolean compile2(Java.Initializer i) throws CompileException {
        return this.compile(i.block);
    }

    private boolean compile2(Java.Block b) throws CompileException {
        this.getCodeContext().saveLocalVariables();
        try {
            boolean bl = this.compileStatements(b.statements);
            return bl;
        }
        finally {
            this.getCodeContext().restoreLocalVariables();
        }
    }

    private boolean compileStatements(List<? extends Java.BlockStatement> statements) throws CompileException {
        boolean previousStatementCanCompleteNormally = true;
        for (Java.BlockStatement blockStatement : statements) {
            if (!previousStatementCanCompleteNormally && this.generatesCode(blockStatement)) {
                this.compileError("Statement is unreachable", blockStatement.getLocation());
                break;
            }
            previousStatementCanCompleteNormally = this.compile(blockStatement);
        }
        return previousStatementCanCompleteNormally;
    }

    private boolean compile2(Java.DoStatement ds) throws CompileException {
        Object cvc = this.getConstantValue(ds.condition);
        if (cvc != NOT_CONSTANT) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("DSTC", "Condition of DO statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ds.getLocation());
                return this.compileUnconditionalLoop(ds, ds.body, null);
            }
            this.warning("DSNR", "DO statement never repeats", ds.getLocation());
        }
        CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
        ds.whereToContinue = null;
        if (!this.compile(ds.body) && ds.whereToContinue == null) {
            this.warning("DSNTC", "\"do\" statement never tests its condition", ds.getLocation());
            CodeContext.Offset wtb = ds.whereToBreak;
            if (wtb == null) {
                return false;
            }
            wtb.set();
            ds.whereToBreak = null;
            return true;
        }
        if (ds.whereToContinue != null) {
            ds.whereToContinue.set();
            ds.whereToContinue = null;
        }
        this.compileBoolean(ds.condition, bodyOffset, true);
        if (ds.whereToBreak != null) {
            ds.whereToBreak.set();
            ds.whereToBreak = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.ForStatement fs) throws CompileException {
        this.getCodeContext().saveLocalVariables();
        try {
            Java.BlockStatement oi = fs.optionalInit;
            Java.Rvalue[] ou = fs.optionalUpdate;
            Java.Rvalue oc = fs.optionalCondition;
            if (oi != null) {
                this.compile(oi);
            }
            if (oc == null) {
                boolean bl = this.compileUnconditionalLoop(fs, fs.body, ou);
                return bl;
            }
            Object cvc = this.getConstantValue(oc);
            if (cvc != NOT_CONSTANT) {
                if (Boolean.TRUE.equals(cvc)) {
                    this.warning("FSTC", "Condition of FOR statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", fs.getLocation());
                    boolean bl = this.compileUnconditionalLoop(fs, fs.body, ou);
                    return bl;
                }
                this.warning("FSNR", "FOR statement never repeats", fs.getLocation());
            }
            CodeContext.Offset toCondition = this.getCodeContext().new CodeContext.Offset();
            this.writeBranch(fs, -89, toCondition);
            fs.whereToContinue = null;
            CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
            boolean bodyCcn = this.compile(fs.body);
            if (fs.whereToContinue != null) {
                fs.whereToContinue.set();
            }
            if (ou != null) {
                if (!bodyCcn && fs.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fs.getLocation());
                } else {
                    for (Java.Rvalue rv : ou) {
                        this.compile(rv);
                    }
                }
            }
            fs.whereToContinue = null;
            toCondition.set();
            this.compileBoolean(oc, bodyOffset, true);
        }
        finally {
            this.getCodeContext().restoreLocalVariables();
        }
        if (fs.whereToBreak != null) {
            fs.whereToBreak.set();
            fs.whereToBreak = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.ForEachStatement fes) throws CompileException {
        IClass expressionType = this.getType(fes.expression);
        if (expressionType.isArray()) {
            this.getCodeContext().saveLocalVariables();
            try {
                Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
                elementLv.setSlot(this.getCodeContext().allocateLocalVariable(Descriptor.size(elementLv.type.getDescriptor()), fes.currentElement.name, elementLv.type));
                this.compileGetValue(fes.expression);
                short expressionLv = this.getCodeContext().allocateLocalVariable((short)1);
                this.store(fes.expression, expressionType, expressionLv);
                this.pushConstant(fes, 0);
                Java.LocalVariable indexLv = new Java.LocalVariable(false, IClass.INT);
                indexLv.setSlot(this.getCodeContext().allocateLocalVariable((short)1, null, indexLv.type));
                this.store(fes, indexLv);
                CodeContext.Offset toCondition = this.getCodeContext().new CodeContext.Offset();
                this.writeBranch(fes, -89, toCondition);
                fes.whereToContinue = null;
                CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
                this.load(fes, expressionType, expressionLv);
                this.load(fes, indexLv);
                IClass componentType = expressionType.getComponentType();
                assert (componentType != null);
                this.writeOpcode(fes, 46 + UnitCompiler.ilfdabcs(componentType));
                this.assignmentConversion(fes.currentElement, componentType, elementLv.type, null);
                this.store(fes, elementLv);
                boolean bodyCcn = this.compile(fes.body);
                if (fes.whereToContinue != null) {
                    fes.whereToContinue.set();
                }
                if (!bodyCcn && fes.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fes.getLocation());
                } else {
                    this.crement(fes, indexLv, "++");
                }
                fes.whereToContinue = null;
                toCondition.set();
                this.load(fes, indexLv);
                this.load(fes, expressionType, expressionLv);
                this.writeOpcode(fes, -66);
                this.writeBranch(fes, -95, bodyOffset);
            }
            finally {
                this.getCodeContext().restoreLocalVariables();
            }
            if (fes.whereToBreak != null) {
                fes.whereToBreak.set();
                fes.whereToBreak = null;
            }
        } else if (this.iClassLoader.TYPE_java_lang_Iterable.isAssignableFrom(expressionType)) {
            this.getCodeContext().saveLocalVariables();
            try {
                Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
                elementLv.setSlot(this.getCodeContext().allocateLocalVariable((short)1, fes.currentElement.name, elementLv.type));
                this.compileGetValue(fes.expression);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_lang_Iterable__iterator);
                Java.LocalVariable iteratorLv = new Java.LocalVariable(false, this.iClassLoader.TYPE_java_util_Iterator);
                iteratorLv.setSlot(this.getCodeContext().allocateLocalVariable((short)1, null, iteratorLv.type));
                this.store(fes, iteratorLv);
                CodeContext.Offset toCondition = this.getCodeContext().new CodeContext.Offset();
                this.writeBranch(fes, -89, toCondition);
                fes.whereToContinue = null;
                CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
                this.load(fes, iteratorLv);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_util_Iterator__next);
                if (!this.tryAssignmentConversion(fes.currentElement, this.iClassLoader.TYPE_java_lang_Object, elementLv.type, null) && !this.tryNarrowingReferenceConversion(fes.currentElement, this.iClassLoader.TYPE_java_lang_Object, elementLv.type)) {
                    throw new AssertionError();
                }
                this.store(fes, elementLv);
                boolean bodyCcn = this.compile(fes.body);
                if (fes.whereToContinue != null) {
                    fes.whereToContinue.set();
                }
                if (!bodyCcn && fes.whereToContinue == null) {
                    this.warning("FUUR", "For update is unreachable", fes.getLocation());
                }
                fes.whereToContinue = null;
                toCondition.set();
                this.load(fes, iteratorLv);
                this.invoke((Java.Locatable)fes.expression, this.iClassLoader.METH_java_util_Iterator__hasNext);
                this.writeBranch(fes, -102, bodyOffset);
            }
            finally {
                this.getCodeContext().restoreLocalVariables();
            }
            if (fes.whereToBreak != null) {
                fes.whereToBreak.set();
                fes.whereToBreak = null;
            }
        } else {
            this.compileError("Cannot iterate over '" + expressionType + "'");
        }
        return true;
    }

    private boolean compile2(Java.WhileStatement ws) throws CompileException {
        Object cvc = this.getConstantValue(ws.condition);
        if (cvc != NOT_CONSTANT) {
            if (Boolean.TRUE.equals(cvc)) {
                this.warning("WSTC", "Condition of WHILE statement is always TRUE; the proper way of declaring an unconditional loop is \"for (;;)\"", ws.getLocation());
                return this.compileUnconditionalLoop(ws, ws.body, null);
            }
            this.warning("WSNR", "WHILE statement never repeats", ws.getLocation());
        }
        CodeContext.Offset wtc = ws.whereToContinue = this.getCodeContext().new CodeContext.Offset();
        this.writeBranch(ws, -89, wtc);
        CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
        this.compile(ws.body);
        assert (ws.whereToContinue == wtc);
        wtc.set();
        ws.whereToContinue = null;
        this.compileBoolean(ws.condition, bodyOffset, true);
        if (ws.whereToBreak != null) {
            ws.whereToBreak.set();
            ws.whereToBreak = null;
        }
        return true;
    }

    private boolean compileUnconditionalLoop(Java.ContinuableStatement cs, Java.BlockStatement body, @Nullable Java.Rvalue[] optionalUpdate) throws CompileException {
        if (optionalUpdate != null) {
            return this.compileUnconditionalLoopWithUpdate(cs, body, optionalUpdate);
        }
        CodeContext.Offset wtc = cs.whereToContinue = this.getCodeContext().newOffset();
        if (this.compile(body)) {
            this.writeBranch(cs, -89, wtc);
        }
        cs.whereToContinue = null;
        CodeContext.Offset wtb = cs.whereToBreak;
        if (wtb == null) {
            return false;
        }
        wtb.set();
        cs.whereToBreak = null;
        return true;
    }

    private boolean compileUnconditionalLoopWithUpdate(Java.ContinuableStatement cs, Java.BlockStatement body, Java.Rvalue[] update) throws CompileException {
        cs.whereToContinue = null;
        CodeContext.Offset bodyOffset = this.getCodeContext().newOffset();
        boolean bodyCcn = this.compile(body);
        if (cs.whereToContinue != null) {
            cs.whereToContinue.set();
        }
        if (!bodyCcn && cs.whereToContinue == null) {
            this.warning("LUUR", "Loop update is unreachable", update[0].getLocation());
        } else {
            for (Java.Rvalue rv : update) {
                this.compile(rv);
            }
            this.writeBranch(cs, -89, bodyOffset);
        }
        cs.whereToContinue = null;
        CodeContext.Offset wtb = cs.whereToBreak;
        if (wtb == null) {
            return false;
        }
        wtb.set();
        cs.whereToBreak = null;
        return true;
    }

    private boolean compile2(Java.LabeledStatement ls) throws CompileException {
        boolean canCompleteNormally = this.compile(ls.body);
        CodeContext.Offset wtb = ls.whereToBreak;
        if (wtb == null) {
            return canCompleteNormally;
        }
        wtb.set();
        ls.whereToBreak = null;
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean compile2(Java.SwitchStatement ss) throws CompileException {
        ssvLvIndex = -1;
        switchExpressionType = this.compileGetValue(ss.condition);
        if (this.iClassLoader.TYPE_java_lang_String == switchExpressionType) {
            kind = SwitchKind.STRING;
            this.dup(ss, 1);
            ssvLvIndex = this.getCodeContext().allocateLocalVariable((short)1);
            this.store(ss, this.iClassLoader.TYPE_java_lang_String, ssvLvIndex);
            this.invoke((Java.Locatable)ss, this.iClassLoader.METH_java_lang_String__hashCode);
        } else if (this.iClassLoader.TYPE_java_lang_Enum.isAssignableFrom(switchExpressionType)) {
            kind = SwitchKind.ENUM;
            this.invoke((Java.Locatable)ss, this.iClassLoader.METH_java_lang_Enum__ordinal);
        } else {
            kind = SwitchKind.INT;
            this.assignmentConversion(ss, switchExpressionType, IClass.INT, null);
        }
        caseLabelMap = new TreeMap<Object, CodeContext.Offset>();
        defaultLabelOffset = null;
        sbsgOffsets = new CodeContext.Offset[ss.sbsgs.size()];
        for (i = 0; i < ss.sbsgs.size(); ++i) {
            sbsg = ss.sbsgs.get(i);
            sbsgOffsets[i] = this.getCodeContext().new CodeContext.Offset();
            block6: for (Java.Rvalue caseLabel : sbsg.caseLabels) {
                switch (36.$SwitchMap$org$codehaus$janino$UnitCompiler$SwitchKind[kind.ordinal()]) {
                    case 1: {
                        if (!(caseLabel instanceof Java.AmbiguousName)) {
                            this.compileError("Case label must be an enum constant", caseLabel.getLocation());
                            civ = 99;
                            continue block6;
                        }
                        identifiers = ((Java.AmbiguousName)caseLabel).identifiers;
                        if (identifiers.length != 1) {
                            this.compileError("Case label must be a plain enum constant", caseLabel.getLocation());
                            civ = 99;
                            continue block6;
                        }
                        constantName = identifiers[0];
                        ordinal = 0;
                        for (IClass.IField f : switchExpressionType.getDeclaredIFields()) {
                            if (f.getAccess() != Access.PUBLIC || !f.isStatic()) continue;
                            if (!f.getName().equals(constantName)) ** GOTO lbl44
                            civ = ordinal;
                            ** GOTO lbl48
lbl44:
                            // 1 sources

                            ++ordinal;
                        }
                        this.compileError("Unknown enum constant \"" + constantName + "\"", caseLabel.getLocation());
                        civ = 99;
lbl48:
                        // 2 sources

                        if (caseLabelMap.containsKey(civ)) {
                            this.compileError("Duplicate \"case\" switch label value", caseLabel.getLocation());
                        }
                        caseLabelMap.put(civ, sbsgOffsets[i]);
                        continue block6;
                    }
                    case 2: {
                        cv = this.getConstantValue(caseLabel);
                        if (cv == UnitCompiler.NOT_CONSTANT) {
                            this.compileError("Value of 'case' label does not pose a constant value", caseLabel.getLocation());
                            civ = 99;
                            continue block6;
                        }
                        if (cv instanceof Integer) {
                            civ = (Integer)cv;
                        } else if (cv instanceof Number) {
                            civ = new Integer(((Number)cv).intValue());
                        } else if (cv instanceof Character) {
                            civ = new Integer(((Character)cv).charValue());
                        } else {
                            this.compileError("Value of case label must be a char, byte, short or int constant", caseLabel.getLocation());
                            civ = new Integer(99);
                        }
                        if (caseLabelMap.containsKey(civ)) {
                            this.compileError("Duplicate \"case\" switch label value", caseLabel.getLocation());
                        }
                        caseLabelMap.put(civ, sbsgOffsets[i]);
                        continue block6;
                    }
                    case 3: {
                        cv = this.getConstantValue(caseLabel);
                        if (!(cv instanceof String)) {
                            this.compileError("Value of 'case' label is not a string constant", caseLabel.getLocation());
                            civ = 99;
                            continue block6;
                        }
                        civ = cv.hashCode();
                        if (caseLabelMap.containsKey(civ)) continue block6;
                        caseLabelMap.put(civ, this.getCodeContext().new CodeContext.Offset());
                        continue block6;
                    }
                }
                throw new AssertionError((Object)kind);
            }
            if (!sbsg.hasDefaultLabel) continue;
            if (defaultLabelOffset != null) {
                this.compileError("Duplicate \"default\" switch label", sbsg.getLocation());
            }
            defaultLabelOffset = sbsgOffsets[i];
        }
        if (defaultLabelOffset == null) {
            defaultLabelOffset = this.getWhereToBreak(ss);
        }
        switchOffset = this.getCodeContext().newOffset();
        if (!caseLabelMap.isEmpty()) {
            if ((Integer)caseLabelMap.firstKey() + caseLabelMap.size() >= (Integer)caseLabelMap.lastKey() - caseLabelMap.size()) {
                low = (Integer)caseLabelMap.firstKey();
                high = (Integer)caseLabelMap.lastKey();
                this.writeOpcode(ss, -86);
                new Java.Padder(this.getCodeContext()).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(low);
                this.writeInt(high);
                cur = low;
                for (Map.Entry me : caseLabelMap.entrySet()) {
                    caseLabelValue = (Integer)me.getKey();
                    caseLabelOffset = (CodeContext.Offset)me.getValue();
                    while (cur < caseLabelValue) {
                        this.writeOffset(switchOffset, defaultLabelOffset);
                        ++cur;
                    }
                    this.writeOffset(switchOffset, caseLabelOffset);
                    ++cur;
                }
            } else {
                this.writeOpcode(ss, -85);
                new Java.Padder(this.getCodeContext()).set();
                this.writeOffset(switchOffset, defaultLabelOffset);
                this.writeInt(caseLabelMap.size());
                for (Map.Entry<K, V> me : caseLabelMap.entrySet()) {
                    this.writeInt((Integer)me.getKey());
                    this.writeOffset(switchOffset, (CodeContext.Offset)me.getValue());
                }
            }
        }
        if (kind == SwitchKind.STRING) {
            for (Map.Entry<K, V> e : caseLabelMap.entrySet()) {
                caseHashCode = (Integer)e.getKey();
                offset = (CodeContext.Offset)e.getValue();
                offset.set();
                caseLabelValues = new HashSet<String>();
                for (i = 0; i < ss.sbsgs.size(); ++i) {
                    sbsg = ss.sbsgs.get(i);
                    for (Java.Rvalue caseLabel : sbsg.caseLabels) {
                        cv = (String)this.getConstantValue(caseLabel);
                        if (!UnitCompiler.$assertionsDisabled && cv == null) {
                            throw new AssertionError();
                        }
                        if (!caseLabelValues.add(cv)) {
                            this.compileError("Duplicate case label \"" + cv + "\"", caseLabel.getLocation());
                        }
                        if (cv.hashCode() != caseHashCode.intValue()) continue;
                        this.load(sbsg, this.iClassLoader.TYPE_java_lang_String, ssvLvIndex);
                        this.pushConstant(caseLabel, cv);
                        this.invoke((Java.Locatable)caseLabel, this.iClassLoader.METH_java_lang_String__equals__java_lang_Object);
                        this.writeBranch(sbsg, -102, sbsgOffsets[i]);
                    }
                }
                this.writeBranch(ss, -89, defaultLabelOffset);
            }
        }
        canCompleteNormally = true;
        block14: for (i = 0; i < ss.sbsgs.size(); ++i) {
            sbsg = ss.sbsgs.get(i);
            sbsgOffsets[i].set();
            canCompleteNormally = true;
            for (Java.BlockStatement bs : sbsg.blockStatements) {
                if (!canCompleteNormally) {
                    this.compileError("Statement is unreachable", bs.getLocation());
                    continue block14;
                }
                canCompleteNormally = this.compile(bs);
            }
        }
        wtb = ss.whereToBreak;
        if (wtb == null) {
            return canCompleteNormally;
        }
        wtb.set();
        ss.whereToBreak = null;
        return true;
    }

    private boolean compile2(Java.BreakStatement bs) throws CompileException {
        Java.BreakableStatement brokenStatement = null;
        if (bs.optionalLabel == null) {
            Java.Scope s = bs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.BreakableStatement) {
                    brokenStatement = (Java.BreakableStatement)s;
                    break;
                }
                s = s.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("\"break\" statement is not enclosed by a breakable statement", bs.getLocation());
                return false;
            }
        } else {
            Java.Scope s = bs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s;
                    if (ls.label.equals(bs.optionalLabel)) {
                        brokenStatement = ls;
                        break;
                    }
                }
                s = s.getEnclosingScope();
            }
            if (brokenStatement == null) {
                this.compileError("Statement \"break " + bs.optionalLabel + "\" is not enclosed by a breakable statement with label \"" + bs.optionalLabel + "\"", bs.getLocation());
                return false;
            }
        }
        this.leaveStatements(bs.getEnclosingScope(), brokenStatement.getEnclosingScope(), null);
        this.writeBranch(bs, -89, this.getWhereToBreak(brokenStatement));
        return false;
    }

    private boolean compile2(Java.ContinueStatement cs) throws CompileException {
        CodeContext.Offset wtc;
        Java.Scope s;
        Java.ContinuableStatement continuedStatement = null;
        if (cs.optionalLabel == null) {
            s = cs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.ContinuableStatement) {
                    continuedStatement = (Java.ContinuableStatement)s;
                    break;
                }
                s = s.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("\"continue\" statement is not enclosed by a continuable statement", cs.getLocation());
                return false;
            }
        } else {
            s = cs.getEnclosingScope();
            while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
                if (s instanceof Java.LabeledStatement) {
                    Java.LabeledStatement ls = (Java.LabeledStatement)s;
                    if (ls.label.equals(cs.optionalLabel)) {
                        Java.Statement st = ls.body;
                        while (st instanceof Java.LabeledStatement) {
                            st = ((Java.LabeledStatement)st).body;
                        }
                        if (!(st instanceof Java.ContinuableStatement)) {
                            this.compileError("Labeled statement is not continuable", st.getLocation());
                            return false;
                        }
                        continuedStatement = (Java.ContinuableStatement)st;
                        break;
                    }
                }
                s = s.getEnclosingScope();
            }
            if (continuedStatement == null) {
                this.compileError("Statement \"continue " + cs.optionalLabel + "\" is not enclosed by a continuable statement with label \"" + cs.optionalLabel + "\"", cs.getLocation());
                return false;
            }
        }
        if ((wtc = continuedStatement.whereToContinue) == null) {
            wtc = continuedStatement.whereToContinue = this.getCodeContext().new CodeContext.Offset();
        }
        this.leaveStatements(cs.getEnclosingScope(), continuedStatement.getEnclosingScope(), null);
        this.writeBranch(cs, -89, wtc);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.AssertStatement as) throws CompileException {
        CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
        try {
            Java.Rvalue[] rvalueArray;
            this.compileBoolean(as.expression1, end, true);
            this.writeOpcode(as, -69);
            this.writeConstantClassInfo("Ljava/lang/AssertionError;");
            this.writeOpcode(as, 89);
            if (as.optionalExpression2 == null) {
                rvalueArray = new Java.Rvalue[]{};
            } else {
                Java.Rvalue[] rvalueArray2 = new Java.Rvalue[1];
                rvalueArray = rvalueArray2;
                rvalueArray2[0] = as.optionalExpression2;
            }
            Java.Rvalue[] arguments = rvalueArray;
            this.invokeConstructor(as, as, null, this.iClassLoader.TYPE_java_lang_AssertionError, arguments);
            this.writeOpcode(as, -65);
        }
        finally {
            end.set();
        }
        return true;
    }

    private boolean compile2(Java.EmptyStatement es) {
        return true;
    }

    private boolean compile2(Java.ExpressionStatement ee) throws CompileException {
        this.compile(ee.rvalue);
        return true;
    }

    private boolean compile2(Java.FieldDeclaration fd) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            Java.ArrayInitializerOrRvalue initializer = this.getNonConstantFinalInitializer(fd, vd);
            if (initializer == null) continue;
            if (!Mod.isStatic(fd.modifiers.accessFlags)) {
                this.writeOpcode(fd, 42);
            }
            IClass fieldType = this.getType(fd.type);
            if (initializer instanceof Java.Rvalue) {
                Java.Rvalue rvalue = (Java.Rvalue)initializer;
                IClass initializerType = this.compileGetValue(rvalue);
                fieldType = fieldType.getArrayIClass(vd.brackets, this.iClassLoader.TYPE_java_lang_Object);
                this.assignmentConversion(fd, initializerType, fieldType, this.getConstantValue(rvalue));
            } else if (initializer instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)initializer, fieldType);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + initializer.getClass().getName());
            }
            IClass.IField iField = this.resolve(fd.getDeclaringType()).getDeclaredIField(vd.name);
            assert (iField != null) : fd.getDeclaringType() + " has no field " + vd.name;
            this.putfield(fd, iField);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.IfStatement is) throws CompileException {
        Java.BlockStatement es;
        Object cv = this.getConstantValue(is.condition);
        Java.BlockStatement blockStatement = es = is.optionalElseStatement != null ? is.optionalElseStatement : new Java.EmptyStatement(is.thenStatement.getLocation());
        if (cv instanceof Boolean) {
            Java.BlockStatement blindStatement;
            Java.BlockStatement seeingStatement;
            this.fakeCompile(is.condition);
            if (((Boolean)cv).booleanValue()) {
                seeingStatement = is.thenStatement;
                blindStatement = es;
            } else {
                seeingStatement = es;
                blindStatement = is.thenStatement;
            }
            CodeContext.Inserter ins = this.getCodeContext().newInserter();
            boolean ssccn = this.compile(seeingStatement);
            boolean bsccn = this.fakeCompile(blindStatement);
            if (ssccn) {
                return true;
            }
            if (!bsccn) {
                return false;
            }
            CodeContext.Offset off = this.getCodeContext().newOffset();
            this.getCodeContext().pushInserter(ins);
            try {
                this.pushConstant(is, Boolean.FALSE);
                this.writeBranch(is, -102, off);
            }
            finally {
                this.getCodeContext().popInserter();
            }
            return true;
        }
        if (this.generatesCode(is.thenStatement)) {
            if (this.generatesCode(es)) {
                CodeContext.Offset eso = this.getCodeContext().new CodeContext.Offset();
                CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
                this.compileBoolean(is.condition, eso, false);
                boolean tsccn = this.compile(is.thenStatement);
                if (tsccn) {
                    this.writeBranch(is, -89, end);
                }
                eso.set();
                boolean esccn = this.compile(es);
                end.set();
                return tsccn || esccn;
            }
            CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
            this.compileBoolean(is.condition, end, false);
            this.compile(is.thenStatement);
            end.set();
            return true;
        }
        if (this.generatesCode(es)) {
            CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
            this.compileBoolean(is.condition, end, true);
            this.compile(es);
            end.set();
            return true;
        }
        IClass conditionType = this.compileGetValue(is.condition);
        if (conditionType != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", is.getLocation());
        }
        this.pop(is, conditionType);
        return true;
    }

    private boolean compile2(Java.LocalClassDeclarationStatement lcds) throws CompileException {
        Java.LocalClassDeclaration otherLcd = UnitCompiler.findLocalClassDeclaration(lcds, lcds.lcd.name);
        if (otherLcd != null && otherLcd != lcds.lcd) {
            this.compileError("Redeclaration of local class \"" + lcds.lcd.name + "\"; previously declared in " + otherLcd.getLocation());
        }
        this.compile(lcds.lcd);
        return true;
    }

    @Nullable
    private static Java.LocalClassDeclaration findLocalClassDeclaration(Java.Scope s, String name) {
        Java.Scope es;
        if (s instanceof Java.CompilationUnit) {
            return null;
        }
        while (!((es = s.getEnclosingScope()) instanceof Java.CompilationUnit)) {
            if (s instanceof Java.BlockStatement && (es instanceof Java.Block || es instanceof Java.FunctionDeclarator)) {
                List<Java.BlockStatement> statements;
                Java.BlockStatement bs = (Java.BlockStatement)s;
                List<Java.BlockStatement> list = statements = es instanceof Java.BlockStatement ? ((Java.Block)es).statements : ((Java.FunctionDeclarator)es).optionalStatements;
                if (statements != null) {
                    for (Java.BlockStatement bs2 : statements) {
                        if (bs2 instanceof Java.LocalClassDeclarationStatement) {
                            Java.LocalClassDeclarationStatement lcds = (Java.LocalClassDeclarationStatement)bs2;
                            if (lcds.lcd.name.equals(name)) {
                                return lcds.lcd;
                            }
                        }
                        if (bs2 != bs) continue;
                        break;
                    }
                }
            }
            s = es;
        }
        return null;
    }

    private boolean compile2(Java.LocalVariableDeclarationStatement lvds) throws CompileException {
        if ((lvds.modifiers.accessFlags & 0xFFFFFFEF) != 0) {
            this.compileError("The only allowed modifier in local variable declarations is \"final\"", lvds.getLocation());
        }
        for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            lv.setSlot(this.getCodeContext().allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), vd.name, lv.type));
            Java.ArrayInitializerOrRvalue oi = vd.optionalInitializer;
            if (oi == null) continue;
            if (oi instanceof Java.Rvalue) {
                Java.Rvalue rhs = (Java.Rvalue)oi;
                this.assignmentConversion(lvds, this.compileGetValue(rhs), lv.type, this.getConstantValue(rhs));
            } else if (oi instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)oi, lv.type);
            } else {
                throw new JaninoRuntimeException("Unexpected rvalue or array initialized class " + oi.getClass().getName());
            }
            this.store(lvds, lv);
        }
        return true;
    }

    public Java.LocalVariable getLocalVariable(Java.LocalVariableDeclarationStatement lvds, Java.VariableDeclarator vd) throws CompileException {
        if (vd.localVariable != null) {
            return vd.localVariable;
        }
        Java.Type variableType = lvds.type;
        for (int k = 0; k < vd.brackets; ++k) {
            variableType = new Java.ArrayType(variableType);
        }
        vd.localVariable = new Java.LocalVariable(Mod.isFinal(lvds.modifiers.accessFlags), this.getType(variableType));
        return vd.localVariable;
    }

    private boolean compile2(Java.ReturnStatement rs) throws CompileException {
        Java.FunctionDeclarator enclosingFunction = null;
        Java.Scope s = rs.getEnclosingScope();
        while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        enclosingFunction = (Java.FunctionDeclarator)s;
        Java.Rvalue orv = rs.optionalReturnValue;
        IClass returnType = this.getReturnType(enclosingFunction);
        if (returnType == IClass.VOID) {
            if (orv != null) {
                this.compileError("Method must not return a value", rs.getLocation());
            }
            this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, null);
            this.writeOpcode(rs, -79);
            return false;
        }
        if (orv == null) {
            this.compileError("Method must return a value", rs.getLocation());
            return false;
        }
        IClass type = this.compileGetValue(orv);
        this.assignmentConversion(rs, type, returnType, this.getConstantValue(orv));
        this.leaveStatements(rs.getEnclosingScope(), enclosingFunction, returnType);
        this.writeOpcode(rs, -84 + UnitCompiler.ilfda(returnType));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.SynchronizedStatement ss) throws CompileException {
        if (!this.iClassLoader.TYPE_java_lang_Object.isAssignableFrom(this.compileGetValue(ss.expression))) {
            this.compileError("Monitor object of \"synchronized\" statement is not a subclass of \"Object\"", ss.getLocation());
        }
        this.getCodeContext().saveLocalVariables();
        boolean canCompleteNormally = false;
        try {
            ss.monitorLvIndex = this.getCodeContext().allocateLocalVariable((short)1);
            this.writeOpcode(ss, 89);
            this.store(ss, this.iClassLoader.TYPE_java_lang_Object, ss.monitorLvIndex);
            this.writeOpcode(ss, -62);
            CodeContext.Offset monitorExitOffset = this.getCodeContext().new CodeContext.Offset();
            CodeContext.Offset beginningOfBody = this.getCodeContext().newOffset();
            canCompleteNormally = this.compile(ss.body);
            if (canCompleteNormally) {
                this.writeBranch(ss, -89, monitorExitOffset);
            }
            CodeContext.Offset here = this.getCodeContext().newOffset();
            this.getCodeContext().addExceptionTableEntry(beginningOfBody, here, here, null);
            this.leave(ss, this.iClassLoader.TYPE_java_lang_Throwable);
            this.writeOpcode(ss, -65);
            if (canCompleteNormally) {
                monitorExitOffset.set();
                this.leave(ss, null);
            }
        }
        finally {
            this.getCodeContext().restoreLocalVariables();
        }
        return canCompleteNormally;
    }

    private boolean compile2(Java.ThrowStatement ts) throws CompileException {
        IClass expressionType = this.compileGetValue(ts.expression);
        this.checkThrownException(ts, expressionType, ts.getEnclosingScope());
        this.writeOpcode(ts, -65);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compile2(Java.TryStatement ts) throws CompileException {
        boolean canCompleteNormally;
        CodeContext.Offset beginningOfBody = this.getCodeContext().newOffset();
        CodeContext.Offset afterStatement = this.getCodeContext().new CodeContext.Offset();
        Java.Block of = ts.optionalFinally;
        if (of == null) {
            canCompleteNormally = this.compileTryWithoutFinally(ts, beginningOfBody, afterStatement);
        } else {
            CodeContext.Offset finallyClause = ts.finallyOffset = this.getCodeContext().new CodeContext.Offset();
            this.getCodeContext().saveLocalVariables();
            try {
                short pcLvIndex = this.getCodeContext().allocateLocalVariable((short)1);
                canCompleteNormally = this.compileTryWithoutFinally(ts, beginningOfBody, afterStatement);
                CodeContext.Offset here = this.getCodeContext().newOffset();
                this.getCodeContext().addExceptionTableEntry(beginningOfBody, here, here, null);
                this.getCodeContext().saveLocalVariables();
                try {
                    short evi = this.getCodeContext().allocateLocalVariable((short)1);
                    this.store(of, this.iClassLoader.TYPE_java_lang_Object, evi);
                    this.writeBranch(of, -88, finallyClause);
                    this.load(of, this.iClassLoader.TYPE_java_lang_Object, evi);
                    this.writeOpcode(of, -65);
                    finallyClause.set();
                    this.store(of, this.iClassLoader.TYPE_java_lang_Object, pcLvIndex);
                    if (this.compile(of)) {
                        if (pcLvIndex > 255) {
                            this.writeOpcode(of, -60);
                            this.writeOpcode(of, -87);
                            this.writeShort(pcLvIndex);
                        } else {
                            this.writeOpcode(of, -87);
                            this.writeByte(pcLvIndex);
                        }
                    }
                }
                finally {
                    this.getCodeContext().restoreLocalVariables();
                }
            }
            finally {
                this.getCodeContext().restoreLocalVariables();
            }
        }
        afterStatement.set();
        if (canCompleteNormally) {
            this.leave(ts, null);
        }
        return canCompleteNormally;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileTryWithoutFinally(Java.TryStatement tryStatement, CodeContext.Offset beginningOfBody, CodeContext.Offset afterStatement) throws CompileException {
        for (Java.CatchClause catchClause : tryStatement.catchClauses) {
            IClass caughtExceptionType = this.getType(catchClause.caughtException.type);
            catchClause.reachable = this.iClassLoader.TYPE_java_lang_Error.isAssignableFrom(caughtExceptionType) || caughtExceptionType.isAssignableFrom(this.iClassLoader.TYPE_java_lang_Error) || this.iClassLoader.TYPE_java_lang_RuntimeException.isAssignableFrom(caughtExceptionType) || caughtExceptionType.isAssignableFrom(this.iClassLoader.TYPE_java_lang_RuntimeException);
        }
        boolean canCompleteNormally = this.compile(tryStatement.body);
        CodeContext.Offset afterBody = this.getCodeContext().newOffset();
        if (canCompleteNormally) {
            this.writeBranch(tryStatement, -89, afterStatement);
        }
        if (beginningOfBody.offset != afterBody.offset) {
            this.getCodeContext().saveLocalVariables();
            try {
                for (int i = 0; i < tryStatement.catchClauses.size(); ++i) {
                    try {
                        this.getCodeContext().saveLocalVariables();
                        Java.CatchClause catchClause = tryStatement.catchClauses.get(i);
                        IClass caughtExceptionType = this.getType(catchClause.caughtException.type);
                        if (!catchClause.reachable) {
                            this.compileError("Catch clause is unreachable", catchClause.getLocation());
                        }
                        Java.LocalVariableSlot exceptionVarSlot = this.getCodeContext().allocateLocalVariable((short)1, catchClause.caughtException.name, caughtExceptionType);
                        short evi = exceptionVarSlot.getSlotIndex();
                        this.getLocalVariable(catchClause.caughtException).setSlot(exceptionVarSlot);
                        this.getCodeContext().addExceptionTableEntry(beginningOfBody, afterBody, this.getCodeContext().newOffset(), caughtExceptionType.getDescriptor());
                        this.store(catchClause, caughtExceptionType, evi);
                        if (!this.compile(catchClause.body)) continue;
                        canCompleteNormally = true;
                        if (i >= tryStatement.catchClauses.size() - 1 && tryStatement.optionalFinally == null) continue;
                        this.writeBranch(catchClause, -89, afterStatement);
                        continue;
                    }
                    finally {
                        this.getCodeContext().restoreLocalVariables();
                    }
                }
            }
            finally {
                this.getCodeContext().restoreLocalVariables();
            }
        }
        return canCompleteNormally;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(Java.FunctionDeclarator fd, ClassFile classFile) throws CompileException {
        short lvtani;
        ClassFile.MethodInfo mi;
        if (Mod.isPrivateAccess(fd.modifiers.accessFlags)) {
            short accessFlags;
            if (fd instanceof Java.MethodDeclarator && !fd.isStatic()) {
                accessFlags = Mod.changeAccess(fd.modifiers.accessFlags, (short)0);
                accessFlags = (short)(accessFlags | 8);
                mi = classFile.addMethodInfo(accessFlags, fd.name + '$', MethodDescriptor.prependParameter(this.toIMethod((Java.MethodDeclarator)fd).getDescriptor(), this.resolve(fd.getDeclaringType()).getDescriptor()));
            } else {
                accessFlags = Mod.changeAccess(fd.modifiers.accessFlags, (short)0);
                mi = classFile.addMethodInfo(accessFlags, fd.name, this.toIInvocable(fd).getDescriptor());
            }
        } else {
            mi = classFile.addMethodInfo(fd.modifiers.accessFlags, fd.name, this.toIInvocable(fd).getDescriptor());
        }
        this.compileAnnotations(fd.modifiers.annotations, mi, classFile);
        if (fd.thrownExceptions.length > 0) {
            short eani = classFile.addConstantUtf8Info("Exceptions");
            short[] tecciis = new short[fd.thrownExceptions.length];
            for (int i = 0; i < fd.thrownExceptions.length; ++i) {
                tecciis[i] = classFile.addConstantClassInfo(this.getType(fd.thrownExceptions[i]).getDescriptor());
            }
            mi.addAttribute(new ClassFile.ExceptionsAttribute(eani, tecciis));
        }
        if (fd.hasDeprecatedDocTag()) {
            mi.addAttribute(new ClassFile.DeprecatedAttribute(classFile.addConstantUtf8Info("Deprecated")));
        }
        if (Mod.isAbstract(fd.modifiers.accessFlags) || Mod.isNative(fd.modifiers.accessFlags)) {
            return;
        }
        final CodeContext codeContext = new CodeContext(mi.getClassFile(), mi.getName() + mi.getDescriptor());
        CodeContext savedCodeContext = this.replaceCodeContext(codeContext);
        try {
            List<? extends Java.BlockStatement> oss;
            this.getCodeContext().saveLocalVariables();
            if (!Mod.isStatic(fd.modifiers.accessFlags)) {
                this.getCodeContext().allocateLocalVariable((short)1, "this", this.resolve(fd.getDeclaringType()));
            }
            if (fd instanceof Java.ConstructorDeclarator) {
                Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)fd;
                if (fd.getDeclaringType() instanceof Java.EnumDeclaration) {
                    Java.LocalVariable lv1 = new Java.LocalVariable(true, this.iClassLoader.TYPE_java_lang_String);
                    lv1.setSlot(this.getCodeContext().allocateLocalVariable((short)1, null, null));
                    constructorDeclarator.syntheticParameters.put("$name", lv1);
                    Java.LocalVariable lv2 = new Java.LocalVariable(true, IClass.INT);
                    lv2.setSlot(this.getCodeContext().allocateLocalVariable((short)1, null, null));
                    constructorDeclarator.syntheticParameters.put("$ordinal", lv2);
                }
                for (IClass.IField sf : constructorDeclarator.getDeclaringClass().syntheticFields.values()) {
                    Java.LocalVariable lv = new Java.LocalVariable(true, sf.getType());
                    lv.setSlot(this.getCodeContext().allocateLocalVariable(Descriptor.size(sf.getDescriptor()), null, null));
                    constructorDeclarator.syntheticParameters.put(sf.getName(), lv);
                }
            }
            this.buildLocalVariableMap(fd);
            if (fd instanceof Java.ConstructorDeclarator) {
                Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
                if (cd.optionalConstructorInvocation != null) {
                    this.compile(cd.optionalConstructorInvocation);
                    if (cd.optionalConstructorInvocation instanceof Java.SuperConstructorInvocation) {
                        this.assignSyntheticParametersToSyntheticFields(cd);
                        this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                    }
                } else {
                    Java.Rvalue[] arguments;
                    IClass superclass = this.resolve(cd.getDeclaringClass()).getSuperclass();
                    if (superclass == null) {
                        throw new CompileException("\"" + cd + "\" has no superclass", cd.getLocation());
                    }
                    IClass outerClassOfSuperclass = superclass.getOuterIClass();
                    Java.QualifiedThisReference qualification = null;
                    if (outerClassOfSuperclass != null) {
                        qualification = new Java.QualifiedThisReference(cd.getLocation(), new Java.SimpleType(cd.getLocation(), outerClassOfSuperclass));
                    }
                    if (fd.getDeclaringType() instanceof Java.EnumDeclaration) {
                        Java.LocalVariableAccess nameAccess = new Java.LocalVariableAccess(cd.getLocation(), cd.syntheticParameters.get("$name"));
                        assert (nameAccess != null);
                        Java.LocalVariableAccess ordinalAccess = new Java.LocalVariableAccess(cd.getLocation(), cd.syntheticParameters.get("$ordinal"));
                        assert (ordinalAccess != null);
                        arguments = new Java.Rvalue[]{nameAccess, ordinalAccess};
                    } else {
                        arguments = new Java.Rvalue[]{};
                    }
                    Java.SuperConstructorInvocation sci = new Java.SuperConstructorInvocation(cd.getLocation(), qualification, arguments);
                    sci.setEnclosingScope(fd);
                    this.compile(sci);
                    this.assignSyntheticParametersToSyntheticFields(cd);
                    this.initializeInstanceVariablesAndInvokeInstanceInitializers(cd);
                }
            }
            if ((oss = fd.optionalStatements) == null) {
                this.compileError("Method must have a body", fd.getLocation());
                return;
            }
            if (this.compileStatements(oss)) {
                if (this.getReturnType(fd) != IClass.VOID) {
                    this.compileError("Method must return a value", fd.getLocation());
                }
                this.writeOpcode(fd, -79);
            }
        }
        finally {
            this.getCodeContext().restoreLocalVariables();
            this.replaceCodeContext(savedCodeContext);
        }
        if (this.compileErrorCount > 0) {
            return;
        }
        codeContext.fixUpAndRelocate();
        if (LOGGER.isLoggable(Level.FINE)) {
            try {
                codeContext.flowAnalysis(fd.toString());
            }
            catch (RuntimeException re) {
                LOGGER.log(Level.FINE, "*** FLOW ANALYSIS", re);
            }
        } else {
            try {
                codeContext.flowAnalysis(fd.toString());
            }
            catch (RuntimeException re) {
                throw new RuntimeException("Compiling \"" + fd + "\"; " + re.getMessage(), re);
            }
        }
        final short lntani = this.debugLines ? classFile.addConstantUtf8Info("LineNumberTable") : (short)0;
        if (this.debugVars) {
            UnitCompiler.makeLocalVariableNames(codeContext, mi);
            lvtani = classFile.addConstantUtf8Info("LocalVariableTable");
        } else {
            lvtani = 0;
        }
        mi.addAttribute(new ClassFile.AttributeInfo(classFile.addConstantUtf8Info("Code")){

            @Override
            protected void storeBody(DataOutputStream dos) throws IOException {
                codeContext.storeCodeAttributeBody(dos, lntani, lvtani);
            }
        });
    }

    private static void makeLocalVariableNames(CodeContext cc, ClassFile.MethodInfo mi) {
        ClassFile cf = mi.getClassFile();
        cf.addConstantUtf8Info("LocalVariableTable");
        for (Java.LocalVariableSlot slot : cc.getAllLocalVars()) {
            String localVariableName = slot.getName();
            if (localVariableName == null) continue;
            String typeName = slot.getType().getDescriptor();
            cf.addConstantUtf8Info(typeName);
            cf.addConstantUtf8Info(localVariableName);
        }
    }

    private void buildLocalVariableMap(Java.FunctionDeclarator fd) throws CompileException {
        Map<String, Java.LocalVariable> localVars = new HashMap<String, Java.LocalVariable>();
        for (int i = 0; i < fd.formalParameters.parameters.length; ++i) {
            Java.FunctionDeclarator.FormalParameter formalParameter = fd.formalParameters.parameters[i];
            IClass parameterIClass = this.getType(formalParameter.type);
            Java.LocalVariable lv = this.getLocalVariable(formalParameter, i == fd.formalParameters.parameters.length - 1 && fd.formalParameters.variableArity);
            lv.setSlot(this.getCodeContext().allocateLocalVariable(Descriptor.size(lv.type.getDescriptor()), formalParameter.name, parameterIClass));
            if (localVars.put(formalParameter.name, lv) == null) continue;
            this.compileError("Redefinition of parameter \"" + formalParameter.name + "\"", fd.getLocation());
        }
        fd.localVariables = localVars;
        if (fd instanceof Java.ConstructorDeclarator) {
            Java.ConstructorDeclarator cd = (Java.ConstructorDeclarator)fd;
            if (cd.optionalConstructorInvocation != null) {
                UnitCompiler.buildLocalVariableMap(cd.optionalConstructorInvocation, localVars);
            }
        }
        if (fd.optionalStatements != null) {
            for (Java.BlockStatement blockStatement : fd.optionalStatements) {
                localVars = this.buildLocalVariableMap(blockStatement, localVars);
            }
        }
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.BlockStatement blockStatement, final Map<String, Java.LocalVariable> localVars) throws CompileException {
        Map<String, Java.LocalVariable> result = blockStatement.accept(new Visitor.BlockStatementVisitor<Map<String, Java.LocalVariable>, CompileException>(){

            @Override
            public Map<String, Java.LocalVariable> visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.buildLocalVariableMap(aci, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.buildLocalVariableMap(bs, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.buildLocalVariableMap(cs, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitAssertStatement(Java.AssertStatement as) {
                UnitCompiler.buildLocalVariableMap(as, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.buildLocalVariableMap(es, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.buildLocalVariableMap(es, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.buildLocalVariableMap(fd, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.buildLocalVariableMap(rs, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.buildLocalVariableMap(sci, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.buildLocalVariableMap(ts, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.buildLocalVariableMap(lcds, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitBlock(Java.Block b) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(b, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitDoStatement(Java.DoStatement ds) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(ds, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitForStatement(Java.ForStatement fs) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(fs, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitForEachStatement(Java.ForEachStatement fes) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(fes, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitIfStatement(Java.IfStatement is) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(is, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitInitializer(Java.Initializer i) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(i, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitSwitchStatement(Java.SwitchStatement ss) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(ss, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitSynchronizedStatement(Java.SynchronizedStatement ss) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(ss, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitTryStatement(Java.TryStatement ts) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(ts, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitWhileStatement(Java.WhileStatement ws) throws CompileException {
                UnitCompiler.this.buildLocalVariableMap(ws, (Map<String, Java.LocalVariable>)localVars);
                return localVars;
            }

            @Override
            public Map<String, Java.LocalVariable> visitLabeledStatement(Java.LabeledStatement ls) throws CompileException {
                return UnitCompiler.this.buildLocalVariableMap(ls, (Map<String, Java.LocalVariable>)localVars);
            }

            @Override
            public Map<String, Java.LocalVariable> visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) throws CompileException {
                return UnitCompiler.this.buildLocalVariableMap(lvds, (Map<String, Java.LocalVariable>)localVars);
            }
        });
        assert (result != null);
        return result;
    }

    private static Map<String, Java.LocalVariable> buildLocalVariableMap(Java.Statement s, Map<String, Java.LocalVariable> localVars) {
        s.localVariables = localVars;
        return s.localVariables;
    }

    private static Map<String, Java.LocalVariable> buildLocalVariableMap(Java.ConstructorInvocation ci, Map<String, Java.LocalVariable> localVars) {
        ci.localVariables = localVars;
        return ci.localVariables;
    }

    private void buildLocalVariableMap(Java.Block block, Map<String, Java.LocalVariable> localVars) throws CompileException {
        block.localVariables = localVars;
        for (Java.BlockStatement bs : block.statements) {
            localVars = this.buildLocalVariableMap(bs, localVars);
        }
    }

    private void buildLocalVariableMap(Java.DoStatement ds, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ds.localVariables = localVars;
        this.buildLocalVariableMap(ds.body, localVars);
    }

    private void buildLocalVariableMap(Java.ForStatement fs, Map<String, Java.LocalVariable> localVars) throws CompileException {
        Map<String, Java.LocalVariable> inner = localVars;
        if (fs.optionalInit != null) {
            inner = this.buildLocalVariableMap(fs.optionalInit, localVars);
        }
        fs.localVariables = inner;
        this.buildLocalVariableMap(fs.body, inner);
    }

    private void buildLocalVariableMap(Java.ForEachStatement fes, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> vars = new HashMap<String, Java.LocalVariable>();
        vars.putAll(localVars);
        Java.LocalVariable elementLv = this.getLocalVariable(fes.currentElement, false);
        vars.put(fes.currentElement.name, elementLv);
        fes.localVariables = vars;
        this.buildLocalVariableMap(fes.body, vars);
    }

    private void buildLocalVariableMap(Java.IfStatement is, Map<String, Java.LocalVariable> localVars) throws CompileException {
        is.localVariables = localVars;
        this.buildLocalVariableMap(is.thenStatement, localVars);
        if (is.optionalElseStatement != null) {
            this.buildLocalVariableMap(is.optionalElseStatement, localVars);
        }
    }

    private void buildLocalVariableMap(Java.Initializer i, Map<String, Java.LocalVariable> localVars) throws CompileException {
        this.buildLocalVariableMap(i.block, localVars);
    }

    private void buildLocalVariableMap(Java.SwitchStatement ss, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ss.localVariables = localVars;
        Map<String, Java.LocalVariable> vars = localVars;
        for (Java.SwitchStatement.SwitchBlockStatementGroup sbsg : ss.sbsgs) {
            for (Java.BlockStatement bs : sbsg.blockStatements) {
                vars = this.buildLocalVariableMap(bs, vars);
            }
        }
    }

    private void buildLocalVariableMap(Java.SynchronizedStatement ss, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ss.localVariables = localVars;
        this.buildLocalVariableMap(ss.body, localVars);
    }

    private void buildLocalVariableMap(Java.TryStatement ts, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ts.localVariables = localVars;
        this.buildLocalVariableMap(ts.body, localVars);
        for (Java.CatchClause cc : ts.catchClauses) {
            this.buildLocalVariableMap(cc, localVars);
        }
        if (ts.optionalFinally != null) {
            this.buildLocalVariableMap(ts.optionalFinally, localVars);
        }
    }

    private void buildLocalVariableMap(Java.WhileStatement ws, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ws.localVariables = localVars;
        this.buildLocalVariableMap(ws.body, localVars);
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.LabeledStatement ls, Map<String, Java.LocalVariable> localVars) throws CompileException {
        ls.localVariables = localVars;
        return this.buildLocalVariableMap(ls.body, localVars);
    }

    private Map<String, Java.LocalVariable> buildLocalVariableMap(Java.LocalVariableDeclarationStatement lvds, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> newVars = new HashMap<String, Java.LocalVariable>();
        newVars.putAll(localVars);
        for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
            Java.LocalVariable lv = this.getLocalVariable(lvds, vd);
            if (newVars.put(vd.name, lv) == null) continue;
            this.compileError("Redefinition of local variable \"" + vd.name + "\" ", vd.getLocation());
        }
        lvds.localVariables = newVars;
        return newVars;
    }

    protected void buildLocalVariableMap(Java.CatchClause catchClause, Map<String, Java.LocalVariable> localVars) throws CompileException {
        HashMap<String, Java.LocalVariable> vars = new HashMap<String, Java.LocalVariable>();
        vars.putAll(localVars);
        Java.LocalVariable lv = this.getLocalVariable(catchClause.caughtException);
        vars.put(catchClause.caughtException.name, lv);
        this.buildLocalVariableMap(catchClause.body, vars);
    }

    public Java.LocalVariable getLocalVariable(Java.FunctionDeclarator.FormalParameter parameter) throws CompileException {
        return this.getLocalVariable(parameter, false);
    }

    public Java.LocalVariable getLocalVariable(Java.FunctionDeclarator.FormalParameter parameter, boolean isVariableArityParameter) throws CompileException {
        if (parameter.localVariable != null) {
            return parameter.localVariable;
        }
        assert (parameter.type != null);
        IClass parameterType = this.getType(parameter.type);
        if (isVariableArityParameter) {
            parameterType = parameterType.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
        }
        parameter.localVariable = new Java.LocalVariable(parameter.finaL, parameterType);
        return parameter.localVariable;
    }

    private void fakeCompile(Java.Rvalue rv) throws CompileException {
        CodeContext.Offset from = this.getCodeContext().newOffset();
        this.compileContext(rv);
        this.compileGet(rv);
        CodeContext.Offset to = this.getCodeContext().newOffset();
        this.getCodeContext().removeCode(from, to);
    }

    private void compile(Java.Rvalue rv) throws CompileException {
        rv.accept(new Visitor.RvalueVisitor<Void, CompileException>(){

            @Override
            @Nullable
            public Void visitLvalue(Java.Lvalue lv) throws CompileException {
                lv.accept(new Visitor.LvalueVisitor<Void, CompileException>(){

                    @Override
                    @Nullable
                    public Void visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        UnitCompiler.this.compile2(an);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                        UnitCompiler.this.compile2(aae);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        UnitCompiler.this.compile2(fa);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                        UnitCompiler.this.compile2(fae);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                        UnitCompiler.this.compile2(scfae);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitLocalVariableAccess(Java.LocalVariableAccess lva) throws CompileException {
                        UnitCompiler.this.compile2(lva);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        UnitCompiler.this.compile2(pe);
                        return null;
                    }
                });
                return null;
            }

            @Override
            @Nullable
            public Void visitArrayLength(Java.ArrayLength al) throws CompileException {
                UnitCompiler.this.compile2(al);
                return null;
            }

            @Override
            @Nullable
            public Void visitAssignment(Java.Assignment a) throws CompileException {
                UnitCompiler.this.compile2(a);
                return null;
            }

            @Override
            @Nullable
            public Void visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                UnitCompiler.this.compile2(uo);
                return null;
            }

            @Override
            @Nullable
            public Void visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                UnitCompiler.this.compile2(bo);
                return null;
            }

            @Override
            @Nullable
            public Void visitCast(Java.Cast c) throws CompileException {
                UnitCompiler.this.compile2(c);
                return null;
            }

            @Override
            @Nullable
            public Void visitClassLiteral(Java.ClassLiteral cl) throws CompileException {
                UnitCompiler.this.compile2(cl);
                return null;
            }

            @Override
            @Nullable
            public Void visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                UnitCompiler.this.compile2(ce);
                return null;
            }

            @Override
            @Nullable
            public Void visitCrement(Java.Crement c) throws CompileException {
                UnitCompiler.this.compile2(c);
                return null;
            }

            @Override
            @Nullable
            public Void visitInstanceof(Java.Instanceof io) throws CompileException {
                UnitCompiler.this.compile2(io);
                return null;
            }

            @Override
            @Nullable
            public Void visitMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                UnitCompiler.this.compile2(mi);
                return null;
            }

            @Override
            @Nullable
            public Void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) throws CompileException {
                UnitCompiler.this.compile2(smi);
                return null;
            }

            @Override
            @Nullable
            public Void visitIntegerLiteral(Java.IntegerLiteral il) throws CompileException {
                UnitCompiler.this.compile2(il);
                return null;
            }

            @Override
            @Nullable
            public Void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) throws CompileException {
                UnitCompiler.this.compile2(fpl);
                return null;
            }

            @Override
            @Nullable
            public Void visitBooleanLiteral(Java.BooleanLiteral bl) throws CompileException {
                UnitCompiler.this.compile2(bl);
                return null;
            }

            @Override
            @Nullable
            public Void visitCharacterLiteral(Java.CharacterLiteral cl) throws CompileException {
                UnitCompiler.this.compile2(cl);
                return null;
            }

            @Override
            @Nullable
            public Void visitStringLiteral(Java.StringLiteral sl) throws CompileException {
                UnitCompiler.this.compile2(sl);
                return null;
            }

            @Override
            @Nullable
            public Void visitNullLiteral(Java.NullLiteral nl) throws CompileException {
                UnitCompiler.this.compile2(nl);
                return null;
            }

            @Override
            @Nullable
            public Void visitSimpleConstant(Java.SimpleConstant sl) throws CompileException {
                UnitCompiler.this.compile2(sl);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) throws CompileException {
                UnitCompiler.this.compile2(naci);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewArray(Java.NewArray na) throws CompileException {
                UnitCompiler.this.compile2(na);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewInitializedArray(Java.NewInitializedArray nia) throws CompileException {
                UnitCompiler.this.compile2(nia);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                UnitCompiler.this.compile2(nci);
                return null;
            }

            @Override
            @Nullable
            public Void visitParameterAccess(Java.ParameterAccess pa) throws CompileException {
                UnitCompiler.this.compile2(pa);
                return null;
            }

            @Override
            @Nullable
            public Void visitQualifiedThisReference(Java.QualifiedThisReference qtr) throws CompileException {
                UnitCompiler.this.compile2(qtr);
                return null;
            }

            @Override
            @Nullable
            public Void visitThisReference(Java.ThisReference tr) throws CompileException {
                UnitCompiler.this.compile2(tr);
                return null;
            }
        });
    }

    private void compile2(Java.Rvalue rv) throws CompileException {
        this.pop(rv, this.compileGetValue(rv));
    }

    private void compile2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            this.compileContext(a.lhs);
            this.assignmentConversion(a, this.compileGetValue(a.rhs), this.getType(a.lhs), this.getConstantValue(a.rhs));
            this.compileSet(a.lhs);
            return;
        }
        int lhsCs = this.compileContext(a.lhs);
        this.dup(a, lhsCs);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!(this.tryIdentityConversion(resultType, lhsType) || this.tryNarrowingPrimitiveConversion(a, resultType, lhsType) || this.tryBoxingConversion(a, resultType, lhsType))) {
            this.compileError("Operand types unsuitable for '" + a.operator + "'", a.getLocation());
        }
        this.compileSet(a.lhs);
    }

    private void compile2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLv(c);
        if (lv != null) {
            this.compileLocalVariableCrement(c, lv);
            return;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        this.compileSet(c.operand);
    }

    private void compile2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compile(pe.value);
    }

    private boolean compile2(Java.AlternateConstructorInvocation aci) throws CompileException {
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)aci.getEnclosingScope();
        IClass declaringIClass = this.resolve(declaringConstructor.getDeclaringClass());
        this.writeOpcode(aci, 42);
        if (declaringIClass.getOuterIClass() != null) {
            this.writeOpcode(aci, 43);
        }
        this.invokeConstructor(aci, declaringConstructor, null, declaringIClass, aci.arguments);
        return true;
    }

    private boolean compile2(Java.SuperConstructorInvocation sci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        Java.ConstructorDeclarator declaringConstructor = (Java.ConstructorDeclarator)sci.getEnclosingScope();
        this.writeOpcode(sci, 42);
        Java.AbstractClassDeclaration declaringClass = declaringConstructor.getDeclaringClass();
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        if (superclass == null) {
            throw new CompileException("Class has no superclass", sci.getLocation());
        }
        if (sci.optionalQualification != null) {
            optionalEnclosingInstance = sci.optionalQualification;
        } else {
            IClass outerIClassOfSuperclass = superclass.getOuterIClass();
            if (outerIClassOfSuperclass == null) {
                optionalEnclosingInstance = null;
            } else {
                optionalEnclosingInstance = new Java.QualifiedThisReference(sci.getLocation(), new Java.SimpleType(sci.getLocation(), outerIClassOfSuperclass));
                optionalEnclosingInstance.setEnclosingScope(sci);
            }
        }
        this.invokeConstructor(sci, declaringConstructor, optionalEnclosingInstance, superclass, sci.arguments);
        return true;
    }

    private void compileBoolean(Java.Rvalue rv, final CodeContext.Offset dst, final boolean orientation) throws CompileException {
        rv.accept(new Visitor.RvalueVisitor<Void, CompileException>(){

            @Override
            @Nullable
            public Void visitLvalue(Java.Lvalue lv) throws CompileException {
                lv.accept(new Visitor.LvalueVisitor<Void, CompileException>(){

                    @Override
                    @Nullable
                    public Void visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        UnitCompiler.this.compileBoolean2(an, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                        UnitCompiler.this.compileBoolean2(aae, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        UnitCompiler.this.compileBoolean2(fa, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                        UnitCompiler.this.compileBoolean2(fae, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                        UnitCompiler.this.compileBoolean2(scfae, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitLocalVariableAccess(Java.LocalVariableAccess lva) throws CompileException {
                        UnitCompiler.this.compileBoolean2(lva, dst, orientation);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        UnitCompiler.this.compileBoolean2(pe, dst, orientation);
                        return null;
                    }
                });
                return null;
            }

            @Override
            @Nullable
            public Void visitArrayLength(Java.ArrayLength al) throws CompileException {
                UnitCompiler.this.compileBoolean2(al, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitAssignment(Java.Assignment a) throws CompileException {
                UnitCompiler.this.compileBoolean2(a, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                UnitCompiler.this.compileBoolean2(uo, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                UnitCompiler.this.compileBoolean2(bo, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitCast(Java.Cast c) throws CompileException {
                UnitCompiler.this.compileBoolean2(c, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitClassLiteral(Java.ClassLiteral cl) throws CompileException {
                UnitCompiler.this.compileBoolean2(cl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                UnitCompiler.this.compileBoolean2(ce, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitCrement(Java.Crement c) throws CompileException {
                UnitCompiler.this.compileBoolean2(c, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitInstanceof(Java.Instanceof io) throws CompileException {
                UnitCompiler.this.compileBoolean2(io, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                UnitCompiler.this.compileBoolean2(mi, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) throws CompileException {
                UnitCompiler.this.compileBoolean2(smi, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitIntegerLiteral(Java.IntegerLiteral il) throws CompileException {
                UnitCompiler.this.compileBoolean2(il, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) throws CompileException {
                UnitCompiler.this.compileBoolean2(fpl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitBooleanLiteral(Java.BooleanLiteral bl) throws CompileException {
                UnitCompiler.this.compileBoolean2(bl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitCharacterLiteral(Java.CharacterLiteral cl) throws CompileException {
                UnitCompiler.this.compileBoolean2(cl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitStringLiteral(Java.StringLiteral sl) throws CompileException {
                UnitCompiler.this.compileBoolean2(sl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitNullLiteral(Java.NullLiteral nl) throws CompileException {
                UnitCompiler.this.compileBoolean2(nl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitSimpleConstant(Java.SimpleConstant sl) throws CompileException {
                UnitCompiler.this.compileBoolean2(sl, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) throws CompileException {
                UnitCompiler.this.compileBoolean2(naci, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewArray(Java.NewArray na) throws CompileException {
                UnitCompiler.this.compileBoolean2(na, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewInitializedArray(Java.NewInitializedArray nia) throws CompileException {
                UnitCompiler.this.compileBoolean2(nia, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                UnitCompiler.this.compileBoolean2(nci, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitParameterAccess(Java.ParameterAccess pa) throws CompileException {
                UnitCompiler.this.compileBoolean2(pa, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitQualifiedThisReference(Java.QualifiedThisReference qtr) throws CompileException {
                UnitCompiler.this.compileBoolean2(qtr, dst, orientation);
                return null;
            }

            @Override
            @Nullable
            public Void visitThisReference(Java.ThisReference tr) throws CompileException {
                UnitCompiler.this.compileBoolean2(tr, dst, orientation);
                return null;
            }
        });
    }

    private void compileBoolean2(Java.Rvalue rv, CodeContext.Offset dst, boolean orientation) throws CompileException {
        IClass type = this.compileGetValue(rv);
        IClassLoader icl = this.iClassLoader;
        if (type == icl.TYPE_java_lang_Boolean) {
            this.unboxingConversion(rv, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
        } else if (type != IClass.BOOLEAN) {
            this.compileError("Not a boolean expression", rv.getLocation());
        }
        this.writeBranch(rv, orientation ? -102 : -103, dst);
    }

    private void compileBoolean2(Java.UnaryOperation ue, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (ue.operator == "!") {
            this.compileBoolean(ue.operand, dst, !orientation);
            return;
        }
        this.compileError("Boolean expression expected", ue.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileBoolean2(Java.BinaryOperation bo, CodeContext.Offset dst, boolean orientation) throws CompileException {
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            this.compileBoolean2((Java.Rvalue)bo, dst, orientation);
            return;
        }
        if (bo.op == "||" || bo.op == "&&") {
            Object lhsCv = this.getConstantValue(bo.lhs);
            if (lhsCv instanceof Boolean) {
                if ((Boolean)lhsCv ^ bo.op == "||") {
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                } else {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                    this.fakeCompile(bo.rhs);
                }
                return;
            }
            Object rhsCv = this.getConstantValue(bo.rhs);
            if (rhsCv instanceof Boolean) {
                if ((Boolean)rhsCv ^ bo.op == "||") {
                    this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                } else {
                    this.pop(bo.lhs, this.compileGetValue(bo.lhs));
                    this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                }
                return;
            }
            if (bo.op == "||" ^ !orientation) {
                this.compileBoolean(bo.lhs, dst, true ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
            } else {
                CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
                this.compileBoolean(bo.lhs, end, false ^ !orientation);
                this.compileBoolean(bo.rhs, dst, true ^ !orientation);
                end.set();
            }
            return;
        }
        if (bo.op == "==" || bo.op == "!=" || bo.op == "<=" || bo.op == ">=" || bo.op == "<" || bo.op == ">") {
            boolean rhsIsNull;
            int opIdx;
            int n = bo.op == "==" ? 0 : (bo.op == "!=" ? 1 : (bo.op == "<" ? 2 : (bo.op == ">=" ? 3 : (bo.op == ">" ? 4 : (opIdx = bo.op == "<=" ? 5 : Integer.MIN_VALUE)))));
            if (!orientation) {
                opIdx ^= 1;
            }
            boolean lhsIsNull = this.getConstantValue(bo.lhs) == null;
            boolean bl = rhsIsNull = this.getConstantValue(bo.rhs) == null;
            if (lhsIsNull || rhsIsNull) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on operand \"null\"", bo.getLocation());
                }
                if (!lhsIsNull) {
                    IClass lhsType = this.compileGetValue(bo.lhs);
                    if (lhsType.isPrimitive()) {
                        this.compileError("Cannot compare primitive type \"" + lhsType.toString() + "\" with \"null\"", bo.getLocation());
                    }
                } else if (!rhsIsNull) {
                    IClass rhsType = this.compileGetValue(bo.rhs);
                    if (rhsType.isPrimitive()) {
                        this.compileError("Cannot compare \"null\" with primitive type \"" + rhsType.toString() + "\"", bo.getLocation());
                    }
                } else {
                    this.pushConstant(bo, null);
                }
                this.writeBranch(bo, -58 + opIdx, dst);
                return;
            }
            IClass lhsType = this.compileGetValue(bo.lhs);
            CodeContext.Inserter convertLhsInserter = this.getCodeContext().newInserter();
            IClass rhsType = this.compileGetValue(bo.rhs);
            if (this.getUnboxedType(lhsType).isPrimitiveNumeric() && this.getUnboxedType(rhsType).isPrimitiveNumeric() && (bo.op != "==" && bo.op != "!=" || lhsType.isPrimitive() || rhsType.isPrimitive())) {
                IClass promotedType = this.binaryNumericPromotion(bo, lhsType, convertLhsInserter, rhsType);
                if (promotedType == IClass.INT) {
                    this.writeBranch(bo, -97 + opIdx, dst);
                } else if (promotedType == IClass.LONG) {
                    this.writeOpcode(bo, -108);
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.FLOAT) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -107);
                    } else {
                        this.writeOpcode(bo, -106);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else if (promotedType == IClass.DOUBLE) {
                    if (bo.op == ">" || bo.op == ">=") {
                        this.writeOpcode(bo, -105);
                    } else {
                        this.writeOpcode(bo, -104);
                    }
                    this.writeBranch(bo, -103 + opIdx, dst);
                } else {
                    throw new JaninoRuntimeException("Unexpected promoted type \"" + promotedType + "\"");
                }
                return;
            }
            if (lhsType == IClass.BOOLEAN && this.getUnboxedType(rhsType) == IClass.BOOLEAN || rhsType == IClass.BOOLEAN && this.getUnboxedType(lhsType) == IClass.BOOLEAN) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on boolean operands", bo.getLocation());
                }
                IClassLoader icl = this.iClassLoader;
                if (lhsType == icl.TYPE_java_lang_Boolean) {
                    this.getCodeContext().pushInserter(convertLhsInserter);
                    try {
                        this.unboxingConversion(bo, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                    }
                    finally {
                        this.getCodeContext().popInserter();
                    }
                }
                if (rhsType == icl.TYPE_java_lang_Boolean) {
                    this.unboxingConversion(bo, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                }
                this.writeBranch(bo, -97 + opIdx, dst);
                return;
            }
            if (!lhsType.isPrimitive() && !rhsType.isPrimitive()) {
                if (bo.op != "==" && bo.op != "!=") {
                    this.compileError("Operator \"" + bo.op + "\" not allowed on reference operands", bo.getLocation());
                }
                if (!this.isCastReferenceConvertible(lhsType, rhsType) || !this.isCastReferenceConvertible(rhsType, lhsType)) {
                    this.compileError("Incomparable types '" + lhsType + "' and '" + rhsType + "'", bo.getLocation());
                }
                this.writeBranch(bo, -91 + opIdx, dst);
                return;
            }
            this.compileError("Cannot compare types \"" + lhsType + "\" and \"" + rhsType + "\"", bo.getLocation());
        }
        this.compileError("Boolean expression expected", bo.getLocation());
    }

    private void compileBoolean2(Java.ParenthesizedExpression pe, CodeContext.Offset dst, boolean orientation) throws CompileException {
        this.compileBoolean(pe.value, dst, orientation);
    }

    private int compileContext(Java.Rvalue rv) throws CompileException {
        Integer result = rv.accept(new Visitor.RvalueVisitor<Integer, CompileException>(){

            @Override
            @Nullable
            public Integer visitLvalue(Java.Lvalue lv) throws CompileException {
                return lv.accept(new Visitor.LvalueVisitor<Integer, CompileException>(){

                    @Override
                    public Integer visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        return UnitCompiler.this.compileContext2(an);
                    }

                    @Override
                    public Integer visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                        return UnitCompiler.this.compileContext2(aae);
                    }

                    @Override
                    public Integer visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        return UnitCompiler.this.compileContext2(fa);
                    }

                    @Override
                    public Integer visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                        return UnitCompiler.this.compileContext2(fae);
                    }

                    @Override
                    public Integer visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                        return UnitCompiler.this.compileContext2(scfae);
                    }

                    @Override
                    public Integer visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                        return UnitCompiler.this.compileContext2(lva);
                    }

                    @Override
                    public Integer visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        return UnitCompiler.this.compileContext2(pe);
                    }
                });
            }

            @Override
            public Integer visitArrayLength(Java.ArrayLength al) throws CompileException {
                return UnitCompiler.this.compileContext2(al);
            }

            @Override
            public Integer visitAssignment(Java.Assignment a) {
                return UnitCompiler.this.compileContext2(a);
            }

            @Override
            public Integer visitUnaryOperation(Java.UnaryOperation uo) {
                return UnitCompiler.this.compileContext2(uo);
            }

            @Override
            public Integer visitBinaryOperation(Java.BinaryOperation bo) {
                return UnitCompiler.this.compileContext2(bo);
            }

            @Override
            public Integer visitCast(Java.Cast c) {
                return UnitCompiler.this.compileContext2(c);
            }

            @Override
            public Integer visitClassLiteral(Java.ClassLiteral cl) {
                return UnitCompiler.this.compileContext2(cl);
            }

            @Override
            public Integer visitConditionalExpression(Java.ConditionalExpression ce) {
                return UnitCompiler.this.compileContext2(ce);
            }

            @Override
            public Integer visitCrement(Java.Crement c) {
                return UnitCompiler.this.compileContext2(c);
            }

            @Override
            public Integer visitInstanceof(Java.Instanceof io) {
                return UnitCompiler.this.compileContext2(io);
            }

            @Override
            public Integer visitMethodInvocation(Java.MethodInvocation mi) {
                return UnitCompiler.this.compileContext2(mi);
            }

            @Override
            public Integer visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                return UnitCompiler.this.compileContext2(smi);
            }

            @Override
            public Integer visitIntegerLiteral(Java.IntegerLiteral il) {
                return UnitCompiler.this.compileContext2(il);
            }

            @Override
            public Integer visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                return UnitCompiler.this.compileContext2(fpl);
            }

            @Override
            public Integer visitBooleanLiteral(Java.BooleanLiteral bl) {
                return UnitCompiler.this.compileContext2(bl);
            }

            @Override
            public Integer visitCharacterLiteral(Java.CharacterLiteral cl) {
                return UnitCompiler.this.compileContext2(cl);
            }

            @Override
            public Integer visitStringLiteral(Java.StringLiteral sl) {
                return UnitCompiler.this.compileContext2(sl);
            }

            @Override
            public Integer visitNullLiteral(Java.NullLiteral nl) {
                return UnitCompiler.this.compileContext2(nl);
            }

            @Override
            public Integer visitSimpleConstant(Java.SimpleConstant sl) {
                return UnitCompiler.this.compileContext2(sl);
            }

            @Override
            public Integer visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                return UnitCompiler.this.compileContext2(naci);
            }

            @Override
            public Integer visitNewArray(Java.NewArray na) {
                return UnitCompiler.this.compileContext2(na);
            }

            @Override
            public Integer visitNewInitializedArray(Java.NewInitializedArray nia) {
                return UnitCompiler.this.compileContext2(nia);
            }

            @Override
            public Integer visitNewClassInstance(Java.NewClassInstance nci) {
                return UnitCompiler.this.compileContext2(nci);
            }

            @Override
            public Integer visitParameterAccess(Java.ParameterAccess pa) {
                return UnitCompiler.this.compileContext2(pa);
            }

            @Override
            public Integer visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                return UnitCompiler.this.compileContext2(qtr);
            }

            @Override
            public Integer visitThisReference(Java.ThisReference tr) {
                return UnitCompiler.this.compileContext2(tr);
            }
        });
        assert (result != null);
        return result;
    }

    private int compileContext2(Java.Rvalue rv) {
        return 0;
    }

    private int compileContext2(Java.AmbiguousName an) throws CompileException {
        return this.compileContext(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    private int compileContext2(Java.FieldAccess fa) throws CompileException {
        if (fa.field.isStatic()) {
            Java.Rvalue rv = fa.lhs.toRvalue();
            if (rv != null) {
                this.warning("CNSFA", "Left-hand side of static field access should be a type, not an rvalue", fa.lhs.getLocation());
                this.pop(fa.lhs, this.compileGetValue(rv));
            }
            return 0;
        }
        this.compileGetValue(this.toRvalueOrCompileException(fa.lhs));
        return 1;
    }

    private int compileContext2(Java.ArrayLength al) throws CompileException {
        if (!this.compileGetValue(al.lhs).isArray()) {
            this.compileError("Cannot determine length of non-array type", al.getLocation());
        }
        return 1;
    }

    private int compileContext2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass indexType;
        IClass lhsType = this.compileGetValue(aae.lhs);
        if (!lhsType.isArray()) {
            this.compileError("Subscript not allowed on non-array type \"" + lhsType.toString() + "\"", aae.getLocation());
        }
        if (!this.tryIdentityConversion(indexType = this.compileGetValue(aae.index), IClass.INT) && !this.tryWideningPrimitiveConversion(aae, indexType, IClass.INT)) {
            this.compileError("Index expression of type \"" + indexType + "\" cannot be widened to \"int\"", aae.getLocation());
        }
        return 2;
    }

    private int compileContext2(Java.FieldAccessExpression fae) throws CompileException {
        return this.compileContext(this.determineValue(fae));
    }

    private int compileContext2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        return this.compileContext(this.determineValue(scfae));
    }

    private int compileContext2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileContext(pe.value);
    }

    private IClass compileGet(Java.Rvalue rv) throws CompileException {
        IClass result = rv.accept(new Visitor.RvalueVisitor<IClass, CompileException>(){

            @Override
            @Nullable
            public IClass visitLvalue(Java.Lvalue lv) throws CompileException {
                return lv.accept(new Visitor.LvalueVisitor<IClass, CompileException>(){

                    @Override
                    public IClass visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        return UnitCompiler.this.compileGet2(an);
                    }

                    @Override
                    public IClass visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                        return UnitCompiler.this.compileGet2(aae);
                    }

                    @Override
                    public IClass visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        return UnitCompiler.this.compileGet2(fa);
                    }

                    @Override
                    public IClass visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                        return UnitCompiler.this.compileGet2(fae);
                    }

                    @Override
                    public IClass visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                        return UnitCompiler.this.compileGet2(scfae);
                    }

                    @Override
                    public IClass visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                        return UnitCompiler.this.compileGet2(lva);
                    }

                    @Override
                    public IClass visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        return UnitCompiler.this.compileGet2(pe);
                    }
                });
            }

            @Override
            public IClass visitArrayLength(Java.ArrayLength al) {
                return UnitCompiler.this.compileGet2(al);
            }

            @Override
            public IClass visitAssignment(Java.Assignment a) throws CompileException {
                return UnitCompiler.this.compileGet2(a);
            }

            @Override
            public IClass visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                return UnitCompiler.this.compileGet2(uo);
            }

            @Override
            public IClass visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                return UnitCompiler.this.compileGet2(bo);
            }

            @Override
            public IClass visitCast(Java.Cast c) throws CompileException {
                return UnitCompiler.this.compileGet2(c);
            }

            @Override
            public IClass visitClassLiteral(Java.ClassLiteral cl) throws CompileException {
                return UnitCompiler.this.compileGet2(cl);
            }

            @Override
            public IClass visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                return UnitCompiler.this.compileGet2(ce);
            }

            @Override
            public IClass visitCrement(Java.Crement c) throws CompileException {
                return UnitCompiler.this.compileGet2(c);
            }

            @Override
            public IClass visitInstanceof(Java.Instanceof io) throws CompileException {
                return UnitCompiler.this.compileGet2(io);
            }

            @Override
            public IClass visitMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                return UnitCompiler.this.compileGet2(mi);
            }

            @Override
            public IClass visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) throws CompileException {
                return UnitCompiler.this.compileGet2(smi);
            }

            @Override
            public IClass visitIntegerLiteral(Java.IntegerLiteral il) throws CompileException {
                return UnitCompiler.this.compileGet2(il);
            }

            @Override
            public IClass visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) throws CompileException {
                return UnitCompiler.this.compileGet2(fpl);
            }

            @Override
            public IClass visitBooleanLiteral(Java.BooleanLiteral bl) throws CompileException {
                return UnitCompiler.this.compileGet2(bl);
            }

            @Override
            public IClass visitCharacterLiteral(Java.CharacterLiteral cl) throws CompileException {
                return UnitCompiler.this.compileGet2(cl);
            }

            @Override
            public IClass visitStringLiteral(Java.StringLiteral sl) throws CompileException {
                return UnitCompiler.this.compileGet2(sl);
            }

            @Override
            public IClass visitNullLiteral(Java.NullLiteral nl) throws CompileException {
                return UnitCompiler.this.compileGet2(nl);
            }

            @Override
            public IClass visitSimpleConstant(Java.SimpleConstant sl) throws CompileException {
                return UnitCompiler.this.compileGet2(sl);
            }

            @Override
            public IClass visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) throws CompileException {
                return UnitCompiler.this.compileGet2(naci);
            }

            @Override
            public IClass visitNewArray(Java.NewArray na) throws CompileException {
                return UnitCompiler.this.compileGet2(na);
            }

            @Override
            public IClass visitNewInitializedArray(Java.NewInitializedArray nia) throws CompileException {
                return UnitCompiler.this.compileGet2(nia);
            }

            @Override
            public IClass visitNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                return UnitCompiler.this.compileGet2(nci);
            }

            @Override
            public IClass visitParameterAccess(Java.ParameterAccess pa) throws CompileException {
                return UnitCompiler.this.compileGet2(pa);
            }

            @Override
            public IClass visitQualifiedThisReference(Java.QualifiedThisReference qtr) throws CompileException {
                return UnitCompiler.this.compileGet2(qtr);
            }

            @Override
            public IClass visitThisReference(Java.ThisReference tr) throws CompileException {
                return UnitCompiler.this.compileGet2(tr);
            }
        });
        assert (result != null);
        return result;
    }

    private IClass compileGet2(Java.BooleanRvalue brv) throws CompileException {
        CodeContext.Offset isTrue = this.getCodeContext().new CodeContext.Offset();
        this.compileBoolean(brv, isTrue, true);
        this.writeOpcode(brv, 3);
        CodeContext.Offset end = this.getCodeContext().new CodeContext.Offset();
        this.writeBranch(brv, -89, end);
        isTrue.set();
        this.writeOpcode(brv, 4);
        end.set();
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.AmbiguousName an) throws CompileException {
        return this.compileGet(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    private IClass compileGet2(Java.LocalVariableAccess lva) {
        return this.load(lva, lva.localVariable);
    }

    private IClass compileGet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingScope(), fa.getLocation());
        this.getfield(fa, fa.field);
        return fa.field.getType();
    }

    private IClass compileGet2(Java.ArrayLength al) {
        this.writeOpcode(al, -66);
        return IClass.INT;
    }

    private IClass compileGet2(Java.ThisReference tr) throws CompileException {
        this.referenceThis(tr);
        return this.getIClass(tr);
    }

    private IClass compileGet2(Java.QualifiedThisReference qtr) throws CompileException {
        this.referenceThis(qtr, this.getDeclaringClass(qtr), this.getDeclaringTypeBodyDeclaration(qtr), this.getTargetIClass(qtr));
        return this.getTargetIClass(qtr);
    }

    private IClass compileGet2(Java.ClassLiteral cl) throws CompileException {
        String classDollarFieldName;
        String className;
        Java.AbstractTypeDeclaration declaringType;
        Location loc;
        block18: {
            List<Java.BlockStatement> statics;
            loc = cl.getLocation();
            IClassLoader icl = this.iClassLoader;
            IClass iClass = this.getType(cl.type);
            if (iClass.isPrimitive()) {
                String wrapperClassDescriptor;
                this.writeOpcode(cl, -78);
                String string = iClass == IClass.VOID ? "Ljava/lang/Void;" : (iClass == IClass.BYTE ? "Ljava/lang/Byte;" : (iClass == IClass.CHAR ? "Ljava/lang/Character;" : (iClass == IClass.DOUBLE ? "Ljava/lang/Double;" : (iClass == IClass.FLOAT ? "Ljava/lang/Float;" : (iClass == IClass.INT ? "Ljava/lang/Integer;" : (iClass == IClass.LONG ? "Ljava/lang/Long;" : (iClass == IClass.SHORT ? "Ljava/lang/Short;" : (wrapperClassDescriptor = iClass == IClass.BOOLEAN ? "Ljava/lang/Boolean;" : null))))))));
                if (wrapperClassDescriptor == null) {
                    throw new JaninoRuntimeException("SNO: Unidentifiable primitive type \"" + iClass + "\"");
                }
                this.writeConstantFieldrefInfo(wrapperClassDescriptor, "TYPE", "Ljava/lang/Class;");
                return icl.TYPE_java_lang_Class;
            }
            Java.Scope s = cl.getEnclosingScope();
            while (true) {
                if (s instanceof Java.TypeDeclaration) break;
                s = s.getEnclosingScope();
            }
            declaringType = (Java.AbstractTypeDeclaration)s;
            if (declaringType.getMethodDeclaration("class$") == null) {
                this.declareClassDollarMethod(cl);
            }
            if (declaringType instanceof Java.AbstractClassDeclaration) {
                statics = ((Java.AbstractClassDeclaration)declaringType).variableDeclaratorsAndInitializers;
            } else if (declaringType instanceof Java.InterfaceDeclaration) {
                statics = ((Java.InterfaceDeclaration)declaringType).constantDeclarations;
            } else {
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }
            className = Descriptor.toClassName(iClass.getDescriptor());
            if (className.startsWith("[")) {
                classDollarFieldName = "array" + className.replace('.', '$').replace('[', '$');
                if (classDollarFieldName.endsWith(";")) {
                    classDollarFieldName = classDollarFieldName.substring(0, classDollarFieldName.length() - 1);
                }
            } else {
                classDollarFieldName = "class$" + className.replace('.', '$');
            }
            for (Java.BlockStatement bs : statics) {
                if (!((Java.TypeBodyDeclaration)((Object)bs)).isStatic() || !(bs instanceof Java.FieldDeclaration)) continue;
                for (Java.VariableDeclarator vd : ((Java.FieldDeclaration)bs).variableDeclarators) {
                    if (!vd.name.equals(classDollarFieldName)) {
                        continue;
                    }
                    break block18;
                }
            }
            Java.SimpleType classType = new Java.SimpleType(loc, icl.TYPE_java_lang_Class);
            Java.FieldDeclaration fd = new Java.FieldDeclaration(loc, null, new Java.Modifiers(8), classType, new Java.VariableDeclarator[]{new Java.VariableDeclarator(loc, classDollarFieldName, 0, null)});
            if (declaringType instanceof Java.AbstractClassDeclaration) {
                ((Java.AbstractClassDeclaration)declaringType).addFieldDeclaration(fd);
            } else if (declaringType instanceof Java.InterfaceDeclaration) {
                ((Java.InterfaceDeclaration)declaringType).addConstantDeclaration(fd);
            } else {
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }
        }
        Java.SimpleType declaringClassOrInterfaceType = new Java.SimpleType(loc, this.resolve(declaringType));
        Java.FieldAccessExpression classDollarFieldAccess = new Java.FieldAccessExpression(loc, declaringClassOrInterfaceType, classDollarFieldName);
        Java.ConditionalExpression ce = new Java.ConditionalExpression(loc, new Java.BinaryOperation(loc, classDollarFieldAccess, "!=", new Java.NullLiteral(loc, "null")), classDollarFieldAccess, new Java.Assignment(loc, classDollarFieldAccess, "=", new Java.MethodInvocation(loc, declaringClassOrInterfaceType, "class$", new Java.Rvalue[]{new Java.StringLiteral(loc, '\"' + className + '\"')})));
        ce.setEnclosingScope(cl.getEnclosingScope());
        return this.compileGet(ce);
    }

    private IClass compileGet2(Java.Assignment a) throws CompileException {
        if (a.operator == "=") {
            int lhsCs = this.compileContext(a.lhs);
            IClass rhsType = this.compileGetValue(a.rhs);
            IClass lhsType = this.getType(a.lhs);
            Object rhsCv = this.getConstantValue(a.rhs);
            this.assignmentConversion(a, rhsType, lhsType, rhsCv);
            this.dupx(a, lhsType, lhsCs);
            this.compileSet(a.lhs);
            return lhsType;
        }
        int lhsCs = this.compileContext(a.lhs);
        this.dup(a, lhsCs);
        IClass lhsType = this.compileGet(a.lhs);
        IClass resultType = this.compileArithmeticBinaryOperation(a, lhsType, a.operator.substring(0, a.operator.length() - 1).intern(), a.rhs);
        if (!this.tryIdentityConversion(resultType, lhsType) && !this.tryNarrowingPrimitiveConversion(a, resultType, lhsType)) {
            throw new JaninoRuntimeException("SNO: \"" + a.operator + "\" reconversion failed");
        }
        this.dupx(a, lhsType, lhsCs);
        this.compileSet(a.lhs);
        return lhsType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IClass compileGet2(Java.ConditionalExpression ce) throws CompileException {
        IClass expressionType;
        CodeContext.Offset toEnd;
        block16: {
            IClass rhsType;
            IClass mhsType;
            block24: {
                CodeContext.Inserter rhsConvertInserter;
                CodeContext.Inserter mhsConvertInserter;
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            toEnd = this.getCodeContext().new CodeContext.Offset();
                                            Object cv = this.getConstantValue(ce.lhs);
                                            if (cv instanceof Boolean) {
                                                if (((Boolean)cv).booleanValue()) {
                                                    mhsType = this.compileGetValue(ce.mhs);
                                                    mhsConvertInserter = this.getCodeContext().newInserter();
                                                    rhsType = this.getType(ce.rhs);
                                                    rhsConvertInserter = null;
                                                } else {
                                                    mhsType = this.getType(ce.mhs);
                                                    mhsConvertInserter = null;
                                                    rhsType = this.compileGetValue(ce.rhs);
                                                    rhsConvertInserter = this.getCodeContext().currentInserter();
                                                }
                                            } else {
                                                CodeContext.Offset toRhs = this.getCodeContext().new CodeContext.Offset();
                                                this.compileBoolean(ce.lhs, toRhs, false);
                                                mhsType = this.compileGetValue(ce.mhs);
                                                mhsConvertInserter = this.getCodeContext().newInserter();
                                                this.writeBranch(ce, -89, toEnd);
                                                toRhs.set();
                                                rhsType = this.compileGetValue(ce.rhs);
                                                rhsConvertInserter = this.getCodeContext().currentInserter();
                                            }
                                            if (mhsType != rhsType) break block17;
                                            expressionType = mhsType;
                                            break block16;
                                        }
                                        if (!this.tryUnboxingConversion(ce.mhs, mhsType, rhsType, mhsConvertInserter)) break block18;
                                        expressionType = rhsType;
                                        break block16;
                                    }
                                    if (!this.tryUnboxingConversion(ce.rhs, rhsType, mhsType, rhsConvertInserter)) break block19;
                                    expressionType = mhsType;
                                    break block16;
                                }
                                if (this.getConstantValue(ce.mhs) != null || rhsType.isPrimitive()) break block20;
                                expressionType = rhsType;
                                break block16;
                            }
                            if (mhsType.isPrimitive() || this.getConstantValue(ce.rhs) != null) break block21;
                            expressionType = mhsType;
                            break block16;
                        }
                        if (ce.mhs.constantValue != null || !rhsType.isPrimitive()) break block22;
                        expressionType = this.isBoxingConvertible(rhsType);
                        assert (expressionType != null) : rhsType + " is not boxing convertible";
                        break block16;
                    }
                    if (ce.rhs.constantValue != null || !mhsType.isPrimitive()) break block23;
                    expressionType = this.isBoxingConvertible(mhsType);
                    assert (expressionType != null) : mhsType + " is not boxing convertible";
                    break block16;
                }
                if (!this.isConvertibleToPrimitiveNumeric(mhsType) || !this.isConvertibleToPrimitiveNumeric(rhsType)) break block24;
                Object rhscv = ce.rhs.constantValue;
                Object mhscv = ce.mhs.constantValue;
                if (mhsType == IClass.BYTE && rhsType == IClass.INT && UnitCompiler.isByteConstant(rhscv) != null) {
                    expressionType = IClass.BYTE;
                    ce.rhs.constantValue = UnitCompiler.isByteConstant(rhscv);
                    break block16;
                } else if (mhsType == IClass.INT && rhsType == IClass.BYTE && UnitCompiler.isByteConstant(mhscv) != null) {
                    expressionType = IClass.BYTE;
                    ce.mhs.constantValue = UnitCompiler.isByteConstant(mhscv);
                    break block16;
                } else {
                    expressionType = this.binaryNumericPromotion(ce, mhsType, mhsConvertInserter, rhsType, rhsConvertInserter);
                }
                break block16;
            }
            if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
                if (mhsType.isAssignableFrom(rhsType)) {
                    expressionType = mhsType;
                } else {
                    if (!rhsType.isAssignableFrom(mhsType)) {
                        this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
                        return this.iClassLoader.TYPE_java_lang_Object;
                    }
                    expressionType = rhsType;
                }
            } else {
                this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
                return this.iClassLoader.TYPE_java_lang_Object;
            }
        }
        toEnd.set();
        return expressionType;
    }

    @Nullable
    private static Byte isByteConstant(@Nullable Object o) {
        if (o instanceof Integer) {
            int v = (Integer)o;
            return v >= -128 && v <= 127 ? Byte.valueOf((byte)v) : null;
        }
        return null;
    }

    private IClass compileGet2(Java.Crement c) throws CompileException {
        Java.LocalVariable lv = this.isIntLv(c);
        if (lv != null) {
            if (!c.pre) {
                this.load(c, lv);
            }
            this.compileLocalVariableCrement(c, lv);
            if (c.pre) {
                this.load(c, lv);
            }
            return lv.type;
        }
        int cs = this.compileContext(c.operand);
        this.dup(c, cs);
        IClass type = this.compileGet(c.operand);
        if (!c.pre) {
            this.dupx(c, type, cs);
        }
        IClass promotedType = this.unaryNumericPromotion(c, type);
        this.writeOpcode(c, UnitCompiler.ilfd(promotedType, 4, 10, 12, 15));
        if (c.operator == "++") {
            this.writeOpcode(c, 96 + UnitCompiler.ilfd(promotedType));
        } else if (c.operator == "--") {
            this.writeOpcode(c, 100 + UnitCompiler.ilfd(promotedType));
        } else {
            this.compileError("Unexpected operator \"" + c.operator + "\"", c.getLocation());
        }
        this.reverseUnaryNumericPromotion(c, promotedType, type);
        if (c.pre) {
            this.dupx(c, type, cs);
        }
        this.compileSet(c.operand);
        return type;
    }

    private void compileLocalVariableCrement(Java.Crement c, Java.LocalVariable lv) {
        this.crement(c, lv, c.operator);
    }

    private void crement(Java.Locatable locatable, Java.LocalVariable lv, String operator) {
        if (lv.getSlotIndex() > 255) {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, -124);
            this.writeShort(lv.getSlotIndex());
            this.writeShort(operator == "++" ? 1 : -1);
        } else {
            this.writeOpcode(locatable, -124);
            this.writeByte(lv.getSlotIndex());
            this.writeByte(operator == "++" ? 1 : -1);
        }
    }

    private IClass compileGet2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass lhsComponentType = this.getType(aae);
        this.writeOpcode(aae, 46 + UnitCompiler.ilfdabcs(lhsComponentType));
        return lhsComponentType;
    }

    private IClass compileGet2(Java.FieldAccessExpression fae) throws CompileException {
        return this.compileGet(this.determineValue(fae));
    }

    private IClass compileGet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        return this.compileGet(this.determineValue(scfae));
    }

    private IClass compileGet2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return this.compileGet2((Java.BooleanRvalue)uo);
        }
        if (uo.operator == "+") {
            return this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
        }
        if (uo.operator == "-") {
            Object ncv = this.getNegatedConstantValue(uo.operand);
            if (ncv != NOT_CONSTANT) {
                return this.unaryNumericPromotion(uo, this.pushConstant(uo, ncv));
            }
            IClass promotedType = this.unaryNumericPromotion(uo, this.convertToPrimitiveNumericType(uo, this.compileGetValue(uo.operand)));
            this.writeOpcode(uo, 116 + UnitCompiler.ilfd(promotedType));
            return promotedType;
        }
        if (uo.operator == "~") {
            IClass operandType = this.compileGetValue(uo.operand);
            IClass promotedType = this.unaryNumericPromotion(uo, operandType);
            if (promotedType == IClass.INT) {
                this.writeOpcode(uo, 2);
                this.writeOpcode(uo, -126);
                return IClass.INT;
            }
            if (promotedType == IClass.LONG) {
                this.writeOpcode(uo, 20);
                this.writeConstantLongInfo(-1L);
                this.writeOpcode(uo, -125);
                return IClass.LONG;
            }
            this.compileError("Operator \"~\" not applicable to type \"" + promotedType + "\"", uo.getLocation());
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass compileGet2(Java.Instanceof io) throws CompileException {
        IClass lhsType = this.compileGetValue(io.lhs);
        IClass rhsType = this.getType(io.rhs);
        if (lhsType.isInterface() || rhsType.isInterface() || lhsType.isAssignableFrom(rhsType) || rhsType.isAssignableFrom(lhsType)) {
            this.writeOpcode(io, -63);
            this.writeConstantClassInfo(rhsType.getDescriptor());
        } else {
            this.compileError("\"" + lhsType + "\" can never be an instance of \"" + rhsType + "\"", io.getLocation());
        }
        return IClass.BOOLEAN;
    }

    private IClass compileGet2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return this.compileGet2((Java.BooleanRvalue)bo);
        }
        return this.compileArithmeticOperation(bo, null, bo.unrollLeftAssociation(), bo.op);
    }

    private IClass compileGet2(Java.Cast c) throws CompileException {
        IClass tt = this.getType(c.targetType);
        IClass vt = this.compileGetValue(c.value);
        if (this.tryIdentityConversion(vt, tt) || this.tryWideningPrimitiveConversion(c, vt, tt) || this.tryNarrowingPrimitiveConversion(c, vt, tt) || this.tryWideningReferenceConversion(vt, tt) || this.tryNarrowingReferenceConversion(c, vt, tt) || this.tryBoxingConversion(c, vt, tt) || this.tryUnboxingConversion(c, vt, tt, null)) {
            return tt;
        }
        IClass boxedType = this.isBoxingConvertible(vt);
        if (boxedType != null && this.isWideningReferenceConvertible(boxedType, tt)) {
            this.boxingConversion(c, vt, boxedType);
            return tt;
        }
        IClass unboxedType = this.isUnboxingConvertible(vt);
        if (unboxedType != null && this.isWideningPrimitiveConvertible(unboxedType, tt)) {
            this.unboxingConversion(c, vt, unboxedType);
            this.tryWideningPrimitiveConversion(c, unboxedType, tt);
            return tt;
        }
        this.compileError("Cannot cast \"" + vt + "\" to \"" + tt + "\"", c.getLocation());
        return tt;
    }

    private IClass compileGet2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.compileGet(pe.value);
    }

    private IClass compileGet2(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod = this.findIMethod(mi);
        Java.Atom ot = mi.optionalTarget;
        if (ot == null) {
            Java.Scope s = mi.getEnclosingScope();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeBodyDeclaration scopeTbd = (Java.TypeBodyDeclaration)s;
            if (!(s instanceof Java.AbstractClassDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.AbstractClassDeclaration scopeClassDeclaration = (Java.AbstractClassDeclaration)s;
            if (iMethod.isStatic()) {
                this.warning("IASM", "Implicit access to static method \"" + iMethod.toString() + "\"", mi.getLocation());
            } else {
                this.warning("IANSM", "Implicit access to non-static method \"" + iMethod.toString() + "\"", mi.getLocation());
                if (scopeTbd.isStatic()) {
                    this.compileError("Instance method \"" + iMethod.toString() + "\" cannot be invoked in static context", mi.getLocation());
                }
                this.referenceThis(mi, scopeClassDeclaration, scopeTbd, iMethod.getDeclaringIClass());
            }
        } else {
            boolean staticContext = this.isType(ot);
            if (staticContext) {
                this.getType(this.toTypeOrCompileException(ot));
            } else {
                this.compileGetValue(this.toRvalueOrCompileException(ot));
            }
            if (iMethod.isStatic()) {
                if (!staticContext) {
                    this.pop(ot, this.getType(ot));
                }
            } else if (staticContext) {
                this.compileError("Instance method \"" + mi.methodName + "\" cannot be invoked in static context", mi.getLocation());
            }
        }
        IClass[] parameterTypes = iMethod.getParameterTypes();
        Java.Rvalue[] adjustedArgs = null;
        int actualSize = mi.arguments.length;
        if (iMethod.isVarargs() && iMethod.argsNeedAdjust()) {
            int i;
            adjustedArgs = new Java.Rvalue[parameterTypes.length];
            Java.ArrayInitializerOrRvalue[] lastArgs = new Java.Rvalue[actualSize - parameterTypes.length + 1];
            Location loc = mi.getLocation();
            if (lastArgs.length > 0) {
                i = 0;
                int j = parameterTypes.length - 1;
                while (i < lastArgs.length) {
                    lastArgs[i] = mi.arguments[j];
                    ++i;
                    ++j;
                }
            }
            for (i = parameterTypes.length - 2; i >= 0; --i) {
                adjustedArgs[i] = mi.arguments[i];
            }
            adjustedArgs[adjustedArgs.length - 1] = new Java.NewInitializedArray(loc, parameterTypes[parameterTypes.length - 1], new Java.ArrayInitializer(loc, lastArgs));
        } else {
            adjustedArgs = mi.arguments;
        }
        for (int i = 0; i < adjustedArgs.length; ++i) {
            this.assignmentConversion(mi, this.compileGetValue(adjustedArgs[i]), parameterTypes[i], this.getConstantValue(adjustedArgs[i]));
        }
        this.checkAccessible(iMethod, mi.getEnclosingScope(), mi.getLocation());
        if (iMethod.getDeclaringIClass().isInterface()) {
            this.invoke((Java.Locatable)mi, iMethod);
        } else if (!iMethod.isStatic() && iMethod.getAccess() == Access.PRIVATE) {
            this.writeOpcode(mi, -72);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName() + '$', MethodDescriptor.prependParameter(iMethod.getDescriptor(), iMethod.getDeclaringIClass().getDescriptor()));
        } else {
            this.invoke((Java.Locatable)mi, iMethod);
        }
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        Java.FunctionDeclarator fd;
        IClass.IMethod iMethod = this.findIMethod(scmi);
        Java.Scope s = scmi.getEnclosingScope();
        while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        Java.FunctionDeclarator functionDeclarator = fd = s instanceof Java.FunctionDeclarator ? (Java.FunctionDeclarator)s : null;
        if (fd == null) {
            this.compileError("Cannot invoke superclass method in non-method scope", scmi.getLocation());
            return IClass.INT;
        }
        if (Mod.isStatic(fd.modifiers.accessFlags)) {
            this.compileError("Cannot invoke superclass method in static context", scmi.getLocation());
        }
        this.load(scmi, this.resolve(fd.getDeclaringType()), 0);
        IClass[] parameterTypes = iMethod.getParameterTypes();
        for (int i = 0; i < scmi.arguments.length; ++i) {
            this.assignmentConversion(scmi, this.compileGetValue(scmi.arguments[i]), parameterTypes[i], this.getConstantValue(scmi.arguments[i]));
        }
        this.writeOpcode(scmi, -73);
        this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), scmi.methodName, iMethod.getDescriptor());
        return iMethod.getReturnType();
    }

    private IClass compileGet2(Java.NewClassInstance nci) throws CompileException {
        Java.Rvalue optionalEnclosingInstance;
        IClass iClass;
        if (nci.iClass != null) {
            iClass = nci.iClass;
        } else {
            assert (nci.type != null);
            iClass = nci.iClass = this.getType(nci.type);
        }
        this.writeOpcode(nci, -69);
        this.writeConstantClassInfo(iClass.getDescriptor());
        this.writeOpcode(nci, 89);
        if (iClass.isInterface()) {
            this.compileError("Cannot instantiate \"" + iClass + "\"", nci.getLocation());
        }
        this.checkAccessible(iClass, nci.getEnclosingScope(), nci.getLocation());
        if (iClass.isAbstract()) {
            this.compileError("Cannot instantiate abstract \"" + iClass + "\"", nci.getLocation());
        }
        if (nci.optionalQualification != null) {
            if (iClass.getOuterIClass() == null) {
                this.compileError("Static member class cannot be instantiated with qualified NEW");
            }
            optionalEnclosingInstance = nci.optionalQualification;
        } else {
            Java.Scope s = nci.getEnclosingScope();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeBodyDeclaration enclosingTypeBodyDeclaration = (Java.TypeBodyDeclaration)s;
            Java.TypeDeclaration enclosingTypeDeclaration = (Java.TypeDeclaration)s.getEnclosingScope();
            if (!(enclosingTypeDeclaration instanceof Java.AbstractClassDeclaration) || enclosingTypeBodyDeclaration.isStatic()) {
                if (iClass.getOuterIClass() != null) {
                    this.compileError("Instantiation of \"" + (nci.type != null ? nci.type.toString() : String.valueOf(nci.iClass)) + "\" requires an enclosing instance", nci.getLocation());
                }
                optionalEnclosingInstance = null;
            } else {
                IClass optionalOuterIClass = iClass.getDeclaringIClass();
                if (optionalOuterIClass == null) {
                    optionalEnclosingInstance = null;
                } else {
                    optionalEnclosingInstance = new Java.QualifiedThisReference(nci.getLocation(), new Java.SimpleType(nci.getLocation(), optionalOuterIClass));
                    optionalEnclosingInstance.setEnclosingScope(nci.getEnclosingScope());
                }
            }
        }
        this.invokeConstructor(nci, nci.getEnclosingScope(), optionalEnclosingInstance, iClass, nci.arguments);
        return iClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileGet2(Java.NewAnonymousClassInstance naci) throws CompileException {
        Java.AnonymousClassDeclaration acd = naci.anonymousClassDeclaration;
        IClass sc = this.resolve(acd).getSuperclass();
        assert (sc != null);
        IClass.IInvocable[] superclassIConstructors = sc.getDeclaredIConstructors();
        if (superclassIConstructors.length == 0) {
            throw new JaninoRuntimeException("SNO: Superclass has no constructors");
        }
        IClass.IConstructor superclassIConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(naci, superclassIConstructors, naci.arguments, acd);
        Location loc = naci.getLocation();
        IClass[] scpts = superclassIConstructor.getParameterTypes();
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        if (naci.optionalQualification != null) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, this.getType(naci.optionalQualification)), "this$base"));
        }
        for (int i = 0; i < scpts.length; ++i) {
            l.add(new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, scpts[i]), "p" + i));
        }
        Java.FunctionDeclarator.FormalParameters parameters = new Java.FunctionDeclarator.FormalParameters(loc, l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]), false);
        IClass[] tes = superclassIConstructor.getThrownExceptions();
        Java.Type[] thrownExceptions = new Java.Type[tes.length];
        for (int i = 0; i < tes.length; ++i) {
            thrownExceptions[i] = new Java.SimpleType(loc, tes[i]);
        }
        int j = 0;
        Java.ParameterAccess optionalQualificationAccess = naci.optionalQualification == null ? null : new Java.ParameterAccess(loc, parameters.parameters[j++]);
        Java.Rvalue[] parameterAccesses = new Java.Rvalue[scpts.length];
        for (int i = 0; i < scpts.length; ++i) {
            parameterAccesses[i] = new Java.ParameterAccess(loc, parameters.parameters[j++]);
        }
        acd.addConstructor(new Java.ConstructorDeclarator(loc, null, new Java.Modifiers(0), parameters, thrownExceptions, new Java.SuperConstructorInvocation(loc, optionalQualificationAccess, parameterAccesses), Collections.<Java.BlockStatement>emptyList()));
        try {
            Java.ThisReference oei;
            Java.Rvalue[] arguments2;
            this.compile(acd);
            this.writeOpcode(naci, -69);
            this.writeConstantClassInfo(this.resolve(naci.anonymousClassDeclaration).getDescriptor());
            this.writeOpcode(naci, 89);
            if (naci.optionalQualification == null) {
                arguments2 = naci.arguments;
            } else {
                arguments2 = new Java.Rvalue[naci.arguments.length + 1];
                arguments2[0] = naci.optionalQualification;
                System.arraycopy(naci.arguments, 0, arguments2, 1, naci.arguments.length);
            }
            Java.Scope s = naci.getEnclosingScope();
            while (!(s instanceof Java.TypeBodyDeclaration)) {
                s = s.getEnclosingScope();
            }
            if (((Java.TypeBodyDeclaration)s).isStatic()) {
                oei = null;
            } else {
                oei = new Java.ThisReference(loc);
                oei.setEnclosingScope(naci.getEnclosingScope());
            }
            this.invokeConstructor(naci, naci.getEnclosingScope(), oei, this.resolve(naci.anonymousClassDeclaration), arguments2);
        }
        finally {
            acd.constructors.remove(acd.constructors.size() - 1);
        }
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass compileGet2(Java.ParameterAccess pa) throws CompileException {
        Java.LocalVariable lv = this.getLocalVariable(pa.formalParameter);
        this.load(pa, lv);
        return lv.type;
    }

    private IClass compileGet2(Java.NewArray na) throws CompileException {
        for (Java.Rvalue dimExpr : na.dimExprs) {
            IClass dimType = this.compileGetValue(dimExpr);
            if (dimType == IClass.INT || this.unaryNumericPromotion(na, dimType) == IClass.INT) continue;
            this.compileError("Invalid array size expression type", na.getLocation());
        }
        return this.newArray(na, na.dimExprs.length, na.dims, this.getType(na.type));
    }

    private IClass compileGet2(Java.NewInitializedArray nia) throws CompileException {
        IClass at = this.getType2(nia);
        this.compileGetValue(nia.arrayInitializer, at);
        return at;
    }

    private void compileGetValue(Java.ArrayInitializer ai, IClass arrayType) throws CompileException {
        if (!arrayType.isArray()) {
            this.compileError("Array initializer not allowed for non-array type \"" + arrayType.toString() + "\"");
        }
        IClass ct = arrayType.getComponentType();
        assert (ct != null);
        this.pushConstant(ai, new Integer(ai.values.length));
        this.newArray(ai, 1, 0, ct);
        for (int i = 0; i < ai.values.length; ++i) {
            this.writeOpcode(ai, 89);
            this.pushConstant(ai, new Integer(i));
            Java.ArrayInitializerOrRvalue aiorv = ai.values[i];
            if (aiorv instanceof Java.Rvalue) {
                Java.Rvalue rv = (Java.Rvalue)aiorv;
                this.assignmentConversion(ai, this.compileGetValue(rv), ct, this.getConstantValue(rv));
            } else if (aiorv instanceof Java.ArrayInitializer) {
                this.compileGetValue((Java.ArrayInitializer)aiorv, ct);
            } else {
                throw new JaninoRuntimeException("Unexpected array initializer or rvalue class " + aiorv.getClass().getName());
            }
            this.writeOpcode(ai, 79 + UnitCompiler.ilfdabcs(ct));
        }
    }

    private IClass compileGet2(Java.Literal l) throws CompileException {
        return this.pushConstant(l, this.getConstantValue(l));
    }

    private IClass compileGet2(Java.SimpleConstant sl) throws CompileException {
        return this.pushConstant(sl, sl.value);
    }

    private IClass compileGetValue(Java.Rvalue rv) throws CompileException {
        Object cv = this.getConstantValue(rv);
        if (cv != NOT_CONSTANT) {
            this.fakeCompile(rv);
            this.pushConstant(rv, cv);
            return this.getType(rv);
        }
        this.compileContext(rv);
        return this.compileGet(rv);
    }

    @Nullable
    public final Object getConstantValue(Java.Rvalue rv) throws CompileException {
        if (rv.constantValue != Java.Rvalue.CONSTANT_VALUE_UNKNOWN) {
            return rv.constantValue;
        }
        rv.constantValue = rv.accept(new Visitor.RvalueVisitor<Object, CompileException>(){

            @Override
            @Nullable
            public Object visitLvalue(Java.Lvalue lv) throws CompileException {
                return lv.accept(new Visitor.LvalueVisitor<Object, CompileException>(){

                    @Override
                    @Nullable
                    public Object visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        return UnitCompiler.this.getConstantValue2(an);
                    }

                    @Override
                    @Nullable
                    public Object visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                        return UnitCompiler.this.getConstantValue2(aae);
                    }

                    @Override
                    @Nullable
                    public Object visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        return UnitCompiler.this.getConstantValue2(fa);
                    }

                    @Override
                    @Nullable
                    public Object visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                        return UnitCompiler.this.getConstantValue2(fae);
                    }

                    @Override
                    @Nullable
                    public Object visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                        return UnitCompiler.this.getConstantValue2(scfae);
                    }

                    @Override
                    @Nullable
                    public Object visitLocalVariableAccess(Java.LocalVariableAccess lva) throws CompileException {
                        return UnitCompiler.this.getConstantValue2(lva);
                    }

                    @Override
                    @Nullable
                    public Object visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        return UnitCompiler.this.getConstantValue2(pe);
                    }
                });
            }

            @Override
            @Nullable
            public Object visitArrayLength(Java.ArrayLength al) {
                return UnitCompiler.this.getConstantValue2(al);
            }

            @Override
            @Nullable
            public Object visitAssignment(Java.Assignment a) {
                return UnitCompiler.this.getConstantValue2(a);
            }

            @Override
            @Nullable
            public Object visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                return UnitCompiler.this.getConstantValue2(uo);
            }

            @Override
            @Nullable
            public Object visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                return UnitCompiler.this.getConstantValue2(bo);
            }

            @Override
            @Nullable
            public Object visitCast(Java.Cast c) throws CompileException {
                return UnitCompiler.this.getConstantValue2(c);
            }

            @Override
            @Nullable
            public Object visitClassLiteral(Java.ClassLiteral cl) {
                return UnitCompiler.this.getConstantValue2(cl);
            }

            @Override
            @Nullable
            public Object visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                return UnitCompiler.this.getConstantValue2(ce);
            }

            @Override
            @Nullable
            public Object visitCrement(Java.Crement c) {
                return UnitCompiler.this.getConstantValue2(c);
            }

            @Override
            @Nullable
            public Object visitInstanceof(Java.Instanceof io) {
                return UnitCompiler.this.getConstantValue2(io);
            }

            @Override
            @Nullable
            public Object visitMethodInvocation(Java.MethodInvocation mi) {
                return UnitCompiler.this.getConstantValue2(mi);
            }

            @Override
            @Nullable
            public Object visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                return UnitCompiler.this.getConstantValue2(smi);
            }

            @Override
            @Nullable
            public Object visitIntegerLiteral(Java.IntegerLiteral il) throws CompileException {
                return UnitCompiler.this.getConstantValue2(il);
            }

            @Override
            @Nullable
            public Object visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) throws CompileException {
                return UnitCompiler.this.getConstantValue2(fpl);
            }

            @Override
            @Nullable
            public Object visitBooleanLiteral(Java.BooleanLiteral bl) {
                return UnitCompiler.this.getConstantValue2(bl);
            }

            @Override
            @Nullable
            public Object visitCharacterLiteral(Java.CharacterLiteral cl) {
                return UnitCompiler.this.getConstantValue2(cl);
            }

            @Override
            @Nullable
            public Object visitStringLiteral(Java.StringLiteral sl) {
                return UnitCompiler.this.getConstantValue2(sl);
            }

            @Override
            @Nullable
            public Object visitNullLiteral(Java.NullLiteral nl) {
                return UnitCompiler.this.getConstantValue2(nl);
            }

            @Override
            @Nullable
            public Object visitSimpleConstant(Java.SimpleConstant sl) {
                return UnitCompiler.this.getConstantValue2(sl);
            }

            @Override
            @Nullable
            public Object visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                return UnitCompiler.this.getConstantValue2(naci);
            }

            @Override
            @Nullable
            public Object visitNewArray(Java.NewArray na) {
                return UnitCompiler.this.getConstantValue2(na);
            }

            @Override
            @Nullable
            public Object visitNewInitializedArray(Java.NewInitializedArray nia) {
                return UnitCompiler.this.getConstantValue2(nia);
            }

            @Override
            @Nullable
            public Object visitNewClassInstance(Java.NewClassInstance nci) {
                return UnitCompiler.this.getConstantValue2(nci);
            }

            @Override
            @Nullable
            public Object visitParameterAccess(Java.ParameterAccess pa) {
                return UnitCompiler.this.getConstantValue2(pa);
            }

            @Override
            @Nullable
            public Object visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                return UnitCompiler.this.getConstantValue2(qtr);
            }

            @Override
            @Nullable
            public Object visitThisReference(Java.ThisReference tr) {
                return UnitCompiler.this.getConstantValue2(tr);
            }
        });
        return rv.constantValue;
    }

    @Nullable
    private Object getConstantValue2(Java.Rvalue rv) {
        return NOT_CONSTANT;
    }

    @Nullable
    private Object getConstantValue2(Java.AmbiguousName an) throws CompileException {
        return this.getConstantValue(this.toRvalueOrCompileException(this.reclassify(an)));
    }

    @Nullable
    private Object getConstantValue2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getConstantValue();
    }

    @Nullable
    private Object getConstantValue2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator.equals("+")) {
            return this.getConstantValue(uo.operand);
        }
        if (uo.operator.equals("-")) {
            return this.getNegatedConstantValue(uo.operand);
        }
        if (uo.operator.equals("!")) {
            Object cv = this.getConstantValue(uo.operand);
            return cv == Boolean.TRUE ? Boolean.FALSE : (cv == Boolean.FALSE ? Boolean.TRUE : NOT_CONSTANT);
        }
        return NOT_CONSTANT;
    }

    @Nullable
    private Object getConstantValue2(Java.ConditionalExpression ce) throws CompileException {
        Object lhsValue = this.getConstantValue(ce.lhs);
        if (lhsValue instanceof Boolean) {
            return (Boolean)lhsValue != false ? this.getConstantValue(ce.mhs) : this.getConstantValue(ce.rhs);
        }
        return NOT_CONSTANT;
    }

    @Nullable
    private Object getConstantValue2(Java.BinaryOperation bo) throws CompileException {
        Object lhsValue;
        if (bo.op == "|" || bo.op == "^" || bo.op == "&" || bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-" || bo.op == "==" || bo.op == "!=") {
            ArrayList<Object> cvs = new ArrayList<Object>();
            Iterator<Java.Rvalue> it = bo.unrollLeftAssociation();
            while (it.hasNext()) {
                Object cv = this.getConstantValue(it.next());
                if (cv == NOT_CONSTANT) {
                    return NOT_CONSTANT;
                }
                cvs.add(cv);
            }
            it = cvs.iterator();
            Object lhs = it.next();
            while (it.hasNext()) {
                if (lhs == NOT_CONSTANT) {
                    return NOT_CONSTANT;
                }
                Java.Rvalue rhs = it.next();
                if (bo.op == "+" && (lhs instanceof String || rhs instanceof String)) {
                    StringBuilder sb = new StringBuilder(lhs.toString()).append(rhs);
                    while (it.hasNext()) {
                        sb.append(((Object)it.next()).toString());
                    }
                    return sb.toString();
                }
                if (lhs instanceof Number && rhs instanceof Number) {
                    try {
                        if (lhs instanceof Double || rhs instanceof Double) {
                            double lhsD = ((Number)lhs).doubleValue();
                            double rhsD = ((Number)((Object)rhs)).doubleValue();
                            lhs = bo.op == "*" ? new Double(lhsD * rhsD) : (bo.op == "/" ? new Double(lhsD / rhsD) : (bo.op == "%" ? new Double(lhsD % rhsD) : (bo.op == "+" ? new Double(lhsD + rhsD) : (bo.op == "-" ? new Double(lhsD - rhsD) : (bo.op == "==" ? Boolean.valueOf(lhsD == rhsD) : (bo.op == "!=" ? Boolean.valueOf(lhsD != rhsD) : NOT_CONSTANT))))));
                            continue;
                        }
                        if (lhs instanceof Float || rhs instanceof Float) {
                            float lhsF = ((Number)lhs).floatValue();
                            float rhsF = ((Number)((Object)rhs)).floatValue();
                            lhs = bo.op == "*" ? new Float(lhsF * rhsF) : (bo.op == "/" ? new Float(lhsF / rhsF) : (bo.op == "%" ? new Float(lhsF % rhsF) : (bo.op == "+" ? new Float(lhsF + rhsF) : (bo.op == "-" ? new Float(lhsF - rhsF) : (bo.op == "==" ? Boolean.valueOf(lhsF == rhsF) : (bo.op == "!=" ? Boolean.valueOf(lhsF != rhsF) : NOT_CONSTANT))))));
                            continue;
                        }
                        if (lhs instanceof Long || rhs instanceof Long) {
                            long lhsL = ((Number)lhs).longValue();
                            long rhsL = ((Number)((Object)rhs)).longValue();
                            lhs = bo.op == "|" ? new Long(lhsL | rhsL) : (bo.op == "^" ? new Long(lhsL ^ rhsL) : (bo.op == "&" ? new Long(lhsL & rhsL) : (bo.op == "*" ? new Long(lhsL * rhsL) : (bo.op == "/" ? new Long(lhsL / rhsL) : (bo.op == "%" ? new Long(lhsL % rhsL) : (bo.op == "+" ? new Long(lhsL + rhsL) : (bo.op == "-" ? new Long(lhsL - rhsL) : (bo.op == "==" ? Boolean.valueOf(lhsL == rhsL) : (bo.op == "!=" ? Boolean.valueOf(lhsL != rhsL) : NOT_CONSTANT)))))))));
                            continue;
                        }
                        if (lhs instanceof Integer || lhs instanceof Byte || lhs instanceof Short || rhs instanceof Integer || lhs instanceof Byte || lhs instanceof Short) {
                            int lhsI = ((Number)lhs).intValue();
                            int rhsI = ((Number)((Object)rhs)).intValue();
                            lhs = bo.op == "|" ? new Integer(lhsI | rhsI) : (bo.op == "^" ? new Integer(lhsI ^ rhsI) : (bo.op == "&" ? new Integer(lhsI & rhsI) : (bo.op == "*" ? new Integer(lhsI * rhsI) : (bo.op == "/" ? new Integer(lhsI / rhsI) : (bo.op == "%" ? new Integer(lhsI % rhsI) : (bo.op == "+" ? new Integer(lhsI + rhsI) : (bo.op == "-" ? new Integer(lhsI - rhsI) : (bo.op == "==" ? Boolean.valueOf(lhsI == rhsI) : (bo.op == "!=" ? Boolean.valueOf(lhsI != rhsI) : NOT_CONSTANT)))))))));
                            continue;
                        }
                    }
                    catch (ArithmeticException ae) {
                        return NOT_CONSTANT;
                    }
                    throw new IllegalStateException();
                }
                if (lhs instanceof Character && rhs instanceof Character) {
                    char lhsC = ((Character)lhs).charValue();
                    char rhsC = ((Character)((Object)rhs)).charValue();
                    lhs = bo.op == "==" ? Boolean.valueOf(lhsC == rhsC) : (bo.op == "!=" ? Boolean.valueOf(lhsC != rhsC) : NOT_CONSTANT);
                    continue;
                }
                if (lhs == null || rhs == null) {
                    lhs = bo.op == "==" ? Boolean.valueOf(lhs == rhs) : (bo.op == "!=" ? Boolean.valueOf(lhs != rhs) : NOT_CONSTANT);
                    continue;
                }
                return NOT_CONSTANT;
            }
            return lhs;
        }
        if ((bo.op == "&&" || bo.op == "||") && (lhsValue = this.getConstantValue(bo.lhs)) instanceof Boolean) {
            boolean lhsBv = (Boolean)lhsValue;
            return bo.op == "&&" ? (lhsBv ? this.getConstantValue(bo.rhs) : Boolean.FALSE) : (lhsBv ? Boolean.TRUE : this.getConstantValue(bo.rhs));
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.Cast c) throws CompileException {
        Object cv = this.getConstantValue(c.value);
        if (cv == NOT_CONSTANT) {
            return NOT_CONSTANT;
        }
        if (cv instanceof Number) {
            IClass tt = this.getType(c.targetType);
            if (tt == IClass.BYTE) {
                return new Byte(((Number)cv).byteValue());
            }
            if (tt == IClass.SHORT) {
                return new Short(((Number)cv).shortValue());
            }
            if (tt == IClass.INT) {
                return new Integer(((Number)cv).intValue());
            }
            if (tt == IClass.LONG) {
                return new Long(((Number)cv).longValue());
            }
            if (tt == IClass.FLOAT) {
                return new Float(((Number)cv).floatValue());
            }
            if (tt == IClass.DOUBLE) {
                return new Double(((Number)cv).doubleValue());
            }
        }
        return NOT_CONSTANT;
    }

    @Nullable
    private Object getConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getConstantValue(pe.value);
    }

    @Nullable
    private Object getConstantValue2(Java.LocalVariableAccess lva) throws CompileException {
        if (lva.getEnclosingScope() instanceof Java.IfStatement) {
            Java.Atom ra;
            Java.IfStatement is = (Java.IfStatement)lva.getEnclosingScope();
            if (is.condition instanceof Java.AmbiguousName && (ra = ((Java.AmbiguousName)is.condition).reclassified) instanceof Java.LocalVariableAccess) {
                int isi;
                List<? extends Java.BlockStatement> ss;
                Java.LocalVariable lv = ((Java.LocalVariableAccess)ra).localVariable;
                List<? extends Java.BlockStatement> list = is.getEnclosingScope() instanceof Java.FunctionDeclarator ? ((Java.FunctionDeclarator)is.getEnclosingScope()).optionalStatements : (ss = is.getEnclosingScope() instanceof Java.Block ? ((Java.Block)is.getEnclosingScope()).statements : null);
                if (ss != null && (isi = ss.indexOf(is)) >= 1 && ss.get(isi - 1) instanceof Java.LocalVariableDeclarationStatement) {
                    Java.ArrayInitializerOrRvalue oi;
                    Java.LocalVariableDeclarationStatement lvds = (Java.LocalVariableDeclarationStatement)ss.get(isi - 1);
                    if (lvds.variableDeclarators.length == 1 && lvds.variableDeclarators[0].localVariable == lv && (oi = lvds.variableDeclarators[0].optionalInitializer) instanceof Java.Rvalue) {
                        return this.getConstantValue((Java.Rvalue)oi);
                    }
                }
            }
        }
        return NOT_CONSTANT;
    }

    private Object getConstantValue2(Java.IntegerLiteral il) throws CompileException {
        int ui;
        String v = il.value;
        while ((ui = v.indexOf(95)) != -1) {
            v = v.substring(0, ui) + v.substring(ui + 1);
        }
        if (v.startsWith("0x") || v.startsWith("0X")) {
            return v.endsWith("L") || v.endsWith("l") ? (Number)UnitCompiler.hex2Long(il, v.substring(2, v.length() - 1)) : (Number)UnitCompiler.hex2Int(il, v.substring(2));
        }
        if (v.startsWith("0b") || v.startsWith("0X")) {
            return v.endsWith("L") || v.endsWith("l") ? (Number)UnitCompiler.bin2Long(il, v.substring(2, v.length() - 1)) : (Number)UnitCompiler.bin2Int(il, v.substring(2));
        }
        if (v.startsWith("0")) {
            return v.endsWith("L") || v.endsWith("l") ? (Number)UnitCompiler.oct2Long(il, v.substring(0, v.length() - 1)) : (Number)UnitCompiler.oct2Int(il, v);
        }
        try {
            return v.endsWith("L") || v.endsWith("l") ? (Number)Long.valueOf(v.substring(0, v.length() - 1)) : (Number)Integer.valueOf(v);
        }
        catch (NumberFormatException e) {
            throw UnitCompiler.compileException(il, "Invalid integer literal \"" + v + "\"");
        }
    }

    private Object getConstantValue2(Java.FloatingPointLiteral fpl) throws CompileException {
        double dv;
        int ui;
        String v = fpl.value;
        while ((ui = v.indexOf(95)) != -1) {
            v = v.substring(0, ui) + v.substring(ui + 1);
        }
        char lastChar = v.charAt(v.length() - 1);
        if (lastChar == 'f' || lastChar == 'F') {
            float fv;
            v = v.substring(0, v.length() - 1);
            try {
                fv = Float.parseFloat(v);
            }
            catch (NumberFormatException e) {
                throw new JaninoRuntimeException("SNO: parsing float literal '" + v + "': " + e.getMessage(), e);
            }
            if (Float.isInfinite(fv)) {
                throw UnitCompiler.compileException(fpl, "Value of float literal '" + v + "' is out of range");
            }
            if (Float.isNaN(fv)) {
                throw new JaninoRuntimeException("SNO: parsing float literal '" + v + "' results in NaN");
            }
            if (fv == 0.0f) {
                for (int i = 0; i < v.length(); ++i) {
                    char c = v.charAt(i);
                    if ("123456789".indexOf(c) != -1) {
                        throw UnitCompiler.compileException(fpl, "Literal '" + v + "' is too small to be represented as a float");
                    }
                    if (c != '0' && c != '.') break;
                }
            }
            return new Float(fv);
        }
        if (lastChar == 'd' || lastChar == 'D') {
            v = v.substring(0, v.length() - 1);
        }
        try {
            dv = Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            throw new JaninoRuntimeException("SNO: parsing double literal '" + v + "': " + e.getMessage(), e);
        }
        if (Double.isInfinite(dv)) {
            throw UnitCompiler.compileException(fpl, "Value of double literal '" + v + "' is out of range");
        }
        if (Double.isNaN(dv)) {
            throw new JaninoRuntimeException("SNO: parsing double literal '" + v + "' results is NaN");
        }
        if (dv == 0.0) {
            for (int i = 0; i < v.length(); ++i) {
                char c = v.charAt(i);
                if ("123456789".indexOf(c) != -1) {
                    throw UnitCompiler.compileException(fpl, "Literal '" + v + "' is too small to be represented as a double");
                }
                if (c != '0' && c != '.') break;
            }
        }
        return new Double(dv);
    }

    private Object getConstantValue2(Java.BooleanLiteral bl) {
        if (bl.value == "true") {
            return Boolean.TRUE;
        }
        if (bl.value == "false") {
            return Boolean.FALSE;
        }
        throw new JaninoRuntimeException(bl.value);
    }

    private Object getConstantValue2(Java.CharacterLiteral cl) {
        String v = cl.value;
        return Character.valueOf(UnitCompiler.unescape(v.substring(1, v.length() - 1)).charAt(0));
    }

    private Object getConstantValue2(Java.StringLiteral sl) {
        String v = sl.value;
        return UnitCompiler.unescape(v.substring(1, v.length() - 1));
    }

    @Nullable
    private Object getConstantValue2(Java.NullLiteral nl) {
        return null;
    }

    @Nullable
    private Object getConstantValue2(Java.SimpleConstant sl) {
        return sl.value;
    }

    @Nullable
    private Object getNegatedConstantValue(Java.Rvalue rv) throws CompileException {
        return rv.accept(new Visitor.RvalueVisitor<Object, CompileException>(){

            @Override
            @Nullable
            public Object visitLvalue(Java.Lvalue lv) throws CompileException {
                return lv.accept(new Visitor.LvalueVisitor<Object, CompileException>(){

                    @Override
                    @Nullable
                    public Object visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(an);
                    }

                    @Override
                    @Nullable
                    public Object visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(aae);
                    }

                    @Override
                    @Nullable
                    public Object visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(fa);
                    }

                    @Override
                    @Nullable
                    public Object visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(fae);
                    }

                    @Override
                    @Nullable
                    public Object visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(scfae);
                    }

                    @Override
                    @Nullable
                    public Object visitLocalVariableAccess(Java.LocalVariableAccess lva) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(lva);
                    }

                    @Override
                    @Nullable
                    public Object visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                        return UnitCompiler.this.getNegatedConstantValue2(pe);
                    }
                });
            }

            @Override
            @Nullable
            public Object visitArrayLength(Java.ArrayLength al) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(al);
            }

            @Override
            @Nullable
            public Object visitAssignment(Java.Assignment a) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(a);
            }

            @Override
            @Nullable
            public Object visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(uo);
            }

            @Override
            @Nullable
            public Object visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(bo);
            }

            @Override
            @Nullable
            public Object visitCast(Java.Cast c) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(c);
            }

            @Override
            @Nullable
            public Object visitClassLiteral(Java.ClassLiteral cl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(cl);
            }

            @Override
            @Nullable
            public Object visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(ce);
            }

            @Override
            @Nullable
            public Object visitCrement(Java.Crement c) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(c);
            }

            @Override
            @Nullable
            public Object visitInstanceof(Java.Instanceof io) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(io);
            }

            @Override
            @Nullable
            public Object visitMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(mi);
            }

            @Override
            @Nullable
            public Object visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(smi);
            }

            @Override
            @Nullable
            public Object visitIntegerLiteral(Java.IntegerLiteral il) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(il);
            }

            @Override
            @Nullable
            public Object visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(fpl);
            }

            @Override
            @Nullable
            public Object visitBooleanLiteral(Java.BooleanLiteral bl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(bl);
            }

            @Override
            @Nullable
            public Object visitCharacterLiteral(Java.CharacterLiteral cl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(cl);
            }

            @Override
            @Nullable
            public Object visitStringLiteral(Java.StringLiteral sl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(sl);
            }

            @Override
            @Nullable
            public Object visitNullLiteral(Java.NullLiteral nl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(nl);
            }

            @Override
            @Nullable
            public Object visitSimpleConstant(Java.SimpleConstant sl) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(sl);
            }

            @Override
            @Nullable
            public Object visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(naci);
            }

            @Override
            @Nullable
            public Object visitNewArray(Java.NewArray na) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(na);
            }

            @Override
            @Nullable
            public Object visitNewInitializedArray(Java.NewInitializedArray nia) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(nia);
            }

            @Override
            @Nullable
            public Object visitNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(nci);
            }

            @Override
            @Nullable
            public Object visitParameterAccess(Java.ParameterAccess pa) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(pa);
            }

            @Override
            @Nullable
            public Object visitQualifiedThisReference(Java.QualifiedThisReference qtr) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(qtr);
            }

            @Override
            @Nullable
            public Object visitThisReference(Java.ThisReference tr) throws CompileException {
                return UnitCompiler.this.getNegatedConstantValue2(tr);
            }
        });
    }

    @Nullable
    private Object getNegatedConstantValue2(Java.Rvalue rv) throws CompileException {
        Object cv = this.getConstantValue(rv);
        if (cv instanceof Byte) {
            return new Byte(-((Byte)cv).byteValue());
        }
        if (cv instanceof Short) {
            return new Short(-((Short)cv).shortValue());
        }
        if (cv instanceof Integer) {
            return new Integer(-((Integer)cv).intValue());
        }
        if (cv instanceof Long) {
            return new Long(-((Long)cv).longValue());
        }
        if (cv instanceof Float) {
            return new Float(-((Float)cv).floatValue());
        }
        if (cv instanceof Double) {
            return new Double(-((Double)cv).doubleValue());
        }
        return NOT_CONSTANT;
    }

    @Nullable
    private Object getNegatedConstantValue2(Java.UnaryOperation uo) throws CompileException {
        return uo.operator.equals("+") ? this.getNegatedConstantValue(uo.operand) : (uo.operator.equals("-") ? this.getConstantValue(uo.operand) : NOT_CONSTANT);
    }

    @Nullable
    private Object getNegatedConstantValue2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getNegatedConstantValue(pe.value);
    }

    @Nullable
    private Object getNegatedConstantValue2(Java.IntegerLiteral il) throws CompileException {
        String v = il.value;
        if (TWO_E_31_INTEGER.matcher(v).matches()) {
            return new Integer(Integer.MIN_VALUE);
        }
        if (TWO_E_63_LONG.matcher(v).matches()) {
            return new Long(Long.MIN_VALUE);
        }
        return this.getNegatedConstantValue2((Java.Rvalue)il);
    }

    private boolean generatesCode(Java.BlockStatement bs) throws CompileException {
        Boolean result = bs.accept(new Visitor.BlockStatementVisitor<Boolean, CompileException>(){

            @Override
            public Boolean visitInitializer(Java.Initializer i) throws CompileException {
                return UnitCompiler.this.generatesCode2(i);
            }

            @Override
            public Boolean visitFieldDeclaration(Java.FieldDeclaration fd) throws CompileException {
                return UnitCompiler.this.generatesCode2(fd);
            }

            @Override
            public Boolean visitLabeledStatement(Java.LabeledStatement ls) {
                return UnitCompiler.this.generatesCode2(ls);
            }

            @Override
            public Boolean visitBlock(Java.Block b) throws CompileException {
                return UnitCompiler.this.generatesCode2(b);
            }

            @Override
            public Boolean visitExpressionStatement(Java.ExpressionStatement es) {
                return UnitCompiler.this.generatesCode2(es);
            }

            @Override
            public Boolean visitIfStatement(Java.IfStatement is) {
                return UnitCompiler.this.generatesCode2(is);
            }

            @Override
            public Boolean visitForStatement(Java.ForStatement fs) {
                return UnitCompiler.this.generatesCode2(fs);
            }

            @Override
            public Boolean visitForEachStatement(Java.ForEachStatement fes) {
                return UnitCompiler.this.generatesCode2(fes);
            }

            @Override
            public Boolean visitWhileStatement(Java.WhileStatement ws) {
                return UnitCompiler.this.generatesCode2(ws);
            }

            @Override
            public Boolean visitTryStatement(Java.TryStatement ts) {
                return UnitCompiler.this.generatesCode2(ts);
            }

            @Override
            public Boolean visitSwitchStatement(Java.SwitchStatement ss) {
                return UnitCompiler.this.generatesCode2(ss);
            }

            @Override
            public Boolean visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                return UnitCompiler.this.generatesCode2(ss);
            }

            @Override
            public Boolean visitDoStatement(Java.DoStatement ds) {
                return UnitCompiler.this.generatesCode2(ds);
            }

            @Override
            public Boolean visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                return UnitCompiler.this.generatesCode2(lvds);
            }

            @Override
            public Boolean visitReturnStatement(Java.ReturnStatement rs) {
                return UnitCompiler.this.generatesCode2(rs);
            }

            @Override
            public Boolean visitThrowStatement(Java.ThrowStatement ts) {
                return UnitCompiler.this.generatesCode2(ts);
            }

            @Override
            public Boolean visitBreakStatement(Java.BreakStatement bs) {
                return UnitCompiler.this.generatesCode2(bs);
            }

            @Override
            public Boolean visitContinueStatement(Java.ContinueStatement cs) {
                return UnitCompiler.this.generatesCode2(cs);
            }

            @Override
            public Boolean visitAssertStatement(Java.AssertStatement as) {
                return UnitCompiler.this.generatesCode2(as);
            }

            @Override
            public Boolean visitEmptyStatement(Java.EmptyStatement es) {
                return UnitCompiler.this.generatesCode2(es);
            }

            @Override
            public Boolean visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                return UnitCompiler.this.generatesCode2(lcds);
            }

            @Override
            public Boolean visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                return UnitCompiler.this.generatesCode2(aci);
            }

            @Override
            public Boolean visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                return UnitCompiler.this.generatesCode2(sci);
            }
        });
        assert (result != null);
        return result;
    }

    private boolean generatesCode2(Java.BlockStatement bs) {
        return true;
    }

    private boolean generatesCode2(Java.AssertStatement as) {
        return true;
    }

    private boolean generatesCode2(Java.EmptyStatement es) {
        return false;
    }

    private boolean generatesCode2(Java.LocalClassDeclarationStatement lcds) {
        return false;
    }

    private boolean generatesCode2(Java.Initializer i) throws CompileException {
        return this.generatesCode(i.block);
    }

    private boolean generatesCode2(List<Java.BlockStatement> l) throws CompileException {
        for (Java.BlockStatement bs : l) {
            if (!this.generatesCode(bs)) continue;
            return true;
        }
        return false;
    }

    private boolean generatesCode2(Java.Block b) throws CompileException {
        return this.generatesCode2(b.statements);
    }

    private boolean generatesCode2(Java.FieldDeclaration fd) throws CompileException {
        for (Java.VariableDeclarator vd : fd.variableDeclarators) {
            if (this.getNonConstantFinalInitializer(fd, vd) == null) continue;
            return true;
        }
        return false;
    }

    private void leave(Java.BlockStatement bs, final @Nullable IClass optionalStackValueType) {
        Visitor.BlockStatementVisitor<Void, RuntimeException> bsv = new Visitor.BlockStatementVisitor<Void, RuntimeException>(){

            @Override
            @Nullable
            public Void visitInitializer(Java.Initializer i) {
                UnitCompiler.this.leave2(i, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitFieldDeclaration(Java.FieldDeclaration fd) {
                UnitCompiler.this.leave2(fd, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitLabeledStatement(Java.LabeledStatement ls) {
                UnitCompiler.this.leave2(ls, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitBlock(Java.Block b) {
                UnitCompiler.this.leave2(b, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitExpressionStatement(Java.ExpressionStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitIfStatement(Java.IfStatement is) {
                UnitCompiler.this.leave2(is, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitForStatement(Java.ForStatement fs) {
                UnitCompiler.this.leave2(fs, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitForEachStatement(Java.ForEachStatement fes) {
                UnitCompiler.this.leave2(fes, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitWhileStatement(Java.WhileStatement ws) {
                UnitCompiler.this.leave2(ws, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitTryStatement(Java.TryStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitSwitchStatement(Java.SwitchStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitSynchronizedStatement(Java.SynchronizedStatement ss) {
                UnitCompiler.this.leave2(ss, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitDoStatement(Java.DoStatement ds) {
                UnitCompiler.this.leave2(ds, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                UnitCompiler.this.leave2(lvds, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitReturnStatement(Java.ReturnStatement rs) {
                UnitCompiler.this.leave2(rs, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitThrowStatement(Java.ThrowStatement ts) {
                UnitCompiler.this.leave2(ts, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitBreakStatement(Java.BreakStatement bs) {
                UnitCompiler.this.leave2(bs, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitContinueStatement(Java.ContinueStatement cs) {
                UnitCompiler.this.leave2(cs, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitAssertStatement(Java.AssertStatement as) {
                UnitCompiler.this.leave2(as, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitEmptyStatement(Java.EmptyStatement es) {
                UnitCompiler.this.leave2(es, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement lcds) {
                UnitCompiler.this.leave2(lcds, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation aci) {
                UnitCompiler.this.leave2(aci, optionalStackValueType);
                return null;
            }

            @Override
            @Nullable
            public Void visitSuperConstructorInvocation(Java.SuperConstructorInvocation sci) {
                UnitCompiler.this.leave2(sci, optionalStackValueType);
                return null;
            }
        };
        bs.accept(bsv);
    }

    private void leave2(Java.BlockStatement bs, @Nullable IClass optionalStackValueType) {
    }

    private void leave2(Java.SynchronizedStatement ss, @Nullable IClass optionalStackValueType) {
        this.load(ss, this.iClassLoader.TYPE_java_lang_Object, ss.monitorLvIndex);
        this.writeOpcode(ss, -61);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave2(Java.TryStatement ts, @Nullable IClass optionalStackValueType) {
        CodeContext.Offset fo = ts.finallyOffset;
        if (fo == null) {
            return;
        }
        this.getCodeContext().saveLocalVariables();
        try {
            short sv = 0;
            if (optionalStackValueType != null) {
                sv = this.getCodeContext().allocateLocalVariable(Descriptor.size(optionalStackValueType.getDescriptor()));
                this.store(ts, optionalStackValueType, sv);
            }
            this.writeBranch(ts, -88, fo);
            if (optionalStackValueType != null) {
                this.load(ts, optionalStackValueType, sv);
            }
        }
        finally {
            this.getCodeContext().restoreLocalVariables();
        }
    }

    private void compileSet(Java.Lvalue lv) throws CompileException {
        lv.accept(new Visitor.LvalueVisitor<Void, CompileException>(){

            @Override
            @Nullable
            public Void visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                UnitCompiler.this.compileSet2(an);
                return null;
            }

            @Override
            @Nullable
            public Void visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                UnitCompiler.this.compileSet2(aae);
                return null;
            }

            @Override
            @Nullable
            public Void visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                UnitCompiler.this.compileSet2(fa);
                return null;
            }

            @Override
            @Nullable
            public Void visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                UnitCompiler.this.compileSet2(fae);
                return null;
            }

            @Override
            @Nullable
            public Void visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                UnitCompiler.this.compileSet2(scfae);
                return null;
            }

            @Override
            @Nullable
            public Void visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                UnitCompiler.this.compileSet2(lva);
                return null;
            }

            @Override
            @Nullable
            public Void visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                UnitCompiler.this.compileSet2(pe);
                return null;
            }
        });
    }

    private void compileSet2(Java.AmbiguousName an) throws CompileException {
        this.compileSet(this.toLvalueOrCompileException(this.reclassify(an)));
    }

    private void compileSet2(Java.LocalVariableAccess lva) {
        this.store(lva, lva.localVariable);
    }

    private void compileSet2(Java.FieldAccess fa) throws CompileException {
        this.checkAccessible(fa.field, fa.getEnclosingScope(), fa.getLocation());
        this.putfield(fa, fa.field);
    }

    private void compileSet2(Java.ArrayAccessExpression aae) throws CompileException {
        this.writeOpcode(aae, 79 + UnitCompiler.ilfdabcs(this.getType(aae)));
    }

    private void compileSet2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        this.compileSet(this.toLvalueOrCompileException(this.determineValue(fae)));
    }

    private void compileSet2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        this.compileSet(this.toLvalueOrCompileException(this.determineValue(scfae)));
    }

    private void compileSet2(Java.ParenthesizedExpression pe) throws CompileException {
        this.compileSet(this.toLvalueOrCompileException(pe.value));
    }

    private IClass getType(Java.Atom a) throws CompileException {
        IClass result = a.accept(new Visitor.AtomVisitor<IClass, CompileException>(){

            @Override
            public IClass visitPackage(Java.Package p) throws CompileException {
                return UnitCompiler.this.getType2(p);
            }

            @Override
            @Nullable
            public IClass visitType(Java.Type t) throws CompileException {
                return t.accept(new Visitor.TypeVisitor<IClass, CompileException>(){

                    @Override
                    public IClass visitArrayType(Java.ArrayType at) throws CompileException {
                        return UnitCompiler.this.getType2(at);
                    }

                    @Override
                    public IClass visitPrimitiveType(Java.PrimitiveType bt) {
                        return UnitCompiler.this.getType2(bt);
                    }

                    @Override
                    public IClass visitReferenceType(Java.ReferenceType rt) throws CompileException {
                        return UnitCompiler.this.getType2(rt);
                    }

                    @Override
                    public IClass visitRvalueMemberType(Java.RvalueMemberType rmt) throws CompileException {
                        return UnitCompiler.this.getType2(rmt);
                    }

                    @Override
                    public IClass visitSimpleType(Java.SimpleType st) {
                        return UnitCompiler.this.getType2(st);
                    }
                });
            }

            @Override
            @Nullable
            public IClass visitRvalue(Java.Rvalue rv) throws CompileException {
                return rv.accept(new Visitor.RvalueVisitor<IClass, CompileException>(){

                    @Override
                    @Nullable
                    public IClass visitLvalue(Java.Lvalue lv) throws CompileException {
                        return lv.accept(new Visitor.LvalueVisitor<IClass, CompileException>(){

                            @Override
                            public IClass visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                                return UnitCompiler.this.getType2(an);
                            }

                            @Override
                            public IClass visitArrayAccessExpression(Java.ArrayAccessExpression aae) throws CompileException {
                                return UnitCompiler.this.getType2(aae);
                            }

                            @Override
                            public IClass visitFieldAccess(Java.FieldAccess fa) throws CompileException {
                                return UnitCompiler.this.getType2(fa);
                            }

                            @Override
                            public IClass visitFieldAccessExpression(Java.FieldAccessExpression fae) throws CompileException {
                                return UnitCompiler.this.getType2(fae);
                            }

                            @Override
                            public IClass visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
                                return UnitCompiler.this.getType2(scfae);
                            }

                            @Override
                            public IClass visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                                return UnitCompiler.this.getType2(lva);
                            }

                            @Override
                            public IClass visitParenthesizedExpression(Java.ParenthesizedExpression pe) throws CompileException {
                                return UnitCompiler.this.getType2(pe);
                            }
                        });
                    }

                    @Override
                    public IClass visitArrayLength(Java.ArrayLength al) {
                        return UnitCompiler.this.getType2(al);
                    }

                    @Override
                    public IClass visitAssignment(Java.Assignment a) throws CompileException {
                        return UnitCompiler.this.getType2(a);
                    }

                    @Override
                    public IClass visitUnaryOperation(Java.UnaryOperation uo) throws CompileException {
                        return UnitCompiler.this.getType2(uo);
                    }

                    @Override
                    public IClass visitBinaryOperation(Java.BinaryOperation bo) throws CompileException {
                        return UnitCompiler.this.getType2(bo);
                    }

                    @Override
                    public IClass visitCast(Java.Cast c) throws CompileException {
                        return UnitCompiler.this.getType2(c);
                    }

                    @Override
                    public IClass visitClassLiteral(Java.ClassLiteral cl) {
                        return UnitCompiler.this.getType2(cl);
                    }

                    @Override
                    public IClass visitConditionalExpression(Java.ConditionalExpression ce) throws CompileException {
                        return UnitCompiler.this.getType2(ce);
                    }

                    @Override
                    public IClass visitCrement(Java.Crement c) throws CompileException {
                        return UnitCompiler.this.getType2(c);
                    }

                    @Override
                    public IClass visitInstanceof(Java.Instanceof io) {
                        return UnitCompiler.this.getType2(io);
                    }

                    @Override
                    public IClass visitMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                        return UnitCompiler.this.getType2(mi);
                    }

                    @Override
                    public IClass visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) throws CompileException {
                        return UnitCompiler.this.getType2(smi);
                    }

                    @Override
                    public IClass visitIntegerLiteral(Java.IntegerLiteral il) {
                        return UnitCompiler.this.getType2(il);
                    }

                    @Override
                    public IClass visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                        return UnitCompiler.this.getType2(fpl);
                    }

                    @Override
                    public IClass visitBooleanLiteral(Java.BooleanLiteral bl) {
                        return UnitCompiler.this.getType2(bl);
                    }

                    @Override
                    public IClass visitCharacterLiteral(Java.CharacterLiteral cl) {
                        return UnitCompiler.this.getType2(cl);
                    }

                    @Override
                    public IClass visitStringLiteral(Java.StringLiteral sl) {
                        return UnitCompiler.this.getType2(sl);
                    }

                    @Override
                    public IClass visitNullLiteral(Java.NullLiteral nl) {
                        return UnitCompiler.this.getType2(nl);
                    }

                    @Override
                    public IClass visitSimpleConstant(Java.SimpleConstant sl) {
                        return UnitCompiler.this.getType2(sl);
                    }

                    @Override
                    public IClass visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                        return UnitCompiler.this.getType2(naci);
                    }

                    @Override
                    public IClass visitNewArray(Java.NewArray na) throws CompileException {
                        return UnitCompiler.this.getType2(na);
                    }

                    @Override
                    public IClass visitNewInitializedArray(Java.NewInitializedArray nia) throws CompileException {
                        return UnitCompiler.this.getType2(nia);
                    }

                    @Override
                    public IClass visitNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                        return UnitCompiler.this.getType2(nci);
                    }

                    @Override
                    public IClass visitParameterAccess(Java.ParameterAccess pa) throws CompileException {
                        return UnitCompiler.this.getType2(pa);
                    }

                    @Override
                    public IClass visitQualifiedThisReference(Java.QualifiedThisReference qtr) throws CompileException {
                        return UnitCompiler.this.getType2(qtr);
                    }

                    @Override
                    public IClass visitThisReference(Java.ThisReference tr) throws CompileException {
                        return UnitCompiler.this.getType2(tr);
                    }
                });
            }

            @Override
            @Nullable
            public IClass visitConstructorInvocation(Java.ConstructorInvocation ci) throws CompileException {
                return UnitCompiler.this.getType2(ci);
            }
        });
        return result != null ? result : this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.ConstructorInvocation ci) throws CompileException {
        this.compileError("Explicit constructor invocation not allowed here", ci.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.SimpleType st) {
        return st.iClass;
    }

    private IClass getType2(Java.PrimitiveType bt) {
        switch (bt.primitive) {
            case VOID: {
                return IClass.VOID;
            }
            case BYTE: {
                return IClass.BYTE;
            }
            case SHORT: {
                return IClass.SHORT;
            }
            case CHAR: {
                return IClass.CHAR;
            }
            case INT: {
                return IClass.INT;
            }
            case LONG: {
                return IClass.LONG;
            }
            case FLOAT: {
                return IClass.FLOAT;
            }
            case DOUBLE: {
                return IClass.DOUBLE;
            }
            case BOOLEAN: {
                return IClass.BOOLEAN;
            }
        }
        throw new JaninoRuntimeException("Invalid primitive " + (Object)((Object)bt.primitive));
    }

    private IClass getType2(Java.ReferenceType rt) throws CompileException {
        String[] identifiers = rt.identifiers;
        IClass result = this.getReferenceType(rt.getLocation(), rt.getEnclosingScope(), identifiers, identifiers.length);
        if (result == null) {
            this.compileError("Reference type '" + rt + "' not found", rt.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        return result;
    }

    @Nullable
    private IClass getReferenceType(Location location, Java.Scope scope, String[] identifiers, int n) throws CompileException {
        IClass enclosingType;
        if (n == 1) {
            return this.getReferenceType(location, identifiers[0], scope);
        }
        String className = Java.join(identifiers, ".", 0, n);
        IClass result = this.findTypeByName(location, className);
        if (result != null) {
            return result;
        }
        if (n >= 2 && (enclosingType = this.getReferenceType(location, scope, identifiers, n - 1)) != null) {
            String memberTypeName = identifiers[n - 1];
            IClass memberType = this.findMemberType(enclosingType, memberTypeName, location);
            if (memberType == null) {
                this.compileError("'" + enclosingType + "' declares no member type '" + memberTypeName + "'", location);
                return this.iClassLoader.TYPE_java_lang_Object;
            }
            return memberType;
        }
        return null;
    }

    private IClass getReferenceType(Location location, String simpleTypeName, Java.Scope scope) throws CompileException {
        Java.TypeArgument[] otas;
        Java.Type bt;
        IClass importedClass;
        Java.LocalClassDeclaration lcd;
        Java.TypeParameter[] optionalTypeParameters;
        Java.BlockStatement scopeBlockStatement = null;
        Java.TypeDeclaration scopeTypeDeclaration = null;
        Java.MethodDeclarator scopeMethodDeclarator = null;
        Java.Scope s = scope;
        while (true) {
            if (s instanceof Java.BlockStatement && scopeBlockStatement == null) {
                scopeBlockStatement = (Java.BlockStatement)s;
            }
            if (s instanceof Java.TypeDeclaration && scopeTypeDeclaration == null) {
                scopeTypeDeclaration = (Java.TypeDeclaration)s;
            }
            if (s instanceof Java.MethodDeclarator && scopeMethodDeclarator == null) {
                scopeMethodDeclarator = (Java.MethodDeclarator)s;
            }
            if (s instanceof Java.CompilationUnit) break;
            s = s.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s;
        if (scopeMethodDeclarator != null && (optionalTypeParameters = scopeMethodDeclarator.getOptionalTypeParameters()) != null) {
            for (Java.TypeParameter tp : optionalTypeParameters) {
                IClass[] boundTypes;
                if (!tp.name.equals(simpleTypeName)) continue;
                Java.ReferenceType[] ob = tp.optionalBound;
                if (ob == null) {
                    boundTypes = new IClass[]{this.iClassLoader.TYPE_java_lang_Object};
                } else {
                    boundTypes = new IClass[ob.length];
                    for (int i = 0; i < boundTypes.length; ++i) {
                        boundTypes[i] = this.getType(ob[i]);
                    }
                }
                return boundTypes[0];
            }
        }
        if (scopeTypeDeclaration instanceof Java.NamedTypeDeclaration && (optionalTypeParameters = ((Java.NamedTypeDeclaration)scopeTypeDeclaration).getOptionalTypeParameters()) != null) {
            for (Java.TypeParameter tp : optionalTypeParameters) {
                IClass[] boundTypes;
                if (!tp.name.equals(simpleTypeName)) continue;
                Java.ReferenceType[] ob = tp.optionalBound;
                if (ob == null) {
                    boundTypes = new IClass[]{this.iClassLoader.TYPE_java_lang_Object};
                } else {
                    boundTypes = new IClass[ob.length];
                    for (int i = 0; i < boundTypes.length; ++i) {
                        boundTypes[i] = this.getType(ob[i]);
                    }
                }
                return boundTypes[0];
            }
        }
        if ((lcd = UnitCompiler.findLocalClassDeclaration(scope, simpleTypeName)) != null) {
            return this.resolve(lcd);
        }
        if (scopeTypeDeclaration != null) {
            s = scopeTypeDeclaration;
            while (!(s instanceof Java.CompilationUnit)) {
                IClass mt;
                if (s instanceof Java.TypeDeclaration && (mt = this.findMemberType(this.resolve((Java.AbstractTypeDeclaration)s), simpleTypeName, location)) != null) {
                    return mt;
                }
                s = s.getEnclosingScope();
            }
        }
        if ((importedClass = this.importSingleType(simpleTypeName, location)) != null) {
            return importedClass;
        }
        Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(simpleTypeName);
        if (pmtd != null) {
            return this.resolve(pmtd);
        }
        Java.PackageDeclaration opd = scopeCompilationUnit.optionalPackageDeclaration;
        String pkg = opd == null ? null : opd.packageName;
        String className = pkg == null ? simpleTypeName : pkg + "." + simpleTypeName;
        IClass result = this.findTypeByName(location, className);
        if (result != null) {
            return result;
        }
        importedClass = this.importTypeOnDemand(simpleTypeName, location);
        if (importedClass != null) {
            return importedClass;
        }
        List<Object> l = this.singleStaticImports.get(simpleTypeName);
        if (l != null) {
            Object importedMemberType = null;
            for (Object o : l) {
                IClass mt;
                if (!(o instanceof IClass) || !this.isAccessible(mt = (IClass)o, scope)) continue;
                if (importedMemberType != null && importedMemberType != mt) {
                    this.compileError("Ambiguous static imports: \"" + ((IClass)importedMemberType).toString() + "\" vs. \"" + mt.toString() + "\"");
                }
                importedMemberType = mt;
            }
            if (importedMemberType != null) {
                return importedMemberType;
            }
        }
        IClass importedMemberType = null;
        for (IClass ic : this.staticImportsOnDemand) {
            IClass[] memberTypes;
            for (IClass mt : memberTypes = ic.getDeclaredIClasses()) {
                if (!this.isAccessible(mt, scope) || !mt.getDescriptor().endsWith('$' + simpleTypeName + ';')) continue;
                if (importedMemberType != null) {
                    this.compileError("Ambiguous static imports: \"" + importedMemberType.toString() + "\" vs. \"" + mt.toString() + "\"");
                }
                importedMemberType = mt;
            }
        }
        if (importedMemberType != null) {
            return importedMemberType;
        }
        IClass result2 = this.findTypeByName(location, simpleTypeName);
        if (result2 != null) {
            return result2;
        }
        if (scopeTypeDeclaration instanceof Java.AnonymousClassDeclaration && (bt = ((Java.AnonymousClassDeclaration)scopeTypeDeclaration).baseType) instanceof Java.ReferenceType && (otas = ((Java.ReferenceType)bt).optionalTypeArguments) != null) {
            for (Java.TypeArgument ta : otas) {
                String[] is;
                if (!(ta instanceof Java.ReferenceType) || (is = ((Java.ReferenceType)ta).identifiers).length != 1 || !is[0].equals(simpleTypeName)) continue;
                return this.iClassLoader.TYPE_java_lang_Object;
            }
        }
        this.compileError("Cannot determine simple type name \"" + simpleTypeName + "\"", location);
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.RvalueMemberType rvmt) throws CompileException {
        IClass rvt = this.getType(rvmt.rvalue);
        IClass memberType = this.findMemberType(rvt, rvmt.identifier, rvmt.getLocation());
        if (memberType == null) {
            this.compileError("\"" + rvt + "\" has no member type \"" + rvmt.identifier + "\"", rvmt.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        return memberType;
    }

    private IClass getType2(Java.ArrayType at) throws CompileException {
        return this.getType(at.componentType).getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
    }

    private IClass getType2(Java.AmbiguousName an) throws CompileException {
        return this.getType(this.reclassify(an));
    }

    private IClass getType2(Java.Package p) throws CompileException {
        this.compileError("Unknown variable or type \"" + p.name + "\"", p.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.LocalVariableAccess lva) {
        return lva.localVariable.type;
    }

    private IClass getType2(Java.FieldAccess fa) throws CompileException {
        return fa.field.getType();
    }

    private IClass getType2(Java.ArrayLength al) {
        return IClass.INT;
    }

    private IClass getType2(Java.ThisReference tr) throws CompileException {
        return this.getIClass(tr);
    }

    private IClass getType2(Java.QualifiedThisReference qtr) throws CompileException {
        return this.getTargetIClass(qtr);
    }

    private IClass getType2(Java.ClassLiteral cl) {
        return this.iClassLoader.TYPE_java_lang_Class;
    }

    private IClass getType2(Java.Assignment a) throws CompileException {
        return this.getType(a.lhs);
    }

    private IClass getType2(Java.ConditionalExpression ce) throws CompileException {
        IClass rhsType;
        IClass mhsType = this.getType(ce.mhs);
        if (mhsType == (rhsType = this.getType(ce.rhs))) {
            return mhsType;
        }
        if (this.isUnboxingConvertible(mhsType) == rhsType) {
            return rhsType;
        }
        if (this.isUnboxingConvertible(rhsType) == mhsType) {
            return mhsType;
        }
        if (this.getConstantValue(ce.mhs) == null && !rhsType.isPrimitive()) {
            return rhsType;
        }
        if (!mhsType.isPrimitive() && this.getConstantValue(ce.rhs) == null) {
            return mhsType;
        }
        if (this.isConvertibleToPrimitiveNumeric(mhsType) && this.isConvertibleToPrimitiveNumeric(rhsType)) {
            if (!(mhsType != IClass.BYTE && mhsType != this.iClassLoader.TYPE_java_lang_Byte || rhsType != IClass.SHORT && rhsType != this.iClassLoader.TYPE_java_lang_Short)) {
                return IClass.SHORT;
            }
            if (!(rhsType != IClass.BYTE && rhsType != this.iClassLoader.TYPE_java_lang_Byte || mhsType != IClass.SHORT && mhsType != this.iClassLoader.TYPE_java_lang_Short)) {
                return IClass.SHORT;
            }
            if ((mhsType == IClass.BYTE || mhsType == IClass.SHORT || mhsType == IClass.CHAR) && ce.rhs.constantValue != null && this.assignmentConversion(ce.rhs, this.getConstantValue(ce.rhs), mhsType) != null) {
                return mhsType;
            }
            if ((rhsType == IClass.BYTE || rhsType == IClass.SHORT || rhsType == IClass.CHAR) && ce.mhs.constantValue != null && this.assignmentConversion(ce.mhs, this.getConstantValue(ce.mhs), rhsType) != null) {
                return rhsType;
            }
            return this.binaryNumericPromotionType(ce, this.getUnboxedType(mhsType), this.getUnboxedType(rhsType));
        }
        if (!mhsType.isPrimitive() && !rhsType.isPrimitive()) {
            if (mhsType.isAssignableFrom(rhsType)) {
                return mhsType;
            }
            if (rhsType.isAssignableFrom(mhsType)) {
                return rhsType;
            }
            this.compileError("Reference types \"" + mhsType + "\" and \"" + rhsType + "\" don't match", ce.getLocation());
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        this.compileError("Incompatible expression types \"" + mhsType + "\" and \"" + rhsType + "\"", ce.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getType2(Java.Crement c) throws CompileException {
        return this.getType(c.operand);
    }

    private IClass getType2(Java.ArrayAccessExpression aae) throws CompileException {
        IClass componentType = this.getType(aae.lhs).getComponentType();
        assert (componentType != null) : "null component type for " + aae;
        return componentType;
    }

    private IClass getType2(Java.FieldAccessExpression fae) throws CompileException {
        this.determineValue(fae);
        return this.getType(this.determineValue(fae));
    }

    private IClass getType2(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        this.determineValue(scfae);
        return this.getType(this.determineValue(scfae));
    }

    private IClass getType2(Java.UnaryOperation uo) throws CompileException {
        if (uo.operator == "!") {
            return IClass.BOOLEAN;
        }
        if (uo.operator == "+" || uo.operator == "-" || uo.operator == "~") {
            return this.unaryNumericPromotionType(uo, this.getUnboxedType(this.getType(uo.operand)));
        }
        this.compileError("Unexpected operator \"" + uo.operator + "\"", uo.getLocation());
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.Instanceof io) {
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.BinaryOperation bo) throws CompileException {
        if (bo.op == "||" || bo.op == "&&" || bo.op == "==" || bo.op == "!=" || bo.op == "<" || bo.op == ">" || bo.op == "<=" || bo.op == ">=") {
            return IClass.BOOLEAN;
        }
        if (bo.op == "|" || bo.op == "^" || bo.op == "&") {
            IClass lhsType = this.getType(bo.lhs);
            return lhsType == IClass.BOOLEAN || lhsType == this.iClassLoader.TYPE_java_lang_Boolean ? IClass.BOOLEAN : this.binaryNumericPromotionType(bo, lhsType, this.getType(bo.rhs));
        }
        if (bo.op == "*" || bo.op == "/" || bo.op == "%" || bo.op == "+" || bo.op == "-") {
            IClassLoader icl = this.iClassLoader;
            Iterator<Java.Rvalue> ops = bo.unrollLeftAssociation();
            IClass lhsType = this.getUnboxedType(this.getType(ops.next()));
            if (bo.op == "+" && lhsType == icl.TYPE_java_lang_String) {
                return icl.TYPE_java_lang_String;
            }
            do {
                IClass rhsType = this.getUnboxedType(this.getType(ops.next()));
                if (bo.op == "+" && rhsType == icl.TYPE_java_lang_String) {
                    return icl.TYPE_java_lang_String;
                }
                lhsType = this.binaryNumericPromotionType(bo, lhsType, rhsType);
            } while (ops.hasNext());
            return lhsType;
        }
        if (bo.op == "<<" || bo.op == ">>" || bo.op == ">>>") {
            IClass lhsType = this.getType(bo.lhs);
            return this.unaryNumericPromotionType(bo, lhsType);
        }
        this.compileError("Unexpected operator \"" + bo.op + "\"", bo.getLocation());
        return this.iClassLoader.TYPE_java_lang_Object;
    }

    private IClass getUnboxedType(IClass type) {
        IClass c = this.isUnboxingConvertible(type);
        return c != null ? c : type;
    }

    private IClass getType2(Java.Cast c) throws CompileException {
        return this.getType(c.targetType);
    }

    private IClass getType2(Java.ParenthesizedExpression pe) throws CompileException {
        return this.getType(pe.value);
    }

    private IClass getType2(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod = mi.iMethod != null ? mi.iMethod : (mi.iMethod = this.findIMethod(mi));
        return iMethod.getReturnType();
    }

    private IClass getType2(Java.SuperclassMethodInvocation scmi) throws CompileException {
        return this.findIMethod(scmi).getReturnType();
    }

    private IClass getType2(Java.NewClassInstance nci) throws CompileException {
        if (nci.iClass != null) {
            return nci.iClass;
        }
        assert (nci.type != null);
        nci.iClass = this.getType(nci.type);
        return nci.iClass;
    }

    private IClass getType2(Java.NewAnonymousClassInstance naci) {
        return this.resolve(naci.anonymousClassDeclaration);
    }

    private IClass getType2(Java.ParameterAccess pa) throws CompileException {
        return this.getLocalVariable((Java.FunctionDeclarator.FormalParameter)pa.formalParameter).type;
    }

    private IClass getType2(Java.NewArray na) throws CompileException {
        IClass res = this.getType(na.type);
        return res.getArrayIClass(na.dimExprs.length + na.dims, this.iClassLoader.TYPE_java_lang_Object);
    }

    private IClass getType2(Java.NewInitializedArray nia) throws CompileException {
        IClass at;
        IClass iClass = at = nia.arrayType != null ? this.getType(nia.arrayType) : nia.arrayIClass;
        assert (at != null);
        return at;
    }

    private IClass getType2(Java.IntegerLiteral il) {
        String v = il.value;
        char lastChar = v.charAt(v.length() - 1);
        return lastChar == 'l' || lastChar == 'L' ? IClass.LONG : IClass.INT;
    }

    private IClass getType2(Java.FloatingPointLiteral fpl) {
        String v = fpl.value;
        char lastChar = v.charAt(v.length() - 1);
        return lastChar == 'f' || lastChar == 'F' ? IClass.FLOAT : IClass.DOUBLE;
    }

    private IClass getType2(Java.BooleanLiteral bl) {
        return IClass.BOOLEAN;
    }

    private IClass getType2(Java.CharacterLiteral cl) {
        return IClass.CHAR;
    }

    private IClass getType2(Java.StringLiteral sl) {
        return this.iClassLoader.TYPE_java_lang_String;
    }

    private IClass getType2(Java.NullLiteral nl) {
        return IClass.VOID;
    }

    private IClass getType2(Java.SimpleConstant sl) {
        Object v = sl.value;
        if (v instanceof Byte) {
            return IClass.BYTE;
        }
        if (v instanceof Short) {
            return IClass.SHORT;
        }
        if (v instanceof Integer) {
            return IClass.INT;
        }
        if (v instanceof Long) {
            return IClass.LONG;
        }
        if (v instanceof Float) {
            return IClass.FLOAT;
        }
        if (v instanceof Double) {
            return IClass.DOUBLE;
        }
        if (v instanceof Boolean) {
            return IClass.BOOLEAN;
        }
        if (v instanceof Character) {
            return IClass.CHAR;
        }
        if (v instanceof String) {
            return this.iClassLoader.TYPE_java_lang_String;
        }
        if (v == null) {
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("Invalid SimpleLiteral value type '" + v.getClass() + "'");
    }

    private boolean isType(Java.Atom a) throws CompileException {
        Boolean result = a.accept(new Visitor.AtomVisitor<Boolean, CompileException>(){

            @Override
            public Boolean visitPackage(Java.Package p) {
                return UnitCompiler.this.isType2(p);
            }

            @Override
            @Nullable
            public Boolean visitType(Java.Type t) {
                return t.accept(new Visitor.TypeVisitor<Boolean, RuntimeException>(){

                    @Override
                    public Boolean visitArrayType(Java.ArrayType at) {
                        return UnitCompiler.this.isType2(at);
                    }

                    @Override
                    public Boolean visitPrimitiveType(Java.PrimitiveType bt) {
                        return UnitCompiler.this.isType2(bt);
                    }

                    @Override
                    public Boolean visitReferenceType(Java.ReferenceType rt) {
                        return UnitCompiler.this.isType2(rt);
                    }

                    @Override
                    public Boolean visitRvalueMemberType(Java.RvalueMemberType rmt) {
                        return UnitCompiler.this.isType2(rmt);
                    }

                    @Override
                    public Boolean visitSimpleType(Java.SimpleType st) {
                        return UnitCompiler.this.isType2(st);
                    }
                });
            }

            @Override
            @Nullable
            public Boolean visitRvalue(Java.Rvalue rv) throws CompileException {
                return rv.accept(new Visitor.RvalueVisitor<Boolean, CompileException>(){

                    @Override
                    @Nullable
                    public Boolean visitLvalue(Java.Lvalue lv) throws CompileException {
                        return lv.accept(new Visitor.LvalueVisitor<Boolean, CompileException>(){

                            @Override
                            public Boolean visitAmbiguousName(Java.AmbiguousName an) throws CompileException {
                                return UnitCompiler.this.isType2(an);
                            }

                            @Override
                            public Boolean visitArrayAccessExpression(Java.ArrayAccessExpression aae) {
                                return UnitCompiler.this.isType2(aae);
                            }

                            @Override
                            public Boolean visitFieldAccess(Java.FieldAccess fa) {
                                return UnitCompiler.this.isType2(fa);
                            }

                            @Override
                            public Boolean visitFieldAccessExpression(Java.FieldAccessExpression fae) {
                                return UnitCompiler.this.isType2(fae);
                            }

                            @Override
                            public Boolean visitSuperclassFieldAccessExpression(Java.SuperclassFieldAccessExpression scfae) {
                                return UnitCompiler.this.isType2(scfae);
                            }

                            @Override
                            public Boolean visitLocalVariableAccess(Java.LocalVariableAccess lva) {
                                return UnitCompiler.this.isType2(lva);
                            }

                            @Override
                            public Boolean visitParenthesizedExpression(Java.ParenthesizedExpression pe) {
                                return UnitCompiler.this.isType2(pe);
                            }
                        });
                    }

                    @Override
                    public Boolean visitArrayLength(Java.ArrayLength al) {
                        return UnitCompiler.this.isType2(al);
                    }

                    @Override
                    public Boolean visitAssignment(Java.Assignment a) {
                        return UnitCompiler.this.isType2(a);
                    }

                    @Override
                    public Boolean visitUnaryOperation(Java.UnaryOperation uo) {
                        return UnitCompiler.this.isType2(uo);
                    }

                    @Override
                    public Boolean visitBinaryOperation(Java.BinaryOperation bo) {
                        return UnitCompiler.this.isType2(bo);
                    }

                    @Override
                    public Boolean visitCast(Java.Cast c) {
                        return UnitCompiler.this.isType2(c);
                    }

                    @Override
                    public Boolean visitClassLiteral(Java.ClassLiteral cl) {
                        return UnitCompiler.this.isType2(cl);
                    }

                    @Override
                    public Boolean visitConditionalExpression(Java.ConditionalExpression ce) {
                        return UnitCompiler.this.isType2(ce);
                    }

                    @Override
                    public Boolean visitCrement(Java.Crement c) {
                        return UnitCompiler.this.isType2(c);
                    }

                    @Override
                    public Boolean visitInstanceof(Java.Instanceof io) {
                        return UnitCompiler.this.isType2(io);
                    }

                    @Override
                    public Boolean visitMethodInvocation(Java.MethodInvocation mi) {
                        return UnitCompiler.this.isType2(mi);
                    }

                    @Override
                    public Boolean visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation smi) {
                        return UnitCompiler.this.isType2(smi);
                    }

                    @Override
                    public Boolean visitIntegerLiteral(Java.IntegerLiteral il) {
                        return UnitCompiler.this.isType2(il);
                    }

                    @Override
                    public Boolean visitFloatingPointLiteral(Java.FloatingPointLiteral fpl) {
                        return UnitCompiler.this.isType2(fpl);
                    }

                    @Override
                    public Boolean visitBooleanLiteral(Java.BooleanLiteral bl) {
                        return UnitCompiler.this.isType2(bl);
                    }

                    @Override
                    public Boolean visitCharacterLiteral(Java.CharacterLiteral cl) {
                        return UnitCompiler.this.isType2(cl);
                    }

                    @Override
                    public Boolean visitStringLiteral(Java.StringLiteral sl) {
                        return UnitCompiler.this.isType2(sl);
                    }

                    @Override
                    public Boolean visitNullLiteral(Java.NullLiteral nl) {
                        return UnitCompiler.this.isType2(nl);
                    }

                    @Override
                    public Boolean visitSimpleConstant(Java.SimpleConstant sl) {
                        return UnitCompiler.this.isType2(sl);
                    }

                    @Override
                    public Boolean visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                        return UnitCompiler.this.isType2(naci);
                    }

                    @Override
                    public Boolean visitNewArray(Java.NewArray na) {
                        return UnitCompiler.this.isType2(na);
                    }

                    @Override
                    public Boolean visitNewInitializedArray(Java.NewInitializedArray nia) {
                        return UnitCompiler.this.isType2(nia);
                    }

                    @Override
                    public Boolean visitNewClassInstance(Java.NewClassInstance nci) {
                        return UnitCompiler.this.isType2(nci);
                    }

                    @Override
                    public Boolean visitParameterAccess(Java.ParameterAccess pa) {
                        return UnitCompiler.this.isType2(pa);
                    }

                    @Override
                    public Boolean visitQualifiedThisReference(Java.QualifiedThisReference qtr) {
                        return UnitCompiler.this.isType2(qtr);
                    }

                    @Override
                    public Boolean visitThisReference(Java.ThisReference tr) {
                        return UnitCompiler.this.isType2(tr);
                    }
                });
            }

            @Override
            @Nullable
            public Boolean visitConstructorInvocation(Java.ConstructorInvocation ci) {
                return false;
            }
        });
        assert (result != null);
        return result;
    }

    private boolean isType2(Java.Atom a) {
        return a instanceof Java.Type;
    }

    private boolean isType2(Java.AmbiguousName an) throws CompileException {
        return this.isType(this.reclassify(an));
    }

    private boolean isAccessible(IClass.IMember member, Java.Scope contextScope) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        boolean acc = this.isAccessible(declaringIClass, contextScope);
        acc = acc && this.isAccessible(declaringIClass, member.getAccess(), contextScope);
        return acc;
    }

    private void checkAccessible(IClass.IMember member, Java.Scope contextScope, Location location) throws CompileException {
        IClass declaringIClass = member.getDeclaringIClass();
        this.checkAccessible(declaringIClass, contextScope, location);
        this.checkMemberAccessible(declaringIClass, member, contextScope, location);
    }

    private boolean isAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(iClassDeclaringMember, memberAccess, contextScope);
    }

    private void checkMemberAccessible(IClass iClassDeclaringMember, IClass.IMember member, Java.Scope contextScope, Location location) throws CompileException {
        String message = this.internalCheckAccessible(iClassDeclaringMember, member.getAccess(), contextScope);
        if (message != null) {
            this.compileError(member.toString() + ": " + message, location);
        }
    }

    @Nullable
    private String internalCheckAccessible(IClass iClassDeclaringMember, Access memberAccess, Java.Scope contextScope) throws CompileException {
        if (memberAccess == Access.PUBLIC) {
            return null;
        }
        IClass iClassDeclaringContext = null;
        Java.Scope s = contextScope;
        while (!(s instanceof Java.CompilationUnit)) {
            if (s instanceof Java.TypeDeclaration) {
                iClassDeclaringContext = this.resolve((Java.TypeDeclaration)s);
                break;
            }
            s = s.getEnclosingScope();
        }
        if (iClassDeclaringContext == iClassDeclaringMember) {
            return null;
        }
        if (iClassDeclaringContext != null) {
            IClass topLevelIClassEnclosingMember = iClassDeclaringMember;
            for (IClass c = iClassDeclaringMember.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
                topLevelIClassEnclosingMember = c;
            }
            IClass topLevelIClassEnclosingContextBlockStatement = iClassDeclaringContext;
            for (IClass c = iClassDeclaringContext.getDeclaringIClass(); c != null; c = c.getDeclaringIClass()) {
                topLevelIClassEnclosingContextBlockStatement = c;
            }
            if (topLevelIClassEnclosingMember == topLevelIClassEnclosingContextBlockStatement) {
                return null;
            }
        }
        if (memberAccess == Access.PRIVATE) {
            return "Private member cannot be accessed from type \"" + iClassDeclaringContext + "\".";
        }
        if (iClassDeclaringContext != null && Descriptor.areInSamePackage(iClassDeclaringMember.getDescriptor(), iClassDeclaringContext.getDescriptor())) {
            return null;
        }
        if (memberAccess == Access.DEFAULT) {
            return "Member with \"package\" access cannot be accessed from type \"" + iClassDeclaringContext + "\".";
        }
        IClass parentClass = iClassDeclaringContext;
        do {
            assert (parentClass != null);
            if (!iClassDeclaringMember.isAssignableFrom(parentClass)) continue;
            return null;
        } while ((parentClass = parentClass.getOuterIClass()) != null);
        return "Protected member cannot be accessed from type \"" + iClassDeclaringContext + "\", which is neither declared in the same package as nor is a subclass of \"" + iClassDeclaringMember + "\".";
    }

    private boolean isAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        return null == this.internalCheckAccessible(type, contextScope);
    }

    private void checkAccessible(IClass type, Java.Scope contextScope, Location location) throws CompileException {
        String message = this.internalCheckAccessible(type, contextScope);
        if (message != null) {
            this.compileError(message, location);
        }
    }

    @Nullable
    private String internalCheckAccessible(IClass type, Java.Scope contextScope) throws CompileException {
        IClass iClassDeclaringType = type.getDeclaringIClass();
        if (iClassDeclaringType == null) {
            if (type.getAccess() == Access.PUBLIC) {
                return null;
            }
            if (type.getAccess() == Access.DEFAULT) {
                IClass iClassDeclaringContextBlockStatement;
                Java.Scope s = contextScope;
                while (true) {
                    if (s instanceof Java.TypeDeclaration) {
                        iClassDeclaringContextBlockStatement = this.resolve((Java.TypeDeclaration)s);
                        break;
                    }
                    if (s instanceof Java.EnclosingScopeOfTypeDeclaration) {
                        iClassDeclaringContextBlockStatement = this.resolve(((Java.EnclosingScopeOfTypeDeclaration)s).typeDeclaration);
                        break;
                    }
                    s = s.getEnclosingScope();
                }
                String packageDeclaringType = Descriptor.getPackageName(type.getDescriptor());
                String contextPackage = Descriptor.getPackageName(iClassDeclaringContextBlockStatement.getDescriptor());
                if (packageDeclaringType == null ? contextPackage != null : !packageDeclaringType.equals(contextPackage)) {
                    return "\"" + type + "\" is inaccessible from this package";
                }
                return null;
            }
            throw new JaninoRuntimeException("\"" + type + "\" has unexpected access \"" + (Object)((Object)type.getAccess()) + "\"");
        }
        return this.internalCheckAccessible(iClassDeclaringType, type.getAccess(), contextScope);
    }

    private Java.Type toTypeOrCompileException(Java.Atom a) throws CompileException {
        Java.Type result = a.toType();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not a type", a.getLocation());
            return new Java.SimpleType(a.getLocation(), this.iClassLoader.TYPE_java_lang_Object);
        }
        return result;
    }

    private Java.Rvalue toRvalueOrCompileException(Java.Atom a) throws CompileException {
        Java.Rvalue result = a.toRvalue();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an rvalue", a.getLocation());
            return new Java.StringLiteral(a.getLocation(), "\"X\"");
        }
        return result;
    }

    private Java.Lvalue toLvalueOrCompileException(final Java.Atom a) throws CompileException {
        Java.Lvalue result = a.toLvalue();
        if (result == null) {
            this.compileError("Expression \"" + a.toString() + "\" is not an lvalue", a.getLocation());
            return new Java.Lvalue(a.getLocation()){

                @Override
                @Nullable
                public <R, EX extends Throwable> R accept(Visitor.LvalueVisitor<R, EX> visitor) {
                    return null;
                }

                @Override
                public String toString() {
                    return a.toString();
                }
            };
        }
        return result;
    }

    void assignSyntheticParametersToSyntheticFields(Java.ConstructorDeclarator cd) throws CompileException {
        for (IClass.IField sf : cd.getDeclaringClass().syntheticFields.values()) {
            Java.LocalVariable syntheticParameter = cd.syntheticParameters.get(sf.getName());
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter for synthetic field \"" + sf.getName() + "\" not found");
            }
            Java.ExpressionStatement es = new Java.ExpressionStatement(new Java.Assignment(cd.getLocation(), new Java.FieldAccess(cd.getLocation(), new Java.ThisReference(cd.getLocation()), sf), "=", new Java.LocalVariableAccess(cd.getLocation(), syntheticParameter)));
            es.setEnclosingScope(cd);
            this.compile(es);
        }
    }

    void initializeInstanceVariablesAndInvokeInstanceInitializers(Java.ConstructorDeclarator cd) throws CompileException {
        List<Java.BlockStatement> vdai = cd.getDeclaringClass().variableDeclaratorsAndInitializers;
        for (int i = 0; i < vdai.size(); ++i) {
            Java.BlockStatement bs = vdai.get(i);
            if (((Java.TypeBodyDeclaration)((Object)bs)).isStatic() || this.compile(bs)) continue;
            this.compileError("Instance variable declarator or instance initializer does not complete normally", bs.getLocation());
        }
    }

    private void leaveStatements(Java.Scope from, Java.Scope to, @Nullable IClass optionalStackValueType) {
        for (Java.Scope s = from; s != to; s = s.getEnclosingScope()) {
            if (!(s instanceof Java.BlockStatement)) continue;
            this.leave((Java.BlockStatement)s, optionalStackValueType);
        }
    }

    private IClass compileArithmeticBinaryOperation(Java.Locatable locatable, IClass lhsType, String operator, Java.Rvalue rhs) throws CompileException {
        return this.compileArithmeticOperation(locatable, lhsType, Arrays.asList(rhs).iterator(), operator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass compileArithmeticOperation(Java.Locatable locatable, @Nullable IClass firstOperandType, Iterator<Java.Rvalue> operands, String operator) throws CompileException {
        IClass type;
        if (operator == "+" && firstOperandType == this.iClassLoader.TYPE_java_lang_String) {
            assert (firstOperandType != null);
            return this.compileStringConcatenation(locatable, firstOperandType, operands.next(), operands);
        }
        IClass iClass = type = firstOperandType == null ? this.compileGetValue(operands.next()) : firstOperandType;
        if (operator == "|" || operator == "^" || operator == "&") {
            int iopcode;
            int n = operator == "&" ? 126 : (operator == "|" ? -128 : (iopcode = operator == "^" ? -126 : Integer.MAX_VALUE));
            while (operands.hasNext()) {
                Java.Rvalue operand = operands.next();
                CodeContext.Inserter convertLhsInserter = this.getCodeContext().newInserter();
                IClass rhsType = this.compileGetValue(operand);
                if (type.isPrimitiveNumeric() && rhsType.isPrimitiveNumeric()) {
                    IClass promotedType = this.binaryNumericPromotion(locatable, type, convertLhsInserter, rhsType);
                    if (promotedType == IClass.INT) {
                        this.writeOpcode(locatable, iopcode);
                    } else if (promotedType == IClass.LONG) {
                        this.writeOpcode(locatable, iopcode + 1);
                    } else {
                        this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", locatable.getLocation());
                    }
                    type = promotedType;
                    continue;
                }
                if (!(type != IClass.BOOLEAN && this.getUnboxedType(type) != IClass.BOOLEAN || rhsType != IClass.BOOLEAN && this.getUnboxedType(rhsType) != IClass.BOOLEAN)) {
                    IClassLoader icl = this.iClassLoader;
                    if (type == icl.TYPE_java_lang_Boolean) {
                        this.getCodeContext().pushInserter(convertLhsInserter);
                        try {
                            this.unboxingConversion(locatable, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                        }
                        finally {
                            this.getCodeContext().popInserter();
                        }
                    }
                    if (rhsType == icl.TYPE_java_lang_Boolean) {
                        this.unboxingConversion(locatable, icl.TYPE_java_lang_Boolean, IClass.BOOLEAN);
                    }
                    this.writeOpcode(locatable, iopcode);
                    type = IClass.BOOLEAN;
                    continue;
                }
                this.compileError("Operator \"" + operator + "\" not defined on types \"" + type + "\" and \"" + rhsType + "\"", locatable.getLocation());
                type = IClass.INT;
            }
            return type;
        }
        if (operator == "*" || operator == "/" || operator == "%" || operator == "+" || operator == "-") {
            int iopcode;
            int n = operator == "*" ? 104 : (operator == "/" ? 108 : (operator == "%" ? 112 : (operator == "+" ? 96 : (iopcode = operator == "-" ? 100 : Integer.MAX_VALUE))));
            while (operands.hasNext()) {
                int opcode;
                IClass rhsType;
                Java.Rvalue operand = operands.next();
                if (operator == "+" && (type == this.iClassLoader.TYPE_java_lang_String || this.getType(operand) == this.iClassLoader.TYPE_java_lang_String)) {
                    return this.compileStringConcatenation(locatable, type, operand, operands);
                }
                CodeContext.Inserter convertLhsInserter = this.getCodeContext().newInserter();
                if ((type = this.binaryNumericPromotion(locatable, type, convertLhsInserter, rhsType = this.compileGetValue(operand))) == IClass.INT) {
                    opcode = iopcode;
                } else if (type == IClass.LONG) {
                    opcode = iopcode + 1;
                } else if (type == IClass.FLOAT) {
                    opcode = iopcode + 2;
                } else if (type == IClass.DOUBLE) {
                    opcode = iopcode + 3;
                } else {
                    this.compileError("Unexpected promoted type \"" + type + "\"", locatable.getLocation());
                    opcode = iopcode;
                }
                this.writeOpcode(locatable, opcode);
            }
            return type;
        }
        if (operator == "<<" || operator == ">>" || operator == ">>>") {
            int iopcode;
            int n = operator == "<<" ? 120 : (operator == ">>" ? 122 : (iopcode = operator == ">>>" ? 124 : Integer.MAX_VALUE));
            while (operands.hasNext()) {
                int opcode;
                if ((type = this.unaryNumericPromotion(locatable, type)) == IClass.INT) {
                    opcode = iopcode;
                } else if (type == IClass.LONG) {
                    opcode = iopcode + 1;
                } else {
                    this.compileError("Shift operation not allowed on operand type \"" + type + "\"", locatable.getLocation());
                    opcode = iopcode;
                }
                IClass rhsType = this.compileGetValue(operands.next());
                IClass promotedRhsType = this.unaryNumericPromotion(locatable, rhsType);
                if (promotedRhsType != IClass.INT) {
                    if (promotedRhsType == IClass.LONG) {
                        this.writeOpcode(locatable, -120);
                    } else {
                        this.compileError("Shift distance of type \"" + rhsType + "\" is not allowed", locatable.getLocation());
                    }
                }
                this.writeOpcode(locatable, opcode);
            }
            return type;
        }
        throw new JaninoRuntimeException("Unexpected operator \"" + operator + "\"");
    }

    /*
     * WARNING - void declaration
     */
    private IClass compileStringConcatenation(Java.Locatable locatable, IClass type, Java.Rvalue secondOperand, Iterator<Java.Rvalue> operands) throws CompileException {
        this.stringConversion(locatable, type);
        ArrayList<Object> tmp = new ArrayList<Object>();
        Object nextOperand = secondOperand;
        while (nextOperand != null) {
            void var7_7;
            Object object = this.getConstantValue((Java.Rvalue)nextOperand);
            if (object == NOT_CONSTANT) {
                tmp.add(nextOperand);
                nextOperand = operands.hasNext() ? operands.next() : null;
                continue;
            }
            if (operands.hasNext()) {
                nextOperand = operands.next();
                Object object2 = this.getConstantValue((Java.Rvalue)nextOperand);
                if (object2 != NOT_CONSTANT) {
                    StringBuilder sb = new StringBuilder(String.valueOf(object)).append(object2);
                    while (true) {
                        if (!operands.hasNext()) {
                            nextOperand = null;
                            break;
                        }
                        nextOperand = operands.next();
                        Object cv3 = this.getConstantValue((Java.Rvalue)nextOperand);
                        if (cv3 == NOT_CONSTANT) break;
                        sb.append(cv3);
                    }
                    String string = sb.toString();
                }
            } else {
                nextOperand = null;
            }
            for (String s : UnitCompiler.makeUtf8Able(String.valueOf(var7_7))) {
                tmp.add(new Java.SimpleConstant(locatable.getLocation(), s));
            }
        }
        if (tmp.size() <= 2) {
            for (Java.Rvalue rvalue : tmp) {
                this.stringConversion(rvalue, this.compileGetValue(rvalue));
                this.invoke(locatable, this.iClassLoader.METH_java_lang_String__concat__java_lang_String);
            }
            return this.iClassLoader.TYPE_java_lang_String;
        }
        this.writeOpcode(locatable, -69);
        this.writeConstantClassInfo("Ljava/lang/StringBuilder;");
        this.writeOpcode(locatable, 90);
        this.writeOpcode(locatable, 95);
        IClass.IConstructor ctor = this.iClassLoader.CTOR_java_lang_StringBuilder__java_lang_String;
        assert (ctor != null);
        this.invoke(locatable, ctor);
        for (Java.Rvalue rvalue : tmp) {
            IClass t = this.compileGetValue(rvalue);
            this.invoke(locatable, t == IClass.BYTE ? this.iClassLoader.METH_java_lang_StringBuilder__append__int : (t == IClass.SHORT ? this.iClassLoader.METH_java_lang_StringBuilder__append__int : (t == IClass.INT ? this.iClassLoader.METH_java_lang_StringBuilder__append__int : (t == IClass.LONG ? this.iClassLoader.METH_java_lang_StringBuilder__append__long : (t == IClass.FLOAT ? this.iClassLoader.METH_java_lang_StringBuilder__append__float : (t == IClass.DOUBLE ? this.iClassLoader.METH_java_lang_StringBuilder__append__double : (t == IClass.CHAR ? this.iClassLoader.METH_java_lang_StringBuilder__append__char : (t == IClass.BOOLEAN ? this.iClassLoader.METH_java_lang_StringBuilder__append__boolean : this.iClassLoader.METH_java_lang_StringBuilder__append__java_lang_Object))))))));
        }
        this.invoke(locatable, this.iClassLoader.METH_java_lang_StringBuilder__toString);
        return this.iClassLoader.TYPE_java_lang_String;
    }

    private void stringConversion(Java.Locatable locatable, IClass sourceType) throws CompileException {
        this.invoke(locatable, sourceType == IClass.BYTE ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.SHORT ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.INT ? this.iClassLoader.METH_java_lang_String__valueOf__int : (sourceType == IClass.LONG ? this.iClassLoader.METH_java_lang_String__valueOf__long : (sourceType == IClass.FLOAT ? this.iClassLoader.METH_java_lang_String__valueOf__float : (sourceType == IClass.DOUBLE ? this.iClassLoader.METH_java_lang_String__valueOf__double : (sourceType == IClass.CHAR ? this.iClassLoader.METH_java_lang_String__valueOf__char : (sourceType == IClass.BOOLEAN ? this.iClassLoader.METH_java_lang_String__valueOf__boolean : this.iClassLoader.METH_java_lang_String__valueOf__java_lang_Object))))))));
    }

    private void invokeConstructor(Java.Locatable locatable, Java.Scope scope, @Nullable Java.Rvalue optionalEnclosingInstance, IClass targetClass, Java.Rvalue[] arguments) throws CompileException {
        IClass eiic;
        IClass outerIClass;
        IClass[] thrownExceptions;
        IClass.IInvocable[] iConstructors = targetClass.getDeclaredIConstructors();
        if (iConstructors.length == 0) {
            throw new JaninoRuntimeException("SNO: Target class \"" + targetClass.getDescriptor() + "\" has no constructors");
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)this.findMostSpecificIInvocable(locatable, iConstructors, arguments, scope);
        for (IClass te : thrownExceptions = iConstructor.getThrownExceptions()) {
            this.checkThrownException(locatable, te, scope);
        }
        if (scope instanceof Java.FieldDeclaration && scope.getEnclosingScope() instanceof Java.EnumDeclaration) {
            Java.FieldDeclaration fd = (Java.FieldDeclaration)scope;
            Java.EnumDeclaration ed = (Java.EnumDeclaration)fd.getEnclosingScope();
            if (fd.variableDeclarators.length == 1) {
                String fieldName = fd.variableDeclarators[0].name;
                int ordinal = 0;
                for (Java.EnumConstant ec : ed.getConstants()) {
                    if (fieldName.equals(ec.name)) {
                        this.pushConstant(locatable, fieldName);
                        this.pushConstant(locatable, ordinal);
                        break;
                    }
                    ++ordinal;
                }
            }
        }
        if (optionalEnclosingInstance != null && (outerIClass = targetClass.getOuterIClass()) != null && !outerIClass.isAssignableFrom(eiic = this.compileGetValue(optionalEnclosingInstance))) {
            this.compileError("Type of enclosing instance (\"" + eiic + "\") is not assignable to \"" + outerIClass + "\"", locatable.getLocation());
        }
        IClass.IField[] syntheticFields = targetClass.getSyntheticIFields();
        Java.Scope s = scope;
        while (!(s instanceof Java.TypeBodyDeclaration)) {
            s = s.getEnclosingScope();
        }
        Java.TypeBodyDeclaration scopeTbd = (Java.TypeBodyDeclaration)s;
        Java.TypeDeclaration scopeTypeDeclaration = scopeTbd.getDeclaringType();
        if (!(scopeTypeDeclaration instanceof Java.AbstractClassDeclaration)) {
            if (syntheticFields.length > 0) {
                throw new JaninoRuntimeException("SNO: Target class has synthetic fields");
            }
            return;
        }
        Java.AbstractClassDeclaration scopeClassDeclaration = (Java.AbstractClassDeclaration)scopeTypeDeclaration;
        for (IClass.IField sf : syntheticFields) {
            Java.LocalVariable lv;
            block27: {
                if (!sf.getName().startsWith("val$")) continue;
                IClass.IField eisf = (IClass.IField)scopeClassDeclaration.syntheticFields.get(sf.getName());
                if (eisf != null) {
                    if (scopeTbd instanceof Java.MethodDeclarator) {
                        this.load(locatable, this.resolve(scopeClassDeclaration), 0);
                        this.getfield(locatable, eisf);
                        continue;
                    }
                    if (scopeTbd instanceof Java.ConstructorDeclarator) {
                        Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scopeTbd;
                        Java.LocalVariable syntheticParameter = constructorDeclarator.syntheticParameters.get(sf.getName());
                        if (syntheticParameter == null) {
                            this.compileError("Compiler limitation: Constructor cannot access local variable \"" + sf.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. " + "As a workaround, declare a dummy method that accesses the local variable.", locatable.getLocation());
                            this.writeOpcode(locatable, 1);
                            continue;
                        }
                        this.load(locatable, syntheticParameter);
                        continue;
                    }
                    if (scopeTbd instanceof Java.FieldDeclaration) {
                        this.compileError("Compiler limitation: Field initializers cannot access local variable \"" + sf.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. " + "As a workaround, declare a dummy method that accesses the local variable.", locatable.getLocation());
                        this.writeOpcode(scopeTbd, 1);
                        continue;
                    }
                    throw new AssertionError(scopeTbd);
                }
                String localVariableName = sf.getName().substring(4);
                Java.Scope s2 = scope;
                while (s2 instanceof Java.BlockStatement) {
                    block31: {
                        List<Java.BlockStatement> statements;
                        Java.BlockStatement bs;
                        block29: {
                            Java.Scope es;
                            block30: {
                                block28: {
                                    bs = (Java.BlockStatement)s2;
                                    es = bs.getEnclosingScope();
                                    if (!(es instanceof Java.Block)) break block28;
                                    statements = ((Java.Block)es).statements;
                                    break block29;
                                }
                                if (!(es instanceof Java.FunctionDeclarator)) break block30;
                                statements = ((Java.FunctionDeclarator)es).optionalStatements;
                                break block29;
                            }
                            if (!(es instanceof Java.ForEachStatement)) break block31;
                            Java.FunctionDeclarator.FormalParameter fp = ((Java.ForEachStatement)es).currentElement;
                            if (fp.name.equals(localVariableName)) {
                                lv = this.getLocalVariable(fp);
                                break block27;
                            }
                            break block31;
                        }
                        if (statements != null) {
                            for (Java.BlockStatement bs2 : statements) {
                                if (bs2 == bs) break;
                                if (!(bs2 instanceof Java.LocalVariableDeclarationStatement)) continue;
                                Java.LocalVariableDeclarationStatement lvds = (Java.LocalVariableDeclarationStatement)bs2;
                                for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
                                    if (!vd.name.equals(localVariableName)) continue;
                                    lv = this.getLocalVariable(lvds, vd);
                                    break block27;
                                }
                            }
                        }
                    }
                    s2 = s2.getEnclosingScope();
                }
                while (!(s2 instanceof Java.FunctionDeclarator)) {
                    s2 = s2.getEnclosingScope();
                }
                Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s2;
                for (Java.FunctionDeclarator.FormalParameter fp : fd.formalParameters.parameters) {
                    if (!fp.name.equals(localVariableName)) continue;
                    lv = this.getLocalVariable(fp);
                    break block27;
                }
                throw new JaninoRuntimeException("SNO: Synthetic field \"" + sf.getName() + "\" neither maps a synthetic field of an enclosing instance nor a local variable");
            }
            this.load(locatable, lv);
        }
        Java.Rvalue[] adjustedArgs = null;
        IClass[] parameterTypes = iConstructor.getParameterTypes();
        int actualSize = arguments.length;
        if (iConstructor.isVarargs() && iConstructor.argsNeedAdjust()) {
            adjustedArgs = new Java.Rvalue[parameterTypes.length];
            Java.ArrayInitializerOrRvalue[] lastArgs = new Java.Rvalue[actualSize - parameterTypes.length + 1];
            int i = 0;
            int j = parameterTypes.length - 1;
            while (i < lastArgs.length) {
                lastArgs[i] = arguments[j];
                ++i;
                ++j;
            }
            for (i = parameterTypes.length - 2; i >= 0; --i) {
                adjustedArgs[i] = arguments[i];
            }
            Location loc = (lastArgs.length == 0 ? locatable : lastArgs[lastArgs.length - 1]).getLocation();
            adjustedArgs[adjustedArgs.length - 1] = new Java.NewInitializedArray(loc, parameterTypes[parameterTypes.length - 1], new Java.ArrayInitializer(loc, lastArgs));
            arguments = adjustedArgs;
        }
        for (int i = 0; i < arguments.length; ++i) {
            this.assignmentConversion(locatable, this.compileGetValue(arguments[i]), parameterTypes[i], this.getConstantValue(arguments[i]));
        }
        this.invoke(locatable, iConstructor);
    }

    private IClass.IField[] compileFields(Java.FieldDeclaration fieldDeclaration) {
        IClass.IField[] result = new IClass.IField[fieldDeclaration.variableDeclarators.length];
        for (int i = 0; i < result.length; ++i) {
            Java.VariableDeclarator vd = fieldDeclaration.variableDeclarators[i];
            result[i] = this.compileField(fieldDeclaration.getDeclaringType(), fieldDeclaration.modifiers, fieldDeclaration.type, vd);
        }
        return result;
    }

    private IClass.IField compileField(Java.TypeDeclaration declaringType, final Java.Modifiers modifiers, final Java.Type type, final Java.VariableDeclarator variableDeclarator) {
        final IClass.IAnnotation[] ias = this.toIAnnotations(modifiers.annotations);
        IClass iClass = this.resolve(declaringType);
        iClass.getClass();
        return new IClass.IField(iClass){

            @Override
            public Access getAccess() {
                switch (modifiers.accessFlags & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            @Override
            public IClass.IAnnotation[] getAnnotations() {
                return ias;
            }

            @Override
            public boolean isStatic() {
                return Mod.isStatic(modifiers.accessFlags);
            }

            @Override
            public IClass getType() throws CompileException {
                return UnitCompiler.this.getType(type).getArrayIClass(variableDeclarator.brackets, ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
            }

            @Override
            public String getName() {
                return variableDeclarator.name;
            }

            @Override
            @Nullable
            public Object getConstantValue() throws CompileException {
                Object constantInitializerValue;
                Java.ArrayInitializerOrRvalue oi = variableDeclarator.optionalInitializer;
                if (Mod.isFinal(modifiers.accessFlags) && oi instanceof Java.Rvalue && (constantInitializerValue = UnitCompiler.this.getConstantValue((Java.Rvalue)oi)) != NOT_CONSTANT) {
                    return UnitCompiler.this.assignmentConversion(oi, constantInitializerValue, this.getType());
                }
                return NOT_CONSTANT;
            }
        };
    }

    @Nullable
    Java.ArrayInitializerOrRvalue getNonConstantFinalInitializer(Java.FieldDeclaration fd, Java.VariableDeclarator vd) throws CompileException {
        if (vd.optionalInitializer == null) {
            return null;
        }
        if (Mod.isStatic(fd.modifiers.accessFlags) && Mod.isFinal(fd.modifiers.accessFlags) && vd.optionalInitializer instanceof Java.Rvalue && this.getConstantValue((Java.Rvalue)vd.optionalInitializer) != NOT_CONSTANT) {
            return null;
        }
        return vd.optionalInitializer;
    }

    private Java.Atom reclassify(Java.AmbiguousName an) throws CompileException {
        if (an.reclassified != null) {
            return an.reclassified;
        }
        an.reclassified = this.reclassifyName(an.getLocation(), an.getEnclosingScope(), an.identifiers, an.n);
        return an.reclassified;
    }

    private IClass.IAnnotation[] toIAnnotations(Java.Annotation[] annotations) {
        IClass.IAnnotation[] result = new IClass.IAnnotation[annotations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.toIAnnotation(annotations[i]);
        }
        return result;
    }

    private IClass.IAnnotation toIAnnotation(Java.Annotation annotation) {
        IClass.IAnnotation result = annotation.accept(new Visitor.AnnotationVisitor<IClass.IAnnotation, RuntimeException>(){

            @Override
            public IClass.IAnnotation visitMarkerAnnotation(Java.MarkerAnnotation ma) {
                return this.toIAnnotation(ma.type, new Java.ElementValuePair[0]);
            }

            @Override
            public IClass.IAnnotation visitSingleElementAnnotation(Java.SingleElementAnnotation sea) {
                return this.toIAnnotation(sea.type, new Java.ElementValuePair[]{new Java.ElementValuePair("value", sea.elementValue)});
            }

            @Override
            public IClass.IAnnotation visitNormalAnnotation(Java.NormalAnnotation na) {
                return this.toIAnnotation(na.type, na.elementValuePairs);
            }

            private IClass.IAnnotation toIAnnotation(final Java.Type type, Java.ElementValuePair[] elementValuePairs) {
                final HashMap<String, Object> m = new HashMap<String, Object>();
                for (Java.ElementValuePair evp : elementValuePairs) {
                    m.put(evp.identifier, this.toObject(evp.elementValue));
                }
                return new IClass.IAnnotation(){

                    @Override
                    public Object getElementValue(String name) {
                        return m.get(name);
                    }

                    @Override
                    public IClass getAnnotationType() throws CompileException {
                        return UnitCompiler.this.getType(type);
                    }
                };
            }

            private Object toObject(Java.ElementValue ev) {
                try {
                    Object result = ev.accept(new Visitor.ElementValueVisitor<Object, CompileException>(){

                        @Override
                        public Object visitRvalue(Java.Rvalue rv) throws CompileException {
                            if (rv instanceof Java.AmbiguousName) {
                                Java.AmbiguousName an = (Java.AmbiguousName)rv;
                                rv = UnitCompiler.this.reclassify(an).toRvalueOrCompileException();
                            }
                            if (rv instanceof Java.ClassLiteral) {
                                return rv;
                            }
                            if (rv instanceof Java.FieldAccess) {
                                return (Java.FieldAccess)rv;
                            }
                            Object result = UnitCompiler.this.getConstantValue(rv);
                            if (result == null) {
                                UnitCompiler.this.compileError("Null value not allowed as an element value", rv.getLocation());
                                return 1;
                            }
                            if (result == NOT_CONSTANT) {
                                UnitCompiler.this.compileError("Element value is not a constant expression", rv.getLocation());
                                return 1;
                            }
                            return result;
                        }

                        @Override
                        public Object visitAnnotation(Java.Annotation a) {
                            return UnitCompiler.this.toIAnnotation(a);
                        }

                        @Override
                        public Object visitElementValueArrayInitializer(Java.ElementValueArrayInitializer evai) {
                            Object[] result = new Object[evai.elementValues.length];
                            for (int i = 0; i < result.length; ++i) {
                                result[i] = this.toObject(evai.elementValues[i]);
                            }
                            return result;
                        }
                    });
                    assert (result != null);
                    return result;
                }
                catch (Exception ce) {
                    throw new IllegalStateException(ce);
                }
            }
        });
        assert (result != null);
        return result;
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, final String[] identifiers, int n) throws CompileException {
        IClass[] classes;
        if (n == 1) {
            return this.reclassifyName(location, scope, identifiers[0]);
        }
        Java.Atom lhs = this.reclassifyName(location, scope, identifiers, n - 1);
        String rhs = identifiers[n - 1];
        LOGGER.log(Level.FINE, "lhs={0}", lhs);
        if (lhs instanceof Java.Package) {
            String className = ((Java.Package)lhs).name + '.' + rhs;
            IClass result = this.findTypeByName(location, className);
            if (result != null) {
                return new Java.SimpleType(location, result);
            }
            return new Java.Package(location, className);
        }
        if ("length".equals(rhs) && this.getType(lhs).isArray()) {
            Java.ArrayLength al = new Java.ArrayLength(location, this.toRvalueOrCompileException(lhs));
            if (!(scope instanceof Java.BlockStatement)) {
                this.compileError("\".length\" only allowed in expression context");
                return al;
            }
            al.setEnclosingScope(scope);
            return al;
        }
        IClass lhsType = this.getType(lhs);
        IClass.IField field = this.findIField(lhsType, rhs, location);
        if (field != null) {
            Java.FieldAccess fa = new Java.FieldAccess(location, lhs, field);
            fa.setEnclosingScope(scope);
            return fa;
        }
        for (IClass memberType : classes = lhsType.getDeclaredIClasses()) {
            String name = Descriptor.toClassName(memberType.getDescriptor());
            if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals(rhs)) continue;
            return new Java.SimpleType(location, memberType);
        }
        this.compileError("\"" + rhs + "\" is neither a method, a field, nor a member class of \"" + lhsType + "\"", location);
        return new Java.Atom(location){

            @Override
            @Nullable
            public <R, EX extends Throwable> R accept(Visitor.AtomVisitor<R, EX> visitor) {
                return null;
            }

            @Override
            public String toString() {
                return Java.join(identifiers, ".");
            }
        };
    }

    @Nullable
    private IClass findTypeByName(Location location, String className) throws CompileException {
        IClass res = this.findClass(className);
        if (res != null) {
            return res;
        }
        try {
            return this.iClassLoader.loadIClass(Descriptor.fromClassName(className));
        }
        catch (ClassNotFoundException ex) {
            if (ex.getException() instanceof CompileException) {
                throw (CompileException)ex.getException();
            }
            throw new CompileException(className, location, (Throwable)ex);
        }
    }

    private Java.Atom reclassifyName(Location location, Java.Scope scope, String identifier) throws CompileException {
        IClass memberType;
        IClass.IField f;
        Java.LocalVariable lv;
        Java.TypeBodyDeclaration scopeTbd = null;
        Java.AbstractTypeDeclaration scopeTypeDeclaration = null;
        Java.Scope s = scope;
        while ((s instanceof Java.BlockStatement || s instanceof Java.CatchClause) && !(s instanceof Java.TypeBodyDeclaration)) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.TypeBodyDeclaration) {
            scopeTbd = (Java.TypeBodyDeclaration)s;
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.TypeDeclaration) {
            scopeTypeDeclaration = (Java.AbstractTypeDeclaration)s;
            s = s.getEnclosingScope();
        }
        while (!(s instanceof Java.CompilationUnit)) {
            s = s.getEnclosingScope();
        }
        Java.CompilationUnit scopeCompilationUnit = (Java.CompilationUnit)s;
        s = scope;
        if (s instanceof Java.BlockStatement) {
            Java.BlockStatement bs = (Java.BlockStatement)s;
            lv = bs.findLocalVariable(identifier);
            if (lv != null) {
                Java.LocalVariableAccess lva = new Java.LocalVariableAccess(location, lv);
                lva.setEnclosingScope(bs);
                return lva;
            }
            s = s.getEnclosingScope();
        }
        while (s instanceof Java.BlockStatement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.FunctionDeclarator) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.InnerClassDeclaration) {
            Java.InnerClassDeclaration icd = (Java.InnerClassDeclaration)s;
            if ((s = s.getEnclosingScope()) instanceof Java.AnonymousClassDeclaration) {
                s = s.getEnclosingScope();
            } else if (s instanceof Java.FieldDeclaration) {
                s = s.getEnclosingScope().getEnclosingScope();
            }
            while (s instanceof Java.BlockStatement) {
                lv = ((Java.BlockStatement)s).findLocalVariable(identifier);
                if (lv != null) {
                    if (!lv.finaL) {
                        this.compileError("Cannot access non-final local variable \"" + identifier + "\" from inner class");
                    }
                    IClass lvType = lv.type;
                    SimpleIField iField = new SimpleIField(this.resolve(icd), "val$" + identifier, lvType);
                    icd.defineSyntheticField(iField);
                    Java.FieldAccess fa = new Java.FieldAccess(location, new Java.QualifiedThisReference(location, new Java.SimpleType(location, this.resolve(icd))), iField);
                    fa.setEnclosingScope(scope);
                    return fa;
                }
                s = s.getEnclosingScope();
                while (s instanceof Java.BlockStatement) {
                    s = s.getEnclosingScope();
                }
                if (!(s instanceof Java.FunctionDeclarator) || !((s = s.getEnclosingScope()) instanceof Java.InnerClassDeclaration)) break;
                icd = (Java.InnerClassDeclaration)s;
                s = s.getEnclosingScope();
            }
        }
        Java.BlockStatement enclosingBlockStatement = null;
        Java.Scope s2 = scope;
        while (!(s2 instanceof Java.CompilationUnit)) {
            Iterator<IClass> enclosingTypeDecl;
            IClass etd;
            if (s2 instanceof Java.BlockStatement && enclosingBlockStatement == null) {
                enclosingBlockStatement = (Java.BlockStatement)s2;
            }
            if (s2 instanceof Java.TypeDeclaration && (f = this.findIField(etd = this.resolve((Java.TypeDeclaration)((Object)(enclosingTypeDecl = (Java.AbstractTypeDeclaration)s2))), identifier, location)) != null) {
                if (f.isStatic()) {
                    this.warning("IASF", "Implicit access to static field \"" + identifier + "\" of declaring class (better write \"" + f.getDeclaringIClass() + '.' + f.getName() + "\")", location);
                } else if (f.getDeclaringIClass() == etd) {
                    this.warning("IANSF", "Implicit access to non-static field \"" + identifier + "\" of declaring class (better write \"this." + f.getName() + "\")", location);
                } else {
                    this.warning("IANSFEI", "Implicit access to non-static field \"" + identifier + "\" of enclosing instance (better write \"" + f.getDeclaringIClass() + ".this." + f.getName() + "\")", location);
                }
                assert (scopeTypeDeclaration != null);
                assert (scopeTbd != null);
                Java.SimpleType ct = new Java.SimpleType(scopeTypeDeclaration.getLocation(), etd);
                Java.Atom lhs = scopeTbd.isStatic() ? ct : (f.isStatic() ? ct : new Java.QualifiedThisReference(location, ct));
                Java.FieldAccess res = new Java.FieldAccess(location, lhs, f);
                res.setEnclosingScope(scope);
                return res;
            }
            s2 = s2.getEnclosingScope();
        }
        List<Object> l = this.singleStaticImports.get(identifier);
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof IClass.IField)) continue;
                Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, ((IClass.IField)o).getDeclaringIClass()), (IClass.IField)o);
                fieldAccess.setEnclosingScope(scope);
                return fieldAccess;
            }
        }
        IClass.IField importedField = null;
        for (IClass iClass : this.staticImportsOnDemand) {
            f = iClass.getDeclaredIField(identifier);
            if (f == null || !this.isAccessible(f, scope)) continue;
            if (importedField != null) {
                this.compileError("Ambiguous static field import: \"" + importedField.toString() + "\" vs. \"" + f.toString() + "\"");
            }
            importedField = f;
        }
        if (importedField != null) {
            if (!importedField.isStatic()) {
                this.compileError("Cannot static-import non-static field");
            }
            Java.FieldAccess fieldAccess = new Java.FieldAccess(location, new Java.SimpleType(location, importedField.getDeclaringIClass()), importedField);
            fieldAccess.setEnclosingScope(scope);
            return fieldAccess;
        }
        if ("java".equals(identifier)) {
            return new Java.Package(location, identifier);
        }
        IClass unnamedPackageType = this.findTypeByName(location, identifier);
        if (unnamedPackageType != null) {
            return new Java.SimpleType(location, unnamedPackageType);
        }
        Java.LocalClassDeclaration lcd = UnitCompiler.findLocalClassDeclaration(scope, identifier);
        if (lcd != null) {
            return new Java.SimpleType(location, this.resolve(lcd));
        }
        if (scopeTypeDeclaration != null && (memberType = this.findMemberType(this.resolve(scopeTypeDeclaration), identifier, location)) != null) {
            return new Java.SimpleType(location, memberType);
        }
        IClass iClass = this.importSingleType(identifier, location);
        if (iClass != null) {
            return new Java.SimpleType(location, iClass);
        }
        Java.PackageMemberTypeDeclaration pmtd = scopeCompilationUnit.getPackageMemberTypeDeclaration(identifier);
        if (pmtd != null) {
            return new Java.SimpleType(location, this.resolve(pmtd));
        }
        Java.PackageDeclaration opd = scopeCompilationUnit.optionalPackageDeclaration;
        String className = opd == null ? identifier : opd.packageName + '.' + identifier;
        IClass result = this.findTypeByName(location, className);
        if (result != null) {
            return new Java.SimpleType(location, result);
        }
        IClass importedClass = this.importTypeOnDemand(identifier, location);
        if (importedClass != null) {
            return new Java.SimpleType(location, importedClass);
        }
        l = this.singleStaticImports.get(identifier);
        if (l != null) {
            for (Object o : l) {
                if (!(o instanceof IClass)) continue;
                return new Java.SimpleType(location, (IClass)o);
            }
        }
        IClass importedType = null;
        for (IClass ic : this.staticImportsOnDemand) {
            IClass[] memberTypes;
            for (IClass memberType2 : memberTypes = ic.getDeclaredIClasses()) {
                if (!this.isAccessible(memberType2, scope) || !memberType2.getDescriptor().endsWith('$' + identifier + ';')) continue;
                if (importedType != null) {
                    this.compileError("Ambiguous static type import: \"" + importedType.toString() + "\" vs. \"" + memberType2.toString() + "\"");
                }
                importedType = memberType2;
            }
        }
        if (importedType != null) {
            return new Java.SimpleType(location, importedType);
        }
        return new Java.Package(location, identifier);
    }

    private Java.Rvalue determineValue(Java.FieldAccessExpression fae) throws CompileException {
        Java.Rvalue value;
        if (fae.value != null) {
            return fae.value;
        }
        IClass lhsType = this.getType(fae.lhs);
        if (fae.fieldName.equals("length") && lhsType.isArray()) {
            value = new Java.ArrayLength(fae.getLocation(), this.toRvalueOrCompileException(fae.lhs));
        } else {
            IClass.IField iField = this.findIField(lhsType, fae.fieldName, fae.getLocation());
            if (iField == null) {
                this.compileError("\"" + this.getType(fae.lhs).toString() + "\" has no field \"" + fae.fieldName + "\"", fae.getLocation());
                value = new Java.Rvalue(fae.getLocation()){

                    @Override
                    @Nullable
                    public <R, EX extends Throwable> R accept(Visitor.RvalueVisitor<R, EX> visitor) {
                        return null;
                    }

                    @Override
                    public String toString() {
                        return "???";
                    }
                };
            } else {
                value = new Java.FieldAccess(fae.getLocation(), fae.lhs, iField);
            }
        }
        value.setEnclosingScope(fae.getEnclosingScope());
        fae.value = value;
        return fae.value;
    }

    private Java.Rvalue determineValue(Java.SuperclassFieldAccessExpression scfae) throws CompileException {
        Java.Rvalue value;
        if (scfae.value != null) {
            return scfae.value;
        }
        Java.ThisReference tr = new Java.ThisReference(scfae.getLocation());
        tr.setEnclosingScope(scfae.getEnclosingScope());
        IClass type = scfae.optionalQualification != null ? this.getType(scfae.optionalQualification) : this.getType(tr);
        IClass superclass = type.getSuperclass();
        if (superclass == null) {
            throw new CompileException("Cannot use \"super\" on \"" + type + "\"", scfae.getLocation());
        }
        Java.Cast lhs = new Java.Cast(scfae.getLocation(), new Java.SimpleType(scfae.getLocation(), superclass), tr);
        IClass.IField iField = this.findIField(this.getType(lhs), scfae.fieldName, scfae.getLocation());
        if (iField == null) {
            this.compileError("Class has no field \"" + scfae.fieldName + "\"", scfae.getLocation());
            value = new Java.Rvalue(scfae.getLocation()){

                @Override
                @Nullable
                public <R, EX extends Throwable> R accept(Visitor.RvalueVisitor<R, EX> visitor) {
                    return null;
                }

                @Override
                public String toString() {
                    return "???";
                }
            };
        } else {
            value = new Java.FieldAccess(scfae.getLocation(), lhs, iField);
        }
        value.setEnclosingScope(scfae.getEnclosingScope());
        scfae.value = value;
        return scfae.value;
    }

    public IClass.IMethod findIMethod(Java.MethodInvocation mi) throws CompileException {
        IClass.IMethod iMethod;
        block12: {
            block15: {
                List<Object> l;
                block14: {
                    Java.Atom ot;
                    block13: {
                        ot = mi.optionalTarget;
                        if (ot != null) break block13;
                        Java.Scope s = mi.getEnclosingScope();
                        while (!(s instanceof Java.CompilationUnit)) {
                            Object td;
                            if (!(s instanceof Java.TypeDeclaration) || (iMethod = this.findIMethod(this.resolve((Java.TypeDeclaration)(td = (Java.TypeDeclaration)s)), mi)) == null) {
                                s = s.getEnclosingScope();
                                continue;
                            }
                            break block12;
                        }
                        break block14;
                    }
                    iMethod = this.findIMethod(this.getType(ot), mi);
                    if (iMethod != null) break block12;
                }
                if ((l = this.singleStaticImports.get(mi.methodName)) == null) break block15;
                iMethod = null;
                for (Object e : l) {
                    IClass declaringIClass;
                    IClass.IMethod im;
                    if (!(e instanceof IClass.IMethod) || (im = this.findIMethod(declaringIClass = ((IClass.IMethod)e).getDeclaringIClass(), mi)) == null) continue;
                    if (iMethod != null && iMethod != im) {
                        this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + im.toString() + "\"");
                    }
                    iMethod = im;
                }
                if (iMethod != null) break block12;
            }
            iMethod = null;
            for (IClass iClass : this.staticImportsOnDemand) {
                IClass.IMethod iMethod2 = this.findIMethod(iClass, mi);
                if (iMethod2 == null) continue;
                if (iMethod != null) {
                    this.compileError("Ambiguous static method import: \"" + iMethod.toString() + "\" vs. \"" + iMethod2.toString() + "\"");
                }
                iMethod = iMethod2;
            }
            if (iMethod == null) {
                this.compileError("A method named \"" + mi.methodName + "\" is not declared in any enclosing class nor any supertype, nor through a static import", mi.getLocation());
                return this.fakeIMethod(this.iClassLoader.TYPE_java_lang_Object, mi.methodName, mi.arguments);
            }
        }
        assert (iMethod != null);
        this.checkThrownExceptions(mi, iMethod);
        return iMethod;
    }

    @Nullable
    private IClass.IMethod findIMethod(IClass targetType, Java.Invocation invocation) throws CompileException {
        ArrayList<IClass.IMethod> ms = new ArrayList<IClass.IMethod>();
        this.getIMethods(targetType, invocation.methodName, ms);
        if (targetType.isInterface()) {
            IClass.IMethod[] oms;
            for (IClass.IMethod om : oms = this.iClassLoader.TYPE_java_lang_Object.getDeclaredIMethods(invocation.methodName)) {
                if (om.isStatic() || om.getAccess() != Access.PUBLIC) continue;
                ms.add(om);
            }
        }
        if (ms.size() == 0) {
            return null;
        }
        return (IClass.IMethod)this.findMostSpecificIInvocable(invocation, ms.toArray(new IClass.IMethod[ms.size()]), invocation.arguments, invocation.getEnclosingScope());
    }

    private IClass.IMethod fakeIMethod(IClass targetType, final String name, Java.Rvalue[] arguments) throws CompileException {
        final IClass[] pts = new IClass[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            pts[i] = this.getType(arguments[i]);
        }
        IClass iClass = targetType;
        iClass.getClass();
        return new IClass.IMethod(iClass){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public IClass getReturnType() {
                return IClass.INT;
            }

            @Override
            public boolean isStatic() {
                return false;
            }

            @Override
            public boolean isAbstract() {
                return false;
            }

            @Override
            public boolean isVarargs() {
                return false;
            }

            @Override
            public IClass[] getParameterTypes2() {
                return pts;
            }

            @Override
            public IClass[] getThrownExceptions2() {
                return new IClass[0];
            }

            @Override
            public Access getAccess() {
                return Access.PUBLIC;
            }

            @Override
            public IClass.IAnnotation[] getAnnotations() {
                return new IClass.IAnnotation[0];
            }
        };
    }

    public void getIMethods(IClass type, String methodName, List<IClass.IMethod> v) throws CompileException {
        IClass[] interfaces;
        IClass.IMethod[] ims;
        for (IClass.IMethod im : ims = type.getDeclaredIMethods(methodName)) {
            v.add(im);
        }
        IClass superclass = type.getSuperclass();
        if (superclass != null) {
            this.getIMethods(superclass, methodName, v);
        }
        for (IClass interfacE : interfaces = type.getInterfaces()) {
            this.getIMethods(interfacE, methodName, v);
        }
    }

    public IClass.IMethod findIMethod(Java.SuperclassMethodInvocation superclassMethodInvocation) throws CompileException {
        Java.Scope s = superclassMethodInvocation.getEnclosingScope();
        while (true) {
            if (s instanceof Java.FunctionDeclarator) {
                Java.FunctionDeclarator fd = (Java.FunctionDeclarator)s;
                if (Mod.isStatic(fd.modifiers.accessFlags)) {
                    this.compileError("Superclass method cannot be invoked in static context", superclassMethodInvocation.getLocation());
                }
            }
            if (s instanceof Java.AbstractClassDeclaration) break;
            s = s.getEnclosingScope();
        }
        Java.AbstractClassDeclaration declaringClass = (Java.AbstractClassDeclaration)s;
        IClass superclass = this.resolve(declaringClass).getSuperclass();
        if (superclass == null) {
            throw new CompileException("\"" + declaringClass + "\" has no superclass", superclassMethodInvocation.getLocation());
        }
        IClass.IMethod iMethod = this.findIMethod(superclass, superclassMethodInvocation);
        if (iMethod == null) {
            this.compileError("Class \"" + superclass + "\" has no method named \"" + superclassMethodInvocation.methodName + "\"", superclassMethodInvocation.getLocation());
            return this.fakeIMethod(superclass, superclassMethodInvocation.methodName, superclassMethodInvocation.arguments);
        }
        this.checkThrownExceptions(superclassMethodInvocation, iMethod);
        return iMethod;
    }

    private IClass.IInvocable findMostSpecificIInvocable(Java.Locatable locatable, IClass.IInvocable[] iInvocables, Java.Rvalue[] arguments, Java.Scope contextScope) throws CompileException {
        int i;
        final IClass[] argumentTypes = new IClass[arguments.length];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            argumentTypes[i2] = this.getType(arguments[i2]);
        }
        IClass.IInvocable ii = this.findMostSpecificIInvocable(locatable, iInvocables, argumentTypes, false, contextScope);
        if (ii != null) {
            return ii;
        }
        ii = this.findMostSpecificIInvocable(locatable, iInvocables, argumentTypes, true, contextScope);
        if (ii != null) {
            return ii;
        }
        StringBuilder sb = new StringBuilder("No applicable constructor/method found for ");
        if (argumentTypes.length == 0) {
            sb.append("zero actual parameters");
        } else {
            sb.append("actual parameters \"").append(argumentTypes[0]);
            for (i = 1; i < argumentTypes.length; ++i) {
                sb.append(", ").append(argumentTypes[i]);
            }
            sb.append("\"");
        }
        sb.append("; candidates are: ").append('\"' + iInvocables[0].toString() + '\"');
        for (i = 1; i < iInvocables.length; ++i) {
            sb.append(", ").append('\"' + iInvocables[i].toString() + '\"');
        }
        this.compileError(sb.toString(), locatable.getLocation());
        if (iInvocables[0] instanceof IClass.IConstructor) {
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IConstructor(iClass){

                @Override
                public boolean isVarargs() {
                    return false;
                }

                @Override
                public IClass[] getParameterTypes2() {
                    return argumentTypes;
                }

                @Override
                public Access getAccess() {
                    return Access.PUBLIC;
                }

                @Override
                public IClass[] getThrownExceptions2() {
                    return new IClass[0];
                }

                @Override
                public IClass.IAnnotation[] getAnnotations() {
                    return new IClass.IAnnotation[0];
                }
            };
        }
        if (iInvocables[0] instanceof IClass.IMethod) {
            final String methodName = ((IClass.IMethod)iInvocables[0]).getName();
            IClass iClass = iInvocables[0].getDeclaringIClass();
            iClass.getClass();
            return new IClass.IMethod(iClass){

                @Override
                public boolean isStatic() {
                    return true;
                }

                @Override
                public boolean isAbstract() {
                    return false;
                }

                @Override
                public IClass getReturnType() {
                    return IClass.INT;
                }

                @Override
                public String getName() {
                    return methodName;
                }

                @Override
                public Access getAccess() {
                    return Access.PUBLIC;
                }

                @Override
                public boolean isVarargs() {
                    return false;
                }

                @Override
                public IClass[] getParameterTypes2() {
                    return argumentTypes;
                }

                @Override
                public IClass[] getThrownExceptions2() {
                    return new IClass[0];
                }

                @Override
                public IClass.IAnnotation[] getAnnotations() {
                    return new IClass.IAnnotation[0];
                }
            };
        }
        return iInvocables[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public IClass.IInvocable findMostSpecificIInvocable(Java.Locatable locatable, IClass.IInvocable[] iInvocables, IClass[] argumentTypes, boolean boxingPermitted, Java.Scope contextScope) throws CompileException {
        int i;
        ArrayList<IClass.IInvocable> maximallySpecificIInvocables;
        block44: {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.entering((String)null, "findMostSpecificIInvocable", new Object[]{locatable, Arrays.toString(iInvocables), Arrays.toString(argumentTypes), boxingPermitted, contextScope});
            }
            ArrayList<IClass.IInvocable> applicableIInvocables = new ArrayList<IClass.IInvocable>();
            ArrayList<IClass.IInvocable> varargApplicables = new ArrayList<IClass.IInvocable>();
            block0: for (IClass.IInvocable ii : iInvocables) {
                boolean isVarargs;
                int nUncheckedArg;
                int formalParamCount;
                IClass[] parameterTypes;
                boolean argsNeedAdjust;
                block43: {
                    argsNeedAdjust = false;
                    if (!this.isAccessible(ii, contextScope)) continue;
                    parameterTypes = ii.getParameterTypes();
                    formalParamCount = parameterTypes.length;
                    nUncheckedArg = argumentTypes.length;
                    isVarargs = ii.isVarargs();
                    if (isVarargs) {
                        IClass lastParamType = parameterTypes[--formalParamCount].getComponentType();
                        assert (lastParamType != null);
                        int lastActualArg = nUncheckedArg - 1;
                        if (formalParamCount == lastActualArg && argumentTypes[lastActualArg].isArray() && this.isMethodInvocationConvertible(UnitCompiler.assertNonNull(argumentTypes[lastActualArg].getComponentType()), lastParamType, boxingPermitted)) {
                            --nUncheckedArg;
                        } else {
                            for (int idx = lastActualArg; idx >= formalParamCount; --idx) {
                                LOGGER.log(Level.FINE, "{0} <=> {1}", new Object[]{lastParamType, argumentTypes[idx]});
                                if (!this.isMethodInvocationConvertible(argumentTypes[idx], lastParamType, boxingPermitted)) {
                                    ++formalParamCount;
                                    break block43;
                                }
                                --nUncheckedArg;
                            }
                            argsNeedAdjust = true;
                        }
                    }
                }
                if (formalParamCount != nUncheckedArg) continue;
                for (int j = 0; j < nUncheckedArg; ++j) {
                    LOGGER.log(Level.FINE, "{0}: {1} <=> {2}", new Object[]{j, parameterTypes[j], argumentTypes[j]});
                    if (!this.isMethodInvocationConvertible(argumentTypes[j], (IClass)parameterTypes[j], boxingPermitted)) continue block0;
                }
                LOGGER.fine("Applicable!");
                if (isVarargs) {
                    ii.setArgsNeedAdjust(argsNeedAdjust);
                    varargApplicables.add(ii);
                    continue;
                }
                applicableIInvocables.add(ii);
            }
            if (applicableIInvocables.size() == 1) {
                return (IClass.IInvocable)applicableIInvocables.get(0);
            }
            if (applicableIInvocables.size() == 0 && !varargApplicables.isEmpty() && (applicableIInvocables = varargApplicables).size() == 1) {
                return (IClass.IInvocable)applicableIInvocables.get(0);
            }
            if (applicableIInvocables.size() == 0) {
                return null;
            }
            maximallySpecificIInvocables = new ArrayList<IClass.IInvocable>();
            for (IClass.IInvocable applicableIInvocable : applicableIInvocables) {
                int moreSpecific = 0;
                int lessSpecific = 0;
                for (IClass.IInvocable mostSpecificIInvocable : maximallySpecificIInvocables) {
                    if (applicableIInvocable.isMoreSpecificThan(mostSpecificIInvocable)) {
                        ++moreSpecific;
                        continue;
                    }
                    if (!applicableIInvocable.isLessSpecificThan(mostSpecificIInvocable)) continue;
                    ++lessSpecific;
                }
                if (moreSpecific == maximallySpecificIInvocables.size()) {
                    maximallySpecificIInvocables.clear();
                    maximallySpecificIInvocables.add(applicableIInvocable);
                } else if (lessSpecific < maximallySpecificIInvocables.size()) {
                    maximallySpecificIInvocables.add(applicableIInvocable);
                }
                LOGGER.log(Level.FINE, "maximallySpecificIInvocables={0}", maximallySpecificIInvocables);
            }
            if (maximallySpecificIInvocables.size() == 1) {
                return (IClass.IInvocable)maximallySpecificIInvocables.get(0);
            }
            if (maximallySpecificIInvocables.size() > 1 && iInvocables[0] instanceof IClass.IMethod) {
                int i2;
                IClass.IMethod theNonAbstractMethod = null;
                Iterator it = maximallySpecificIInvocables.iterator();
                IClass.IMethod m = (IClass.IMethod)it.next();
                IClass[] parameterTypesOfFirstMethod = m.getParameterTypes();
                block5: while (true) {
                    if (!m.isAbstract()) {
                        if (theNonAbstractMethod == null) {
                            theNonAbstractMethod = m;
                        } else {
                            IClass theNonAbstractMethodDeclaringIClass;
                            IClass declaringIClass = m.getDeclaringIClass();
                            if (declaringIClass == (theNonAbstractMethodDeclaringIClass = theNonAbstractMethod.getDeclaringIClass())) {
                                if (m.getReturnType() == theNonAbstractMethod.getReturnType()) {
                                    throw new JaninoRuntimeException("Two non-abstract methods '" + m + "' have the same parameter types, " + "declaring type and return type");
                                }
                                if (!m.getReturnType().isAssignableFrom(theNonAbstractMethod.getReturnType())) {
                                    if (!theNonAbstractMethod.getReturnType().isAssignableFrom(m.getReturnType())) throw new JaninoRuntimeException("Incompatible return types");
                                    theNonAbstractMethod = m;
                                }
                            } else if (!declaringIClass.isAssignableFrom(theNonAbstractMethodDeclaringIClass)) {
                                if (!theNonAbstractMethodDeclaringIClass.isAssignableFrom(declaringIClass)) throw new JaninoRuntimeException("SNO: Types declaring '" + theNonAbstractMethod + "' are not assignable");
                                theNonAbstractMethod = m;
                            }
                        }
                    }
                    if (!it.hasNext()) break;
                    m = (IClass.IMethod)it.next();
                    IClass[] pts = m.getParameterTypes();
                    int i3 = 0;
                    while (true) {
                        if (i3 >= pts.length) continue block5;
                        if (pts[i3] == parameterTypesOfFirstMethod[i3]) {
                            ++i3;
                            continue;
                        }
                        break block44;
                        break;
                    }
                    break;
                }
                if (theNonAbstractMethod != null) {
                    return theNonAbstractMethod;
                }
                HashSet<IClass> s = new HashSet<IClass>();
                IClass[][] tes = new IClass[maximallySpecificIInvocables.size()][];
                Iterator it2 = maximallySpecificIInvocables.iterator();
                for (i2 = 0; i2 < tes.length; ++i2) {
                    tes[i2] = ((IClass.IMethod)it2.next()).getThrownExceptions();
                }
                for (i2 = 0; i2 < tes.length; ++i2) {
                    block9: for (IClass te1 : tes[i2]) {
                        block10: for (int k = 0; k < tes.length; ++k) {
                            if (k == i2) continue;
                            for (IClass te2 : tes[k]) {
                                if (te2.isAssignableFrom(te1)) continue block10;
                            }
                            continue block9;
                        }
                        s.add(te1);
                    }
                }
                final IClass.IMethod im = (IClass.IMethod)maximallySpecificIInvocables.get(0);
                final IClass[] tes2 = s.toArray(new IClass[s.size()]);
                IClass iClass = im.getDeclaringIClass();
                iClass.getClass();
                return new IClass.IMethod(iClass){

                    @Override
                    public String getName() {
                        return im.getName();
                    }

                    @Override
                    public IClass getReturnType() throws CompileException {
                        return im.getReturnType();
                    }

                    @Override
                    public boolean isAbstract() {
                        return im.isAbstract();
                    }

                    @Override
                    public boolean isStatic() {
                        return im.isStatic();
                    }

                    @Override
                    public Access getAccess() {
                        return im.getAccess();
                    }

                    @Override
                    public boolean isVarargs() {
                        return im.isVarargs();
                    }

                    @Override
                    public IClass[] getParameterTypes2() throws CompileException {
                        return im.getParameterTypes();
                    }

                    @Override
                    public IClass[] getThrownExceptions2() {
                        return tes2;
                    }

                    @Override
                    public IClass.IAnnotation[] getAnnotations() {
                        return im.getAnnotations();
                    }
                };
            }
        }
        if (!boxingPermitted) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Invocation of constructor/method with argument type(s) \"");
        for (i = 0; i < argumentTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Descriptor.toString(argumentTypes[i].getDescriptor()));
        }
        sb.append("\" is ambiguous: ");
        for (i = 0; i < maximallySpecificIInvocables.size(); ++i) {
            if (i > 0) {
                sb.append(" vs. ");
            }
            sb.append("\"" + maximallySpecificIInvocables.get(i) + "\"");
        }
        this.compileError(sb.toString(), locatable.getLocation());
        return iInvocables[0];
    }

    private static <T> T assertNonNull(@Nullable T subject) {
        assert (subject != null);
        return subject;
    }

    private boolean isMethodInvocationConvertible(IClass sourceType, IClass targetType, boolean boxingPermitted) throws CompileException {
        IClass unboxedType;
        IClass boxedType;
        if (sourceType == targetType) {
            return true;
        }
        if (this.isWideningPrimitiveConvertible(sourceType, targetType)) {
            return true;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return true;
        }
        if (boxingPermitted && (boxedType = this.isBoxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(boxedType, targetType) || this.isWideningReferenceConvertible(boxedType, targetType);
        }
        if (boxingPermitted && (unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            return this.isIdentityConvertible(unboxedType, targetType) || this.isWideningPrimitiveConvertible(unboxedType, targetType);
        }
        return false;
    }

    private void checkThrownExceptions(Java.Invocation in, IClass.IMethod iMethod) throws CompileException {
        IClass[] thrownExceptions;
        for (IClass thrownException : thrownExceptions = iMethod.getThrownExceptions()) {
            this.checkThrownException(in, thrownException, in.getEnclosingScope());
        }
    }

    private void checkThrownException(Java.Locatable locatable, IClass type, Java.Scope scope) throws CompileException {
        if (!this.iClassLoader.TYPE_java_lang_Throwable.isAssignableFrom(type)) {
            this.compileError("Thrown object of type \"" + type + "\" is not assignable to \"Throwable\"", locatable.getLocation());
        }
        if (this.iClassLoader.TYPE_java_lang_RuntimeException.isAssignableFrom(type) || this.iClassLoader.TYPE_java_lang_Error.isAssignableFrom(type)) {
            return;
        }
        while (true) {
            if (scope instanceof Java.TryStatement) {
                Java.TryStatement ts = (Java.TryStatement)scope;
                block1: for (int i = 0; i < ts.catchClauses.size(); ++i) {
                    Java.CatchClause cc = ts.catchClauses.get(i);
                    IClass caughtType = this.getType(cc.caughtException.type);
                    if (caughtType.isAssignableFrom(type)) {
                        cc.reachable = true;
                        return;
                    }
                    if (!type.isAssignableFrom(caughtType)) continue;
                    for (int j = 0; j < i; ++j) {
                        if (this.getType(ts.catchClauses.get((int)j).caughtException.type).isAssignableFrom(caughtType)) continue block1;
                    }
                    cc.reachable = true;
                }
            } else {
                if (scope instanceof Java.FunctionDeclarator) {
                    Java.FunctionDeclarator fd = (Java.FunctionDeclarator)scope;
                    for (Java.Type thrownException : fd.thrownExceptions) {
                        if (!this.getType(thrownException).isAssignableFrom(type)) continue;
                        return;
                    }
                    break;
                }
                if (scope instanceof Java.TypeBodyDeclaration) break;
            }
            scope = scope.getEnclosingScope();
        }
        this.compileError("Thrown exception of type \"" + type + "\" is neither caught by a \"try...catch\" block " + "nor declared in the \"throws\" clause of the declaring function", locatable.getLocation());
    }

    private IClass getTargetIClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.targetIClass != null) {
            return qtr.targetIClass;
        }
        qtr.targetIClass = this.getType(qtr.qualification);
        return qtr.targetIClass;
    }

    @Nullable
    Java.LocalVariable isIntLv(Java.Crement c) throws CompileException {
        if (!(c.operand instanceof Java.AmbiguousName)) {
            return null;
        }
        Java.AmbiguousName an = (Java.AmbiguousName)c.operand;
        Java.Atom rec = this.reclassify(an);
        if (!(rec instanceof Java.LocalVariableAccess)) {
            return null;
        }
        Java.LocalVariableAccess lva = (Java.LocalVariableAccess)rec;
        Java.LocalVariable lv = lva.localVariable;
        if (lv.finaL) {
            this.compileError("Must not increment or decrement \"final\" local variable", lva.getLocation());
        }
        if (lv.type == IClass.BYTE || lv.type == IClass.SHORT || lv.type == IClass.INT || lv.type == IClass.CHAR) {
            return lv;
        }
        return null;
    }

    private IClass resolve(final Java.TypeDeclaration td) {
        final Java.AbstractTypeDeclaration atd = (Java.AbstractTypeDeclaration)td;
        if (atd.resolvedType != null) {
            return atd.resolvedType;
        }
        atd.resolvedType = new IClass(){
            @Nullable
            private IClass[] declaredClasses;

            @Override
            protected IClass.IMethod[] getDeclaredIMethods2() {
                ArrayList<IClass.IMethod> res = new ArrayList<IClass.IMethod>(atd.getMethodDeclarations().size());
                for (Java.MethodDeclarator md : atd.getMethodDeclarations()) {
                    res.add(UnitCompiler.this.toIMethod(md));
                }
                if (td instanceof Java.EnumDeclaration) {
                    res.add(new IClass.IMethod(){

                        @Override
                        public IClass.IAnnotation[] getAnnotations() {
                            return new IClass.IAnnotation[0];
                        }

                        @Override
                        public boolean isStatic() {
                            return true;
                        }

                        @Override
                        public boolean isAbstract() {
                            return false;
                        }

                        @Override
                        public String getName() {
                            return "values";
                        }

                        @Override
                        public boolean isVarargs() {
                            return false;
                        }

                        @Override
                        public Access getAccess() {
                            return Access.PUBLIC;
                        }

                        @Override
                        public IClass[] getParameterTypes2() {
                            return new IClass[0];
                        }

                        @Override
                        public IClass[] getThrownExceptions2() {
                            return new IClass[0];
                        }

                        @Override
                        public IClass getReturnType() {
                            IClass rt = atd.resolvedType;
                            assert (rt != null);
                            return rt.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                        }
                    });
                    res.add(new IClass.IMethod(){

                        @Override
                        public IClass.IAnnotation[] getAnnotations() {
                            return new IClass.IAnnotation[0];
                        }

                        @Override
                        public boolean isStatic() {
                            return true;
                        }

                        @Override
                        public boolean isAbstract() {
                            return false;
                        }

                        @Override
                        public String getName() {
                            return "valueOf";
                        }

                        @Override
                        public boolean isVarargs() {
                            return false;
                        }

                        @Override
                        public Access getAccess() {
                            return Access.PUBLIC;
                        }

                        @Override
                        public IClass[] getParameterTypes2() {
                            return new IClass[]{((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_String};
                        }

                        @Override
                        public IClass[] getThrownExceptions2() {
                            return new IClass[0];
                        }

                        @Override
                        public IClass getReturnType() {
                            IClass rt = atd.resolvedType;
                            assert (rt != null);
                            return rt;
                        }
                    });
                }
                return res.toArray(new IClass.IMethod[res.size()]);
            }

            @Override
            protected IClass[] getDeclaredIClasses2() {
                if (this.declaredClasses != null) {
                    return this.declaredClasses;
                }
                Collection<Java.MemberTypeDeclaration> mtds = td.getMemberTypeDeclarations();
                IClass[] mts = new IClass[mtds.size()];
                int i = 0;
                for (Java.MemberTypeDeclaration mtd : mtds) {
                    mts[i++] = UnitCompiler.this.resolve(mtd);
                }
                this.declaredClasses = mts;
                return mts;
            }

            @Override
            @Nullable
            protected IClass getDeclaringIClass2() {
                Java.Scope s = atd;
                while (!(s instanceof Java.TypeBodyDeclaration)) {
                    if (s instanceof Java.CompilationUnit) {
                        return null;
                    }
                    s = s.getEnclosingScope();
                }
                return UnitCompiler.this.resolve((Java.AbstractTypeDeclaration)s.getEnclosingScope());
            }

            @Override
            @Nullable
            protected IClass getOuterIClass2() {
                Java.AbstractTypeDeclaration oc = (Java.AbstractTypeDeclaration)UnitCompiler.getOuterClass(atd);
                if (oc == null) {
                    return null;
                }
                return UnitCompiler.this.resolve(oc);
            }

            @Override
            protected String getDescriptor2() {
                return Descriptor.fromClassName(atd.getClassName());
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            protected IClass getComponentType2() {
                throw new JaninoRuntimeException("SNO: Non-array type has no component type");
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isPrimitiveNumeric() {
                return false;
            }

            @Override
            protected IClass.IConstructor[] getDeclaredIConstructors2() {
                if (atd instanceof Java.AbstractClassDeclaration) {
                    Java.ConstructorDeclarator[] cs = ((Java.AbstractClassDeclaration)atd).getConstructors();
                    IClass.IConstructor[] res = new IClass.IConstructor[cs.length];
                    for (int i = 0; i < cs.length; ++i) {
                        res[i] = UnitCompiler.this.toIConstructor(cs[i]);
                    }
                    return res;
                }
                return new IClass.IConstructor[0];
            }

            @Override
            protected IClass.IField[] getDeclaredIFields2() {
                if (atd instanceof Java.AbstractClassDeclaration) {
                    Java.AbstractClassDeclaration cd = (Java.AbstractClassDeclaration)atd;
                    ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                    for (Java.BlockStatement blockStatement : cd.variableDeclaratorsAndInitializers) {
                        IClass.IField[] flds;
                        if (!(blockStatement instanceof Java.FieldDeclaration)) continue;
                        Java.FieldDeclaration fd = (Java.FieldDeclaration)blockStatement;
                        for (IClass.IField fld : flds = UnitCompiler.this.compileFields(fd)) {
                            l.add(fld);
                        }
                    }
                    if (atd instanceof Java.EnumDeclaration) {
                        Java.EnumDeclaration ed = (Java.EnumDeclaration)((Object)atd);
                        for (Java.EnumConstant ec : ed.getConstants()) {
                            l.add(UnitCompiler.this.compileField(ed, new Java.Modifiers(25), new Java.SimpleType(ed.getLocation(), UnitCompiler.this.resolve(ed)), new Java.VariableDeclarator(ec.getLocation(), ec.name, 0, null)));
                        }
                    }
                    return l.toArray(new IClass.IField[l.size()]);
                }
                if (atd instanceof Java.InterfaceDeclaration) {
                    Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                    ArrayList<IClass.IField> l = new ArrayList<IClass.IField>();
                    for (Java.BlockStatement blockStatement : id.constantDeclarations) {
                        IClass.IField[] flds;
                        if (!(blockStatement instanceof Java.FieldDeclaration)) continue;
                        Java.FieldDeclaration fd = (Java.FieldDeclaration)blockStatement;
                        for (IClass.IField fld : flds = UnitCompiler.this.compileFields(fd)) {
                            l.add(fld);
                        }
                    }
                    return l.toArray(new IClass.IField[l.size()]);
                }
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }

            @Override
            public IClass.IField[] getSyntheticIFields() {
                if (atd instanceof Java.AbstractClassDeclaration) {
                    Collection<IClass.IField> c = ((Java.AbstractClassDeclaration)atd).syntheticFields.values();
                    return c.toArray(new IClass.IField[c.size()]);
                }
                return new IClass.IField[0];
            }

            @Override
            @Nullable
            protected IClass getSuperclass2() throws CompileException {
                if (atd instanceof Java.EnumDeclaration) {
                    return ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Enum;
                }
                if (atd instanceof Java.AnonymousClassDeclaration) {
                    IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                    return bt.isInterface() ? ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object : bt;
                }
                if (atd instanceof Java.NamedClassDeclaration) {
                    Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                    Java.Type oet = ncd.optionalExtendedType;
                    if (oet == null) {
                        return ((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object;
                    }
                    IClass superclass = UnitCompiler.this.getType(oet);
                    if (superclass.isInterface()) {
                        UnitCompiler.this.compileError("\"" + superclass.toString() + "\" is an interface; classes can only extend a class", td.getLocation());
                    }
                    return superclass;
                }
                return null;
            }

            @Override
            public Access getAccess() {
                return UnitCompiler.modifiers2Access(atd.getModifierFlags());
            }

            @Override
            public boolean isFinal() {
                return Mod.isFinal(atd.getModifierFlags());
            }

            @Override
            protected IClass[] getInterfaces2() throws CompileException {
                if (atd instanceof Java.AnonymousClassDeclaration) {
                    IClass[] iClassArray;
                    IClass bt = UnitCompiler.this.getType(((Java.AnonymousClassDeclaration)atd).baseType);
                    if (bt.isInterface()) {
                        IClass[] iClassArray2 = new IClass[1];
                        iClassArray = iClassArray2;
                        iClassArray2[0] = bt;
                    } else {
                        iClassArray = new IClass[]{};
                    }
                    return iClassArray;
                }
                if (atd instanceof Java.NamedClassDeclaration) {
                    Java.NamedClassDeclaration ncd = (Java.NamedClassDeclaration)atd;
                    IClass[] res = new IClass[ncd.implementedTypes.length];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = UnitCompiler.this.getType(ncd.implementedTypes[i]);
                        if (res[i].isInterface()) continue;
                        UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; classes can only implement interfaces", td.getLocation());
                    }
                    return res;
                }
                if (atd instanceof Java.InterfaceDeclaration) {
                    Java.InterfaceDeclaration id = (Java.InterfaceDeclaration)atd;
                    IClass[] res = new IClass[id.extendedTypes.length];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = UnitCompiler.this.getType(id.extendedTypes[i]);
                        if (res[i].isInterface()) continue;
                        UnitCompiler.this.compileError("\"" + res[i].toString() + "\" is not an interface; interfaces can only extend interfaces", td.getLocation());
                    }
                    return res;
                }
                throw new JaninoRuntimeException("SNO: AbstractTypeDeclaration is neither ClassDeclaration nor InterfaceDeclaration");
            }

            @Override
            public boolean isAbstract() {
                return atd instanceof Java.InterfaceDeclaration || Mod.isAbstract(atd.getModifierFlags());
            }

            @Override
            public boolean isEnum() {
                return atd instanceof Java.EnumDeclaration;
            }

            @Override
            public boolean isInterface() {
                return atd instanceof Java.InterfaceDeclaration;
            }
        };
        return atd.resolvedType;
    }

    private void referenceThis(Java.Locatable locatable, Java.AbstractClassDeclaration declaringClass, Java.TypeBodyDeclaration declaringTypeBodyDeclaration, IClass targetIClass) throws CompileException {
        int i;
        int j;
        List<Java.TypeDeclaration> path;
        block8: {
            path = UnitCompiler.getOuterClasses(declaringClass);
            if (declaringTypeBodyDeclaration.isStatic()) {
                this.compileError("No current instance available in static context", locatable.getLocation());
            }
            for (j = 0; j < path.size(); ++j) {
                if (!targetIClass.isAssignableFrom(this.resolve(path.get(j)))) {
                    continue;
                }
                break block8;
            }
            this.compileError("\"" + declaringClass + "\" is not enclosed by \"" + targetIClass + "\"", locatable.getLocation());
        }
        if (declaringTypeBodyDeclaration instanceof Java.ConstructorDeclarator) {
            if (j == 0) {
                this.writeOpcode(locatable, 42);
                return;
            }
            Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)declaringTypeBodyDeclaration;
            String spn = "this$" + (path.size() - 2);
            Java.LocalVariable syntheticParameter = constructorDeclarator.syntheticParameters.get(spn);
            if (syntheticParameter == null) {
                throw new JaninoRuntimeException("SNO: Synthetic parameter \"" + spn + "\" not found");
            }
            this.load(locatable, syntheticParameter);
            i = 1;
        } else {
            this.writeOpcode(locatable, 42);
            i = 0;
        }
        while (i < j) {
            Java.InnerClassDeclaration inner = (Java.InnerClassDeclaration)path.get(i);
            Java.TypeDeclaration outer = path.get(i + 1);
            SimpleIField sf = new SimpleIField(this.resolve(inner), "this$" + (path.size() - i - 2), this.resolve(outer));
            inner.defineSyntheticField(sf);
            this.getfield(locatable, sf);
            ++i;
        }
    }

    private static List<Java.TypeDeclaration> getOuterClasses(Java.TypeDeclaration inner) {
        ArrayList<Java.TypeDeclaration> path = new ArrayList<Java.TypeDeclaration>();
        Java.TypeDeclaration ic = inner;
        while (ic != null) {
            path.add(ic);
            ic = UnitCompiler.getOuterClass(ic);
        }
        return path;
    }

    @Nullable
    static Java.TypeDeclaration getOuterClass(Java.TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof Java.PackageMemberClassDeclaration) {
            return null;
        }
        if (typeDeclaration instanceof Java.MemberEnumDeclaration) {
            return null;
        }
        if (typeDeclaration instanceof Java.LocalClassDeclaration) {
            Java.Scope s = typeDeclaration.getEnclosingScope();
            while (!(s instanceof Java.FunctionDeclarator)) {
                s = s.getEnclosingScope();
            }
            if (s instanceof Java.MethodDeclarator && Mod.isStatic(((Java.FunctionDeclarator)s).modifiers.accessFlags)) {
                return null;
            }
            while (!(s instanceof Java.TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            Java.TypeDeclaration immediatelyEnclosingTypeDeclaration = (Java.TypeDeclaration)s;
            return immediatelyEnclosingTypeDeclaration instanceof Java.AbstractClassDeclaration ? immediatelyEnclosingTypeDeclaration : null;
        }
        if (typeDeclaration instanceof Java.MemberClassDeclaration && Mod.isStatic(((Java.MemberClassDeclaration)typeDeclaration).getModifierFlags())) {
            return null;
        }
        Java.Scope s = typeDeclaration;
        while (!(s instanceof Java.TypeBodyDeclaration)) {
            if (s instanceof Java.ConstructorInvocation) {
                return null;
            }
            if (s instanceof Java.CompilationUnit) {
                return null;
            }
            s = s.getEnclosingScope();
        }
        if (((Java.TypeBodyDeclaration)s).isStatic()) {
            return null;
        }
        return (Java.AbstractTypeDeclaration)s.getEnclosingScope();
    }

    private IClass getIClass(Java.ThisReference tr) throws CompileException {
        if (tr.iClass != null) {
            return tr.iClass;
        }
        Java.Scope s = tr.getEnclosingScope();
        while (s instanceof Java.Statement || s instanceof Java.CatchClause) {
            s = s.getEnclosingScope();
        }
        if (s instanceof Java.FunctionDeclarator) {
            Java.FunctionDeclarator function = (Java.FunctionDeclarator)s;
            if (Mod.isStatic(function.modifiers.accessFlags)) {
                this.compileError("No current instance available in static method", tr.getLocation());
            }
        }
        while (!(s instanceof Java.TypeDeclaration)) {
            s = s.getEnclosingScope();
        }
        if (!(s instanceof Java.AbstractClassDeclaration)) {
            this.compileError("Only methods of classes can have a current instance", tr.getLocation());
        }
        tr.iClass = this.resolve((Java.AbstractClassDeclaration)s);
        return tr.iClass;
    }

    private IClass getReturnType(Java.FunctionDeclarator fd) throws CompileException {
        if (fd.returnType != null) {
            return fd.returnType;
        }
        fd.returnType = this.getType(fd.type);
        return fd.returnType;
    }

    IClass.IConstructor toIConstructor(final Java.ConstructorDeclarator constructorDeclarator) {
        if (constructorDeclarator.iConstructor != null) {
            return constructorDeclarator.iConstructor;
        }
        final IClass.IAnnotation[] ias = this.toIAnnotations(constructorDeclarator.getAnnotations());
        IClass iClass = this.resolve(constructorDeclarator.getDeclaringType());
        iClass.getClass();
        constructorDeclarator.iConstructor = new IClass.IConstructor(iClass){

            @Override
            public Access getAccess() {
                switch (constructorDeclarator.modifiers.accessFlags & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            @Override
            public IClass.IAnnotation[] getAnnotations() {
                return ias;
            }

            @Override
            public String getDescriptor2() throws CompileException {
                if (!(constructorDeclarator.getDeclaringClass() instanceof Java.InnerClassDeclaration)) {
                    return super.getDescriptor2();
                }
                if (constructorDeclarator.getDeclaringClass() instanceof Java.MemberEnumDeclaration) {
                    return super.getDescriptor2();
                }
                ArrayList<String> parameterFds = new ArrayList<String>();
                IClass outerClass = UnitCompiler.this.resolve(constructorDeclarator.getDeclaringClass()).getOuterIClass();
                if (outerClass != null) {
                    parameterFds.add(outerClass.getDescriptor());
                }
                for (IClass.IField sf : constructorDeclarator.getDeclaringClass().syntheticFields.values()) {
                    if (!sf.getName().startsWith("val$")) continue;
                    parameterFds.add(sf.getType().getDescriptor());
                }
                for (IClass pt : this.getParameterTypes2()) {
                    parameterFds.add(pt.getDescriptor());
                }
                return new MethodDescriptor(parameterFds.toArray(new String[parameterFds.size()]), "V").toString();
            }

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(constructorDeclarator.modifiers.accessFlags);
            }

            @Override
            public IClass[] getParameterTypes2() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] parameters = constructorDeclarator.formalParameters.parameters;
                IClass[] res = new IClass[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    IClass parameterType = UnitCompiler.this.getType(parameters[i].type);
                    if (i == parameters.length - 1 && constructorDeclarator.formalParameters.variableArity) {
                        parameterType = parameterType.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                    }
                    res[i] = parameterType;
                }
                return res;
            }

            @Override
            public IClass[] getThrownExceptions2() throws CompileException {
                IClass[] res = new IClass[constructorDeclarator.thrownExceptions.length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = UnitCompiler.this.getType(constructorDeclarator.thrownExceptions[i]);
                }
                return res;
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder().append(constructorDeclarator.getDeclaringType().getClassName()).append('(');
                Java.FunctionDeclarator.FormalParameter[] parameters = constructorDeclarator.formalParameters.parameters;
                for (int i = 0; i < parameters.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(parameters[i].toString(i == parameters.length - 1 && constructorDeclarator.formalParameters.variableArity));
                }
                return sb.append(')').toString();
            }
        };
        return constructorDeclarator.iConstructor;
    }

    public IClass.IMethod toIMethod(final Java.MethodDeclarator methodDeclarator) {
        if (methodDeclarator.iMethod != null) {
            return methodDeclarator.iMethod;
        }
        final IClass.IAnnotation[] ias = this.toIAnnotations(methodDeclarator.getAnnotations());
        IClass iClass = this.resolve(methodDeclarator.getDeclaringType());
        iClass.getClass();
        methodDeclarator.iMethod = new IClass.IMethod(iClass){

            @Override
            public Access getAccess() {
                switch (methodDeclarator.modifiers.accessFlags & 7) {
                    case 2: {
                        return Access.PRIVATE;
                    }
                    case 4: {
                        return Access.PROTECTED;
                    }
                    case 0: {
                        return Access.DEFAULT;
                    }
                    case 1: {
                        return Access.PUBLIC;
                    }
                }
                throw new JaninoRuntimeException("Invalid access");
            }

            @Override
            public IClass.IAnnotation[] getAnnotations() {
                return ias;
            }

            @Override
            public boolean isVarargs() {
                return Mod.isVarargs(methodDeclarator.modifiers.accessFlags);
            }

            @Override
            public IClass[] getParameterTypes2() throws CompileException {
                Java.FunctionDeclarator.FormalParameter[] parameters = methodDeclarator.formalParameters.parameters;
                IClass[] res = new IClass[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    IClass parameterType = UnitCompiler.this.getType(parameters[i].type);
                    if (i == parameters.length - 1 && methodDeclarator.formalParameters.variableArity) {
                        parameterType = parameterType.getArrayIClass(((UnitCompiler)UnitCompiler.this).iClassLoader.TYPE_java_lang_Object);
                    }
                    res[i] = parameterType;
                }
                return res;
            }

            @Override
            public IClass[] getThrownExceptions2() throws CompileException {
                ArrayList<IClass> result = new ArrayList<IClass>();
                for (Java.Type ti : methodDeclarator.thrownExceptions) {
                    String[] identifiers;
                    if (ti instanceof Java.ReferenceType && (identifiers = ((Java.ReferenceType)ti).identifiers).length == 1 && LOOKS_LIKE_TYPE_PARAMETER.matcher(identifiers[0]).matches()) continue;
                    result.add(UnitCompiler.this.getType(ti));
                }
                return result.toArray(new IClass[result.size()]);
            }

            @Override
            public boolean isStatic() {
                return Mod.isStatic(methodDeclarator.modifiers.accessFlags);
            }

            @Override
            public boolean isAbstract() {
                return methodDeclarator.getDeclaringType() instanceof Java.InterfaceDeclaration || Mod.isAbstract(methodDeclarator.modifiers.accessFlags);
            }

            @Override
            public IClass getReturnType() throws CompileException {
                return UnitCompiler.this.getReturnType(methodDeclarator);
            }

            @Override
            public String getName() {
                return methodDeclarator.name;
            }
        };
        return methodDeclarator.iMethod;
    }

    private IClass.IInvocable toIInvocable(final Java.FunctionDeclarator fd) {
        IClass.IInvocable result = fd.accept(new Visitor.FunctionDeclaratorVisitor<IClass.IInvocable, RuntimeException>(){

            @Override
            public IClass.IInvocable visitMethodDeclarator(Java.MethodDeclarator md) {
                return UnitCompiler.this.toIMethod((Java.MethodDeclarator)fd);
            }

            @Override
            public IClass.IInvocable visitConstructorDeclarator(Java.ConstructorDeclarator cd) {
                return UnitCompiler.this.toIConstructor((Java.ConstructorDeclarator)fd);
            }
        });
        assert (result != null);
        return result;
    }

    @Nullable
    private IClass importSingleType(String simpleTypeName, Location location) throws CompileException {
        Object[] ss = this.getSingleTypeImport(simpleTypeName, location);
        if (ss == null) {
            return null;
        }
        IClass iClass = this.findTypeByFullyQualifiedName(location, (String[])ss);
        if (iClass == null) {
            this.compileError("Imported class \"" + Java.join(ss, ".") + "\" could not be loaded", location);
            return this.iClassLoader.TYPE_java_lang_Object;
        }
        return iClass;
    }

    @Nullable
    public String[] getSingleTypeImport(String name, Location location) throws CompileException {
        Map<String, String[]> stis = this.singleTypeImports;
        if (stis == null) {
            final ArrayList stids = new ArrayList();
            for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
                id.accept(new Visitor.ImportVisitor<Void, RuntimeException>(){

                    @Override
                    @Nullable
                    public Void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                        stids.add(stid);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                        return null;
                    }
                });
            }
            stis = new HashMap<String, String[]>();
            for (Java.CompilationUnit.SingleTypeImportDeclaration stid : stids) {
                Object[] ids = stid.identifiers;
                String simpleName = UnitCompiler.last((String[])ids);
                Object[] prev = stis.put(simpleName, (String[])ids);
                if (prev != null && !Arrays.equals(prev, ids)) {
                    this.compileError("Class \"" + simpleName + "\" was previously imported as " + "\"" + Java.join(prev, ".") + "\", now as \"" + Java.join(ids, ".") + "\"", stid.getLocation());
                }
                if (this.findTypeByFullyQualifiedName(location, (String[])ids) != null) continue;
                this.compileError("A class '" + Java.join(ids, ".") + "' could not be found", stid.getLocation());
            }
            this.singleTypeImports = stis;
        }
        return stis.get(name);
    }

    @Nullable
    public IClass importTypeOnDemand(String simpleTypeName, Location location) throws CompileException {
        IClass importedClass = this.onDemandImportableTypes.get(simpleTypeName);
        if (importedClass != null) {
            return importedClass;
        }
        Collection<String[]> tiods = this.typeImportsOnDemand;
        if (tiods == null) {
            tiods = new ArrayList<String[]>();
            tiods.add(new String[]{"java", "lang"});
            for (Java.CompilationUnit.ImportDeclaration id : this.compilationUnit.importDeclarations) {
                final Collection<String[]> finalTiods = tiods;
                id.accept(new Visitor.ImportVisitor<Void, RuntimeException>(){

                    @Override
                    @Nullable
                    public Void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
                        finalTiods.add(tiodd.identifiers);
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration ssid) {
                        return null;
                    }

                    @Override
                    @Nullable
                    public Void visitStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
                        return null;
                    }
                });
            }
            this.typeImportsOnDemand = tiods;
        }
        IClass importedClass2 = null;
        for (String[] packageComponents : tiods) {
            String[] typeComponents = UnitCompiler.concat(packageComponents, simpleTypeName);
            IClass iClass = this.findTypeByFullyQualifiedName(location, typeComponents);
            if (iClass == null) continue;
            if (importedClass2 != null && importedClass2 != iClass) {
                this.compileError("Ambiguous class name: \"" + importedClass2 + "\" vs. \"" + iClass + "\"", location);
            }
            importedClass2 = iClass;
        }
        if (importedClass2 == null) {
            return null;
        }
        this.onDemandImportableTypes.put(simpleTypeName, importedClass2);
        return importedClass2;
    }

    private void declareClassDollarMethod(Java.ClassLiteral cl) {
        IClass noClassDefFoundErrorIClass;
        IClass classNotFoundExceptionIClass;
        Location loc = cl.getLocation();
        Java.Scope s = cl.getEnclosingScope();
        while (true) {
            if (s instanceof Java.AbstractTypeDeclaration) break;
            s = s.getEnclosingScope();
        }
        Java.AbstractTypeDeclaration declaringType = (Java.AbstractTypeDeclaration)s;
        Java.MethodInvocation mi = new Java.MethodInvocation(loc, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_Class), "forName", new Java.Rvalue[]{new Java.AmbiguousName(loc, new String[]{"className"})});
        try {
            classNotFoundExceptionIClass = this.iClassLoader.loadIClass("Ljava/lang/ClassNotFoundException;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"ClassNotFoundException\": " + ex.getMessage(), ex);
        }
        if (classNotFoundExceptionIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"ClassNotFoundException\"");
        }
        try {
            noClassDefFoundErrorIClass = this.iClassLoader.loadIClass("Ljava/lang/NoClassDefFoundError;");
        }
        catch (ClassNotFoundException ex) {
            throw new JaninoRuntimeException("Loading class \"NoClassDefFoundError\": " + ex.getMessage(), ex);
        }
        if (noClassDefFoundErrorIClass == null) {
            throw new JaninoRuntimeException("SNO: Cannot load \"NoClassFoundError\"");
        }
        Java.Block b = new Java.Block(loc);
        b.addStatement(new Java.ThrowStatement(loc, new Java.NewClassInstance(loc, (Java.Rvalue)null, new Java.SimpleType(loc, noClassDefFoundErrorIClass), new Java.Rvalue[]{new Java.MethodInvocation(loc, new Java.AmbiguousName(loc, new String[]{"ex"}), "getMessage", new Java.Rvalue[0])})));
        ArrayList<Java.CatchClause> l = new ArrayList<Java.CatchClause>();
        l.add(new Java.CatchClause(loc, new Java.FunctionDeclarator.FormalParameter(loc, true, new Java.SimpleType(loc, classNotFoundExceptionIClass), "ex"), b));
        Java.TryStatement ts = new Java.TryStatement(loc, new Java.ReturnStatement(loc, mi), l, null);
        ArrayList<Java.TryStatement> statements = new ArrayList<Java.TryStatement>();
        statements.add(ts);
        Java.FunctionDeclarator.FormalParameter parameter = new Java.FunctionDeclarator.FormalParameter(loc, false, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_String), "className");
        Java.MethodDeclarator cdmd = new Java.MethodDeclarator(loc, null, new Java.Modifiers(8), null, new Java.SimpleType(loc, this.iClassLoader.TYPE_java_lang_Class), "class$", new Java.FunctionDeclarator.FormalParameters(loc, new Java.FunctionDeclarator.FormalParameter[]{parameter}, false), new Java.ReferenceType[0], statements);
        declaringType.addDeclaredMethod(cdmd);
        declaringType.invalidateMethodCaches();
    }

    private IClass pushConstant(Java.Locatable locatable, @Nullable Object value) throws CompileException {
        block27: {
            int iv;
            block24: {
                block26: {
                    block25: {
                        block23: {
                            if (!(value instanceof Character)) break block23;
                            iv = ((Character)value).charValue();
                            break block24;
                        }
                        if (!(value instanceof Byte)) break block25;
                        iv = ((Byte)value).intValue();
                        break block24;
                    }
                    if (!(value instanceof Short)) break block26;
                    iv = ((Short)value).intValue();
                    break block24;
                }
                if (!(value instanceof Integer)) break block27;
                iv = (Integer)value;
            }
            if (iv >= -1 && iv <= 5) {
                this.writeOpcode(locatable, 3 + iv);
            } else if (iv >= -128 && iv <= 127) {
                this.writeOpcode(locatable, 16);
                this.writeByte((byte)iv);
            } else {
                this.writeLdc(locatable, this.addConstantIntegerInfo(iv));
            }
            return IClass.INT;
        }
        if (value instanceof Long) {
            long lv = (Long)value;
            if (lv == 0L) {
                this.writeOpcode(locatable, 9);
            } else if (lv == 1L) {
                this.writeOpcode(locatable, 10);
            } else {
                this.writeOpcode(locatable, 20);
                this.writeConstantLongInfo(lv);
            }
            return IClass.LONG;
        }
        if (value instanceof Float) {
            float fv = ((Float)value).floatValue();
            if (Float.floatToIntBits(fv) == Float.floatToIntBits(0.0f) || fv == 1.0f || fv == 2.0f) {
                this.writeOpcode(locatable, 11 + (int)fv);
            } else {
                this.writeLdc(locatable, this.addConstantFloatInfo(fv));
            }
            return IClass.FLOAT;
        }
        if (value instanceof Double) {
            double dv = (Double)value;
            if (Double.doubleToLongBits(dv) == Double.doubleToLongBits(0.0) || dv == 1.0) {
                this.writeOpcode(locatable, 14 + (int)dv);
            } else {
                this.writeOpcode(locatable, 20);
                this.writeConstantDoubleInfo(dv);
            }
            return IClass.DOUBLE;
        }
        if (value instanceof String) {
            String s = (String)value;
            String[] ss = UnitCompiler.makeUtf8Able(s);
            this.writeLdc(locatable, this.addConstantStringInfo(ss[0]));
            for (int i = 1; i < ss.length; ++i) {
                this.writeLdc(locatable, this.addConstantStringInfo(ss[i]));
                this.invoke(locatable, this.iClassLoader.METH_java_lang_String__concat__java_lang_String);
            }
            return this.iClassLoader.TYPE_java_lang_String;
        }
        if (Boolean.TRUE.equals(value)) {
            this.writeOpcode(locatable, 4);
            return IClass.BOOLEAN;
        }
        if (Boolean.FALSE.equals(value)) {
            this.writeOpcode(locatable, 3);
            return IClass.BOOLEAN;
        }
        if (value == null) {
            this.writeOpcode(locatable, 1);
            return IClass.VOID;
        }
        throw new JaninoRuntimeException("Unknown literal '" + value + "'");
    }

    private static int hex2Int(Java.Locatable locatable, String value) throws CompileException {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & 0xF0000000) != 0) {
                throw UnitCompiler.compileException(locatable, "Value of hexadecimal integer literal \"" + value + "\" is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 16);
            assert (digitValue >= 0);
            result = (result << 4) + digitValue;
        }
        return result;
    }

    private static int oct2Int(Java.Locatable locatable, String value) throws CompileException {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & 0xE0000000) != 0) {
                throw UnitCompiler.compileException(locatable, "Value of octal integer literal '" + value + "' is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 8);
            assert (digitValue >= 0);
            result = (result << 3) + digitValue;
        }
        return result;
    }

    private static int bin2Int(Java.Locatable locatable, String value) throws CompileException {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & Integer.MIN_VALUE) != 0) {
                throw UnitCompiler.compileException(locatable, "Value of binary integer literal '" + value + "' is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 2);
            assert (digitValue >= 0);
            result = (result << 1) + digitValue;
        }
        return result;
    }

    private static long hex2Long(Java.Locatable locatable, String value) throws CompileException {
        long result = 0L;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & 0xF000000000000000L) != 0L) {
                throw UnitCompiler.compileException(locatable, "Value of hexadecimal long literal \"" + value + "\" is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 16);
            assert (digitValue >= 0);
            result = (result << 4) + (long)digitValue;
        }
        return result;
    }

    private static long oct2Long(Java.Locatable locatable, String value) throws CompileException {
        long result = 0L;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & 0xE000000000000000L) != 0L) {
                throw UnitCompiler.compileException(locatable, "Value of octal long literal '" + value + "' is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 8);
            assert (digitValue >= 0);
            result = (result << 3) + (long)digitValue;
        }
        return result;
    }

    private static long bin2Long(Java.Locatable locatable, String value) throws CompileException {
        long result = 0L;
        for (int i = 0; i < value.length(); ++i) {
            if ((result & Long.MIN_VALUE) != 0L) {
                throw UnitCompiler.compileException(locatable, "Value of binary long literal '" + value + "' is out of range");
            }
            int digitValue = Character.digit(value.charAt(i), 2);
            assert (digitValue >= 0);
            result = (result << 1) + (long)digitValue;
        }
        return result;
    }

    private static String[] makeUtf8Able(String s) {
        if (s.length() < 21845) {
            return new String[]{s};
        }
        int sLength = s.length();
        int utfLength = 0;
        int from = 0;
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (true) {
            char c;
            if (i == sLength) {
                l.add(s.substring(from));
                break;
            }
            if (utfLength >= 65532) {
                l.add(s.substring(from, i));
                if (i + 21845 > sLength) {
                    l.add(s.substring(i));
                    break;
                }
                from = i;
                utfLength = 0;
            }
            utfLength = (c = s.charAt(i)) >= '\u0001' && c <= '\u007f' ? ++utfLength : (c > '\u07ff' ? (utfLength += 3) : (utfLength += 2));
            ++i;
        }
        return l.toArray(new String[l.size()]);
    }

    private void writeLdc(Java.Locatable locatable, short index) {
        if (0 <= index && index <= 255) {
            this.writeOpcode(locatable, 18);
            this.writeByte((byte)index);
        } else {
            this.writeOpcode(locatable, 19);
            this.writeShort(index);
        }
    }

    private void assignmentConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, @Nullable Object optionalConstantValue) throws CompileException {
        if (!this.tryAssignmentConversion(locatable, sourceType, targetType, optionalConstantValue)) {
            this.compileError("Assignment conversion not possible from type \"" + sourceType + "\" to type \"" + targetType + "\"", locatable.getLocation());
        }
    }

    private boolean tryAssignmentConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, @Nullable Object optionalConstantValue) throws CompileException {
        IClass unboxedType;
        LOGGER.entering((String)null, "tryAssignmentConversion", new Object[]{locatable, sourceType, targetType, optionalConstantValue});
        if (this.tryIdentityConversion(sourceType, targetType)) {
            return true;
        }
        if (this.tryWideningPrimitiveConversion(locatable, sourceType, targetType)) {
            return true;
        }
        if (this.isWideningReferenceConvertible(sourceType, targetType)) {
            return true;
        }
        IClass boxedType = this.isBoxingConvertible(sourceType);
        if (boxedType != null) {
            if (this.tryIdentityConversion(boxedType, targetType)) {
                this.boxingConversion(locatable, sourceType, boxedType);
                return true;
            }
            if (this.isWideningReferenceConvertible(boxedType, targetType)) {
                this.boxingConversion(locatable, sourceType, boxedType);
                return true;
            }
        }
        if ((unboxedType = this.isUnboxingConvertible(sourceType)) != null) {
            if (this.tryIdentityConversion(unboxedType, targetType)) {
                this.unboxingConversion(locatable, sourceType, unboxedType);
                return true;
            }
            if (this.isWideningPrimitiveConvertible(unboxedType, targetType)) {
                this.unboxingConversion(locatable, sourceType, unboxedType);
                this.tryWideningPrimitiveConversion(locatable, unboxedType, targetType);
                return true;
            }
        }
        return optionalConstantValue != NOT_CONSTANT && this.tryConstantAssignmentConversion(locatable, optionalConstantValue, targetType);
    }

    @Nullable
    private Object assignmentConversion(Java.Locatable locatable, @Nullable Object value, IClass targetType) throws CompileException {
        if (targetType == IClass.BOOLEAN) {
            if (value instanceof Boolean) {
                return value;
            }
        } else if (targetType == this.iClassLoader.TYPE_java_lang_String) {
            if (value instanceof String) {
                return value;
            }
        } else if (targetType == IClass.BYTE) {
            char x;
            if (value instanceof Byte) {
                return value;
            }
            if (value instanceof Short || value instanceof Integer) {
                assert (value != null);
                int x2 = ((Number)value).intValue();
                if (x2 >= -128 && x2 <= 127) {
                    return new Byte((byte)x2);
                }
            } else if (value instanceof Character && (x = ((Character)value).charValue()) >= '\uffffff80' && x <= '\u007f') {
                return new Byte((byte)x);
            }
        } else if (targetType == IClass.SHORT) {
            int x;
            if (value instanceof Byte) {
                return new Short(((Number)value).shortValue());
            }
            if (value instanceof Short) {
                return value;
            }
            if (value instanceof Character) {
                char x3 = ((Character)value).charValue();
                if (x3 >= Short.MIN_VALUE && x3 <= Short.MAX_VALUE) {
                    return new Short((short)x3);
                }
            } else if (value instanceof Integer && (x = ((Integer)value).intValue()) >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                return new Short((short)x);
            }
        } else if (targetType == IClass.CHAR) {
            if (value instanceof Short) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                assert (value != null);
                int x = ((Number)value).intValue();
                if (x >= 0 && x <= 65535) {
                    return new Character((char)x);
                }
            }
        } else if (targetType == IClass.INT) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short) {
                assert (value != null);
                return new Integer(((Number)value).intValue());
            }
            if (value instanceof Character) {
                return new Integer(((Character)value).charValue());
            }
        } else if (targetType == IClass.LONG) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                assert (value != null);
                return new Long(((Number)value).longValue());
            }
            if (value instanceof Character) {
                return new Long(((Character)value).charValue());
            }
        } else if (targetType == IClass.FLOAT) {
            if (value instanceof Float) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                assert (value != null);
                return new Float(((Number)value).floatValue());
            }
            if (value instanceof Character) {
                return new Float(((Character)value).charValue());
            }
        } else if (targetType == IClass.DOUBLE) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float) {
                assert (value != null);
                return new Double(((Number)value).doubleValue());
            }
            if (value instanceof Character) {
                return new Double(((Character)value).charValue());
            }
        } else if (value == null && !targetType.isPrimitive()) {
            return null;
        }
        if (value == null) {
            this.compileError("Cannot convert 'null' to type '" + targetType.toString() + "'", locatable.getLocation());
        } else {
            this.compileError("Cannot convert constant of type '" + value.getClass().getName() + "' to type '" + targetType.toString() + "'", locatable.getLocation());
        }
        return value;
    }

    private IClass unaryNumericPromotion(Java.Locatable locatable, IClass type) throws CompileException {
        type = this.convertToPrimitiveNumericType(locatable, type);
        IClass promotedType = this.unaryNumericPromotionType(locatable, type);
        this.numericPromotion(locatable, type, promotedType);
        return promotedType;
    }

    private void reverseUnaryNumericPromotion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        IClass pt;
        IClass unboxedType = this.isUnboxingConvertible(targetType);
        IClass iClass = pt = unboxedType != null ? unboxedType : targetType;
        if (!this.tryIdentityConversion(sourceType, pt) && !this.tryNarrowingPrimitiveConversion(locatable, sourceType, pt)) {
            throw new JaninoRuntimeException("SNO: reverse unary numeric promotion failed");
        }
        if (unboxedType != null) {
            this.boxingConversion(locatable, unboxedType, targetType);
        }
    }

    private IClass convertToPrimitiveNumericType(Java.Locatable locatable, IClass type) throws CompileException {
        if (type.isPrimitiveNumeric()) {
            return type;
        }
        IClass unboxedType = this.isUnboxingConvertible(type);
        if (unboxedType != null) {
            this.unboxingConversion(locatable, type, unboxedType);
            return unboxedType;
        }
        this.compileError("Object of type \"" + type.toString() + "\" cannot be converted to a numeric type", locatable.getLocation());
        return type;
    }

    private void numericPromotion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        if (!this.tryIdentityConversion(sourceType, targetType) && !this.tryWideningPrimitiveConversion(locatable, sourceType, targetType)) {
            throw new JaninoRuntimeException("SNO: Conversion failed");
        }
    }

    private IClass unaryNumericPromotionType(Java.Locatable locatable, IClass type) throws CompileException {
        if (!type.isPrimitiveNumeric()) {
            this.compileError("Unary numeric promotion not possible on non-numeric-primitive type \"" + type + "\"", locatable.getLocation());
        }
        return type == IClass.DOUBLE ? IClass.DOUBLE : (type == IClass.FLOAT ? IClass.FLOAT : (type == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private IClass binaryNumericPromotion(Java.Locatable locatable, IClass type1, CodeContext.Inserter convertInserter1, IClass type2) throws CompileException {
        return this.binaryNumericPromotion(locatable, type1, convertInserter1, type2, this.getCodeContext().currentInserter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClass binaryNumericPromotion(Java.Locatable locatable, IClass type1, @Nullable CodeContext.Inserter convertInserter1, IClass type2, @Nullable CodeContext.Inserter convertInserter2) throws CompileException {
        IClass c1 = this.isUnboxingConvertible(type1);
        IClass c2 = this.isUnboxingConvertible(type2);
        IClass promotedType = this.binaryNumericPromotionType(locatable, c1 != null ? c1 : type1, c2 != null ? c2 : type2);
        if (convertInserter1 != null) {
            this.getCodeContext().pushInserter(convertInserter1);
            try {
                this.numericPromotion(locatable, this.convertToPrimitiveNumericType(locatable, type1), promotedType);
            }
            finally {
                this.getCodeContext().popInserter();
            }
        }
        if (convertInserter2 != null) {
            this.getCodeContext().pushInserter(convertInserter2);
            try {
                this.numericPromotion(locatable, this.convertToPrimitiveNumericType(locatable, type2), promotedType);
            }
            finally {
                this.getCodeContext().popInserter();
            }
        }
        return promotedType;
    }

    private IClass binaryNumericPromotionType(Java.Locatable locatable, IClass type1, IClass type2) throws CompileException {
        if (!type1.isPrimitiveNumeric() || !type2.isPrimitiveNumeric()) {
            this.compileError("Binary numeric promotion not possible on types \"" + type1 + "\" and \"" + type2 + "\"", locatable.getLocation());
        }
        return type1 == IClass.DOUBLE || type2 == IClass.DOUBLE ? IClass.DOUBLE : (type1 == IClass.FLOAT || type2 == IClass.FLOAT ? IClass.FLOAT : (type1 == IClass.LONG || type2 == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    private boolean isIdentityConvertible(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean tryIdentityConversion(IClass sourceType, IClass targetType) {
        return sourceType == targetType;
    }

    private boolean isWideningPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor()) != null;
    }

    private boolean tryWideningPrimitiveConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        byte[] opcodes = PRIMITIVE_WIDENING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes != null) {
            this.writeOpcodes(locatable, opcodes);
            return true;
        }
        return false;
    }

    private static void fillConversionMap(Object[] array, Map<String, byte[]> map) {
        byte[] opcodes = null;
        for (Object o : array) {
            if (o instanceof byte[]) {
                opcodes = (byte[])o;
                continue;
            }
            map.put((String)o, opcodes);
        }
    }

    private boolean isWideningReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean tryWideningReferenceConversion(IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.isPrimitive() || sourceType == targetType) {
            return false;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    private boolean isNarrowingPrimitiveConvertible(IClass sourceType, IClass targetType) {
        return PRIMITIVE_NARROWING_CONVERSIONS.containsKey(sourceType.getDescriptor() + targetType.getDescriptor());
    }

    private boolean tryNarrowingPrimitiveConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        byte[] opcodes = PRIMITIVE_NARROWING_CONVERSIONS.get(sourceType.getDescriptor() + targetType.getDescriptor());
        if (opcodes != null) {
            this.writeOpcodes(locatable, opcodes);
            return true;
        }
        return false;
    }

    private boolean tryConstantAssignmentConversion(Java.Locatable locatable, @Nullable Object constantValue, IClass targetType) throws CompileException {
        int cv;
        LOGGER.entering((String)null, "tryConstantAssignmentConversion", new Object[]{locatable, constantValue, targetType});
        if (constantValue instanceof Byte) {
            cv = ((Byte)constantValue).byteValue();
        } else if (constantValue instanceof Short) {
            cv = ((Short)constantValue).shortValue();
        } else if (constantValue instanceof Integer) {
            cv = (Integer)constantValue;
        } else if (constantValue instanceof Character) {
            cv = ((Character)constantValue).charValue();
        } else {
            return false;
        }
        if (targetType == IClass.BYTE) {
            return cv >= -128 && cv <= 127;
        }
        if (targetType == IClass.SHORT) {
            return cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE;
        }
        if (targetType == IClass.CHAR) {
            return cv >= 0 && cv <= 65535;
        }
        IClassLoader icl = this.iClassLoader;
        if (targetType == icl.TYPE_java_lang_Byte && cv >= -128 && cv <= 127) {
            this.boxingConversion(locatable, IClass.BYTE, targetType);
            return true;
        }
        if (targetType == icl.TYPE_java_lang_Short && cv >= Short.MIN_VALUE && cv <= Short.MAX_VALUE) {
            this.boxingConversion(locatable, IClass.SHORT, targetType);
            return true;
        }
        if (targetType == icl.TYPE_java_lang_Character && cv >= 0 && cv <= 65535) {
            this.boxingConversion(locatable, IClass.CHAR, targetType);
            return true;
        }
        return false;
    }

    private boolean isNarrowingReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        if (sourceType.isPrimitive()) {
            return false;
        }
        if (sourceType == targetType) {
            return false;
        }
        if (sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (targetType.isInterface() && !sourceType.isFinal() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType == this.iClassLoader.TYPE_java_lang_Object && targetType.isArray()) {
            return true;
        }
        if (sourceType == this.iClassLoader.TYPE_java_lang_Object && targetType.isInterface()) {
            return true;
        }
        if (sourceType.isInterface() && !targetType.isFinal()) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isFinal() && sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (sourceType.isInterface() && targetType.isInterface() && !targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (sourceType.isArray() && targetType.isArray()) {
            IClass st = sourceType.getComponentType();
            assert (st != null);
            IClass tt = targetType.getComponentType();
            assert (tt != null);
            if (this.isNarrowingPrimitiveConvertible(st, tt) || this.isNarrowingReferenceConvertible(st, tt)) {
                return true;
            }
        }
        return false;
    }

    private boolean tryNarrowingReferenceConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (!this.isNarrowingReferenceConvertible(sourceType, targetType)) {
            return false;
        }
        this.writeOpcode(locatable, -64);
        this.writeConstantClassInfo(targetType.getDescriptor());
        return true;
    }

    private boolean isCastReferenceConvertible(IClass sourceType, IClass targetType) throws CompileException {
        return this.isIdentityConvertible(sourceType, targetType) || this.isWideningReferenceConvertible(sourceType, targetType) || this.isNarrowingReferenceConvertible(sourceType, targetType);
    }

    @Nullable
    private IClass isBoxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == IClass.BOOLEAN) {
            return icl.TYPE_java_lang_Boolean;
        }
        if (sourceType == IClass.BYTE) {
            return icl.TYPE_java_lang_Byte;
        }
        if (sourceType == IClass.CHAR) {
            return icl.TYPE_java_lang_Character;
        }
        if (sourceType == IClass.SHORT) {
            return icl.TYPE_java_lang_Short;
        }
        if (sourceType == IClass.INT) {
            return icl.TYPE_java_lang_Integer;
        }
        if (sourceType == IClass.LONG) {
            return icl.TYPE_java_lang_Long;
        }
        if (sourceType == IClass.FLOAT) {
            return icl.TYPE_java_lang_Float;
        }
        if (sourceType == IClass.DOUBLE) {
            return icl.TYPE_java_lang_Double;
        }
        return null;
    }

    private boolean tryBoxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (this.isBoxingConvertible(sourceType) == targetType) {
            this.boxingConversion(locatable, sourceType, targetType);
            return true;
        }
        return false;
    }

    private void boxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) throws CompileException {
        if (targetType.hasIMethod("valueOf", new IClass[]{sourceType})) {
            this.writeOpcode(locatable, -72);
            this.writeConstantMethodrefInfo(targetType.getDescriptor(), "valueOf", '(' + sourceType.getDescriptor() + ')' + targetType.getDescriptor());
            return;
        }
        this.writeOpcode(locatable, -69);
        this.writeConstantClassInfo(targetType.getDescriptor());
        if (Descriptor.hasSize2(sourceType.getDescriptor())) {
            this.writeOpcode(locatable, 91);
            this.writeOpcode(locatable, 91);
            this.writeOpcode(locatable, 87);
        } else {
            this.writeOpcode(locatable, 90);
            this.writeOpcode(locatable, 95);
        }
        this.writeOpcode(locatable, -73);
        this.writeConstantMethodrefInfo(targetType.getDescriptor(), "<init>", '(' + sourceType.getDescriptor() + ')' + "V");
    }

    @Nullable
    private IClass isUnboxingConvertible(IClass sourceType) {
        IClassLoader icl = this.iClassLoader;
        if (sourceType == icl.TYPE_java_lang_Boolean) {
            return IClass.BOOLEAN;
        }
        if (sourceType == icl.TYPE_java_lang_Byte) {
            return IClass.BYTE;
        }
        if (sourceType == icl.TYPE_java_lang_Character) {
            return IClass.CHAR;
        }
        if (sourceType == icl.TYPE_java_lang_Short) {
            return IClass.SHORT;
        }
        if (sourceType == icl.TYPE_java_lang_Integer) {
            return IClass.INT;
        }
        if (sourceType == icl.TYPE_java_lang_Long) {
            return IClass.LONG;
        }
        if (sourceType == icl.TYPE_java_lang_Float) {
            return IClass.FLOAT;
        }
        if (sourceType == icl.TYPE_java_lang_Double) {
            return IClass.DOUBLE;
        }
        return null;
    }

    private boolean isConvertibleToPrimitiveNumeric(IClass sourceType) {
        if (sourceType.isPrimitiveNumeric()) {
            return true;
        }
        IClass unboxedType = this.isUnboxingConvertible(sourceType);
        return unboxedType != null && unboxedType.isPrimitiveNumeric();
    }

    private boolean tryUnboxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, @Nullable CodeContext.Inserter optionalInserter) {
        if (this.isUnboxingConvertible(sourceType) == targetType) {
            this.unboxingConversion(locatable, sourceType, targetType, optionalInserter);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unboxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType, @Nullable CodeContext.Inserter optionalInserter) {
        if (optionalInserter == null) {
            this.unboxingConversion(locatable, sourceType, targetType);
        } else {
            this.getCodeContext().pushInserter(optionalInserter);
            try {
                this.unboxingConversion(locatable, sourceType, targetType);
            }
            finally {
                this.getCodeContext().popInserter();
            }
        }
    }

    private void unboxingConversion(Java.Locatable locatable, IClass sourceType, IClass targetType) {
        this.writeOpcode(locatable, -74);
        this.writeConstantMethodrefInfo(sourceType.getDescriptor(), targetType.toString() + "Value", "()" + targetType.getDescriptor());
    }

    @Nullable
    private IClass findTypeByFullyQualifiedName(Location location, String[] identifiers) throws CompileException {
        String className = Java.join(identifiers, ".");
        while (true) {
            IClass iClass;
            if ((iClass = this.findTypeByName(location, className)) != null) {
                return iClass;
            }
            int idx = className.lastIndexOf(46);
            if (idx == -1) break;
            className = className.substring(0, idx) + '$' + className.substring(idx + 1);
        }
        return null;
    }

    private IClass load(Java.Locatable locatable, Java.LocalVariable localVariable) {
        this.load(locatable, localVariable.type, localVariable.getSlotIndex());
        return localVariable.type;
    }

    private void load(Java.Locatable locatable, IClass type, int index) {
        if (index <= 3) {
            this.writeOpcode(locatable, 26 + 4 * UnitCompiler.ilfda(type) + index);
        } else if (index <= 255) {
            this.writeOpcode(locatable, 21 + UnitCompiler.ilfda(type));
            this.writeByte(index);
        } else {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, 21 + UnitCompiler.ilfda(type));
            this.writeShort(index);
        }
    }

    private void store(Java.Locatable locatable, Java.LocalVariable localVariable) {
        this.store(locatable, localVariable.type, localVariable.getSlotIndex());
    }

    private void store(Java.Locatable locatable, IClass lvType, short lvIndex) {
        if (lvIndex <= 3) {
            this.writeOpcode(locatable, 59 + 4 * UnitCompiler.ilfda(lvType) + lvIndex);
        } else if (lvIndex <= 255) {
            this.writeOpcode(locatable, 54 + UnitCompiler.ilfda(lvType));
            this.writeByte(lvIndex);
        } else {
            this.writeOpcode(locatable, -60);
            this.writeOpcode(locatable, 54 + UnitCompiler.ilfda(lvType));
            this.writeShort(lvIndex);
        }
    }

    private void getfield(Java.Locatable locatable, IClass.IField iField) throws CompileException {
        this.writeOpcode(locatable, iField.isStatic() ? -78 : -76);
        this.writeConstantFieldrefInfo(iField.getDeclaringIClass().getDescriptor(), iField.getName(), iField.getDescriptor());
    }

    private void putfield(Java.Locatable locatable, IClass.IField iField) throws CompileException {
        this.writeOpcode(locatable, iField.isStatic() ? -77 : -75);
        this.writeConstantFieldrefInfo(iField.getDeclaringIClass().getDescriptor(), iField.getName(), iField.getDescriptor());
    }

    private void dup(Java.Locatable locatable, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.writeOpcode(locatable, 89);
                break;
            }
            case 2: {
                this.writeOpcode(locatable, 92);
                break;
            }
            default: {
                throw new JaninoRuntimeException("dup(" + n + ")");
            }
        }
    }

    private void dupx(Java.Locatable locatable, IClass type, int x) {
        if (x < 0 || x > 2) {
            throw new JaninoRuntimeException("SNO: x has value " + x);
        }
        int dup = 89 + x;
        int dup2 = 92 + x;
        this.writeOpcode(locatable, type == IClass.LONG || type == IClass.DOUBLE ? dup2 : dup);
    }

    private void pop(Java.Locatable locatable, IClass type) {
        if (type == IClass.VOID) {
            return;
        }
        this.writeOpcode(locatable, type == IClass.LONG || type == IClass.DOUBLE ? 88 : 87);
    }

    private static int ilfd(IClass t) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private static int ilfd(IClass t, int opcodeInt, int opcodeLong, int opcodeFloat, int opcodeDouble) {
        if (t == IClass.BYTE || t == IClass.CHAR || t == IClass.INT || t == IClass.SHORT || t == IClass.BOOLEAN) {
            return opcodeInt;
        }
        if (t == IClass.LONG) {
            return opcodeLong;
        }
        if (t == IClass.FLOAT) {
            return opcodeFloat;
        }
        if (t == IClass.DOUBLE) {
            return opcodeDouble;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private static int ilfda(IClass t) {
        return !t.isPrimitive() ? 4 : UnitCompiler.ilfd(t);
    }

    private static int ilfdabcs(IClass t) {
        if (t == IClass.INT) {
            return 0;
        }
        if (t == IClass.LONG) {
            return 1;
        }
        if (t == IClass.FLOAT) {
            return 2;
        }
        if (t == IClass.DOUBLE) {
            return 3;
        }
        if (!t.isPrimitive()) {
            return 4;
        }
        if (t == IClass.BOOLEAN) {
            return 5;
        }
        if (t == IClass.BYTE) {
            return 5;
        }
        if (t == IClass.CHAR) {
            return 6;
        }
        if (t == IClass.SHORT) {
            return 7;
        }
        throw new JaninoRuntimeException("Unexpected type \"" + t + "\"");
    }

    private void invoke(Java.Locatable locatable, IClass.IMethod iMethod) throws CompileException {
        if (iMethod.getDeclaringIClass().isInterface() && !iMethod.isStatic()) {
            this.writeOpcode(locatable, -71);
            this.writeConstantInterfaceMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
            int count = 1;
            for (IClass pt : iMethod.getParameterTypes()) {
                count += Descriptor.size(pt.getDescriptor());
            }
            this.writeByte(count);
            this.writeByte(0);
        } else {
            this.writeOpcode(locatable, iMethod.isStatic() ? -72 : -74);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
        }
    }

    private void invoke(Java.Locatable locatable, IClass.IConstructor iConstructor) throws CompileException {
        this.writeOpcode(locatable, -73);
        this.writeConstantMethodrefInfo(iConstructor.getDeclaringIClass().getDescriptor(), "<init>", iConstructor.getDescriptor());
    }

    @Nullable
    private IClass.IField findIField(IClass iClass, String name, Location location) throws CompileException {
        IClass[] ifs;
        IClass.IField f = iClass.getDeclaredIField(name);
        if (f != null) {
            return f;
        }
        IClass superclass = iClass.getSuperclass();
        if (superclass != null) {
            f = this.findIField(superclass, name, location);
        }
        for (IClass iF : ifs = iClass.getInterfaces()) {
            IClass.IField f2 = this.findIField(iF, name, location);
            if (f2 == null) continue;
            if (f != null) {
                throw new CompileException("Access to field \"" + name + "\" is ambiguous - both \"" + f.getDeclaringIClass() + "\" and \"" + f2.getDeclaringIClass() + "\" declare it", location);
            }
            f = f2;
        }
        return f;
    }

    @Nullable
    private IClass findMemberType(IClass iClass, String name, Location location) throws CompileException {
        IClass[] types = iClass.findMemberType(name);
        if (types.length == 0) {
            return null;
        }
        if (types.length == 1) {
            return types[0];
        }
        StringBuilder sb = new StringBuilder("Type \"").append(name).append("\" is ambiguous: ").append(types[0]);
        for (int i = 1; i < types.length; ++i) {
            sb.append(" vs. ").append(types[i].toString());
        }
        this.compileError(sb.toString(), location);
        return types[0];
    }

    @Nullable
    public IClass findClass(String className) {
        StringTokenizer st;
        Java.NamedTypeDeclaration td;
        Java.PackageDeclaration opd = this.compilationUnit.optionalPackageDeclaration;
        if (opd != null) {
            String packageName = opd.packageName;
            if (!className.startsWith(packageName + '.')) {
                return null;
            }
            className = className.substring(packageName.length() + 1);
        }
        if ((td = this.compilationUnit.getPackageMemberTypeDeclaration((st = new StringTokenizer(className, "$")).nextToken())) == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            if ((td = td.getMemberTypeDeclaration(st.nextToken())) != null) continue;
            return null;
        }
        return this.resolve(td);
    }

    private void compileError(String message) throws CompileException {
        this.compileError(message, null);
    }

    private void compileError(String message, @Nullable Location optionalLocation) throws CompileException {
        ++this.compileErrorCount;
        if (this.optionalCompileErrorHandler == null) {
            throw new CompileException(message, optionalLocation);
        }
        this.optionalCompileErrorHandler.handleError(message, optionalLocation);
    }

    private void warning(String handle, String message, @Nullable Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    @Nullable
    private CodeContext replaceCodeContext(@Nullable CodeContext newCodeContext) {
        CodeContext oldCodeContext = this.codeContext;
        this.codeContext = newCodeContext;
        return oldCodeContext;
    }

    private void writeByte(int v) {
        if (v > 255) {
            throw new JaninoRuntimeException("Byte value out of legal range");
        }
        this.getCodeContext().write((short)-1, (byte)v);
    }

    private void writeShort(int v) {
        if (v > 65535) {
            throw new JaninoRuntimeException("Short value out of legal range");
        }
        this.getCodeContext().write((short)-1, (byte)(v >> 8), (byte)v);
    }

    private void writeInt(int v) {
        this.getCodeContext().write((short)-1, (byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v);
    }

    private void writeOpcode(Java.Locatable locatable, int opcode) {
        int lineNumber = locatable.getLocation().getLineNumber();
        this.getCodeContext().write((short)Math.min(lineNumber, 65535), (byte)opcode);
    }

    private void writeOpcodes(Java.Locatable locatable, byte[] opcodes) {
        int lineNumber = locatable.getLocation().getLineNumber();
        this.getCodeContext().write((short)Math.min(lineNumber, 65535), opcodes);
    }

    private void writeBranch(Java.Locatable locatable, int opcode, CodeContext.Offset dst) {
        int lineNumber = locatable.getLocation().getLineNumber();
        this.getCodeContext().writeBranch((short)Math.min(lineNumber, 65535), opcode, dst);
    }

    private void writeOffset(CodeContext.Offset src, CodeContext.Offset dst) {
        this.getCodeContext().writeOffset((short)-1, src, dst);
    }

    private void writeConstantClassInfo(String descriptor) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantClassInfo(descriptor));
    }

    private void writeConstantFieldrefInfo(String classFd, String fieldName, String fieldFd) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantFieldrefInfo(classFd, fieldName, fieldFd));
    }

    private void writeConstantMethodrefInfo(String classFd, String methodName, String methodMd) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantMethodrefInfo(classFd, methodName, methodMd));
    }

    private void writeConstantInterfaceMethodrefInfo(String classFd, String methodName, String methodMd) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantInterfaceMethodrefInfo(classFd, methodName, methodMd));
    }

    private short addConstantStringInfo(String value) {
        return this.getCodeContext().getClassFile().addConstantStringInfo(value);
    }

    private short addConstantIntegerInfo(int value) {
        return this.getCodeContext().getClassFile().addConstantIntegerInfo(value);
    }

    private short addConstantFloatInfo(float value) {
        return this.getCodeContext().getClassFile().addConstantFloatInfo(value);
    }

    private void writeConstantLongInfo(long value) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantLongInfo(value));
    }

    private void writeConstantDoubleInfo(double value) {
        CodeContext ca = this.getCodeContext();
        ca.writeShort((short)-1, ca.getClassFile().addConstantDoubleInfo(value));
    }

    private CodeContext.Offset getWhereToBreak(Java.BreakableStatement bs) {
        if (bs.whereToBreak != null) {
            return bs.whereToBreak;
        }
        bs.whereToBreak = this.getCodeContext().new CodeContext.Offset();
        return bs.whereToBreak;
    }

    private Java.TypeBodyDeclaration getDeclaringTypeBodyDeclaration(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringTypeBodyDeclaration != null) {
            return qtr.declaringTypeBodyDeclaration;
        }
        Java.Scope s = qtr.getEnclosingScope();
        while (!(s instanceof Java.TypeBodyDeclaration)) {
            s = s.getEnclosingScope();
        }
        Java.TypeBodyDeclaration result = (Java.TypeBodyDeclaration)s;
        if (result.isStatic()) {
            this.compileError("No current instance available in static method", qtr.getLocation());
        }
        qtr.declaringClass = (Java.AbstractClassDeclaration)result.getDeclaringType();
        qtr.declaringTypeBodyDeclaration = result;
        return qtr.declaringTypeBodyDeclaration;
    }

    private Java.AbstractClassDeclaration getDeclaringClass(Java.QualifiedThisReference qtr) throws CompileException {
        if (qtr.declaringClass != null) {
            return qtr.declaringClass;
        }
        this.getDeclaringTypeBodyDeclaration(qtr);
        assert (qtr.declaringClass != null);
        return qtr.declaringClass;
    }

    private void referenceThis(Java.Locatable locatable) {
        this.writeOpcode(locatable, 42);
    }

    private IClass newArray(Java.Locatable locatable, int dimExprCount, int dims, IClass componentType) {
        if (dimExprCount == 1 && dims == 0 && componentType.isPrimitive()) {
            this.writeOpcode(locatable, -68);
            this.writeByte(componentType == IClass.BOOLEAN ? 4 : (componentType == IClass.CHAR ? 5 : (componentType == IClass.FLOAT ? 6 : (componentType == IClass.DOUBLE ? 7 : (componentType == IClass.BYTE ? 8 : (componentType == IClass.SHORT ? 9 : (componentType == IClass.INT ? 10 : (componentType == IClass.LONG ? 11 : -1))))))));
            return componentType.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
        }
        if (dimExprCount == 1) {
            IClass at = componentType.getArrayIClass(dims, this.iClassLoader.TYPE_java_lang_Object);
            this.writeOpcode(locatable, -67);
            this.writeConstantClassInfo(at.getDescriptor());
            return at.getArrayIClass(this.iClassLoader.TYPE_java_lang_Object);
        }
        IClass at = componentType.getArrayIClass(dimExprCount + dims, this.iClassLoader.TYPE_java_lang_Object);
        this.writeOpcode(locatable, -59);
        this.writeConstantClassInfo(at.getDescriptor());
        this.writeByte(dimExprCount);
        return at;
    }

    private static Access modifiers2Access(short modifiers) {
        return Mod.isPublicAccess(modifiers) ? Access.PUBLIC : (Mod.isProtectedAccess(modifiers) ? Access.PROTECTED : (Mod.isPrivateAccess(modifiers) ? Access.PRIVATE : Access.DEFAULT));
    }

    private static String last(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        return sa[sa.length - 1];
    }

    private static String[] allButLast(String[] sa) {
        if (sa.length == 0) {
            throw new IllegalArgumentException("SNO: Empty string array");
        }
        String[] tmp = new String[sa.length - 1];
        System.arraycopy(sa, 0, tmp, 0, tmp.length);
        return tmp;
    }

    private static String[] concat(String[] sa, String s) {
        String[] tmp = new String[sa.length + 1];
        System.arraycopy(sa, 0, tmp, 0, sa.length);
        tmp[sa.length] = s;
        return tmp;
    }

    private static CompileException compileException(Java.Locatable locatable, String message) {
        return new CompileException(message, locatable.getLocation());
    }

    private static String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            int secondDigit;
            int idx;
            char c;
            if ((c = s.charAt(i++)) != '\\') {
                sb.append(c);
                continue;
            }
            if ((idx = "btnfr\"'\\".indexOf(c = s.charAt(i++))) != -1) {
                sb.append("\b\t\n\f\r\"'\\".charAt(idx));
                continue;
            }
            int x = Character.digit(c, 8);
            if (x == -1) {
                throw new JaninoRuntimeException("Invalid escape sequence '\\" + c + "'");
            }
            if (i < s.length() && (secondDigit = Character.digit(c = s.charAt(i), 8)) != -1) {
                int thirdDigit;
                x = 8 * x + secondDigit;
                if (++i < s.length() && x <= 31 && (thirdDigit = Character.digit(c, 8)) != -1) {
                    x = 8 * x + thirdDigit;
                    ++i;
                }
            }
            sb.append((char)x);
        }
        return sb.toString();
    }

    public static void disassembleToStdout(byte[] contents) {
        try {
            Class<?> disassemblerClass = Class.forName("de.unkrig.jdisasm.Disassembler");
            disassemblerClass.getMethod("disasm", InputStream.class).invoke(disassemblerClass.newInstance(), new ByteArrayInputStream(contents));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Notice: Could not disassemble class file for logging because \"de.unkrig.jdisasm.Disassembler\" is not on the classpath. If you are interested in disassemblies of class files generated by JANINO, get de.unkrig.jdisasm and put it on the classpath.");
        }
    }

    static {
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BS", "BI", "SI", "CI", new byte[]{-123}, "BJ", "SJ", "CJ", "IJ", new byte[]{-122}, "BF", "SF", "CF", "IF", new byte[]{-119}, "JF", new byte[]{-121}, "BD", "SD", "CD", "ID", new byte[]{-118}, "JD", new byte[]{-115}, "FD"}, PRIMITIVE_WIDENING_CONVERSIONS);
        PRIMITIVE_NARROWING_CONVERSIONS = new HashMap<String, byte[]>();
        UnitCompiler.fillConversionMap(new Object[]{new byte[0], "BC", "SC", "CS", new byte[]{-111}, "SB", "CB", "IB", new byte[]{-109}, "IS", "IC", new byte[]{-120, -111}, "JB", new byte[]{-120, -109}, "JS", "JC", new byte[]{-120}, "JI", new byte[]{-117, -111}, "FB", new byte[]{-117, -109}, "FS", "FC", new byte[]{-117}, "FI", new byte[]{-116}, "FJ", new byte[]{-114, -111}, "DB", new byte[]{-114, -109}, "DS", "DC", new byte[]{-114}, "DI", new byte[]{-113}, "DJ", new byte[]{-112}, "DF"}, PRIMITIVE_NARROWING_CONVERSIONS);
    }

    public static class SimpleIField
    extends IClass.IField {
        private final String name;
        private final IClass type;

        public SimpleIField(IClass declaringIClass, String name, IClass type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public Object getConstantValue() {
            return NOT_CONSTANT;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IClass getType() {
            return this.type;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Access getAccess() {
            return Access.DEFAULT;
        }

        @Override
        public IClass.IAnnotation[] getAnnotations() {
            return new IClass.IAnnotation[0];
        }
    }

    static interface Compilable {
        public void compile() throws CompileException;
    }

    private static enum SwitchKind {
        INT,
        ENUM,
        STRING;

    }
}

