/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.CatchClause;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class TryExp
extends Expression {
    Expression try_clause;
    CatchClause catch_clauses;
    Expression finally_clause;

    public final CatchClause getCatchClauses() {
        return this.catch_clauses;
    }

    public final void setCatchClauses(CatchClause catch_clauses) {
        this.catch_clauses = catch_clauses;
    }

    public TryExp(Expression try_clause, Expression finally_clause) {
        this.try_clause = try_clause;
        this.finally_clause = finally_clause;
    }

    protected boolean mustCompile() {
        return this.catch_clauses != null;
    }

    public void apply(CallContext ctx) throws Throwable {
        if (this.catch_clauses != null) {
            throw new RuntimeException("internal error - TryExp.eval called");
        }
        try {
            this.try_clause.apply(ctx);
            ctx.runUntilDone();
        }
        catch (Throwable ex) {
            CatchClause clause = this.catch_clauses;
            while (clause != null) {
                clause = clause.next;
            }
            throw ex;
        }
        finally {
            this.finally_clause.eval(ctx);
        }
    }

    public void compile(Compilation comp, Target target) {
        Type result_type;
        CodeAttr code = comp.getCode();
        boolean has_finally = this.finally_clause != null;
        Type type = result_type = target instanceof IgnoreTarget ? null : this.getType();
        Target ttarg = result_type == null ? Target.Ignore : (result_type == Type.pointer_type ? Target.pushObject : new StackTarget(result_type));
        code.emitTryStart(has_finally, result_type);
        this.try_clause.compileWithPosition(comp, ttarg);
        code.emitTryEnd();
        for (CatchClause catch_clause = this.catch_clauses; catch_clause != null; catch_clause = catch_clause.getNext()) {
            catch_clause.compile(comp, ttarg);
        }
        if (this.finally_clause != null) {
            code.emitFinallyStart();
            this.finally_clause.compileWithPosition(comp, Target.Ignore);
            code.emitFinallyEnd();
        }
        code.emitTryCatchEnd();
        if (result_type != null) {
            target.compileFromStack(comp, result_type);
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkTryExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.try_clause = walker.walk(this.try_clause);
        for (CatchClause catch_clause = this.catch_clauses; walker.exitValue == null && catch_clause != null; catch_clause = catch_clause.getNext()) {
            walker.walk(catch_clause);
        }
        if (walker.exitValue == null && this.finally_clause != null) {
            this.finally_clause = walker.walk(this.finally_clause);
        }
    }

    public void print(OutPort ps) {
        ps.startLogicalBlock("(Try", ")", 2);
        ps.writeSpaceFill();
        this.try_clause.print(ps);
        for (CatchClause catch_clause = this.catch_clauses; catch_clause != null; catch_clause = catch_clause.getNext()) {
            catch_clause.print(ps);
        }
        if (this.finally_clause != null) {
            ps.writeSpaceLinear();
            ps.print(" finally: ");
            this.finally_clause.print(ps);
        }
        ps.endLogicalBlock(")");
    }
}

