/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect.instruction;

import alt.jiapi.file.ConstantPool;
import alt.jiapi.reflect.Instruction;

public class CPInstruction
extends Instruction {
    protected ConstantPool cp;

    public CPInstruction(byte[] bytes, ConstantPool cp) {
        super(bytes);
        this.cp = cp;
    }

    public int getIndex() {
        byte[] bytes = this.getBytes();
        int index = 0;
        if (bytes.length == 2) {
            index = bytes[1] & 0xFF;
        } else {
            index = (short)(bytes[1] << 8);
            index |= bytes[2] & 0xFF;
        }
        return 0xFFFF & index;
    }

    private void setIndex(short index) {
        byte[] bytes = this.getBytes();
        if (bytes.length == 2) {
            if (index > 256) {
                if (bytes[0] == 18) {
                    bytes = new byte[]{19, (byte)(index >> 8 & 0xFF), (byte)(index & 0xFF)};
                    this.setBytes(bytes);
                } else {
                    System.err.println("ERROR: cannot change index to " + index + ", because byte[] has only one byte. " + this);
                }
            } else {
                bytes[1] = (byte)index;
            }
        } else {
            bytes[1] = (byte)(index >> 8 & 0xFF);
            bytes[2] = (byte)(index & 0xFF);
        }
        if (this.getIndex() != index) {
            System.out.println("ERROR setting index: " + this.getIndex() + " != " + index + ": " + this);
        }
    }

    public void replaceConstantPool(ConstantPool newCP) {
        ConstantPool.Entry entry = this.getEntry();
        short index = newCP.add(entry);
        this.setIndex(index);
        this.cp = newCP;
    }

    public ConstantPool.Entry getEntry() {
        return this.cp.get(this.getIndex());
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" ; ");
        sb.append(this.cp.get(this.getIndex()));
        return sb.toString();
    }
}

