/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:58:48 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ZipFileDocument_ESTest extends ZipFileDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      MockFile mockFile0 = new MockFile("uk.ac.sanger.artemis.util.InputStreamProgressEvent");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, (String) null);
      String string0 = zipFileDocument0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MockFile mockFile0 = new MockFile("7NTNR(");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "7NTNR(");
      String string0 = zipFileDocument0.getName();
      assertEquals("7NTNR(", string0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      mockFile0.createNewFile();
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      InputStream inputStream0 = zipFileDocument0.getInputStream();
      assertNotNull(inputStream0);
      assertEquals("", zipFileDocument0.getName());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MockFile mockFile0 = new MockFile((String) null, "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "Xh=+KTmtnO");
      // Undeclared exception!
      try { 
        zipFileDocument0.writeTmpFile((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Writer", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      FileSystemHandling.shouldAllThrowIOExceptions();
      try { 
        zipFileDocument0.writeTmpFile("");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      MockFile mockFile0 = new MockFile("[IZk_uEPWJ>*~]h.zip", " was already set to ");
      File file0 = MockFile.createTempFile("[IZk_uEPWJ>*~]h.zip", "[IZk_uEPWJ>*~]h.zip", (File) mockFile0);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "SENZ");
      zipFileDocument0.writeTmpFile("Ev'2!");
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/var/folders/r3/l648tx8s7hn8ppds6z2bk5cc000h2n/T/SENZ.gz2tmp");
      FileSystemHandling.createFolder(evoSuiteFile0);
      zipFileDocument0.getInputStream();
      try { 
        zipFileDocument0.writeTmpFile("4=hZp9{");
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".gz", "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, ".gz");
      zipFileDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        zipFileDocument0.readable();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.ZipFileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      MockFile mockFile0 = new MockFile("7NTNR(");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "7NTNR(");
      zipFileDocument0.setLocation("");
      // Undeclared exception!
      try { 
        zipFileDocument0.readable();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      File file0 = MockFile.createTempFile("t yQ-DZ0t yQ-DZ.zip", "t yQ-DZ0t yQ-DZ.zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, (String) null);
      // Undeclared exception!
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockFile mockFile0 = new MockFile("org.apache.commons.io.filefilter.WildcardFileFilter", "yOWLJMU';Q|z");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "org.apache.commons.io.filefilter.WildcardFileFilter");
      zipFileDocument0.setLocation("org.apache.commons.io.filefilter.WildcardFileFilter");
      // Undeclared exception!
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.io.File
         //
         verifyException("uk.ac.sanger.artemis.util.FileDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MockFile mockFile0 = new MockFile(".zip");
      FileSystemHandling.shouldAllThrowIOExceptions();
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile(java.lang.System.getProperty("user.dir") + "/.zip");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "BUG: Received two reference tagged alleles in VariantContext .zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      File file0 = MockFile.createTempFile(".gz", ".gz");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, ".gz");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: EOFException");
      
      } catch(EOFException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      ZipFileDocument zipFileDocument0 = null;
      try {
        zipFileDocument0 = new ZipFileDocument((File) null, "");
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      mockFile0.createNewFile();
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      mockFile0.createNewFile();
      mockFile0.setReadable(false);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "Alleles cannot be null");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MockFile mockFile0 = new MockFile("uk.ac.sanger.artemis.util.InputStreamProgressEvent");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, (String) null);
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile("[IZk_uEPWJ>*~]h.zip", " was already set to ");
      File file0 = MockFile.createTempFile("[IZk_uEPWJ>*~]h.zip", "[IZk_uEPWJ>*~]h.zip", (File) mockFile0);
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "SENZ");
      boolean boolean0 = zipFileDocument0.readable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      File file0 = MockFile.createTempFile("t yQ-DZ0t yQ-DZ.zip", "t yQ-DZ0t yQ-DZ.zip");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, "t yQ-DZ0t yQ-DZ.zip");
      zipFileDocument0.getInputStream();
      zipFileDocument0.getInputStream();
      assertEquals("t yQ-DZ0t yQ-DZ.zip.gz", zipFileDocument0.getName());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      try { 
        zipFileDocument0.getInputStream();
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      // Undeclared exception!
      try { 
        zipFileDocument0.writeTmpFile("");
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // Prefix string too short
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Alleles cannot be null");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(mockFile0, "");
      String string0 = zipFileDocument0.getName();
      assertEquals("", string0);
  }
}
