/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "id" locale.
 */
public class LocalizedNamesImpl_id extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BR",
        "GB",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "TD",
        "CN",
        "CL",
        "CI",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FJ",
        "PH",
        "FI",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "MP",
        "IC",
        "CC",
        "CK",
        "FO",
        "KY",
        "UM",
        "FK",
        "MH",
        "NF",
        "SB",
        "GS",
        "SJ",
        "TC",
        "VI",
        "VG",
        "WF",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KR",
        "KP",
        "CR",
        "HR",
        "CU",
        "KW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MK",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "EG",
        "MF",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "PG",
        "OM",
        "PS",
        "PK",
        "PW",
        "PA",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PT",
        "FR",
        "PR",
        "AC",
        "BV",
        "CX",
        "CP",
        "HM",
        "QA",
        "QO",
        "CF",
        "CZ",
        "CD",
        "DO",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "ST",
        "NZ",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "CY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "CV",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "AE",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "IO",
        "TF",
        "YE",
        "JO",
        "GR",
        "ZM",
        "ZW",
        "AX",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AC", "Pulau Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Uni Emirat Arab");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("AN", "Antilles Belanda");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AS", "Samoa Amerika");
    namesMap.put("AX", "�Land Islands");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Pulau Bouvet");
    namesMap.put("BY", "Belarusia");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kepulauan Cocos");
    namesMap.put("CD", "Republik Demokratik Kongo");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Kongo - Republik");
    namesMap.put("CH", "Swiss");
    namesMap.put("CI", "Cote d'Ivoire");
    namesMap.put("CK", "Kepulauan Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Pulau Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Serbia dan Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Tanjung Verde");
    namesMap.put("CX", "Pulau Christmas");
    namesMap.put("CY", "Siprus");
    namesMap.put("CZ", "Republik Cheska");
    namesMap.put("DE", "Jerman");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Republik Dominika");
    namesMap.put("EA", "Ceuta dan Melilla");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Spanyol");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FK", "Kepulauan Malvinas");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Kepulauan Faroe");
    namesMap.put("FR", "Prancis");
    namesMap.put("GB", "Britania Raya");
    namesMap.put("GF", "Guyana Perancis");
    namesMap.put("GL", "Grinlandia");
    namesMap.put("GQ", "Guinea Khatulistiwa");
    namesMap.put("GR", "Yunani");
    namesMap.put("GS", "Kepulauan South Sandwich dan South Georgia");
    namesMap.put("HM", "Pulau Heard dan Kepulauan McDonald");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Kepulauan Canary");
    namesMap.put("IE", "Irlandia");
    namesMap.put("IO", "Wilayah Inggris di Samudra Hindia");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordania");
    namesMap.put("JP", "Jepang");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kamboja");
    namesMap.put("KM", "Komoros");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Korea Utara");
    namesMap.put("KR", "Korea Selatan");
    namesMap.put("KY", "Kepulauan Kayman");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LT", "Lituania");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "Kepualuan Mariana Utara");
    namesMap.put("MV", "Maladewa");
    namesMap.put("MX", "Meksiko");
    namesMap.put("NC", "Kaledonia Baru");
    namesMap.put("NF", "Kepulauan Norfolk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Belanda");
    namesMap.put("NO", "Norwegia");
    namesMap.put("NZ", "Selandia Baru");
    namesMap.put("PF", "Polynesia Perancis");
    namesMap.put("PG", "Nugini Papua Nugini");
    namesMap.put("PH", "Filipina");
    namesMap.put("PL", "Polandia");
    namesMap.put("PM", "Saint Pierre dan Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Puerto Riko");
    namesMap.put("PS", "Otoritas Palestina");
    namesMap.put("PT", "Portugis");
    namesMap.put("RO", "Rumania");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SE", "Swedia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SJ", "Kepulauan Svalbard dan Jan Mayen");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("TC", "Kepulauan Turks dan Caicos");
    namesMap.put("TF", "Wilayah Prancis Selatan");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Kepulauan Kecil Terluar Amerika Serikat");
    namesMap.put("US", "Amerika Serikat");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("VG", "Kepulauan Virgin Inggris");
    namesMap.put("VI", "Kepulauan U.S. Virgin");
    namesMap.put("WF", "Kepulauan Wallis dan Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AC": "Pulau Ascension",
        "AD": "Andora",
        "AE": "Uni Emirat Arab",
        "AG": "Antigua dan Barbuda",
        "AN": "Antilles Belanda",
        "AQ": "Antarktika",
        "AS": "Samoa Amerika",
        "AX": "�Land Islands",
        "BA": "Bosnia dan Herzegovina",
        "BE": "Belgia",
        "BR": "Brasil",
        "BS": "Bahama",
        "BV": "Pulau Bouvet",
        "BY": "Belarusia",
        "CA": "Kanada",
        "CC": "Kepulauan Cocos",
        "CD": "Republik Demokratik Kongo",
        "CF": "Republik Afrika Tengah",
        "CG": "Kongo - Republik",
        "CH": "Swiss",
        "CI": "Cote d'Ivoire",
        "CK": "Kepulauan Cook",
        "CL": "Cile",
        "CM": "Kamerun",
        "CO": "Kolombia",
        "CP": "Pulau Clipperton",
        "CR": "Kosta Rika",
        "CS": "Serbia dan Montenegro",
        "CU": "Kuba",
        "CV": "Tanjung Verde",
        "CX": "Pulau Christmas",
        "CY": "Siprus",
        "CZ": "Republik Cheska",
        "DE": "Jerman",
        "DJ": "Jibuti",
        "DM": "Dominika",
        "DO": "Republik Dominika",
        "EA": "Ceuta dan Melilla",
        "EC": "Ekuador",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Spanyol",
        "FI": "Finlandia",
        "FK": "Kepulauan Malvinas",
        "FM": "Mikronesia",
        "FO": "Kepulauan Faroe",
        "FR": "Prancis",
        "GB": "Britania Raya",
        "GF": "Guyana Perancis",
        "GL": "Grinlandia",
        "GQ": "Guinea Khatulistiwa",
        "GR": "Yunani",
        "GS": "Kepulauan South Sandwich dan South Georgia",
        "HM": "Pulau Heard dan Kepulauan McDonald",
        "HR": "Kroasia",
        "HU": "Hungaria",
        "IC": "Kepulauan Canary",
        "IE": "Irlandia",
        "IO": "Wilayah Inggris di Samudra Hindia",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yordania",
        "JP": "Jepang",
        "KG": "Kirgistan",
        "KH": "Kamboja",
        "KM": "Komoros",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Korea Utara",
        "KR": "Korea Selatan",
        "KY": "Kepulauan Kayman",
        "KZ": "Kazakstan",
        "LT": "Lituania",
        "LY": "Libia",
        "MA": "Maroko",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Makedonia",
        "MM": "Myanmar",
        "MO": "Makau",
        "MP": "Kepualuan Mariana Utara",
        "MV": "Maladewa",
        "MX": "Meksiko",
        "NC": "Kaledonia Baru",
        "NF": "Kepulauan Norfolk",
        "NI": "Nikaragua",
        "NL": "Belanda",
        "NO": "Norwegia",
        "NZ": "Selandia Baru",
        "PF": "Polynesia Perancis",
        "PG": "Nugini Papua Nugini",
        "PH": "Filipina",
        "PL": "Polandia",
        "PM": "Saint Pierre dan Miquelon",
        "PN": "Pitcairn",
        "PR": "Puerto Riko",
        "PS": "Otoritas Palestina",
        "PT": "Portugis",
        "RO": "Rumania",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SE": "Swedia",
        "SG": "Singapura",
        "SJ": "Kepulauan Svalbard dan Jan Mayen",
        "ST": "Sao Tome dan Principe",
        "TC": "Kepulauan Turks dan Caicos",
        "TF": "Wilayah Prancis Selatan",
        "TL": "Timor Leste",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UA": "Ukraina",
        "UM": "Kepulauan Kecil Terluar Amerika Serikat",
        "US": "Amerika Serikat",
        "VA": "Vatikan",
        "VC": "Saint Vincent dan Grenadines",
        "VG": "Kepulauan Virgin Inggris",
        "VI": "Kepulauan U.S. Virgin",
        "WF": "Kepulauan Wallis dan Futuna",
        "YE": "Yaman",
        "ZA": "Afrika Selatan"
    };
  }-*/;
}
