/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.i18n.client.CurrencyData;
import com.google.gwt.i18n.client.CurrencyList;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.constants.NumberConstants;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberFormat {
    protected static final NumberConstants localizedNumberConstants;
    protected static NumberConstants defaultNumberConstants;
    private static NumberFormat cachedCurrencyFormat;
    private static NumberFormat cachedDecimalFormat;
    private static NumberFormat cachedPercentFormat;
    private static NumberFormat cachedScientificFormat;
    private static NumberConstants latinNumberConstants;
    private static final String LOCALIZED_COMMA_EQUIVALENTS = ",\u060c\u066b\u3001\ufe10\ufe11\ufe50\ufe51\uff0c\uff64";
    private static final String LOCALIZED_DOT_EQUIVALENTS = ".\u2024\u3002\ufe12\ufe52\uff0e\uff61";
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_MINUS = '-';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char QUOTE = '\'';
    private final String currencyCode;
    private final String currencySymbol;
    private boolean decimalSeparatorAlwaysShown = false;
    private int groupingSize = 3;
    private boolean isCurrencyFormat = false;
    private int maximumFractionDigits = 3;
    private int maximumIntegerDigits = 40;
    private int minExponentDigits;
    private int minimumFractionDigits = 0;
    private int minimumIntegerDigits = 1;
    private int multiplier = 1;
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private final NumberConstants numberConstants;
    private final String pattern;
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private boolean useExponentialNotation = false;
    private transient int exponent;
    private transient int decimalPosition;
    private transient int digitsLength;

    public static boolean forcedLatinDigits() {
        return defaultNumberConstants != localizedNumberConstants;
    }

    public static NumberFormat getCurrencyFormat() {
        if (cachedCurrencyFormat == null) {
            cachedCurrencyFormat = new NumberFormat(defaultNumberConstants.currencyPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedCurrencyFormat;
    }

    public static NumberFormat getCurrencyFormat(CurrencyData currencyData) {
        return new NumberFormat(defaultNumberConstants.currencyPattern(), currencyData, false);
    }

    public static NumberFormat getCurrencyFormat(String currencyCode) {
        return new NumberFormat(defaultNumberConstants.currencyPattern(), NumberFormat.lookupCurrency(currencyCode), false);
    }

    public static NumberFormat getDecimalFormat() {
        if (cachedDecimalFormat == null) {
            cachedDecimalFormat = new NumberFormat(defaultNumberConstants.decimalPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedDecimalFormat;
    }

    public static NumberFormat getFormat(String pattern) {
        return new NumberFormat(pattern, CurrencyList.get().getDefault(), true);
    }

    public static NumberFormat getFormat(String pattern, CurrencyData currencyData) {
        return new NumberFormat(pattern, currencyData, true);
    }

    public static NumberFormat getFormat(String pattern, String currencyCode) {
        return new NumberFormat(pattern, NumberFormat.lookupCurrency(currencyCode), true);
    }

    public static NumberFormat getPercentFormat() {
        if (cachedPercentFormat == null) {
            cachedPercentFormat = new NumberFormat(defaultNumberConstants.percentPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedPercentFormat;
    }

    public static NumberFormat getScientificFormat() {
        if (cachedScientificFormat == null) {
            cachedScientificFormat = new NumberFormat(defaultNumberConstants.scientificPattern(), CurrencyList.get().getDefault(), false);
        }
        return cachedScientificFormat;
    }

    public static void setForcedLatinDigits(boolean useLatinDigits) {
        if (useLatinDigits != NumberFormat.forcedLatinDigits()) {
            cachedCurrencyFormat = null;
            cachedDecimalFormat = null;
            cachedPercentFormat = null;
            cachedScientificFormat = null;
        }
        if (useLatinDigits) {
            if (latinNumberConstants == null) {
                latinNumberConstants = NumberFormat.createLatinNumberConstants(localizedNumberConstants);
            }
            defaultNumberConstants = latinNumberConstants;
        } else {
            defaultNumberConstants = localizedNumberConstants;
        }
    }

    protected static NumberConstants createLatinNumberConstants(final NumberConstants orig) {
        final String groupingSeparator = NumberFormat.remapSeparator(orig.groupingSeparator());
        final String decimalSeparator = NumberFormat.remapSeparator(orig.decimalSeparator());
        final String monetaryGroupingSeparator = NumberFormat.remapSeparator(orig.monetaryGroupingSeparator());
        final String monetarySeparator = NumberFormat.remapSeparator(orig.monetarySeparator());
        return new NumberConstants(){

            public String currencyPattern() {
                return orig.currencyPattern();
            }

            public String decimalPattern() {
                return orig.decimalPattern();
            }

            public String decimalSeparator() {
                return decimalSeparator;
            }

            public String defCurrencyCode() {
                return orig.defCurrencyCode();
            }

            public String exponentialSymbol() {
                return orig.exponentialSymbol();
            }

            public String groupingSeparator() {
                return groupingSeparator;
            }

            public String infinity() {
                return orig.infinity();
            }

            public String minusSign() {
                return orig.minusSign();
            }

            public String monetaryGroupingSeparator() {
                return monetaryGroupingSeparator;
            }

            public String monetarySeparator() {
                return monetarySeparator;
            }

            public String notANumber() {
                return orig.notANumber();
            }

            public String percent() {
                return orig.percent();
            }

            public String percentPattern() {
                return orig.percentPattern();
            }

            public String perMill() {
                return orig.perMill();
            }

            public String plusSign() {
                return orig.plusSign();
            }

            public String scientificPattern() {
                return orig.scientificPattern();
            }

            public String zeroDigit() {
                return "0";
            }
        };
    }

    protected static String remapSeparator(String separator) {
        int ch;
        int n = ch = separator.length() > 0 ? (int)separator.charAt(0) : 65535;
        if (LOCALIZED_DOT_EQUIVALENTS.indexOf(ch) >= 0) {
            return ".";
        }
        if (LOCALIZED_COMMA_EQUIVALENTS.indexOf(ch) >= 0) {
            return ",";
        }
        return "\u00a0";
    }

    static int toScaledString(StringBuilder buf, double val) {
        int dot;
        int startLen = buf.length();
        buf.append(NumberFormat.toPrecision(val, 20));
        int scale = 0;
        int expIdx = buf.indexOf("e", startLen);
        if (expIdx < 0) {
            expIdx = buf.indexOf("E", startLen);
        }
        if (expIdx >= 0) {
            int expDigits = expIdx + 1;
            if (expDigits < buf.length() && buf.charAt(expDigits) == '+') {
                ++expDigits;
            }
            if (expDigits < buf.length()) {
                scale = Integer.parseInt(buf.substring(expDigits));
            }
            buf.delete(expIdx, buf.length());
        }
        if ((dot = buf.indexOf(".", startLen)) >= 0) {
            buf.deleteCharAt(dot);
            scale -= buf.length() - dot;
        }
        return scale;
    }

    private static CurrencyData lookupCurrency(String currencyCode) {
        CurrencyData currencyData = CurrencyList.get().lookup(currencyCode);
        if (currencyData == null) {
            throw new IllegalArgumentException("Currency code " + currencyCode + " is unkown in locale " + LocaleInfo.getCurrentLocale().getLocaleName());
        }
        return currencyData;
    }

    private static native String toPrecision(double var0, int var2);

    protected NumberFormat(NumberConstants numberConstants, String pattern, CurrencyData cdata, boolean userSuppliedPattern) {
        if (cdata == null) {
            throw new IllegalArgumentException("Unknown currency code");
        }
        this.numberConstants = numberConstants;
        this.pattern = pattern;
        this.currencyCode = cdata.getCurrencyCode();
        this.currencySymbol = cdata.getCurrencySymbol();
        this.parsePattern(this.pattern);
        if (!userSuppliedPattern && this.isCurrencyFormat) {
            this.maximumFractionDigits = this.minimumFractionDigits = cdata.getDefaultFractionDigits();
        }
    }

    protected NumberFormat(String pattern, CurrencyData cdata, boolean userSuppliedPattern) {
        this(defaultNumberConstants, pattern, cdata, userSuppliedPattern);
    }

    public String format(double number) {
        boolean isNegative;
        if (Double.isNaN(number)) {
            return this.numberConstants.notANumber();
        }
        boolean bl = isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        if (isNegative) {
            number = -number;
        }
        StringBuilder buf = new StringBuilder();
        if (Double.isInfinite(number)) {
            buf.append(isNegative ? this.negativePrefix : this.positivePrefix);
            buf.append(this.numberConstants.infinity());
            buf.append(isNegative ? this.negativeSuffix : this.positiveSuffix);
            return buf.toString();
        }
        int scale = NumberFormat.toScaledString(buf, number *= (double)this.multiplier);
        int preRound = buf.length() + scale + this.maximumFractionDigits + 3;
        if (preRound > 0 && preRound < buf.length() && buf.charAt(preRound) == '9') {
            this.propagateCarry(buf, preRound - 1);
            scale += buf.length() - preRound;
            buf.delete(preRound, buf.length());
        }
        this.format(isNegative, buf, scale);
        return buf.toString();
    }

    public String format(Number number) {
        if (number instanceof BigDecimal) {
            boolean isNegative;
            BigDecimal bigDec = (BigDecimal)number;
            boolean bl = isNegative = bigDec.signum() < 0;
            if (isNegative) {
                bigDec = bigDec.negate();
            }
            bigDec = bigDec.multiply(BigDecimal.valueOf(this.multiplier));
            StringBuilder buf = new StringBuilder();
            buf.append(bigDec.unscaledValue().toString());
            this.format(isNegative, buf, -bigDec.scale());
            return buf.toString();
        }
        if (number instanceof BigInteger) {
            boolean isNegative;
            BigInteger bigInt = (BigInteger)number;
            boolean bl = isNegative = bigInt.signum() < 0;
            if (isNegative) {
                bigInt = bigInt.negate();
            }
            bigInt = bigInt.multiply(BigInteger.valueOf(this.multiplier));
            StringBuilder buf = new StringBuilder();
            buf.append(bigInt.toString());
            this.format(isNegative, buf, 0);
            return buf.toString();
        }
        if (number instanceof Long) {
            return this.format(number.longValue(), 0);
        }
        return this.format(number.doubleValue());
    }

    public String getPattern() {
        return this.pattern;
    }

    public double parse(String text) throws NumberFormatException {
        int[] pos = new int[]{0};
        double result = this.parse(text, pos);
        if (pos[0] == 0 || pos[0] != text.length()) {
            throw new NumberFormatException(text);
        }
        return result;
    }

    public double parse(String text, int[] inOutPos) throws NumberFormatException {
        boolean gotNegative;
        double ret = 0.0;
        boolean gotPositivePrefix = text.startsWith(this.positivePrefix, inOutPos[0]);
        boolean gotNegativePrefix = text.startsWith(this.negativePrefix, inOutPos[0]);
        boolean gotPositiveSuffix = text.endsWith(this.positiveSuffix);
        boolean gotNegativeSuffix = text.endsWith(this.negativeSuffix);
        boolean gotPositive = gotPositivePrefix && gotPositiveSuffix;
        boolean bl = gotNegative = gotNegativePrefix && gotNegativeSuffix;
        if (gotPositive && gotNegative) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                gotNegative = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                gotPositive = false;
            } else if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                gotNegative = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                gotPositive = false;
            } else {
                gotNegative = false;
            }
        } else if (!gotPositive && !gotNegative) {
            throw new NumberFormatException(text + " does not have either positive or negative affixes");
        }
        String valueOnly = null;
        if (gotPositive) {
            inOutPos[0] = inOutPos[0] + this.positivePrefix.length();
            valueOnly = text.substring(inOutPos[0], text.length() - this.positiveSuffix.length());
        } else {
            inOutPos[0] = inOutPos[0] + this.negativePrefix.length();
            valueOnly = text.substring(inOutPos[0], text.length() - this.negativeSuffix.length());
        }
        if (valueOnly.equals(this.numberConstants.infinity())) {
            inOutPos[0] = inOutPos[0] + this.numberConstants.infinity().length();
            ret = Double.POSITIVE_INFINITY;
        } else if (valueOnly.equals(this.numberConstants.notANumber())) {
            inOutPos[0] = inOutPos[0] + this.numberConstants.notANumber().length();
            ret = Double.NaN;
        } else {
            int[] tempPos = new int[]{0};
            ret = this.parseNumber(valueOnly, tempPos);
            inOutPos[0] = inOutPos[0] + tempPos[0];
        }
        if (gotPositive) {
            inOutPos[0] = inOutPos[0] + this.positiveSuffix.length();
        } else if (gotNegative) {
            inOutPos[0] = inOutPos[0] + this.negativeSuffix.length();
        }
        if (gotNegative) {
            ret = -ret;
        }
        return ret;
    }

    protected void format(boolean isNegative, StringBuilder digits, int scale) {
        char zeroChar;
        char groupingSeparator;
        char decimalSeparator;
        if (this.isCurrencyFormat) {
            decimalSeparator = this.numberConstants.monetarySeparator().charAt(0);
            groupingSeparator = this.numberConstants.monetaryGroupingSeparator().charAt(0);
        } else {
            decimalSeparator = this.numberConstants.decimalSeparator().charAt(0);
            groupingSeparator = this.numberConstants.groupingSeparator().charAt(0);
        }
        this.exponent = 0;
        this.digitsLength = digits.length();
        this.decimalPosition = this.digitsLength + scale;
        boolean useExponent = this.useExponentialNotation;
        int currentGroupingSize = this.groupingSize;
        if (this.decimalPosition > 1024) {
            useExponent = true;
        }
        if (useExponent) {
            this.computeExponent(digits);
        }
        this.processLeadingZeros(digits);
        this.roundValue(digits);
        this.insertGroupingSeparators(digits, groupingSeparator, currentGroupingSize);
        this.adjustFractionDigits(digits);
        this.addZeroAndDecimal(digits, decimalSeparator);
        if (useExponent) {
            this.addExponent(digits);
        }
        if ((zeroChar = this.numberConstants.zeroDigit().charAt(0)) != '0') {
            this.localizeDigits(digits, zeroChar);
        }
        digits.insert(0, isNegative ? this.negativePrefix : this.positivePrefix);
        digits.append(isNegative ? this.negativeSuffix : this.positiveSuffix);
    }

    protected String format(long value, int scale) {
        boolean isNegative;
        boolean bl = isNegative = value < 0L;
        if (isNegative) {
            value = -value;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(value *= (long)this.multiplier));
        this.format(isNegative, buf, scale);
        return buf.toString();
    }

    protected int getGroupingSize() {
        return this.groupingSize;
    }

    protected String getNegativePrefix() {
        return this.negativePrefix;
    }

    protected String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    protected NumberConstants getNumberConstants() {
        return this.numberConstants;
    }

    protected String getPositivePrefix() {
        return this.positivePrefix;
    }

    protected String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    protected boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    private void addExponent(StringBuilder digits) {
        digits.append(this.numberConstants.exponentialSymbol());
        if (this.exponent < 0) {
            this.exponent = -this.exponent;
            digits.append(this.numberConstants.minusSign());
        }
        String exponentDigits = String.valueOf(this.exponent);
        for (int i = exponentDigits.length(); i < this.minExponentDigits; ++i) {
            digits.append('0');
        }
        digits.append(exponentDigits);
    }

    private void addZeroAndDecimal(StringBuilder digits, char decimalSeparator) {
        if (this.digitsLength == 0) {
            digits.insert(0, '0');
            ++this.decimalPosition;
            ++this.digitsLength;
        }
        if (this.decimalPosition < this.digitsLength || this.decimalSeparatorAlwaysShown) {
            digits.insert(this.decimalPosition, decimalSeparator);
            ++this.digitsLength;
        }
    }

    private void adjustFractionDigits(StringBuilder digits) {
        int requiredDigits = this.decimalPosition + this.minimumFractionDigits;
        if (this.digitsLength < requiredDigits) {
            while (this.digitsLength < requiredDigits) {
                digits.append('0');
                ++this.digitsLength;
            }
        } else {
            int toRemove = this.decimalPosition + this.maximumFractionDigits;
            if (toRemove > this.digitsLength) {
                toRemove = this.digitsLength;
            }
            while (toRemove > requiredDigits && digits.charAt(toRemove - 1) == '0') {
                --toRemove;
            }
            if (toRemove < this.digitsLength) {
                digits.delete(toRemove, this.digitsLength);
                this.digitsLength = toRemove;
            }
        }
    }

    private void computeExponent(StringBuilder digits) {
        int strip;
        for (strip = 0; strip < this.digitsLength - 1 && digits.charAt(strip) == '0'; ++strip) {
        }
        if (strip > 0) {
            digits.delete(0, strip);
            this.digitsLength -= strip;
            this.exponent -= strip;
        }
        if (this.maximumIntegerDigits > this.minimumIntegerDigits && this.maximumIntegerDigits > 0) {
            this.exponent += this.decimalPosition - 1;
            int remainder = this.exponent % this.maximumIntegerDigits;
            if (remainder < 0) {
                remainder += this.maximumIntegerDigits;
            }
            this.decimalPosition = remainder + 1;
            this.exponent -= remainder;
        } else {
            this.exponent += this.decimalPosition - this.minimumIntegerDigits;
            this.decimalPosition = this.minimumIntegerDigits;
        }
        if (this.digitsLength == 1 && digits.charAt(0) == '0') {
            this.exponent = 0;
            this.decimalPosition = this.minimumIntegerDigits;
        }
    }

    private int getDigit(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        char zeroChar = this.numberConstants.zeroDigit().charAt(0);
        return zeroChar <= ch && ch <= zeroChar + 9 ? ch - zeroChar : -1;
    }

    private void insertGroupingSeparators(StringBuilder digits, char groupingSeparator, int g) {
        if (g > 0) {
            for (int i = g; i < this.decimalPosition; i += g + 1) {
                digits.insert(this.decimalPosition - i, groupingSeparator);
                ++this.decimalPosition;
                ++this.digitsLength;
            }
        }
    }

    private void localizeDigits(StringBuilder digits, char zero) {
        int n = digits.length();
        for (int i = 0; i < n; ++i) {
            char ch = digits.charAt(i);
            if (ch < '0' || ch > '9') continue;
            digits.setCharAt(i, (char)(ch - 48 + zero));
        }
    }

    private int parseAffix(String pattern, int start, StringBuffer affix, boolean inNegativePattern) {
        affix.delete(0, affix.length());
        boolean inQuote = false;
        int len = pattern.length();
        block7: for (int pos = start; pos < len; ++pos) {
            char ch = pattern.charAt(pos);
            if (ch == '\'') {
                if (pos + 1 < len && pattern.charAt(pos + 1) == '\'') {
                    ++pos;
                    affix.append("'");
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (inQuote) {
                affix.append(ch);
                continue;
            }
            switch (ch) {
                case '#': 
                case ',': 
                case '.': 
                case '0': 
                case ';': {
                    return pos - start;
                }
                case '\u00a4': {
                    this.isCurrencyFormat = true;
                    if (pos + 1 < len && pattern.charAt(pos + 1) == '\u00a4') {
                        ++pos;
                        affix.append(this.currencyCode);
                        continue block7;
                    }
                    affix.append(this.currencySymbol);
                    continue block7;
                }
                case '%': {
                    if (!inNegativePattern) {
                        if (this.multiplier != 1) {
                            throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + pattern + '\"');
                        }
                        this.multiplier = 100;
                    }
                    affix.append(this.numberConstants.percent());
                    continue block7;
                }
                case '\u2030': {
                    if (!inNegativePattern) {
                        if (this.multiplier != 1) {
                            throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + pattern + '\"');
                        }
                        this.multiplier = 1000;
                    }
                    affix.append(this.numberConstants.perMill());
                    continue block7;
                }
                case '-': {
                    affix.append("-");
                    continue block7;
                }
                default: {
                    affix.append(ch);
                }
            }
        }
        return len - start;
    }

    private double parseNumber(String text, int[] pos) {
        boolean sawDecimal = false;
        boolean sawExponent = false;
        boolean sawDigit = false;
        int scale = 1;
        String decimal = this.isCurrencyFormat ? this.numberConstants.monetarySeparator() : this.numberConstants.decimalSeparator();
        String grouping = this.isCurrencyFormat ? this.numberConstants.monetaryGroupingSeparator() : this.numberConstants.groupingSeparator();
        String exponentChar = this.numberConstants.exponentialSymbol();
        StringBuffer normalizedText = new StringBuffer();
        while (pos[0] < text.length()) {
            char ch = text.charAt(pos[0]);
            int digit = this.getDigit(ch);
            if (digit >= 0 && digit <= 9) {
                normalizedText.append((char)(digit + 48));
                sawDigit = true;
            } else if (ch == decimal.charAt(0)) {
                if (sawDecimal || sawExponent) break;
                normalizedText.append('.');
                sawDecimal = true;
            } else if (ch == grouping.charAt(0)) {
                if (sawDecimal || sawExponent) {
                    break;
                }
            } else if (ch == exponentChar.charAt(0)) {
                if (sawExponent) break;
                normalizedText.append('E');
                sawExponent = true;
            } else if (ch == '+' || ch == '-') {
                normalizedText.append(ch);
            } else if (ch == this.numberConstants.percent().charAt(0)) {
                if (scale != 1) break;
                scale = 100;
                if (sawDigit) {
                    pos[0] = pos[0] + 1;
                    break;
                }
            } else {
                if (ch != this.numberConstants.perMill().charAt(0) || scale != 1) break;
                scale = 1000;
                if (sawDigit) {
                    pos[0] = pos[0] + 1;
                    break;
                }
            }
            pos[0] = pos[0] + 1;
        }
        try {
            double ret = Double.parseDouble(normalizedText.toString());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(text);
        }
        return ret /= (double)scale;
    }

    private void parsePattern(String pattern) {
        int pos = 0;
        StringBuffer affix = new StringBuffer();
        pos += this.parseAffix(pattern, pos, affix, false);
        this.positivePrefix = affix.toString();
        pos += this.parseTrunk(pattern, pos, false);
        pos += this.parseAffix(pattern, pos, affix, false);
        this.positiveSuffix = affix.toString();
        if (pos < pattern.length() && pattern.charAt(pos) == ';') {
            ++pos;
            pos += this.parseAffix(pattern, pos, affix, true);
            this.negativePrefix = affix.toString();
            pos += this.parseTrunk(pattern, pos, true);
            pos += this.parseAffix(pattern, pos, affix, true);
            this.negativeSuffix = affix.toString();
        } else {
            this.negativePrefix = this.numberConstants.minusSign() + this.positivePrefix;
            this.negativeSuffix = this.positiveSuffix;
        }
    }

    private int parseTrunk(String pattern, int start, boolean ignorePattern) {
        int pos;
        int decimalPos = -1;
        int digitLeftCount = 0;
        int zeroDigitCount = 0;
        int digitRightCount = 0;
        int groupingCount = -1;
        int len = pattern.length();
        boolean loop = true;
        block7: for (pos = start; pos < len && loop; ++pos) {
            char ch = pattern.charAt(pos);
            switch (ch) {
                case '#': {
                    if (zeroDigitCount > 0) {
                        ++digitRightCount;
                    } else {
                        ++digitLeftCount;
                    }
                    if (groupingCount < 0 || decimalPos >= 0) continue block7;
                    groupingCount = (byte)(groupingCount + 1);
                    continue block7;
                }
                case '0': {
                    if (digitRightCount > 0) {
                        throw new IllegalArgumentException("Unexpected '0' in pattern \"" + pattern + '\"');
                    }
                    ++zeroDigitCount;
                    if (groupingCount < 0 || decimalPos >= 0) continue block7;
                    groupingCount = (byte)(groupingCount + 1);
                    continue block7;
                }
                case ',': {
                    groupingCount = 0;
                    continue block7;
                }
                case '.': {
                    if (decimalPos >= 0) {
                        throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + pattern + '\"');
                    }
                    decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
                    continue block7;
                }
                case 'E': {
                    if (!ignorePattern) {
                        if (this.useExponentialNotation) {
                            throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + pattern + '\"');
                        }
                        this.useExponentialNotation = true;
                        this.minExponentDigits = 0;
                    }
                    while (pos + 1 < len && pattern.charAt(pos + 1) == '0') {
                        ++pos;
                        if (ignorePattern) continue;
                        ++this.minExponentDigits;
                    }
                    if (!ignorePattern && digitLeftCount + zeroDigitCount < 1 || this.minExponentDigits < 1) {
                        throw new IllegalArgumentException("Malformed exponential pattern \"" + pattern + '\"');
                    }
                    loop = false;
                    continue block7;
                }
                default: {
                    --pos;
                    loop = false;
                }
            }
        }
        if (zeroDigitCount == 0 && digitLeftCount > 0 && decimalPos >= 0) {
            int n = decimalPos;
            if (n == 0) {
                ++n;
            }
            digitRightCount = digitLeftCount - n;
            digitLeftCount = n - 1;
            zeroDigitCount = 1;
        }
        if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount == 0) {
            throw new IllegalArgumentException("Malformed pattern \"" + pattern + '\"');
        }
        if (ignorePattern) {
            return pos - start;
        }
        int totalDigits = digitLeftCount + zeroDigitCount + digitRightCount;
        int n = this.maximumFractionDigits = decimalPos >= 0 ? totalDigits - decimalPos : 0;
        if (decimalPos >= 0) {
            this.minimumFractionDigits = digitLeftCount + zeroDigitCount - decimalPos;
            if (this.minimumFractionDigits < 0) {
                this.minimumFractionDigits = 0;
            }
        }
        int effectiveDecimalPos = decimalPos >= 0 ? decimalPos : totalDigits;
        this.minimumIntegerDigits = effectiveDecimalPos - digitLeftCount;
        if (this.useExponentialNotation) {
            this.maximumIntegerDigits = digitLeftCount + this.minimumIntegerDigits;
            if (this.maximumFractionDigits == 0 && this.minimumIntegerDigits == 0) {
                this.minimumIntegerDigits = 1;
            }
        }
        this.groupingSize = groupingCount > 0 ? groupingCount : 0;
        this.decimalSeparatorAlwaysShown = decimalPos == 0 || decimalPos == totalDigits;
        return pos - start;
    }

    private void processLeadingZeros(StringBuilder digits) {
        if (this.decimalPosition > this.digitsLength) {
            while (this.digitsLength < this.decimalPosition) {
                digits.append('0');
                ++this.digitsLength;
            }
        }
        if (!this.useExponentialNotation) {
            if (this.decimalPosition < this.minimumIntegerDigits) {
                StringBuilder prefix = new StringBuilder();
                while (this.decimalPosition < this.minimumIntegerDigits) {
                    prefix.append('0');
                    ++this.decimalPosition;
                    ++this.digitsLength;
                }
                digits.insert(0, prefix);
            } else if (this.decimalPosition > this.minimumIntegerDigits) {
                int strip = this.decimalPosition - this.minimumIntegerDigits;
                for (int i = 0; i < strip; ++i) {
                    if (digits.charAt(i) == '0') continue;
                    strip = i;
                    break;
                }
                if (strip > 0) {
                    digits.delete(0, strip);
                    this.digitsLength -= strip;
                    this.decimalPosition -= strip;
                }
            }
        }
    }

    private void propagateCarry(StringBuilder digits, int i) {
        boolean carry = true;
        while (carry && i >= 0) {
            char digit = digits.charAt(i);
            if (digit == '9') {
                digits.setCharAt(i--, '0');
                continue;
            }
            digits.setCharAt(i, (char)(digit + '\u0001'));
            carry = false;
        }
        if (carry) {
            digits.insert(0, '1');
            ++this.decimalPosition;
            ++this.digitsLength;
        }
    }

    private void roundValue(StringBuilder digits) {
        if (this.digitsLength > this.decimalPosition + this.maximumFractionDigits && digits.charAt(this.decimalPosition + this.maximumFractionDigits) >= '5') {
            int i = this.decimalPosition + this.maximumFractionDigits - 1;
            this.propagateCarry(digits, i);
        }
    }

    static {
        defaultNumberConstants = localizedNumberConstants = LocaleInfo.getCurrentLocale().getNumberConstants();
        latinNumberConstants = null;
    }
}

