/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.adapters;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.adapters.EditorSource;
import com.google.gwt.editor.client.adapters.ListEditorWrapper;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditor<T, E extends Editor<T>>
implements CompositeEditor<List<T>, T, E> {
    private CompositeEditor.EditorChain<T, E> chain;
    private EditorSource<E> editorSource;
    private ListEditorWrapper<T, E> list;

    public static <T, E extends Editor<T>> ListEditor<T, E> of(EditorSource<E> source) {
        return new ListEditor<T, E>(source);
    }

    protected ListEditor(EditorSource<E> source) {
        this.editorSource = source;
    }

    @Override
    public E createEditorForTraversal() {
        E toReturn = this.editorSource.create(0);
        this.editorSource.dispose(toReturn);
        return toReturn;
    }

    @Override
    public void flush() {
        this.list.flush();
    }

    public List<E> getEditors() {
        if (this.list == null) {
            throw new IllegalStateException("Must call EditorDriver.edit() first");
        }
        return Collections.unmodifiableList(this.list.getEditors());
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public String getPathElement(E subEditor) {
        return "[" + this.list.getEditors().indexOf(subEditor) + "]";
    }

    @Override
    public void onPropertyChange(String ... paths) {
    }

    @Override
    public void setDelegate(EditorDelegate<List<T>> delegate) {
    }

    @Override
    public void setEditorChain(CompositeEditor.EditorChain<T, E> chain) {
        this.chain = chain;
    }

    @Override
    public void setValue(List<T> value) {
        if (this.list != null) {
            this.list.detach();
        }
        if (value == null) {
            this.list = null;
        } else {
            this.list = new ListEditorWrapper<T, E>(value, this.chain, this.editorSource);
            this.list.attach();
        }
    }
}

