import time

class PreventTransactionCommit(Exception):
    def __init__(self, reason):
        self. reason = reason

    def __str__(self):
        return "Uncommittable transaction: " % self.reason
    
class UncommittableJar:
    """ A jar that cannot be committed """
    def __init__(self, reason):
        self.reason = reason
        self.time = time.time()
        
    def sort_key(self):
        return self.time()

    def tpc_begin(self, transaction):
        pass

    def commit(self, obj, transaction):
        pass

    def tpc_vote(self, transaction):
        raise PreventTransactionCommit(self.reason)

class makeTransactionUncommittable:
    """
    - register an uncommittable object with the provided transaction
      which prevents the commit of that transaction
    """
    def __init__(self, transaction, reason):
        self._p_jar = UncommittableJar(reason)
        transaction.register(self)
        
