#ifndef DSPTHREAD_H_INCLUDED
#define DSPTHREAD_H_INCLUDED

#include "../config.h"

#ifdef QT_THREAD_SUPPORT
#include <qthread.h>
#else
#include <qtimer.h>
#include <qobject.h>
#endif

#include "../dissipate2/sdp.h"
#include "audiobuffer.h"
#include "dtmfgenerator.h"


class DspOut;

#ifdef QT_THREAD_SUPPORT
class DspAudio : public QThread
#else
class DspAudio : public QObject
#endif
{
public:
	DspAudio( DspOut *in, DspOut *out );
	virtual ~DspAudio( void );
#ifdef QT_THREAD_SUPPORT
	virtual void run();
#else
	virtual void start( void ) = 0;
	bool running( void ) { return false; }
	void wait( void ) { return; }
	void exit( void ) { return; }
#endif
	virtual void timerTick( void ) = 0;
	void startTone(char code);
	void stopTone(void);

	/*
	 * Generate DTMF if required
	 * returns 1 if DTMF was generated
	 * and 0 if not
	*/
	bool generateDTMF(short* buffer, size_t n);
	void setCancel( void ) { cancel = true; }
	void setCodec( const codecType newCodec, int newCodecNum );

protected:
	bool isCanceled( void ) { return cancel; }
	DspOut *input;
	DspOut *output;
	bool broken;
	bool cancel;
	DTMFGenerator dtmf;
	AudioBuffer copybuffer;
	unsigned int dtmfSamples;
	char newTone;      // New DTMF tone to be generated (0 if none)
	char currentTone;  // Tone currently being generated (0 if none)

#ifndef QT_THREAD_SUPPORT
	QTimer *timer;
#endif

};

#endif // DSPTHREAD_H_INCLUDED
