/*
 *  PGGraphvizServiceProvider.m
 *  graphviz
 *
 *  Created by Glen Low on Sat Apr 24 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#import "PGGraphvizApplicationController.h"
#import "PGGraphvizActivityController.h"
#import "PGGraphvizDataDocument.h"
#import "PGGraphvizFileDocument.h"
#import "PGGraphvizSchema.h"
#import "PGNilColor.h"

@implementation PGGraphvizApplicationController

- (void) applicationDidFinishLaunching: (NSNotification*) notification
	{
		[[notification object] setServicesProvider: self];
		[NSColor setIgnoresAlpha: NO];
		
		NSColorPanel* panel = [NSColorPanel sharedColorPanel];
		NSColorList* colors = [PGGraphvizSchema colors];
		
		[panel attachColorList: [PGGraphvizSchema colors]];
		[panel setColor: [colors colorWithKey: [[colors allKeys] objectAtIndex: 0]]];   // to scroll color list to top!
		[panel setColor: [PGNilColor nilColor]];
		
		[NSColorPanel setPickerMode: NSColorListModeColorPanel];
	}

- (IBAction) orderFrontActivityWindow: (id) sender
	{
		[activity orderFrontActivityWindow: sender];
	}
	
- (IBAction) newFileDocument: (id) sender
	{
		NSSavePanel* savePanel = [NSSavePanel savePanel];
		NSFileManager* defaultManager = [NSFileManager defaultManager];

		[savePanel setRequiredFileType: @"dot"];
		if ([savePanel runModal] == NSOKButton &&
/*			[[NSFileManager defaultManager]
			copyPath: [[NSBundle mainBundle] pathForResource: @"Template" ofType: @"dot"]
			toPath: [savePanel filename]
			handler: nil])*/
			
			[defaultManager
				createFileAtPath: [savePanel filename]
				contents: [defaultManager contentsAtPath: [[NSBundle mainBundle] pathForResource: @"Template" ofType: @"dot"]]
				attributes: [NSDictionary dictionaryWithObjectsAndKeys:
					[NSNumber numberWithUnsignedInt: 'GRVZ'], NSFileHFSCreatorCode,
					[NSNumber numberWithUnsignedInt: 'TEXT'], NSFileHFSTypeCode,
					nil]])
			[[NSDocumentController sharedDocumentController]
				openDocumentWithContentsOfFile: [savePanel filename] display: YES];

	}

- (void) drawAsGraph: (NSPasteboard*) pboard userData: (NSString*) userData error: (NSString**) error
	{
		PGGraphvizDataDocument* document = [[NSDocumentController sharedDocumentController]
			openUntitledDocumentOfType: @"Graphviz Graph Data" display: YES];
		[document setFileType: @"Graphviz Graph Data"];
		[document setData: [pboard dataForType: NSStringPboardType]];
		return;
	}

- (void) openFile: (NSPasteboard*) pboard userData: (NSString*) userData error: (NSString**) error
	{
		[[NSDocumentController sharedDocumentController]
			openDocumentWithContentsOfFile: [pboard stringForType: NSStringPboardType] display: YES];
		return;
	}

@end
